"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterMapping = exports.MappingValue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
;
/**
 * (experimental) Represents a Mapping Value.
 *
 * @experimental
 */
class MappingValue {
    /**
     * @experimental
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * (experimental) Creates a header mapping value.
     *
     * @experimental
     */
    static requestHeader(name) { return new MappingValue(`$request.header.${name}`); }
    /**
     * (experimental) Creates a query string mapping value.
     *
     * @experimental
     */
    static requestQueryString(name) { return new MappingValue(`$request.querystring.${name}`); }
    /**
     * (experimental) Creates a request body mapping value.
     *
     * @experimental
     */
    static requestBody(name) { return new MappingValue(`$request.body.${name}`); }
    /**
     * (experimental) Creates a request path mapping value.
     *
     * @experimental
     */
    static requestPath() { return new MappingValue('$request.path'); }
    /**
     * (experimental) Creates a request path parameter mapping value.
     *
     * @experimental
     */
    static requestPathParam(name) { return new MappingValue(`$request.path.${name}`); }
    /**
     * (experimental) Creates a context variable mapping value.
     *
     * @experimental
     */
    static contextVariable(variableName) { return new MappingValue(`$context.${variableName}`); }
    /**
     * (experimental) Creates a stage variable mapping value.
     *
     * @experimental
     */
    static stageVariable(variableName) { return new MappingValue(`$stageVariables.${variableName}`); }
    /**
     * (experimental) Creates a custom mapping value.
     *
     * @experimental
     */
    static custom(value) { return new MappingValue(value); }
}
exports.MappingValue = MappingValue;
_a = JSII_RTTI_SYMBOL_1;
MappingValue[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.MappingValue", version: "2.12.0-alpha.0" };
/**
 * (experimental) Creates an empty mapping value.
 *
 * @experimental
 */
MappingValue.NONE = new MappingValue('');
/**
 * (experimental) Represents a Parameter Mapping.
 *
 * @experimental
 */
class ParameterMapping {
    /**
     * @experimental
     */
    constructor() {
        this.mappings = {};
    }
    /**
     * (experimental) Creates a mapping from an object.
     *
     * @experimental
     */
    static fromObject(obj) {
        const mapping = new ParameterMapping();
        for (const [k, m] of Object.entries(obj)) {
            mapping.custom(k, m.value);
        }
        return mapping;
    }
    /**
     * (experimental) Creates a mapping to append a header.
     *
     * @experimental
     */
    appendHeader(name, value) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        this.mappings[`append:header.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a header.
     *
     * @experimental
     */
    overwriteHeader(name, value) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        this.mappings[`overwrite:header.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to remove a header.
     *
     * @experimental
     */
    removeHeader(name) {
        this.mappings[`remove:header.${name}`] = '';
        return this;
    }
    /**
     * (experimental) Creates a mapping to append a query string.
     *
     * @experimental
     */
    appendQueryString(name, value) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        this.mappings[`append:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a querystring.
     *
     * @experimental
     */
    overwriteQueryString(name, value) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        this.mappings[`overwrite:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a mapping to remove a querystring.
     *
     * @experimental
     */
    removeQueryString(name) {
        this.mappings[`remove:querystring.${name}`] = '';
        return this;
    }
    /**
     * (experimental) Creates a mapping to overwrite a path.
     *
     * @experimental
     */
    overwritePath(value) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        this.mappings['overwrite:path'] = value.value;
        return this;
    }
    /**
     * (experimental) Creates a custom mapping.
     *
     * @experimental
     */
    custom(key, value) {
        this.mappings[key] = value;
        return this;
    }
}
exports.ParameterMapping = ParameterMapping;
_b = JSII_RTTI_SYMBOL_1;
ParameterMapping[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ParameterMapping", version: "2.12.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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