"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(method, path) {
        this.method = method !== null && method !== void 0 ? method : HttpMethod.ANY;
        this.path = path;
        this.key = path ? `${method} ${path}` : '$default';
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpMethod(method);
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(method, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteKey", version: "2.12.0-alpha.0" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey();
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** AWS IAM */
    HttpRouteAuthorizationType["AWS_IAM"] = "AWS_IAM";
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteProps(props);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        this.method = props.routeKey.method;
        this.routeArn = this.produceRouteArn(props.routeKey.method);
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        this.authBindResult = (_c = props.authorizer) === null || _c === void 0 ? void 0 : _c.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        });
        if (this.authBindResult && !(this.authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error(`authorizationType should either be AWS_IAM, JWT, CUSTOM, or NONE but was '${this.authBindResult.authorizationType}'`);
        }
        let authorizationScopes = (_d = this.authBindResult) === null || _d === void 0 ? void 0 : _d.authorizationScopes;
        if (this.authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${config.integrationId}`,
            authorizerId: (_e = this.authBindResult) === null || _e === void 0 ? void 0 : _e.authorizerId,
            authorizationType: (_g = (_f = this.authBindResult) === null || _f === void 0 ? void 0 : _f.authorizationType) !== null && _g !== void 0 ? _g : 'NONE',
            authorizationScopes,
        };
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
    produceRouteArn(httpMethod) {
        var _c;
        const stage = '*';
        const iamHttpMethod = httpMethod === HttpMethod.ANY ? '*' : httpMethod;
        const path = (_c = this.path) !== null && _c !== void 0 ? _c : '/';
        // When the user has provided a path with path variables, we replace the
        // path variable and all that follows with a wildcard.
        const iamPath = path.replace(/\{.*?\}.*/, '*');
        return `arn:aws:execute-api:${this.stack.region}:${this.stack.account}:${this.httpApi.apiId}/${stage}/${iamHttpMethod}${iamPath}`;
    }
    /**
     * (experimental) Grant access to invoke the route.
     *
     * This method requires that the authorizer of the route is undefined or is
     * an `HttpIamAuthorizer`.
     *
     * @experimental
     */
    grantInvoke(grantee, options = {}) {
        var _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_GrantInvokeOptions(options);
        if (!this.authBindResult || this.authBindResult.authorizationType !== HttpRouteAuthorizationType.AWS_IAM) {
            throw new Error('To use grantInvoke, you must use IAM authorization');
        }
        const httpMethods = Array.from(new Set((_c = options.httpMethods) !== null && _c !== void 0 ? _c : [this.method]));
        if (this.method !== HttpMethod.ANY && httpMethods.some(method => method !== this.method)) {
            throw new Error('This route does not support granting invoke for all requested http methods');
        }
        const resourceArns = httpMethods.map(httpMethod => {
            return this.produceRouteArn(httpMethod);
        });
        return iam.Grant.addToPrincipal({
            grantee,
            actions: ['execute-api:Invoke'],
            resourceArns: resourceArns,
        });
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRoute", version: "2.12.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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