"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.IntegrationCredentials = exports.HttpIntegrationSubtype = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported integration types.
 *
 * @experimental
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
    HttpIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * (experimental) Supported integration subtypes.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 * @experimental
 */
var HttpIntegrationSubtype;
(function (HttpIntegrationSubtype) {
    HttpIntegrationSubtype["EVENTBRIDGE_PUT_EVENTS"] = "EventBridge-PutEvents";
    HttpIntegrationSubtype["SQS_SEND_MESSAGE"] = "SQS-SendMessage";
    HttpIntegrationSubtype["SQS_RECEIVE_MESSAGE"] = "SQS-ReceiveMessage";
    HttpIntegrationSubtype["SQS_DELETE_MESSAGE"] = "SQS-DeleteMessage";
    HttpIntegrationSubtype["SQS_PURGE_QUEUE"] = "SQS-PurgeQueue";
    HttpIntegrationSubtype["APPCONFIG_GET_CONFIGURATION"] = "AppConfig-GetConfiguration";
    HttpIntegrationSubtype["KINESIS_PUT_RECORD"] = "Kinesis-PutRecord";
    HttpIntegrationSubtype["STEPFUNCTIONS_START_EXECUTION"] = "StepFunctions-StartExecution";
    HttpIntegrationSubtype["STEPFUNCTIONS_START_SYNC_EXECUTION"] = "StepFunctions-StartSyncExecution";
    HttpIntegrationSubtype["STEPFUNCTIONS_STOP_EXECUTION"] = "StepFunctions-StopExecution";
})(HttpIntegrationSubtype = exports.HttpIntegrationSubtype || (exports.HttpIntegrationSubtype = {}));
/**
 * (experimental) Credentials used for AWS Service integrations.
 *
 * @experimental
 */
class IntegrationCredentials {
    /**
     * (experimental) Use the specified role for integration requests.
     *
     * @experimental
     */
    static fromRole(role) {
        return { credentialsArn: role.roleArn };
    }
    /**
     * (experimental) Use the calling user's identity to call the integration.
     *
     * @experimental
     */
    static useCallerIdentity() {
        return { credentialsArn: 'arn:aws:iam::*:user/*' };
    }
}
exports.IntegrationCredentials = IntegrationCredentials;
_a = JSII_RTTI_SYMBOL_1;
IntegrationCredentials[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.IntegrationCredentials", version: "2.12.0-alpha.0" };
/**
 * (experimental) Supported connection types.
 *
 * @experimental
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * (experimental) Payload format version for lambda proxy integration.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 * @experimental
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * (experimental) A custom payload version.
     *
     * Typically used if there is a version number that the CDK doesn't support yet
     *
     * @experimental
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_b = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.PayloadFormatVersion", version: "2.12.0-alpha.0" };
/**
 * (experimental) Version 1.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/**
 * (experimental) Version 2.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpIntegrationProps(props);
        if (!props.integrationSubtype && !props.integrationUri) {
            throw new Error('Either `integrationSubtype` or `integrationUri` must be specified.');
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationSubtype: props.integrationSubtype,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_e = props.payloadFormatVersion) === null || _e === void 0 ? void 0 : _e.version,
            requestParameters: (_f = props.parameterMapping) === null || _f === void 0 ? void 0 : _f.mappings,
            credentialsArn: (_g = props.credentials) === null || _g === void 0 ? void 0 : _g.credentialsArn,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpIntegration", version: "2.12.0-alpha.0" };
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
class HttpRouteIntegration {
    /**
     * (experimental) Initialize an integration for a route on http api.
     *
     * @param id id of the underlying `HttpIntegration` construct.
     * @experimental
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationSubtype: config.subtype,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
                credentials: config.credentials,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_d = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_d] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteIntegration", version: "2.12.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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