import { IRole } from 'aws-cdk-lib/aws-iam';
import { Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IIntegration } from '../common';
import { ParameterMapping } from '../parameter-mapping';
import { IHttpApi } from './api';
import { HttpMethod, IHttpRoute } from './route';
/**
 * (experimental) Represents an Integration for an HTTP API.
 *
 * @experimental
 */
export interface IHttpIntegration extends IIntegration {
    /**
     * (experimental) The HTTP API associated with this integration.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
}
/**
 * (experimental) Supported integration types.
 *
 * @experimental
 */
export declare enum HttpIntegrationType {
    /**
     * (experimental) Integration type is an HTTP proxy.
     *
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html
     * @experimental
     */
    HTTP_PROXY = "HTTP_PROXY",
    /**
     * (experimental) Integration type is an AWS proxy.
     *
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    AWS_PROXY = "AWS_PROXY"
}
/**
 * (experimental) Supported integration subtypes.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 * @experimental
 */
export declare enum HttpIntegrationSubtype {
    /**
     * (experimental) EventBridge PutEvents integration.
     *
     * @experimental
     */
    EVENTBRIDGE_PUT_EVENTS = "EventBridge-PutEvents",
    /**
     * (experimental) SQS SendMessage integration.
     *
     * @experimental
     */
    SQS_SEND_MESSAGE = "SQS-SendMessage",
    /**
     * (experimental) SQS ReceiveMessage integration,.
     *
     * @experimental
     */
    SQS_RECEIVE_MESSAGE = "SQS-ReceiveMessage",
    /**
     * (experimental) SQS DeleteMessage integration,.
     *
     * @experimental
     */
    SQS_DELETE_MESSAGE = "SQS-DeleteMessage",
    /**
     * (experimental) SQS PurgeQueue integration.
     *
     * @experimental
     */
    SQS_PURGE_QUEUE = "SQS-PurgeQueue",
    /**
     * (experimental) AppConfig GetConfiguration integration.
     *
     * @experimental
     */
    APPCONFIG_GET_CONFIGURATION = "AppConfig-GetConfiguration",
    /**
     * (experimental) Kinesis PutRecord integration.
     *
     * @experimental
     */
    KINESIS_PUT_RECORD = "Kinesis-PutRecord",
    /**
     * (experimental) Step Functions StartExecution integration.
     *
     * @experimental
     */
    STEPFUNCTIONS_START_EXECUTION = "StepFunctions-StartExecution",
    /**
     * (experimental) Step Functions StartSyncExecution integration.
     *
     * @experimental
     */
    STEPFUNCTIONS_START_SYNC_EXECUTION = "StepFunctions-StartSyncExecution",
    /**
     * (experimental) Step Functions StopExecution integration.
     *
     * @experimental
     */
    STEPFUNCTIONS_STOP_EXECUTION = "StepFunctions-StopExecution"
}
/**
 * (experimental) Credentials used for AWS Service integrations.
 *
 * @experimental
 */
export declare abstract class IntegrationCredentials {
    /**
     * (experimental) Use the specified role for integration requests.
     *
     * @experimental
     */
    static fromRole(role: IRole): IntegrationCredentials;
    /**
     * (experimental) Use the calling user's identity to call the integration.
     *
     * @experimental
     */
    static useCallerIdentity(): IntegrationCredentials;
    /**
     * (experimental) The ARN of the credentials.
     *
     * @experimental
     */
    abstract readonly credentialsArn: string;
}
/**
 * (experimental) Supported connection types.
 *
 * @experimental
 */
export declare enum HttpConnectionType {
    /**
     * (experimental) For private connections between API Gateway and resources in a VPC.
     *
     * @experimental
     */
    VPC_LINK = "VPC_LINK",
    /**
     * (experimental) For connections through public routable internet.
     *
     * @experimental
     */
    INTERNET = "INTERNET"
}
/**
 * (experimental) Payload format version for lambda proxy integration.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 * @experimental
 */
export declare class PayloadFormatVersion {
    /**
     * (experimental) Version 1.0.
     *
     * @experimental
     */
    static readonly VERSION_1_0: PayloadFormatVersion;
    /**
     * (experimental) Version 2.0.
     *
     * @experimental
     */
    static readonly VERSION_2_0: PayloadFormatVersion;
    /**
     * (experimental) A custom payload version.
     *
     * Typically used if there is a version number that the CDK doesn't support yet
     *
     * @experimental
     */
    static custom(version: string): PayloadFormatVersion;
    /**
     * (experimental) version as a string.
     *
     * @experimental
     */
    readonly version: string;
    private constructor();
}
/**
 * (experimental) The integration properties.
 *
 * @experimental
 */
export interface HttpIntegrationProps {
    /**
     * (experimental) The HTTP API to which this integration should be bound.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly integrationType: HttpIntegrationType;
    /**
     * (experimental) Integration subtype.
     *
     * Used for AWS Service integrations, specifies the target of the integration.
     *
     * @default - none, required if no `integrationUri` is defined.
     * @experimental
     */
    readonly integrationSubtype?: HttpIntegrationSubtype;
    /**
     * (experimental) Integration URI.
     *
     * This will be the function ARN in the case of `HttpIntegrationType.AWS_PROXY`,
     * or HTTP URL in the case of `HttpIntegrationType.HTTP_PROXY`.
     *
     * @default - none, required if no `integrationSubtype` is defined.
     * @experimental
     */
    readonly integrationUri?: string;
    /**
     * (experimental) The HTTP method to use when calling the underlying HTTP proxy.
     *
     * @default - none. required if the integration type is `HttpIntegrationType.HTTP_PROXY`.
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) The ID of the VPC link for a private integration.
     *
     * Supported only for HTTP APIs.
     *
     * @default - undefined
     * @experimental
     */
    readonly connectionId?: string;
    /**
     * (experimental) The type of the network connection to the integration endpoint.
     *
     * @default HttpConnectionType.INTERNET
     * @experimental
     */
    readonly connectionType?: HttpConnectionType;
    /**
     * (experimental) The version of the payload format.
     *
     * @default - defaults to latest in the case of HttpIntegrationType.AWS_PROXY`, irrelevant otherwise.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
    /**
     * (experimental) Specifies the TLS configuration for a private integration.
     *
     * @default undefined private integration traffic will use HTTP protocol
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @experimental
     */
    readonly secureServerName?: string;
    /**
     * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @default undefined requests are sent to the backend unmodified
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html
     * @experimental
     */
    readonly parameterMapping?: ParameterMapping;
    /**
     * (experimental) The credentials with which to invoke the integration.
     *
     * @default - no credentials, use resource-based permissions on supported AWS services
     * @experimental
     */
    readonly credentials?: IntegrationCredentials;
}
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
export declare class HttpIntegration extends Resource implements IHttpIntegration {
    /**
     * (experimental) Id of the integration.
     *
     * @experimental
     */
    readonly integrationId: string;
    /**
     * (experimental) The HTTP API associated with this integration.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpIntegrationProps);
}
/**
 * (experimental) Options to the HttpRouteIntegration during its bind operation.
 *
 * @experimental
 */
export interface HttpRouteIntegrationBindOptions {
    /**
     * (experimental) The route to which this is being bound.
     *
     * @experimental
     */
    readonly route: IHttpRoute;
    /**
     * (experimental) The current scope in which the bind is occurring.
     *
     * If the `HttpRouteIntegration` being bound creates additional constructs,
     * this will be used as their parent scope.
     *
     * @experimental
     */
    readonly scope: Construct;
}
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
export declare abstract class HttpRouteIntegration {
    private readonly id;
    private integration?;
    /**
     * (experimental) Initialize an integration for a route on http api.
     *
     * @param id id of the underlying `HttpIntegration` construct.
     * @experimental
     */
    constructor(id: string);
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options: HttpRouteIntegrationBindOptions): {
        readonly integrationId: string;
    };
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    abstract bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
/**
 * (experimental) Config returned back as a result of the bind.
 *
 * @experimental
 */
export interface HttpRouteIntegrationConfig {
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly type: HttpIntegrationType;
    /**
     * (experimental) Integration subtype.
     *
     * @default - none, required if no `integrationUri` is defined.
     * @experimental
     */
    readonly subtype?: HttpIntegrationSubtype;
    /**
     * (experimental) Integration URI.
     *
     * @default - none, required if no `integrationSubtype` is defined.
     * @experimental
     */
    readonly uri?: string;
    /**
     * (experimental) The HTTP method that must be used to invoke the underlying proxy.
     *
     * Required for `HttpIntegrationType.HTTP_PROXY`
     *
     * @default - undefined
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) The ID of the VPC link for a private integration.
     *
     * Supported only for HTTP APIs.
     *
     * @default - undefined
     * @experimental
     */
    readonly connectionId?: string;
    /**
     * (experimental) The type of the network connection to the integration endpoint.
     *
     * @default HttpConnectionType.INTERNET
     * @experimental
     */
    readonly connectionType?: HttpConnectionType;
    /**
     * (experimental) Payload format version in the case of lambda proxy integration.
     *
     * @default - undefined
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion: PayloadFormatVersion;
    /**
     * (experimental) Specifies the server name to verified by HTTPS when calling the backend integration.
     *
     * @default undefined private integration traffic will use HTTP protocol
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @experimental
     */
    readonly secureServerName?: string;
    /**
     * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @default undefined requests are sent to the backend unmodified
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html
     * @experimental
     */
    readonly parameterMapping?: ParameterMapping;
    /**
     * (experimental) The credentials with which to invoke the integration.
     *
     * @default - no credentials, use resource-based permissions on supported AWS services
     * @experimental
     */
    readonly credentials?: IntegrationCredentials;
}
