"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StageBase = exports.ApiBase = void 0;
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_mapping_1 = require("./api-mapping");
/**
 * Base class representing an API
 * @internal
 */
class ApiBase extends aws_cdk_lib_1.Resource {
    /**
     * (experimental) Return the given named metric for this Api Gateway.
     *
     * @experimental
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/ApiGateway',
            metricName,
            dimensionsMap: { ApiId: this.apiId },
            ...props,
        }).attachTo(this);
    }
}
exports.ApiBase = ApiBase;
/**
 * Base class representing a Stage
 * @internal
 */
class StageBase extends aws_cdk_lib_1.Resource {
    /**
     * @internal
     */
    _addDomainMapping(domainMapping) {
        if (this._apiMapping) {
            throw new Error('Only one ApiMapping allowed per Stage');
        }
        this._apiMapping = new api_mapping_1.ApiMapping(this, `${domainMapping.domainName}${domainMapping.mappingKey}`, {
            api: this.baseApi,
            domainName: domainMapping.domainName,
            stage: this,
            apiMappingKey: domainMapping.mappingKey,
        });
        // ensure the dependency
        this.node.addDependency(domainMapping.domainName);
    }
    /**
     * (experimental) Return the given named metric for this HTTP Api Gateway Stage.
     *
     * @experimental
     */
    metric(metricName, props) {
        return this.baseApi.metric(metricName, props).with({
            dimensionsMap: { ApiId: this.baseApi.apiId, Stage: this.stageName },
        }).attachTo(this);
    }
}
exports.StageBase = StageBase;
//# sourceMappingURL=data:application/json;base64,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