# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .solver_constraint_operator import SolverConstraintOperator as SolverConstraintOperator_6e4a110d
from ..table.cell_address import CellAddress as CellAddress_ae5f0b56


class SolverConstraint(object):
    """
    Struct Class

    is used to specify a constraint for a solver model.

    See Also:
        `API SolverConstraint <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1SolverConstraint.html>`_
    """
    typeName: Literal['com.sun.star.sheet.SolverConstraint']

    def __init__(self, Left: typing.Optional[CellAddress_ae5f0b56] = ..., Operator: typing.Optional[SolverConstraintOperator_6e4a110d] = ..., Right: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Left (CellAddress, optional): Left value.
            Operator (SolverConstraintOperator, optional): Operator value.
            Right (object, optional): Right value.
        """


    @property
    def Left(self) -> CellAddress_ae5f0b56:
        """
        The address of the cell that is constrained.
        """


    @property
    def Operator(self) -> SolverConstraintOperator_6e4a110d:
        """
        The type of the constraint.
        """


    @property
    def Right(self) -> object:
        """
        The comparison value, of type double or com.sun.star.table.CellAddress.
        """


