# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.logging
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..util.date_time import DateTime as DateTime_84de09d3


class LogRecord(object):
    """
    Struct Class

    assembles the complete information about a to-be-logged event
    
    **since**
    
        OOo 2.3

    See Also:
        `API LogRecord <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1logging_1_1LogRecord.html>`_
    """
    typeName: Literal['com.sun.star.logging.LogRecord']

    def __init__(self, LoggerName: typing.Optional[str] = ..., SourceClassName: typing.Optional[str] = ..., SourceMethodName: typing.Optional[str] = ..., Message: typing.Optional[str] = ..., LogTime: typing.Optional[DateTime_84de09d3] = ..., SequenceNumber: typing.Optional[int] = ..., ThreadID: typing.Optional[str] = ..., Level: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            LoggerName (str, optional): LoggerName value.
            SourceClassName (str, optional): SourceClassName value.
            SourceMethodName (str, optional): SourceMethodName value.
            Message (str, optional): Message value.
            LogTime (DateTime, optional): LogTime value.
            SequenceNumber (int, optional): SequenceNumber value.
            ThreadID (str, optional): ThreadID value.
            Level (int, optional): Level value.
        """


    @property
    def LoggerName(self) -> str:
        """
        specifies the name of the logger at which the record is logged
        """


    @property
    def SourceClassName(self) -> str:
        """
        specifies the name of the class, in which the record was logged.
        
        This name might be empty, in case the caller to one of the various log methods of XLogger did not specify it.
        """


    @property
    def SourceMethodName(self) -> str:
        """
        specifies the name of the method, in which the record was logged.
        
        This name might be empty, in case the caller to one of the various log methods of XLogger did not specify it.
        """


    @property
    def Message(self) -> str:
        """
        specifies the to-be-logged message
        """


    @property
    def LogTime(self) -> DateTime_84de09d3:
        """
        specifies the time at which the event was logged
        """


    @property
    def SequenceNumber(self) -> int:
        """
        specifies the number of the log event.
        
        Subsequent events get assigned increasing sequence numbers by the XLogger at which they're logged.
        """


    @property
    def ThreadID(self) -> str:
        """
        specifies the ID of the thread in which the event was logged
        """


    @property
    def Level(self) -> int:
        """
        specifies the level of the log event
        """


