# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.geometry
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class RealRectangle3D(object):
    """
    Struct Class

    This structure contains the necessary information for a three-dimensional cube.
    
    **since**
    
        OOo 2.0

    See Also:
        `API RealRectangle3D <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1geometry_1_1RealRectangle3D.html>`_
    """
    typeName: Literal['com.sun.star.geometry.RealRectangle3D']

    def __init__(self, X1: typing.Optional[float] = ..., Y1: typing.Optional[float] = ..., Z1: typing.Optional[float] = ..., X2: typing.Optional[float] = ..., Y2: typing.Optional[float] = ..., Z2: typing.Optional[float] = ...) -> None:
        """
        Constructor

        Arguments:
            X1 (float, optional): X1 value.
            Y1 (float, optional): Y1 value.
            Z1 (float, optional): Z1 value.
            X2 (float, optional): X2 value.
            Y2 (float, optional): Y2 value.
            Z2 (float, optional): Z2 value.
        """


    @property
    def X1(self) -> float:
        """
        minimum X coordinate.
        """


    @property
    def Y1(self) -> float:
        """
        minimum Y coordinate.
        """


    @property
    def Z1(self) -> float:
        """
        minimum Z coordinate.
        """


    @property
    def X2(self) -> float:
        """
        maximum X coordinate.
        
        Must be greater than X1 for non-empty cubes.
        
        .
        """


    @property
    def Y2(self) -> float:
        """
        maximum Y coordinate.
        
        Must be greater than Y1 for non-empty cubes.
        """


    @property
    def Z2(self) -> float:
        """
        maximum Z coordinate.
        
        Must be greater than Z1 for non-empty cubes.
        """


