# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.datatransfer.dnd
from typing_extensions import Literal
import typing
from ...uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_drop_target_listener import XDropTargetListener as XDropTargetListener_d62c1305

class XDropTarget(XInterface_8f010a43):
    """
    This interface is implemented by a view or window that supports drop operations.
    
    Differently to Java, the association between view and interface is fixed and cannot be changed. Otherwise, the AWT messaging would have to be implemented for any window supporting Drag and Drop operations, which would be a performance issue.

    See Also:
        `API XDropTarget <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1datatransfer_1_1dnd_1_1XDropTarget.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.datatransfer.dnd.XDropTarget']

    def addDropTargetListener(self, dtl: 'XDropTargetListener_d62c1305') -> None:
        """
        Add a DropTargetListener.
        
        The listener will be queried for the XAutoscroll interface to see if it supports autoscrolling.
        """
    def getDefaultActions(self) -> int:
        """
        Determine the actions supported by a drop target.
        
        By default this will include all drag and drop actions.
        """
    def isActive(self) -> bool:
        """
        Indicates either a drop target object is active or not.
        """
    def removeDropTargetListener(self, dtl: 'XDropTargetListener_d62c1305') -> None:
        """
        Remove a drop target listener.
        """
    def setActive(self, active: bool) -> None:
        """
        Sets the drop target object active or inactive.
        
        A value of FALSE sets the drop target object inactive.
        """
    def setDefaultActions(self, actions: int) -> None:
        """
        Sets the default acceptable actions for this drop target.
        
        This method is a way to reduce the number of Drag and Drop events by blocking events for actions not supported by this target.
        
        By default the listener will receive notifications for all actions.
        """

