"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Specifies the type responses the lambda returns
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    /** Returns simple boolean response */
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    /** Returns an IAM Policy */
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * Authorize Http Api routes via a lambda function
 */
class HttpLambdaAuthorizer {
    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The lambda function handler to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.LAMBDA,
                authorizerName: (_d = this.props.authorizerName) !== null && _d !== void 0 ? _d : this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: (_e = this.props.resultsCacheTtl) !== null && _e !== void 0 ? _e : aws_cdk_lib_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer", version: "2.23.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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