# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

#  (C) Copyright IBM Corp. 2021-2023.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from pprint import pformat
from six import iteritems


class MlAssetsCreateExperimentInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, tags=None, name=None, description=None, framework=None, training_data_reference=None, author=None):
        """
        MlAssetsCreateExperimentInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'tags': 'list[TagRepository]',
            'name': 'str',
            'description': 'str',
            'framework': 'FrameworkOutputRepository',
            'training_data_reference': 'ArrayDataInputRepository',
            'author': 'AuthorRepository'
        }

        self.attribute_map = {
            'tags': 'tags',
            'name': 'name',
            'description': 'description',
            'framework': 'framework',
            'training_data_reference': 'training_data_reference',
            'author': 'author'
        }
        self._tags = tags
        self._name = name
        self._description = description
        self._framework = framework
        self._training_data_reference = training_data_reference
        self._author = author

    @property
    def tags(self):
        """
        Gets the tags of this ExperimentInputExperiments.


        :return: The tags of this ExperimentInputExperiments.
        :rtype: list[TagRepository]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ExperimentInputExperiments.


        :param tags: The tags of this ExperimentInputExperiments.
        :type: list[TagRepository]
        """

        self._tags = tags

    @property
    def name(self):
        """
        Gets the name of this MlAssetsCreateExperimentInput.


        :return: The name of this MlAssetsCreateExperimentInput.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MlAssetsCreateExperimentInput.


        :param name: The name of this MlAssetsCreateExperimentInput.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this MlAssetsCreateExperimentInput.


        :return: The description of this MlAssetsCreateExperimentInput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MlAssetsCreateExperimentInput.


        :param description: The description of this MlAssetsCreateExperimentInput.
        :type: str
        """
        self._description = description

    @property
    def framework(self):
        """
        Gets the framework of this MlAssetsCreateExperimentInput.


        :return: The framework of this MlAssetsCreateExperimentInput.
        :rtype: FrameworkOutputRepository
        """
        return self._framework

    @framework.setter
    def framework(self, framework):
        """
        Sets the framework of this MlAssetsCreateExperimentInput.


        :param framework: The framework of this MlAssetsCreateExperimentInput.
        :type: FrameworkOutputRepository
        """
        self._framework = framework

    @property
    def training_data_reference(self):
        """
        Gets the training_data of this MlAssetsCreateExperimentInput.


        :return: The training_data of this MlAssetsCreateExperimentInput.
        :rtype: ArrayDataInputRepository
        """
        return self._training_data_reference

    @training_data_reference.setter
    def training_data_reference(self, training_data_reference):
        """
        Sets the training_data of this MlAssetsCreateExperimentInput.


        :param training_data: The training_data of this MlAssetsCreateExperimentInput.
        :type: ArrayDataInputRepository
        """
        self._training_data_reference = training_data_reference

    @property
    def author(self):
        """
        Gets the author of this MlAssetsCreateExperimentInput.


        :return: The author of this MlAssetsCreateExperimentInput.
        :rtype: AuthorRepository
        """
        return self._author

    @author.setter
    def author(self, author):
        """
        Sets the author of this MlAssetsCreateExperimentInput.


        :param author: The author of this MlAssetsCreateExperimentInput.
        :type: AuthorRepository
        """
        self._author = author

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

