# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

#  (C) Copyright IBM Corp. 2021-2023.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from pprint import pformat
from six import iteritems


class EvaluationDefinitionRepositoryMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, threshold=None, value=None):
        """
        EvaluationDefinitionRepositoryMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'threshold': 'float',
            'value': 'float'
        }

        self.attribute_map = {
            'name': 'name',
            'threshold': 'threshold',
            'value': 'value'
        }

        self._name = name
        self._threshold =  threshold
        self._value =  value

    @property
    def name(self):
        """
        Gets the name of this EvaluationDefinitionRepositoryMetrics.
        The name of the metric

        :return: The name of this EvaluationDefinitionRepositoryMetrics.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EvaluationDefinitionRepositoryMetrics.
        The name of the metric

        :param name: The name of this EvaluationDefinitionRepositoryMetrics.
        :type: str
        """
        self._name = name

    @property
    def threshold(self):
        """
        Gets the threshold of this EvaluationDefinitionRepositoryMetrics.
        The threshold value for the metric\n(if not given the metric value would not influence the retraining conditions)\n

        :return: The threshold of this EvaluationDefinitionRepositoryMetrics.
        :rtype: float
        """
        return self._threshold

    @threshold.setter
    def threshold(self, threshold):
        """
        Sets the threshold of this EvaluationDefinitionRepositoryMetrics.
        The threshold value for the metric\n(if not given the metric value would not influence the retraining conditions)\n

        :param threshold: The threshold of this EvaluationDefinitionRepositoryMetrics.
        :type: float
        """
        self._threshold = threshold

    @property
    def value(self):
        """
        Gets the value of this EvaluationDefinitionRepositoryMetrics.
        The measured value of the metric for the current model version\n

        :return: The value of this EvaluationDefinitionRepositoryMetrics.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this EvaluationDefinitionRepositoryMetrics.
        The measured value of the metric for the current model version\n

        :param value: The value of this EvaluationDefinitionRepositoryMetrics.
        :type: float
        """
        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

