"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabContainerRunner = exports.InstanceInterruptionBehavior = exports.BlockDuration = void 0;
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const path = require("path");
const cr = require("@aws-cdk/custom-resources");
var BlockDuration;
(function (BlockDuration) {
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    BlockDuration[BlockDuration["SEVEN_HOURS"] = 420] = "SEVEN_HOURS";
    BlockDuration[BlockDuration["EIGHT_HOURS"] = 480] = "EIGHT_HOURS";
    BlockDuration[BlockDuration["NINE_HOURS"] = 540] = "NINE_HOURS";
    BlockDuration[BlockDuration["TEN_HOURS"] = 600] = "TEN_HOURS";
    BlockDuration[BlockDuration["ELEVEN_HOURS"] = 660] = "ELEVEN_HOURS";
    BlockDuration[BlockDuration["TWELVE_HOURS"] = 720] = "TWELVE_HOURS";
    BlockDuration[BlockDuration["THIRTEEN_HOURS"] = 780] = "THIRTEEN_HOURS";
    BlockDuration[BlockDuration["FOURTEEN_HOURS"] = 840] = "FOURTEEN_HOURS";
    BlockDuration[BlockDuration["FIFTEEN_HOURS"] = 900] = "FIFTEEN_HOURS";
    BlockDuration[BlockDuration["SIXTEEN_HOURS"] = 960] = "SIXTEEN_HOURS";
    BlockDuration[BlockDuration["SEVENTEEN_HOURS"] = 1020] = "SEVENTEEN_HOURS";
    BlockDuration[BlockDuration["EIGHTTEEN_HOURS"] = 1080] = "EIGHTTEEN_HOURS";
    BlockDuration[BlockDuration["NINETEEN_HOURS"] = 1140] = "NINETEEN_HOURS";
    BlockDuration[BlockDuration["TWENTY_HOURS"] = 1200] = "TWENTY_HOURS";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
class GitlabContainerRunner extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        const spotFleetId = id;
        const token = props.gitlabtoken;
        const tag1 = (_a = props.tag1) !== null && _a !== void 0 ? _a : 'gitlab';
        const tag2 = (_b = props.tag2) !== null && _b !== void 0 ? _b : 'awscdk';
        const tag3 = (_c = props.tag3) !== null && _c !== void 0 ? _c : 'runner';
        const gitlaburl = (_d = props.gitlaburl) !== null && _d !== void 0 ? _d : 'https://gitlab.com/';
        const ec2type = (_e = props.ec2type) !== null && _e !== void 0 ? _e : 't3.micro';
        const shell = aws_ec2_1.UserData.forLinux();
        shell.addCommands('yum update -y ', 'sleep 15 && yum install docker git -y && systemctl start docker && usermod -aG docker ec2-user && chmod 777 /var/run/docker.sock', 'systemctl restart docker && systemctl enable docker', 'docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url ' +
            gitlaburl +
            ' --registration-token ' +
            token +
            ' --docker-pull-policy if-not-present --docker-volumes "/var/run/docker.sock:/var/run/docker.sock" --executor docker --docker-image "alpine:latest" --description "Docker Runner" --tag-list "' +
            tag1 +
            ',' +
            tag2 +
            ',' +
            tag3 +
            '" --docker-privileged', 'sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine', 'usermod -aG docker ssm-user');
        this.runnerRole = (_f = props.ec2iamrole) !== null && _f !== void 0 ? _f : new aws_iam_1.Role(this, 'runner-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        this.validUntil = props.validUntil;
        const instanceProfile = new aws_iam_1.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [this.runnerRole.roleName],
        });
        this.vpc = (_g = props.selfvpc) !== null && _g !== void 0 ? _g : new aws_ec2_1.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [
                {
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
            ],
            natGateways: 0,
        });
        this.defaultRunnerSG = new aws_ec2_1.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        this.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(22));
        const spotOrOnDemand = (_h = props.spotFleet) !== null && _h !== void 0 ? _h : false;
        if (spotOrOnDemand) {
            //throw new Error('yes new spotfleet');
            const imageId = aws_ec2_1.MachineImage.latestAmazonLinux({
                generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).getImage(this).imageId;
            const lt = new aws_ec2_1.CfnLaunchTemplate(this, 'LaunchTemplate', {
                launchTemplateData: {
                    imageId,
                    instanceType: ec2type,
                    blockDeviceMappings: [
                        {
                            deviceName: '/dev/xvda',
                            ebs: {
                                volumeSize: (_j = props.ebsSize) !== null && _j !== void 0 ? _j : 60,
                            },
                        },
                    ],
                    userData: core_1.Fn.base64(shell.render()),
                    keyName: props.keyName,
                    tagSpecifications: [
                        {
                            resourceType: 'instance',
                            tags: [
                                {
                                    key: 'Name',
                                    value: `${core_1.Stack.of(this).stackName}/spotFleetGitlabRunner/${spotFleetId}`,
                                },
                            ],
                        },
                    ],
                    instanceMarketOptions: {
                        marketType: 'spot',
                        spotOptions: {
                            blockDurationMinutes: (_k = props.blockDuration) !== null && _k !== void 0 ? _k : BlockDuration.ONE_HOUR,
                            instanceInterruptionBehavior: (_l = props.instanceInterruptionBehavior) !== null && _l !== void 0 ? _l : InstanceInterruptionBehavior.TERMINATE,
                        },
                    },
                    securityGroupIds: this.defaultRunnerSG.connections.securityGroups.map((m) => m.securityGroupId),
                    iamInstanceProfile: {
                        arn: instanceProfile.attrArn,
                    },
                },
            });
            const spotFleetRole = new aws_iam_1.Role(this, 'FleetRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('spotfleet.amazonaws.com'),
                managedPolicies: [
                    aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
                ],
            });
            const vpcSubnetSelection = (_m = props.vpcSubnet) !== null && _m !== void 0 ? _m : {
                subnetType: aws_ec2_1.SubnetType.PUBLIC,
            };
            const subnetConfig = this.vpc
                .selectSubnets(vpcSubnetSelection)
                .subnets.map((s) => ({
                subnetId: s.subnetId,
            }));
            const cfnSpotFleet = new aws_ec2_1.CfnSpotFleet(this, id, {
                spotFleetRequestConfigData: {
                    launchTemplateConfigs: [
                        {
                            launchTemplateSpecification: {
                                launchTemplateId: lt.ref,
                                version: lt.attrLatestVersionNumber,
                            },
                            overrides: subnetConfig,
                        },
                    ],
                    iamFleetRole: spotFleetRole.roleArn,
                    targetCapacity: 1,
                    validUntil: core_1.Lazy.stringValue({ produce: () => this.validUntil }),
                    terminateInstancesWithExpiration: true,
                },
            });
            const onEvent = new lambda.Function(this, 'OnEvent', {
                code: lambda.Code.fromAsset(path.join(__dirname, './getinstanceId/')),
                handler: 'index.on_event',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
            });
            const isComplete = new lambda.Function(this, 'IsComplete', {
                code: lambda.Code.fromAsset(path.join(__dirname, './getinstanceId/')),
                handler: 'index.is_complete',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
                role: onEvent.role,
            });
            const myProvider = new cr.Provider(this, 'MyProvider', {
                onEventHandler: onEvent,
                isCompleteHandler: isComplete,
                logRetention: logs.RetentionDays.ONE_DAY,
            });
            onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
                actions: ['ec2:DescribeSpotFleetInstances'],
                resources: ['*'],
            }));
            const fleetInstances = new core_1.CustomResource(this, 'GetInstanceId', {
                serviceToken: myProvider.serviceToken,
                properties: {
                    SpotFleetRequestId: cfnSpotFleet.ref,
                },
            });
            fleetInstances.node.addDependency(cfnSpotFleet);
            this.spotFleetInstanceId = core_1.Token.asString(fleetInstances.getAtt('InstanceId'));
            this.spotFleetRequestId = core_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
            new core_1.CfnOutput(this, 'InstanceId', { value: this.spotFleetInstanceId });
            new core_1.CfnOutput(this, 'SpotFleetId', { value: cfnSpotFleet.ref });
        }
        else {
            this.runnerEc2 = new aws_ec2_1.Instance(this, 'GitlabRunner', {
                instanceType: new aws_ec2_1.InstanceType(ec2type),
                instanceName: 'Gitlab-Runner',
                vpc: this.vpc,
                vpcSubnets: (_o = props.vpcSubnet) !== null && _o !== void 0 ? _o : {
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
                machineImage: aws_ec2_1.MachineImage.latestAmazonLinux({
                    generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
                }),
                role: this.runnerRole,
                userData: shell,
                securityGroup: this.defaultRunnerSG,
                blockDevices: [
                    {
                        deviceName: '/dev/xvda',
                        volume: aws_ec2_1.BlockDeviceVolume.ebs((_p = props.ebsSize) !== null && _p !== void 0 ? _p : 60),
                    },
                ],
            });
            new core_1.CfnOutput(this, 'Runner-Instance-ID', {
                value: this.runnerEc2.instanceId,
            });
        }
        this.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new core_1.CfnOutput(this, 'Runner-Role-Arn', {
            value: this.runnerRole.roleArn,
        });
    }
    /**
     * @default - !!! only support spotfleet runner !!! .
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBU3VCO0FBQ3ZCLDhDQU8wQjtBQUMxQiw4Q0FpQjBCO0FBQzFCLDhDQUE4QztBQUM5QywwQ0FBMEM7QUFDMUMsNkJBQTZCO0FBQzdCLGdEQUFnRDtBQXNMaEQsSUFBWSxhQXFCWDtBQXJCRCxXQUFZLGFBQWE7SUFDdkIsMERBQWEsQ0FBQTtJQUNiLDZEQUFlLENBQUE7SUFDZixpRUFBaUIsQ0FBQTtJQUNqQiwrREFBZ0IsQ0FBQTtJQUNoQiwrREFBZ0IsQ0FBQTtJQUNoQiw2REFBZSxDQUFBO0lBQ2YsaUVBQWlCLENBQUE7SUFDakIsaUVBQWlCLENBQUE7SUFDakIsK0RBQWdCLENBQUE7SUFDaEIsNkRBQWUsQ0FBQTtJQUNmLG1FQUFrQixDQUFBO0lBQ2xCLG1FQUFrQixDQUFBO0lBQ2xCLHVFQUFvQixDQUFBO0lBQ3BCLHVFQUFvQixDQUFBO0lBQ3BCLHFFQUFtQixDQUFBO0lBQ25CLHFFQUFtQixDQUFBO0lBQ25CLDBFQUFzQixDQUFBO0lBQ3RCLDBFQUFzQixDQUFBO0lBQ3RCLHdFQUFxQixDQUFBO0lBQ3JCLG9FQUFtQixDQUFBO0FBQ3JCLENBQUMsRUFyQlcsYUFBYSxHQUFiLHFCQUFhLEtBQWIscUJBQWEsUUFxQnhCO0FBRUQsSUFBWSw0QkFJWDtBQUpELFdBQVksNEJBQTRCO0lBQ3RDLHVEQUF1QixDQUFBO0lBQ3ZCLDZDQUFhLENBQUE7SUFDYix1REFBdUIsQ0FBQTtBQUN6QixDQUFDLEVBSlcsNEJBQTRCLEdBQTVCLG9DQUE0QixLQUE1QixvQ0FBNEIsUUFJdkM7QUFFRCxNQUFhLHFCQUFzQixTQUFRLGdCQUFTO0lBOEJsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlDOztRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQztRQUN2QixNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ2hDLE1BQU0sSUFBSSxTQUFHLEtBQUssQ0FBQyxJQUFJLG1DQUFJLFFBQVEsQ0FBQztRQUNwQyxNQUFNLElBQUksU0FBRyxLQUFLLENBQUMsSUFBSSxtQ0FBSSxRQUFRLENBQUM7UUFDcEMsTUFBTSxJQUFJLFNBQUcsS0FBSyxDQUFDLElBQUksbUNBQUksUUFBUSxDQUFDO1FBQ3BDLE1BQU0sU0FBUyxTQUFHLEtBQUssQ0FBQyxTQUFTLG1DQUFJLHFCQUFxQixDQUFDO1FBQzNELE1BQU0sT0FBTyxTQUFHLEtBQUssQ0FBQyxPQUFPLG1DQUFJLFVBQVUsQ0FBQztRQUM1QyxNQUFNLEtBQUssR0FBRyxrQkFBUSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ2xDLEtBQUssQ0FBQyxXQUFXLENBQ2YsZ0JBQWdCLEVBQ2hCLGtJQUFrSSxFQUNsSSxxREFBcUQsRUFDckQsNE1BQTRNO1lBQzFNLFNBQVM7WUFDVCx3QkFBd0I7WUFDeEIsS0FBSztZQUNMLCtMQUErTDtZQUMvTCxJQUFJO1lBQ0osR0FBRztZQUNILElBQUk7WUFDSixHQUFHO1lBQ0gsSUFBSTtZQUNKLHVCQUF1QixFQUV6Qiw2TEFBNkwsRUFDN0wsNkJBQTZCLENBQzlCLENBQUM7UUFFRixJQUFJLENBQUMsVUFBVSxTQUNiLEtBQUssQ0FBQyxVQUFVLG1DQUNoQixJQUFJLGNBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFO1lBQzVCLFNBQVMsRUFBRSxJQUFJLDBCQUFnQixDQUFDLG1CQUFtQixDQUFDO1lBQ3BELFdBQVcsRUFBRSw0QkFBNEI7U0FDMUMsQ0FBQyxDQUFDO1FBQ0wsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLE1BQU0sZUFBZSxHQUFHLElBQUksNEJBQWtCLENBQUMsSUFBSSxFQUFFLGlCQUFpQixFQUFFO1lBQ3RFLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1NBQ2xDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxHQUFHLFNBQ04sS0FBSyxDQUFDLE9BQU8sbUNBQ2IsSUFBSSxhQUFHLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRTtZQUNuQixJQUFJLEVBQUUsYUFBYTtZQUNuQixNQUFNLEVBQUUsQ0FBQztZQUNULG1CQUFtQixFQUFFO2dCQUNuQjtvQkFDRSxRQUFRLEVBQUUsRUFBRTtvQkFDWixJQUFJLEVBQUUsV0FBVztvQkFDakIsVUFBVSxFQUFFLG9CQUFVLENBQUMsTUFBTTtpQkFDOUI7YUFDRjtZQUNELFdBQVcsRUFBRSxDQUFDO1NBQ2YsQ0FBQyxDQUFDO1FBQ0wsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLHVCQUFhLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUM1RCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7U0FDZCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDaEUsTUFBTSxjQUFjLFNBQUcsS0FBSyxDQUFDLFNBQVMsbUNBQUksS0FBSyxDQUFDO1FBQ2hELElBQUksY0FBYyxFQUFFO1lBQ2xCLHVDQUF1QztZQUV2QyxNQUFNLE9BQU8sR0FBRyxzQkFBWSxDQUFDLGlCQUFpQixDQUFDO2dCQUM3QyxVQUFVLEVBQUUsK0JBQXFCLENBQUMsY0FBYzthQUNqRCxDQUFDLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQztZQUMxQixNQUFNLEVBQUUsR0FBRyxJQUFJLDJCQUFpQixDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtnQkFDdkQsa0JBQWtCLEVBQUU7b0JBQ2xCLE9BQU87b0JBQ1AsWUFBWSxFQUFFLE9BQU87b0JBQ3JCLG1CQUFtQixFQUFFO3dCQUNuQjs0QkFDRSxVQUFVLEVBQUUsV0FBVzs0QkFDdkIsR0FBRyxFQUFFO2dDQUNILFVBQVUsUUFBRSxLQUFLLENBQUMsT0FBTyxtQ0FBSSxFQUFFOzZCQUNoQzt5QkFDRjtxQkFDRjtvQkFDRCxRQUFRLEVBQUUsU0FBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7b0JBQ25DLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztvQkFDdEIsaUJBQWlCLEVBQUU7d0JBQ2pCOzRCQUNFLFlBQVksRUFBRSxVQUFVOzRCQUN4QixJQUFJLEVBQUU7Z0NBQ0o7b0NBQ0UsR0FBRyxFQUFFLE1BQU07b0NBQ1gsS0FBSyxFQUFFLEdBQ0wsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUNqQiwwQkFBMEIsV0FBVyxFQUFFO2lDQUN4Qzs2QkFDRjt5QkFDRjtxQkFDRjtvQkFDRCxxQkFBcUIsRUFBRTt3QkFDckIsVUFBVSxFQUFFLE1BQU07d0JBQ2xCLFdBQVcsRUFBRTs0QkFDWCxvQkFBb0IsUUFDbEIsS0FBSyxDQUFDLGFBQWEsbUNBQUksYUFBYSxDQUFDLFFBQVE7NEJBQy9DLDRCQUE0QixRQUMxQixLQUFLLENBQUMsNEJBQTRCLG1DQUNsQyw0QkFBNEIsQ0FBQyxTQUFTO3lCQUN6QztxQkFDRjtvQkFDRCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsR0FBRyxDQUNuRSxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FDekI7b0JBQ0Qsa0JBQWtCLEVBQUU7d0JBQ2xCLEdBQUcsRUFBRSxlQUFlLENBQUMsT0FBTztxQkFDN0I7aUJBQ0Y7YUFDRixDQUFDLENBQUM7WUFFSCxNQUFNLGFBQWEsR0FBRyxJQUFJLGNBQUksQ0FBQyxJQUFJLEVBQUUsV0FBVyxFQUFFO2dCQUNoRCxTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQyx5QkFBeUIsQ0FBQztnQkFDMUQsZUFBZSxFQUFFO29CQUNmLHVCQUFhLENBQUMsd0JBQXdCLENBQ3BDLDRDQUE0QyxDQUM3QztpQkFDRjthQUNGLENBQUMsQ0FBQztZQUVILE1BQU0sa0JBQWtCLFNBQUcsS0FBSyxDQUFDLFNBQVMsbUNBQUk7Z0JBQzVDLFVBQVUsRUFBRSxvQkFBVSxDQUFDLE1BQU07YUFDOUIsQ0FBQztZQUNGLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxHQUFHO2lCQUMxQixhQUFhLENBQUMsa0JBQWtCLENBQUM7aUJBQ2pDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ25CLFFBQVEsRUFBRSxDQUFDLENBQUMsUUFBUTthQUNyQixDQUFDLENBQUMsQ0FBQztZQUVOLE1BQU0sWUFBWSxHQUFHLElBQUksc0JBQVksQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFFO2dCQUM5QywwQkFBMEIsRUFBRTtvQkFDMUIscUJBQXFCLEVBQUU7d0JBQ3JCOzRCQUNFLDJCQUEyQixFQUFFO2dDQUMzQixnQkFBZ0IsRUFBRSxFQUFFLENBQUMsR0FBRztnQ0FDeEIsT0FBTyxFQUFFLEVBQUUsQ0FBQyx1QkFBdUI7NkJBQ3BDOzRCQUNELFNBQVMsRUFBRSxZQUFZO3lCQUN4QjtxQkFDRjtvQkFDRCxZQUFZLEVBQUUsYUFBYSxDQUFDLE9BQU87b0JBQ25DLGNBQWMsRUFBRSxDQUFDO29CQUNqQixVQUFVLEVBQUUsV0FBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7b0JBQ2hFLGdDQUFnQyxFQUFFLElBQUk7aUJBQ3ZDO2FBQ0YsQ0FBQyxDQUFDO1lBQ0gsTUFBTSxPQUFPLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7Z0JBQ25ELElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO2dCQUNyRSxPQUFPLEVBQUUsZ0JBQWdCO2dCQUN6QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO2dCQUNsQyxPQUFPLEVBQUUsZUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7YUFDOUIsQ0FBQyxDQUFDO1lBRUgsTUFBTSxVQUFVLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7Z0JBQ3pELElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO2dCQUNyRSxPQUFPLEVBQUUsbUJBQW1CO2dCQUM1QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO2dCQUNsQyxPQUFPLEVBQUUsZUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQzdCLElBQUksRUFBRSxPQUFPLENBQUMsSUFBSTthQUNuQixDQUFDLENBQUM7WUFFSCxNQUFNLFVBQVUsR0FBRyxJQUFJLEVBQUUsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtnQkFDckQsY0FBYyxFQUFFLE9BQU87Z0JBQ3ZCLGlCQUFpQixFQUFFLFVBQVU7Z0JBQzdCLFlBQVksRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU87YUFDekMsQ0FBQyxDQUFDO1lBRUgsT0FBTyxDQUFDLGVBQWUsQ0FDckIsSUFBSSx5QkFBZSxDQUFDO2dCQUNsQixPQUFPLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQztnQkFDM0MsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO2FBQ2pCLENBQUMsQ0FDSCxDQUFDO1lBRUYsTUFBTSxjQUFjLEdBQUcsSUFBSSxxQkFBYyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7Z0JBQy9ELFlBQVksRUFBRSxVQUFVLENBQUMsWUFBWTtnQkFDckMsVUFBVSxFQUFFO29CQUNWLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxHQUFHO2lCQUNyQzthQUNGLENBQUMsQ0FBQztZQUVILGNBQWMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQ2hELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxZQUFLLENBQUMsUUFBUSxDQUN2QyxjQUFjLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUNwQyxDQUFDO1lBQ0YsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFlBQUssQ0FBQyxRQUFRLENBQ3RDLGNBQWMsQ0FBQyxNQUFNLENBQUMsdUJBQXVCLENBQUMsQ0FDL0MsQ0FBQztZQUNGLElBQUksZ0JBQVMsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLENBQUM7WUFDdkUsSUFBSSxnQkFBUyxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUUsRUFBRSxLQUFLLEVBQUUsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7U0FDakU7YUFBTTtZQUNMLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxrQkFBUSxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUU7Z0JBQ2xELFlBQVksRUFBRSxJQUFJLHNCQUFZLENBQUMsT0FBTyxDQUFDO2dCQUN2QyxZQUFZLEVBQUUsZUFBZTtnQkFDN0IsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO2dCQUNiLFVBQVUsUUFBRSxLQUFLLENBQUMsU0FBUyxtQ0FBSTtvQkFDN0IsVUFBVSxFQUFFLG9CQUFVLENBQUMsTUFBTTtpQkFDOUI7Z0JBQ0QsWUFBWSxFQUFFLHNCQUFZLENBQUMsaUJBQWlCLENBQUM7b0JBQzNDLFVBQVUsRUFBRSwrQkFBcUIsQ0FBQyxjQUFjO2lCQUNqRCxDQUFDO2dCQUNGLElBQUksRUFBRSxJQUFJLENBQUMsVUFBVTtnQkFDckIsUUFBUSxFQUFFLEtBQUs7Z0JBQ2YsYUFBYSxFQUFFLElBQUksQ0FBQyxlQUFlO2dCQUNuQyxZQUFZLEVBQUU7b0JBQ1o7d0JBQ0UsVUFBVSxFQUFFLFdBQVc7d0JBQ3ZCLE1BQU0sRUFBRSwyQkFBaUIsQ0FBQyxHQUFHLE9BQUMsS0FBSyxDQUFDLE9BQU8sbUNBQUksRUFBRSxDQUFDO3FCQUNuRDtpQkFDRjthQUNGLENBQUMsQ0FBQztZQUNILElBQUksZ0JBQVMsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLEVBQUU7Z0JBQ3hDLEtBQUssRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVU7YUFDakMsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUM5Qix1QkFBYSxDQUFDLHdCQUF3QixDQUFDLDhCQUE4QixDQUFDLENBQ3ZFLENBQUM7UUFFRixJQUFJLGdCQUFTLENBQUMsSUFBSSxFQUFFLGlCQUFpQixFQUFFO1lBQ3JDLEtBQUssRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU87U0FDL0IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0ksV0FBVyxDQUFDLFFBQWtCO1FBQ25DLE1BQU0sSUFBSSxHQUFHLElBQUksSUFBSSxFQUFFLENBQUM7UUFDeEIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLEdBQUcsUUFBUSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDMUQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDdkMsQ0FBQztDQUNGO0FBdlFELHNEQXVRQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENvbnN0cnVjdCxcbiAgQ2ZuT3V0cHV0LFxuICBGbixcbiAgU3RhY2ssXG4gIER1cmF0aW9uLFxuICBMYXp5LFxuICBDdXN0b21SZXNvdXJjZSxcbiAgVG9rZW4sXG59IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHtcbiAgSVJvbGUsXG4gIFJvbGUsXG4gIFNlcnZpY2VQcmluY2lwYWwsXG4gIE1hbmFnZWRQb2xpY3ksXG4gIENmbkluc3RhbmNlUHJvZmlsZSxcbiAgUG9saWN5U3RhdGVtZW50LFxufSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7XG4gIEluc3RhbmNlLFxuICBJbnN0YW5jZVR5cGUsXG4gIE1hY2hpbmVJbWFnZSxcbiAgVXNlckRhdGEsXG4gIEJsb2NrRGV2aWNlVm9sdW1lLFxuICBBbWF6b25MaW51eEdlbmVyYXRpb24sXG4gIFN1Ym5ldFR5cGUsXG4gIFZwYyxcbiAgSVZwYyxcbiAgSUluc3RhbmNlLFxuICBTZWN1cml0eUdyb3VwLFxuICBQb3J0LFxuICBDZm5MYXVuY2hUZW1wbGF0ZSxcbiAgQ2ZuU3BvdEZsZWV0LFxuICBJU2VjdXJpdHlHcm91cCxcbiAgU3VibmV0U2VsZWN0aW9uLFxufSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSAnQGF3cy1jZGsvYXdzLWxvZ3MnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGNyIGZyb20gJ0Bhd3MtY2RrL2N1c3RvbS1yZXNvdXJjZXMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEdpdGxhYkNvbnRhaW5lclJ1bm5lclByb3BzIHtcbiAgLyoqXG4gICAqIEdpdGxhYiB0b2tlbiBmb3IgdGhlIFJlZ2lzdGVyIFJ1bm5lciAuXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIG5ldyBHaXRsYWJDb250YWluZXJSdW5uZXIoc3RhY2ssICdydW5uZXInLCB7IGdpdGxhYnRva2VuOiAnR0lUTEFCX1RPS0VOJyB9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBZb3UgbXVzdCB0byBnaXZlIHRoZSB0b2tlbiAhISFcbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGdpdGxhYnRva2VuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJ1bm5lciBkZWZhdWx0IEVDMiBpbnN0YW5jZSB0eXBlLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsIGVjMnR5cGU6ICd0My5zbWFsbCcgfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdDMubWljcm9cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGVjMnR5cGU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFZQQyBmb3IgdGhlIEdpdGxhYiBSdW5uZXIgLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBjb25zdCBuZXd2cGMgPSBuZXcgVnBjKHN0YWNrLCAnTkVXVlBDJywge1xuICAgKiAgIGNpZHI6ICcxMC4xLjAuMC8xNicsXG4gICAqICAgbWF4QXpzOiAyLFxuICAgKiAgIHN1Ym5ldENvbmZpZ3VyYXRpb246IFt7XG4gICAqICAgICBjaWRyTWFzazogMjYsXG4gICAqICAgICBuYW1lOiAnUnVubmVyVlBDJyxcbiAgICogICAgIHN1Ym5ldFR5cGU6IFN1Ym5ldFR5cGUuUFVCTElDLFxuICAgKiAgIH1dLFxuICAgKiAgIG5hdEdhdGV3YXlzOiAwLFxuICAgKiB9KTtcbiAgICpcbiAgICogbmV3IEdpdGxhYkNvbnRhaW5lclJ1bm5lcihzdGFjaywgJ3J1bm5lcicsIHsgZ2l0bGFidG9rZW46ICdHSVRMQUJfVE9LRU4nLCBzZWxmdnBjOiBuZXd2cGMgfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbmV3IFZQQyB3aWxsIGJlIGNyZWF0ZWQgLCAxIFZwYyAsIDIgUHVibGljIFN1Ym5ldCAuXG4gICAqXG4gICAqL1xuICByZWFkb25seSBzZWxmdnBjPzogSVZwYztcblxuICAvKipcbiAgICogSUFNIHJvbGUgZm9yIHRoZSBHaXRsYWIgUnVubmVyIEluc3RhbmNlIC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogY29uc3Qgcm9sZSA9IG5ldyBSb2xlKHN0YWNrLCAncnVubmVyLXJvbGUnLCB7XG4gICAqICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnZWMyLmFtYXpvbmF3cy5jb20nKSxcbiAgICogICBkZXNjcmlwdGlvbjogJ0ZvciBHaXRsYWIgRUMyIFJ1bm5lciBUZXN0IFJvbGUnLFxuICAgKiAgIHJvbGVOYW1lOiAnTXlzZWxmLVJ1bm5lci1Sb2xlJyxcbiAgICogfSk7XG4gICAqXG4gICAqIG5ldyBHaXRsYWJDb250YWluZXJSdW5uZXIoc3RhY2ssICdydW5uZXInLCB7IGdpdGxhYnRva2VuOiAnR0lUTEFCX1RPS0VOJywgZWMyaWFtcm9sZTogcm9sZSB9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBuZXcgUm9sZSBmb3IgR2l0bGFiIFJ1bm5lciBJbnN0YW5jZSAsIGF0dGFjaCBBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlIFBvbGljeSAuXG4gICAqXG4gICAqL1xuICByZWFkb25seSBlYzJpYW1yb2xlPzogSVJvbGU7XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgcmVnaXN0ZXIgdGFnMSAgLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsIHRhZzE6ICdhYScgfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGFnMTogZ2l0bGFiIC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IHRhZzE/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgcmVnaXN0ZXIgdGFnMiAgLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsIHRhZzI6ICdiYicgfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGFnMjogYXdzY2RrIC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IHRhZzI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgcmVnaXN0ZXIgdGFnMyAgLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsIHRhZzM6ICdjYycgfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGFnMzogcnVubmVyIC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IHRhZzM/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgcmVnaXN0ZXIgdXJsIC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogY29uc3QgcnVubmVyID0gbmV3IEdpdGxhYkNvbnRhaW5lclJ1bm5lcihzdGFjaywgJ3J1bm5lcicsIHsgZ2l0bGFidG9rZW46ICdHSVRMQUJfVE9LRU4nLGdpdGxhYnVybDogJ2h0dHBzOi8vZ2l0bGFiLmNvbS8nfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZ2l0bGFidXJsPSdodHRwczovL2dpdGxhYi5jb20vJ1xuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgZ2l0bGFidXJsPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBHaXRsYWIgUnVubmVyIGluc3RhbmNlIEVCUyBzaXplIC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogY29uc3QgcnVubmVyID0gbmV3IEdpdGxhYkNvbnRhaW5lclJ1bm5lcihzdGFjaywgJ3J1bm5lcicsIHsgZ2l0bGFidG9rZW46ICdHSVRMQUJfVE9LRU4nLGVic1NpemU6IDEwMH0pO1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIGVic1NpemU9NjBcbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGVic1NpemU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgaW5zdGFuY2UgVXNlIFNwb3QgRmxlZXQgb3Igbm90ID8hLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBjb25zdCBydW5uZXIgPSBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsc3BvdEZsZWV0OiB0cnVlfSk7XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gc3BvdEZsZWV0PWZhbHNlXG4gICAqXG4gICAqL1xuICByZWFkb25seSBzcG90RmxlZXQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBTU0gga2V5IG5hbWVcbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBzc2gga2V5IHdpbGwgYmUgYXNzaWduZWQgLCAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHJlYWRvbmx5IGtleU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJlc2VydmNlIHRoZSBTcG90IFJ1bm5lciBpbnN0YW5jZSBhcyBzcG90IGJsb2NrIHdpdGggZGVmaW5lZCBkdXJhdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEJsb2NrRHVyYXRpb24uT05FX0hPVVIgLCAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHJlYWRvbmx5IGJsb2NrRHVyYXRpb24/OiBCbG9ja0R1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgYmVoYXZpb3Igd2hlbiBhIFNwb3QgUnVubmVyIEluc3RhbmNlIGlzIGludGVycnVwdGVkXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gSW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvci5URVJNSU5BVEUgLCAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHJlYWRvbmx5IGluc3RhbmNlSW50ZXJydXB0aW9uQmVoYXZpb3I/OiBJbnN0YW5jZUludGVycnVwdGlvbkJlaGF2aW9yO1xuXG4gIC8qKlxuICAgKiB0aGUgdGltZSB3aGVuIHRoZSBzcG90IGZsZWV0IGFsbG9jYXRpb24gZXhwaXJlc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGV4cGlyYXRpb24gLCAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHJlYWRvbmx5IHZhbGlkVW50aWw/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFZQQyBzdWJuZXQgZm9yIHRoZSBzcG90IGZsZWV0XG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIGNvbnN0IHZwYyA9IG5ldyBWcGMoc3RhY2ssICduYXQnLCB7XG4gICAqIG5hdEdhdGV3YXlzOiAxLFxuICAgKiBtYXhBenM6IDIsXG4gICAqIH0pO1xuICAgKiBjb25zdCBydW5uZXIgPSBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAndGVzdGluZycsIHtcbiAgICogICBnaXRsYWJ0b2tlbjogJ0dJVExBQl9UT0tFTicsXG4gICAqICAgZWMydHlwZTogJ3QzLmxhcmdlJyxcbiAgICogICBlYzJpYW1yb2xlOiByb2xlLFxuICAgKiAgIGVic1NpemU6IDEwMCxcbiAgICogICBzZWxmdnBjOiB2cGMsXG4gICAqICAgdnBjU3VibmV0OiB7XG4gICAqICAgICBzdWJuZXRUeXBlOiBTdWJuZXRUeXBlLlBVQkxJQyxcbiAgICogICB9LFxuICAgKiB9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBwdWJsaWMgc3VibmV0XG4gICAqL1xuICByZWFkb25seSB2cGNTdWJuZXQ/OiBTdWJuZXRTZWxlY3Rpb247XG59XG5cbmV4cG9ydCBlbnVtIEJsb2NrRHVyYXRpb24ge1xuICBPTkVfSE9VUiA9IDYwLFxuICBUV09fSE9VUlMgPSAxMjAsXG4gIFRIUkVFX0hPVVJTID0gMTgwLFxuICBGT1VSX0hPVVJTID0gMjQwLFxuICBGSVZFX0hPVVJTID0gMzAwLFxuICBTSVhfSE9VUlMgPSAzNjAsXG4gIFNFVkVOX0hPVVJTID0gNDIwLFxuICBFSUdIVF9IT1VSUyA9IDQ4MCxcbiAgTklORV9IT1VSUyA9IDU0MCxcbiAgVEVOX0hPVVJTID0gNjAwLFxuICBFTEVWRU5fSE9VUlMgPSA2NjAsXG4gIFRXRUxWRV9IT1VSUyA9IDcyMCxcbiAgVEhJUlRFRU5fSE9VUlMgPSA3ODAsXG4gIEZPVVJURUVOX0hPVVJTID0gODQwLFxuICBGSUZURUVOX0hPVVJTID0gOTAwLFxuICBTSVhURUVOX0hPVVJTID0gOTYwLFxuICBTRVZFTlRFRU5fSE9VUlMgPSAxMDIwLFxuICBFSUdIVFRFRU5fSE9VUlMgPSAxMDgwLFxuICBOSU5FVEVFTl9IT1VSUyA9IDExNDAsXG4gIFRXRU5UWV9IT1VSUyA9IDEyMDAsXG59XG5cbmV4cG9ydCBlbnVtIEluc3RhbmNlSW50ZXJydXB0aW9uQmVoYXZpb3Ige1xuICBISUJFUk5BVEUgPSAnaGliZXJuYXRlJyxcbiAgU1RPUCA9ICdzdG9wJyxcbiAgVEVSTUlOQVRFID0gJ3Rlcm1pbmF0ZScsXG59XG5cbmV4cG9ydCBjbGFzcyBHaXRsYWJDb250YWluZXJSdW5uZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAvKipcbiAgICogVGhlIElBTSByb2xlIGFzc3VtZWQgYnkgdGhlIFJ1bm5lciBpbnN0YW5jZSAuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcnVubmVyUm9sZTogSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoaXMgcmVwcmVzZW50cyBhIFJ1bm5lciBFQzIgaW5zdGFuY2UgLCAhISEgb25seSBzdXBwb3J0IE9uLWRlbWFuZCBydW5uZXIgaW5zdGFuY2UgISEhIC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBydW5uZXJFYzIhOiBJSW5zdGFuY2U7XG5cbiAgcHVibGljIHJlYWRvbmx5IHZwYyE6IElWcGM7XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lIHdoZW4gdGhlIHRoZSBmbGVldCBhbGxvY2F0aW9uIHdpbGwgZXhwaXJlICwgISEhIG9ubHkgc3VwcG9ydCBzcG90ZmxlZXQgcnVubmVyICEhISAuXG4gICAqL1xuICBwcml2YXRlIHZhbGlkVW50aWw/OiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IGRlZmF1bHRSdW5uZXJTRyE6IElTZWN1cml0eUdyb3VwO1xuXG4gIC8qKlxuICAgKiBTcG90RmxlZXRSZXF1ZXN0SWQgZm9yIHRoaXMgc3BvdCBmbGVldCAsICEhISBvbmx5IHN1cHBvcnQgc3BvdGZsZWV0IHJ1bm5lciAhISEgLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNwb3RGbGVldFJlcXVlc3RJZCE6IHN0cmluZztcblxuICAvKipcbiAgICogdGhlIGZpcnN0IGluc3RhbmNlIGlkIGluIHRoaXMgZmxlZXQgLCAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHJlYWRvbmx5IHNwb3RGbGVldEluc3RhbmNlSWQhOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdpdGxhYkNvbnRhaW5lclJ1bm5lclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzcG90RmxlZXRJZCA9IGlkO1xuICAgIGNvbnN0IHRva2VuID0gcHJvcHMuZ2l0bGFidG9rZW47XG4gICAgY29uc3QgdGFnMSA9IHByb3BzLnRhZzEgPz8gJ2dpdGxhYic7XG4gICAgY29uc3QgdGFnMiA9IHByb3BzLnRhZzIgPz8gJ2F3c2Nkayc7XG4gICAgY29uc3QgdGFnMyA9IHByb3BzLnRhZzMgPz8gJ3J1bm5lcic7XG4gICAgY29uc3QgZ2l0bGFidXJsID0gcHJvcHMuZ2l0bGFidXJsID8/ICdodHRwczovL2dpdGxhYi5jb20vJztcbiAgICBjb25zdCBlYzJ0eXBlID0gcHJvcHMuZWMydHlwZSA/PyAndDMubWljcm8nO1xuICAgIGNvbnN0IHNoZWxsID0gVXNlckRhdGEuZm9yTGludXgoKTtcbiAgICBzaGVsbC5hZGRDb21tYW5kcyhcbiAgICAgICd5dW0gdXBkYXRlIC15ICcsXG4gICAgICAnc2xlZXAgMTUgJiYgeXVtIGluc3RhbGwgZG9ja2VyIGdpdCAteSAmJiBzeXN0ZW1jdGwgc3RhcnQgZG9ja2VyICYmIHVzZXJtb2QgLWFHIGRvY2tlciBlYzItdXNlciAmJiBjaG1vZCA3NzcgL3Zhci9ydW4vZG9ja2VyLnNvY2snLFxuICAgICAgJ3N5c3RlbWN0bCByZXN0YXJ0IGRvY2tlciAmJiBzeXN0ZW1jdGwgZW5hYmxlIGRvY2tlcicsXG4gICAgICAnZG9ja2VyIHJ1biAtZCAtdiAvaG9tZS9lYzItdXNlci8uZ2l0bGFiLXJ1bm5lcjovZXRjL2dpdGxhYi1ydW5uZXIgLXYgL3Zhci9ydW4vZG9ja2VyLnNvY2s6L3Zhci9ydW4vZG9ja2VyLnNvY2sgLS1uYW1lIGdpdGxhYi1ydW5uZXItcmVnaXN0ZXIgZ2l0bGFiL2dpdGxhYi1ydW5uZXI6YWxwaW5lIHJlZ2lzdGVyIC0tbm9uLWludGVyYWN0aXZlIC0tdXJsICcgK1xuICAgICAgICBnaXRsYWJ1cmwgK1xuICAgICAgICAnIC0tcmVnaXN0cmF0aW9uLXRva2VuICcgK1xuICAgICAgICB0b2tlbiArXG4gICAgICAgICcgLS1kb2NrZXItcHVsbC1wb2xpY3kgaWYtbm90LXByZXNlbnQgLS1kb2NrZXItdm9sdW1lcyBcIi92YXIvcnVuL2RvY2tlci5zb2NrOi92YXIvcnVuL2RvY2tlci5zb2NrXCIgLS1leGVjdXRvciBkb2NrZXIgLS1kb2NrZXItaW1hZ2UgXCJhbHBpbmU6bGF0ZXN0XCIgLS1kZXNjcmlwdGlvbiBcIkRvY2tlciBSdW5uZXJcIiAtLXRhZy1saXN0IFwiJyArXG4gICAgICAgIHRhZzEgK1xuICAgICAgICAnLCcgK1xuICAgICAgICB0YWcyICtcbiAgICAgICAgJywnICtcbiAgICAgICAgdGFnMyArXG4gICAgICAgICdcIiAtLWRvY2tlci1wcml2aWxlZ2VkJyxcblxuICAgICAgJ3NsZWVwIDIgJiYgZG9ja2VyIHJ1biAtLXJlc3RhcnQgYWx3YXlzIC1kIC12IC9ob21lL2VjMi11c2VyLy5naXRsYWItcnVubmVyOi9ldGMvZ2l0bGFiLXJ1bm5lciAtdiAvdmFyL3J1bi9kb2NrZXIuc29jazovdmFyL3J1bi9kb2NrZXIuc29jayAtLW5hbWUgZ2l0bGFiLXJ1bm5lciBnaXRsYWIvZ2l0bGFiLXJ1bm5lcjphbHBpbmUnLFxuICAgICAgJ3VzZXJtb2QgLWFHIGRvY2tlciBzc20tdXNlcicsXG4gICAgKTtcblxuICAgIHRoaXMucnVubmVyUm9sZSA9XG4gICAgICBwcm9wcy5lYzJpYW1yb2xlID8/XG4gICAgICBuZXcgUm9sZSh0aGlzLCAncnVubmVyLXJvbGUnLCB7XG4gICAgICAgIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2VjMi5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIGRlc2NyaXB0aW9uOiAnRm9yIEdpdGxhYiBFQzIgUnVubmVyIFJvbGUnLFxuICAgICAgfSk7XG4gICAgdGhpcy52YWxpZFVudGlsID0gcHJvcHMudmFsaWRVbnRpbDtcbiAgICBjb25zdCBpbnN0YW5jZVByb2ZpbGUgPSBuZXcgQ2ZuSW5zdGFuY2VQcm9maWxlKHRoaXMsICdJbnN0YW5jZVByb2ZpbGUnLCB7XG4gICAgICByb2xlczogW3RoaXMucnVubmVyUm9sZS5yb2xlTmFtZV0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnZwYyA9XG4gICAgICBwcm9wcy5zZWxmdnBjID8/XG4gICAgICBuZXcgVnBjKHRoaXMsICdWUEMnLCB7XG4gICAgICAgIGNpZHI6ICcxMC4wLjAuMC8xNicsXG4gICAgICAgIG1heEF6czogMixcbiAgICAgICAgc3VibmV0Q29uZmlndXJhdGlvbjogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIGNpZHJNYXNrOiAyNixcbiAgICAgICAgICAgIG5hbWU6ICdSdW5uZXJWUEMnLFxuICAgICAgICAgICAgc3VibmV0VHlwZTogU3VibmV0VHlwZS5QVUJMSUMsXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgbmF0R2F0ZXdheXM6IDAsXG4gICAgICB9KTtcbiAgICB0aGlzLmRlZmF1bHRSdW5uZXJTRyA9IG5ldyBTZWN1cml0eUdyb3VwKHRoaXMsICdTcG90RmxlZXRTZycsIHtcbiAgICAgIHZwYzogdGhpcy52cGMsXG4gICAgfSk7XG4gICAgdGhpcy5kZWZhdWx0UnVubmVyU0cuY29ubmVjdGlvbnMuYWxsb3dGcm9tQW55SXB2NChQb3J0LnRjcCgyMikpO1xuICAgIGNvbnN0IHNwb3RPck9uRGVtYW5kID0gcHJvcHMuc3BvdEZsZWV0ID8/IGZhbHNlO1xuICAgIGlmIChzcG90T3JPbkRlbWFuZCkge1xuICAgICAgLy90aHJvdyBuZXcgRXJyb3IoJ3llcyBuZXcgc3BvdGZsZWV0Jyk7XG5cbiAgICAgIGNvbnN0IGltYWdlSWQgPSBNYWNoaW5lSW1hZ2UubGF0ZXN0QW1hem9uTGludXgoe1xuICAgICAgICBnZW5lcmF0aW9uOiBBbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYXzIsXG4gICAgICB9KS5nZXRJbWFnZSh0aGlzKS5pbWFnZUlkO1xuICAgICAgY29uc3QgbHQgPSBuZXcgQ2ZuTGF1bmNoVGVtcGxhdGUodGhpcywgJ0xhdW5jaFRlbXBsYXRlJywge1xuICAgICAgICBsYXVuY2hUZW1wbGF0ZURhdGE6IHtcbiAgICAgICAgICBpbWFnZUlkLFxuICAgICAgICAgIGluc3RhbmNlVHlwZTogZWMydHlwZSxcbiAgICAgICAgICBibG9ja0RldmljZU1hcHBpbmdzOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIGRldmljZU5hbWU6ICcvZGV2L3h2ZGEnLFxuICAgICAgICAgICAgICBlYnM6IHtcbiAgICAgICAgICAgICAgICB2b2x1bWVTaXplOiBwcm9wcy5lYnNTaXplID8/IDYwLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICBdLFxuICAgICAgICAgIHVzZXJEYXRhOiBGbi5iYXNlNjQoc2hlbGwucmVuZGVyKCkpLFxuICAgICAgICAgIGtleU5hbWU6IHByb3BzLmtleU5hbWUsXG4gICAgICAgICAgdGFnU3BlY2lmaWNhdGlvbnM6IFtcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgcmVzb3VyY2VUeXBlOiAnaW5zdGFuY2UnLFxuICAgICAgICAgICAgICB0YWdzOiBbXG4gICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAga2V5OiAnTmFtZScsXG4gICAgICAgICAgICAgICAgICB2YWx1ZTogYCR7XG4gICAgICAgICAgICAgICAgICAgIFN0YWNrLm9mKHRoaXMpLnN0YWNrTmFtZVxuICAgICAgICAgICAgICAgICAgfS9zcG90RmxlZXRHaXRsYWJSdW5uZXIvJHtzcG90RmxlZXRJZH1gLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF0sXG4gICAgICAgICAgaW5zdGFuY2VNYXJrZXRPcHRpb25zOiB7XG4gICAgICAgICAgICBtYXJrZXRUeXBlOiAnc3BvdCcsXG4gICAgICAgICAgICBzcG90T3B0aW9uczoge1xuICAgICAgICAgICAgICBibG9ja0R1cmF0aW9uTWludXRlczpcbiAgICAgICAgICAgICAgICBwcm9wcy5ibG9ja0R1cmF0aW9uID8/IEJsb2NrRHVyYXRpb24uT05FX0hPVVIsXG4gICAgICAgICAgICAgIGluc3RhbmNlSW50ZXJydXB0aW9uQmVoYXZpb3I6XG4gICAgICAgICAgICAgICAgcHJvcHMuaW5zdGFuY2VJbnRlcnJ1cHRpb25CZWhhdmlvciA/P1xuICAgICAgICAgICAgICAgIEluc3RhbmNlSW50ZXJydXB0aW9uQmVoYXZpb3IuVEVSTUlOQVRFLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHNlY3VyaXR5R3JvdXBJZHM6IHRoaXMuZGVmYXVsdFJ1bm5lclNHLmNvbm5lY3Rpb25zLnNlY3VyaXR5R3JvdXBzLm1hcChcbiAgICAgICAgICAgIChtKSA9PiBtLnNlY3VyaXR5R3JvdXBJZCxcbiAgICAgICAgICApLFxuICAgICAgICAgIGlhbUluc3RhbmNlUHJvZmlsZToge1xuICAgICAgICAgICAgYXJuOiBpbnN0YW5jZVByb2ZpbGUuYXR0ckFybixcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfSk7XG5cbiAgICAgIGNvbnN0IHNwb3RGbGVldFJvbGUgPSBuZXcgUm9sZSh0aGlzLCAnRmxlZXRSb2xlJywge1xuICAgICAgICBhc3N1bWVkQnk6IG5ldyBTZXJ2aWNlUHJpbmNpcGFsKCdzcG90ZmxlZXQuYW1hem9uYXdzLmNvbScpLFxuICAgICAgICBtYW5hZ2VkUG9saWNpZXM6IFtcbiAgICAgICAgICBNYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZShcbiAgICAgICAgICAgICdzZXJ2aWNlLXJvbGUvQW1hem9uRUMyU3BvdEZsZWV0VGFnZ2luZ1JvbGUnLFxuICAgICAgICAgICksXG4gICAgICAgIF0sXG4gICAgICB9KTtcblxuICAgICAgY29uc3QgdnBjU3VibmV0U2VsZWN0aW9uID0gcHJvcHMudnBjU3VibmV0ID8/IHtcbiAgICAgICAgc3VibmV0VHlwZTogU3VibmV0VHlwZS5QVUJMSUMsXG4gICAgICB9O1xuICAgICAgY29uc3Qgc3VibmV0Q29uZmlnID0gdGhpcy52cGNcbiAgICAgICAgLnNlbGVjdFN1Ym5ldHModnBjU3VibmV0U2VsZWN0aW9uKVxuICAgICAgICAuc3VibmV0cy5tYXAoKHMpID0+ICh7XG4gICAgICAgICAgc3VibmV0SWQ6IHMuc3VibmV0SWQsXG4gICAgICAgIH0pKTtcblxuICAgICAgY29uc3QgY2ZuU3BvdEZsZWV0ID0gbmV3IENmblNwb3RGbGVldCh0aGlzLCBpZCwge1xuICAgICAgICBzcG90RmxlZXRSZXF1ZXN0Q29uZmlnRGF0YToge1xuICAgICAgICAgIGxhdW5jaFRlbXBsYXRlQ29uZmlnczogW1xuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBsYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb246IHtcbiAgICAgICAgICAgICAgICBsYXVuY2hUZW1wbGF0ZUlkOiBsdC5yZWYsXG4gICAgICAgICAgICAgICAgdmVyc2lvbjogbHQuYXR0ckxhdGVzdFZlcnNpb25OdW1iZXIsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIG92ZXJyaWRlczogc3VibmV0Q29uZmlnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICBdLFxuICAgICAgICAgIGlhbUZsZWV0Um9sZTogc3BvdEZsZWV0Um9sZS5yb2xlQXJuLFxuICAgICAgICAgIHRhcmdldENhcGFjaXR5OiAxLFxuICAgICAgICAgIHZhbGlkVW50aWw6IExhenkuc3RyaW5nVmFsdWUoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLnZhbGlkVW50aWwgfSksXG4gICAgICAgICAgdGVybWluYXRlSW5zdGFuY2VzV2l0aEV4cGlyYXRpb246IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICAgIGNvbnN0IG9uRXZlbnQgPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHRoaXMsICdPbkV2ZW50Jywge1xuICAgICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4vZ2V0aW5zdGFuY2VJZC8nKSksXG4gICAgICAgIGhhbmRsZXI6ICdpbmRleC5vbl9ldmVudCcsXG4gICAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLlBZVEhPTl8zXzgsXG4gICAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgICAgfSk7XG5cbiAgICAgIGNvbnN0IGlzQ29tcGxldGUgPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHRoaXMsICdJc0NvbXBsZXRlJywge1xuICAgICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4vZ2V0aW5zdGFuY2VJZC8nKSksXG4gICAgICAgIGhhbmRsZXI6ICdpbmRleC5pc19jb21wbGV0ZScsXG4gICAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLlBZVEhPTl8zXzgsXG4gICAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNjApLFxuICAgICAgICByb2xlOiBvbkV2ZW50LnJvbGUsXG4gICAgICB9KTtcblxuICAgICAgY29uc3QgbXlQcm92aWRlciA9IG5ldyBjci5Qcm92aWRlcih0aGlzLCAnTXlQcm92aWRlcicsIHtcbiAgICAgICAgb25FdmVudEhhbmRsZXI6IG9uRXZlbnQsXG4gICAgICAgIGlzQ29tcGxldGVIYW5kbGVyOiBpc0NvbXBsZXRlLFxuICAgICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfREFZLFxuICAgICAgfSk7XG5cbiAgICAgIG9uRXZlbnQuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBhY3Rpb25zOiBbJ2VjMjpEZXNjcmliZVNwb3RGbGVldEluc3RhbmNlcyddLFxuICAgICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgIH0pLFxuICAgICAgKTtcblxuICAgICAgY29uc3QgZmxlZXRJbnN0YW5jZXMgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0dldEluc3RhbmNlSWQnLCB7XG4gICAgICAgIHNlcnZpY2VUb2tlbjogbXlQcm92aWRlci5zZXJ2aWNlVG9rZW4sXG4gICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICBTcG90RmxlZXRSZXF1ZXN0SWQ6IGNmblNwb3RGbGVldC5yZWYsXG4gICAgICAgIH0sXG4gICAgICB9KTtcblxuICAgICAgZmxlZXRJbnN0YW5jZXMubm9kZS5hZGREZXBlbmRlbmN5KGNmblNwb3RGbGVldCk7XG4gICAgICB0aGlzLnNwb3RGbGVldEluc3RhbmNlSWQgPSBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgZmxlZXRJbnN0YW5jZXMuZ2V0QXR0KCdJbnN0YW5jZUlkJyksXG4gICAgICApO1xuICAgICAgdGhpcy5zcG90RmxlZXRSZXF1ZXN0SWQgPSBUb2tlbi5hc1N0cmluZyhcbiAgICAgICAgZmxlZXRJbnN0YW5jZXMuZ2V0QXR0KCdTcG90SW5zdGFuY2VSZXF1ZXN0SWQnKSxcbiAgICAgICk7XG4gICAgICBuZXcgQ2ZuT3V0cHV0KHRoaXMsICdJbnN0YW5jZUlkJywgeyB2YWx1ZTogdGhpcy5zcG90RmxlZXRJbnN0YW5jZUlkIH0pO1xuICAgICAgbmV3IENmbk91dHB1dCh0aGlzLCAnU3BvdEZsZWV0SWQnLCB7IHZhbHVlOiBjZm5TcG90RmxlZXQucmVmIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJ1bm5lckVjMiA9IG5ldyBJbnN0YW5jZSh0aGlzLCAnR2l0bGFiUnVubmVyJywge1xuICAgICAgICBpbnN0YW5jZVR5cGU6IG5ldyBJbnN0YW5jZVR5cGUoZWMydHlwZSksXG4gICAgICAgIGluc3RhbmNlTmFtZTogJ0dpdGxhYi1SdW5uZXInLFxuICAgICAgICB2cGM6IHRoaXMudnBjLFxuICAgICAgICB2cGNTdWJuZXRzOiBwcm9wcy52cGNTdWJuZXQgPz8ge1xuICAgICAgICAgIHN1Ym5ldFR5cGU6IFN1Ym5ldFR5cGUuUFVCTElDLFxuICAgICAgICB9LFxuICAgICAgICBtYWNoaW5lSW1hZ2U6IE1hY2hpbmVJbWFnZS5sYXRlc3RBbWF6b25MaW51eCh7XG4gICAgICAgICAgZ2VuZXJhdGlvbjogQW1hem9uTGludXhHZW5lcmF0aW9uLkFNQVpPTl9MSU5VWF8yLFxuICAgICAgICB9KSxcbiAgICAgICAgcm9sZTogdGhpcy5ydW5uZXJSb2xlLFxuICAgICAgICB1c2VyRGF0YTogc2hlbGwsXG4gICAgICAgIHNlY3VyaXR5R3JvdXA6IHRoaXMuZGVmYXVsdFJ1bm5lclNHLFxuICAgICAgICBibG9ja0RldmljZXM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBkZXZpY2VOYW1lOiAnL2Rldi94dmRhJyxcbiAgICAgICAgICAgIHZvbHVtZTogQmxvY2tEZXZpY2VWb2x1bWUuZWJzKHByb3BzLmVic1NpemUgPz8gNjApLFxuICAgICAgICAgIH0sXG4gICAgICAgIF0sXG4gICAgICB9KTtcbiAgICAgIG5ldyBDZm5PdXRwdXQodGhpcywgJ1J1bm5lci1JbnN0YW5jZS1JRCcsIHtcbiAgICAgICAgdmFsdWU6IHRoaXMucnVubmVyRWMyLmluc3RhbmNlSWQsXG4gICAgICB9KTtcbiAgICB9XG4gICAgdGhpcy5ydW5uZXJSb2xlLmFkZE1hbmFnZWRQb2xpY3koXG4gICAgICBNYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZSgnQW1hem9uU1NNTWFuYWdlZEluc3RhbmNlQ29yZScpLFxuICAgICk7XG5cbiAgICBuZXcgQ2ZuT3V0cHV0KHRoaXMsICdSdW5uZXItUm9sZS1Bcm4nLCB7XG4gICAgICB2YWx1ZTogdGhpcy5ydW5uZXJSb2xlLnJvbGVBcm4sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQGRlZmF1bHQgLSAhISEgb25seSBzdXBwb3J0IHNwb3RmbGVldCBydW5uZXIgISEhIC5cbiAgICovXG4gIHB1YmxpYyBleHBpcmVBZnRlcihkdXJhdGlvbjogRHVyYXRpb24pIHtcbiAgICBjb25zdCBkYXRlID0gbmV3IERhdGUoKTtcbiAgICBkYXRlLnNldFNlY29uZHMoZGF0ZS5nZXRTZWNvbmRzKCkgKyBkdXJhdGlvbi50b1NlY29uZHMoKSk7XG4gICAgdGhpcy52YWxpZFVudGlsID0gZGF0ZS50b0lTT1N0cmluZygpO1xuICB9XG59XG4iXX0=