# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_core.ipynb (unless otherwise specified).

__all__ = ['BaseParser', 'JavaParser', 'FastParser']

# Cell
import fast_trees

from .queries import *
from git import Repo
from pathlib import Path
from tree_sitter import Language, Parser
from typing import List

# Cell
class BaseParser:
    def __init__(self):
        self.build_parser()

    def build_parser(self):
        url, folder = self.LANG_URL
        repo_dir = Path(fast_trees.__path__[0] + "/" + folder)
        if repo_dir.exists():
            print("Repo already exists, continuing.")
        else:
            print(f"Downloading repo {url} to {repo_dir}.")
            Repo.clone_from(url, repo_dir)

        build_dir = fast_trees.__path__[0] + "/" + f"{repo_dir}/build/my-languages.so"
        Language.build_library(
            # Store the library in the `build` directory
            build_dir,
            # Include one or more languages
            [repo_dir],
        )
        self.language = Language(build_dir, self.LANG)
        self.parser = Parser()
        self.parser.set_language(self.language)

# Cell
class JavaParser(BaseParser):
    LANG: str = "java"
    LANG_URL: str = [
        "https://github.com/tree-sitter/tree-sitter-java",
        "tree-sitter-java",
    ]

    def __init__(self):
        super().__init__()

    def get_method_parameters(self, mthd: str) -> List[str]:
        """
        Returns the parameters of a given method

        :param mthd: the method to get the parameters from
        :returns: the parameters of the given method as an array
        """
        tree = self.parser.parse(bytes(mthd, "utf8"))
        query = self.language.query(JavaQueries.get_method_parameters)
        captures = query.captures(tree.root_node)
        lines = mthd.split("\n")
        parameters = []
        for node, _ in captures:
            parameters.append(
                lines[node.start_point[0]][node.start_point[1] : node.end_point[1]]
            )

        return parameters

    def get_method_inline_comments(self, mthd: str) -> List[str]:
        tree = self.parser.parse(bytes(mthd, "utf8"))
        query = self.language.query(JavaQueries.get_all_comments)
        captures = query.captures(tree.root_node)
        lines = mthd.split("\n")
        comments = []
        for node, _ in captures:
            if node.start_point[0] == node.end_point[0]:
                comments.append(
                    lines[node.start_point[0] : node.end_point[0] + 1][0][
                        node.start_point[1] : node.end_point[1]
                    ]
                )
            else:
                start_line = lines[node.start_point[0]][node.start_point[1] :]
                middle_lines = "\n".join(
                    lines[node.start_point[0] + 1 : node.end_point[0]]
                )
                end_line = lines[node.end_point[0]][: node.end_point[1]]
                comments.append("\n".join([start_line, middle_lines, end_line]))

        return comments

# Cell
def FastParser(lang: str):
    PARSERS = {
        "java": JavaParser,
    }

    return PARSERS[lang]()