# Turfpy
[![Build Status](https://travis-ci.com/omanges/turfpy.svg?branch=master)](https://travis-ci.com/omanges/turfpy)
[![PyPI](https://img.shields.io/pypi/v/turfpy)](https://pypi.org/project/turfpy/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/turfpy)](https://pypi.org/project/turfpy/)
[![PyPI - Status](https://img.shields.io/pypi/status/turfpy)](https://pypi.org/project/turfpy/)
[![PyPI - License](https://img.shields.io/pypi/l/turfpy)](https://pypi.org/project/turfpy/)
[![Total alerts](https://img.shields.io/lgtm/alerts/g/omanges/turfpy.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/omanges/turfpy/alerts/)
[![code quality: python](https://img.shields.io/lgtm/grade/python/g/omanges/turfpy.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/omanges/turfpy/context:python)
[![Downloads](https://pepy.tech/badge/turfpy/month)](https://pepy.tech/project/turfpy/month)
[![Conda (channel only)](https://img.shields.io/conda/vn/conda-forge/turfpy)](https://anaconda.org/conda-forge/turfpy)
[![Conda Downloads](https://img.shields.io/conda/dn/conda-forge/turfpy)](https://anaconda.org/conda-forge/turfpy)
[![Join the Gitter Chat](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/turfpy/turfpy-user-group?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Documentation Status](https://readthedocs.org/projects/turfpy/badge/?version=latest)](https://turfpy.readthedocs.io/en/latest/?badge=latest)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![commits since](https://img.shields.io/github/commits-since/omanges/turfpy/latest.svg)](https://github.com/omanges/turfpy/commits/master)
[![GitHub contributors](https://img.shields.io/github/contributors/omanges/turfpy)](https://github.com/omanges/turfpy/graphs/contributors)

Demo:

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/omanges/turfpy/master?urlpath=lab/tree/examples)


A Python library for performing geospatial data analysis which reimplements turf.js.

## Installation

You can install the Turfpy from [PyPI](https://pypi.org/project/turfpy/):
   
    pip install turfpy

If you prefer to use [conda](https://anaconda.org/conda-forge/turfpy):

    conda install -c conda-forge turfpy

## Test Suite

You can run the test suite locally:

```bash
pip install -r dev_requirements.txt
pytest -s -v --cov=turfpy tests
```

## Features
It supports below features:

- [Measurements](https://github.com/omanges/turfpy/blob/master/measurements.md)

- [Transformations](https://github.com/omanges/turfpy/blob/master/transformation.md)

- [Misc](https://github.com/omanges/turfpy/blob/master/misc.md)

- [Random](https://github.com/omanges/turfpy/blob/master/random.md)

## Documentation

Documentation can be found at: [docs](https://turfpy.readthedocs.io/en/latest/)


