# django-static-fontawesome

Django application contain font-awesome static files

## Install

    pip install django-static-fontawesome

## Fontawesome License

- All resource files of static/fontawesome are unzip from fontawesome-free-xx.xx.xx-web.zip which download from https://fontawesome.com without any changes.
- All resource files of static/fontawesome obey Font Awesome License, see details at https://fontawesome.com/license.
- We don't guarantee the latest fontawesome version.

## Settings

**pro/settings.py**

```python
    INSTALLED_APPS = [
        ...
        "django_static_fontawesome",
        ...
    ]
```

## Use static files

**page.html**

```python
    {% load staticfiles %}

    {% block style %}
        <link rel="stylesheet" type="text/css" href="{% static "fontawesome/css/all.min.css" %}" />
    {% endblock %}

    <i class="fas fa-home"></i> Home
```

## About releases

- The first three number is the same with fontawesome project's version.
- The fourth number is our release number, it's optional.

## Releases

### v5.15.4.0

- Upgrade fontawesome to v5.15.4.

### v5.14.0.0

- No depends on django.
- Turn to the package as a pure static wrapper package.

### v5.12.1.4

- Fix setup problem, make description render on pypi.

### v5.12.1.3

- Fix setup.py.

### v5.12.1.1

- App rename to django_static_fontawesome.

### v5.12.1

- Upgrade fontawesome static files to version 5.12.1.
- Add demo page.

### v5.10.2

- Use fontawesome 5.10.2.

### v5.0.8.1

- Use fontawesome 5.0.8.

### v5.0.2

- First release.
