# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['rafm']

package_data = \
{'': ['*']}

install_requires = \
['biopython',
 'loguru',
 'matplotlib',
 'numpy',
 'pandas',
 'scipy',
 'seaborn',
 'statsdict',
 'stmol',
 'streamlit',
 'typer']

entry_points = \
{'console_scripts': ['rafm = rafm.__main__:cli']}

setup_kwargs = {
    'name': 'rafm',
    'version': '1.1.2',
    'description': 'rafm',
    'long_description': '================================\nrafm Reliable AlphaFold Measures\n================================\n| |PyPI| |Python Version| |Repo| |Downloads| |Download_rate|\n\n| |License| |Tests| |Coverage| |Codacy| |Issues| |Health|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/rafm.svg\n   :target: https://pypi.org/project/rafm/\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/rafm\n   :target: https://pypi.org/project/rafm\n   :alt: Supported Python Versions\n.. |Repo| image:: https://img.shields.io/github/last-commit/joelb123/rafm\n    :target: https://github.com/joelb123/rafm\n    :alt: GitHub repository\n.. |Downloads| image:: https://pepy.tech/badge/rafm\n     :target: https://pepy.tech/project/rafm\n     :alt: Download stats\n.. |Download_rate| image:: https://img.shields.io/pypi/dm/rafm\n   :target: https://github.com/joelb123/rafm\n   :alt: PYPI download rate\n.. |License| image:: https://img.shields.io/badge/License-BSD%203--Clause-blue.svg\n    :target: https://github.com/joelb123/rafm/blob/main/LICENSE.txt\n    :alt: License terms\n.. |Tests| image:: https://github.com/joelb123/rafm/workflows/Tests/badge.svg\n   :target: https://github.com/joelb123/rafm/actions?workflow=Tests\n   :alt: Tests\n.. |Coverage| image:: https://codecov.io/gh/joelb123/rafm/branch/main/graph/badge.svg?token=fM56Q8umss\n    :target: https://codecov.io/gh/joelb123/rafm\n    :alt: Codecov.io test coverage\n.. |Codacy| image:: https://api.codacy.com/project/badge/Grade/fd5f97647de84f5e846172bc0a999766\n    :target: https://www.codacy.com/gh/joelb123/rafm?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=joelb123/rafm&amp;utm_campaign=Badge_Grade\n    :alt: Codacy.io grade\n.. |Issues| image:: https://img.shields.io/github/issues/joelb123/rafm.svg\n    :target:  https://github.com/joelb123/rafm/issues\n    :alt: Issues reported\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/rafm/latest.svg?label=Read%20the%20Docs\n   :target: https://rafm.readthedocs.io/\n   :alt: Read the documentation at https://rafm.readthedocs.io/\n.. |Health| image:: https://snyk.io/advisor/python/rafm/badge.svg\n  :target: https://snyk.io/advisor/python/rafm\n  :alt: Snyk health\n\n.. image:: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/calmodulin.png\n   :target: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/calmodulin.png\n   :alt: AlphaFold model and two crystal structures of calmodulin\n\n*rafm* computes per-model measures such as expected global *LDDT*\nassociated with atomic-level accuracy for AlphaFold models from\n*pLDDT* confidence scores.\n\n\nInstallation\n------------\n\nYou can install *rafm* via pip_ from PyPI_:\n\n.. code:: console\n\n   $ pip install rafm\n\n\nUsage\n-----\n*rafm --help* lists all commands. Current commands are:\n\n* *plddt-stats*\n    Calculate stats on bounded pLDDTs from list of AlphaFold model files.\n    in either PDB or mmCIF format.\n\n    Options:\n\n        * *--criterion FLOAT*\n            The cutoff value on truncated pLDDT for possible utility.\n            [default: 91.2]\n        * *--min-length INTEGER*\n            The minimum sequence length for which to calculate truncated stats.\n            [default: 20]\n        * *--min-count INTEGER*\n            The minimum number of truncated *pLDDT* values for which to\n            calculate stats [default: 20]\n        * *--lower-bound INTEGER*\n            The *pLDDT* value below which stats will not be calculated.\n            [default: 80]\n        * *--upper-bound INTEGER*\n            The *pLDDT* value above which stats will not be calculated.\n            [default: 100]\n        * *--file-stem TEXT*\n            Output file name stem. [default: rafm]\n\n    Output columns (where *NN* is the bounds specifier, default: 80):\n\n        * *residues_in_pLDDT*\n            The number of residues in the AlphaFold model.\n        * *pLDDT_mean*\n            The mean value of pLDDT over all residues.\n        * *pLDDT_median*\n            The median value of pLDDT over all residues.\n        * *pLDDTNN_count*\n            The number of residues within bounds.\n        * *pLDDTNN_frac*\n            The fraction of pLDDT values within bounds, if the\n            count is greater than the minimum.\n        * *pLDDTNNN_mean*\n            The mean of pLDDT values within bounds, if the\n            count is greater than the minimum.\n        * *pLDDTNN_median*\n            The median of pLDDT values within bounds, if the\n            count is greater than the minimum.\n        * *LDDT_expect*\n            The expectation value of global *LDDT* over the\n            residues with *LDDT* within bounds.  Only\n            produced if default bounds are used.\n        * *passing*\n            True if the model passed the criterion, False\n            otherwise.  Only produced if default bounds are\n            used.\n        * *file*\n            The path to the model file.\n\n* *plddt-select-residues*\n    Writes a tab-separated file of residues from passing models,\n    using an input file of values selected by *plddt-stats*.\n    Input options are the same as *plddt-stats*.\n\n    Output columns:\n\n        * *file*\n            Path to the model file.\n        * *residue*\n            Residue number, starting from 0 and numbered\n            sequentially.  Note that *all* residues will be\n            written, regardless of bounds set.\n        * *pLDDT*\n            pLDDT value for that residue.\n\n* *plddt-plot-dists*\n    Plot the distributions on the bounded pLDDT and residues in\n    models that pass the selection criteria.\n\n    Input Options:\n        * *out-file-type*\n            Plot file extension of a type that *matplotlib* understands,\n            (e.g., \'jpg\', \'pdf\') [default: png]\n        * *residue-criterion*\n            Per-residue cutoff on usability (for plot only).\n\n    Outputs:\n        When applied to set of "dark" genomes with no previous PDB entries, the\n        distributions of median *pLDDT* scores with a lower bound of 80 and\n        per-residue *pLDDT* scores with a minimum of 80 looks like this:\n\n        .. image:: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/dark_dists.png\n            :target: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/dark_dists.png\n            :alt: Distribution of *pLDDT80* scores and per-residue *pLDDT* scores\n\n* *stats*\n    Produce a set of summary stats on results of runs.  See also the global\n    stats file *rafm_stats.json*.\n\n\nStatistical Basis\n-----------------\nThe default parameters were chosen to select for *LDDT* values of greater\nthan 80 on a set of crystal structures obtained since AlphaFold was trained.\nThe distributions of *LDDT* scores for the passing and non-passing sets, along\nwith an (overlapping) set of AlphaFold model files at 100% sequence identity over\nat least 80% of the sequence looks like this:\n\n.. image:: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/lddt_dist.png\n   :target: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/lddt_dist.png\n   :alt: Distribution of high-scoring, low-scoring, and high-similarity structures\n\nThe markers on the *x*-axis refer to the size of conformational changes\nobserved in conformational changes in various protein crystal structures:\n\n* *CALM*\n    Between calcium-bound and calcium-free calmodulin\n    (depicted in the logo image above).\n* *ERK2*\n    Between unphosphorylated and doubly-phosphorylated ERK2 kinase.\n* *HB*\n    Between R- and T-state hemoglobin\n* *MB*\n    Between carbonmonoxy- and deoxy-myoglobin\n\nThe value of *LDDT* >= 80 we selected as the minimum value that was likely to\nprove useful for virtual screening.  The per-residue value of *pLDDT* >= 80\nwas also chosen as the minimum likely to give the correct side-chain rotamers\nfor a surface defined by contacts between two residues. A choice of 91.2 as a\ncriterion leads to the following confusion matrix versus a set of post-training\ncrystal structures:\n\n.. image:: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/confusion_matrix.png\n   :target: https://raw.githubusercontent.com/joelb123/rafm/main/docs/_static/confusion_matrix.png\n   :alt: Confusion matrix of AlphaFold models vs. crystal structures\n\nAt a correlation coefficient of 0.71, this correlation isn\'t great, but enough\nto demonstrate a usable sensitivity.  After we fix a few problems with the\nalignments, it may go a bit higher but our feeling is probably not\nmore than about 0.8.  The support will get better, but the criterion on this\nmetric seems unlikely to change.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the `MIT license`_,\n*rafm* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\nThis project was generated from the\n`UNM Translational Informatics Python Cookiecutter`_ template.\n\n*rafm* was written by Joel Berendzen and Jessica Binder.\n\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _MIT license: https://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/\n.. _UNM Translational Informatics Python Cookiecutter: https://github.com/joelb123/cookiecutter-joelb123-python\n.. _file an issue: https://github.com/joelb123/rafm/issues\n.. _pip: https://pip.pypa.io/\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n.. _Usage: https://rafm.readthedocs.io/en/latest/usage.html\n',
    'author': 'Joel Berendzen',
    'author_email': 'joel@generisbio.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/joelb123/rafm',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<3.11',
}


setup(**setup_kwargs)
