from enum import Enum


class MemberType(Enum):
    '''
    Member Type
    '''
    TYPE_BEAM, TYPE_BUCKLING, TYPE_CABLE, TYPE_COMPRESSION, TYPE_COUPLING_HINGE_HINGE,\
    TYPE_COUPLING_HINGE_RIGID, TYPE_COUPLING_RIGID_HINGE, TYPE_COUPLING_RIGID_RIGID,\
    TYPE_DEFINABLE_STIFFNESS, TYPE_RIB, TYPE_RIGID, TYPE_TENSION, TYPE_TRUSS, TYPE_TRUSS_ONLY_N, TYPE_RESULT_BEAM = range(15)


class NodalSupportType(Enum):
    '''
    Nodal Support Type
    '''
    FIXED, HINGED, ROLLER, ROLLER_IN_X, ROLLER_IN_Y, ROLLER_IN_Z, FREE = range(7)


class LineSupportType(Enum):
    '''
    Nodal Support Type
    '''
    FIXED, HINGED, SLIDING_IN_X_AND_Y, SLIDING_IN_X, SLIDING_IN_Y, SLIDING_IN_Z, FREE = range(7)


class LineWeldedJointType(Enum):
    """
    Line Welded Joint Type | Enum
    """
    BUTT_JOINT, CORNER_JOINT, LAP_JOINT, TEE_JOINT = range(4)


class WeldType(Enum):
    """
    Welded Type | Enum
    """
    WELD_BEVEL_AND_FILLET, WELD_DOUBLE_BEVEL, WELD_DOUBLE_FILLET, WELD_DOUBLE_J,\
    WELD_DOUBLE_SQUARE, WELD_DOUBLE_U, WELD_DOUBLE_V, WELD_J_AND_FILLET, WELD_SINGLE_BEVEL,\
    WELD_SINGLE_FILLET, WELD_SINGLE_J, WELD_SINGLE_SQUARE, WELD_SINGLE_U, WELD_SINGLE_V, WELD_V_AND_FILLET = range(15)


class WeldComponentType(Enum):
    '''
    Aluminum Member Transverse Weld Component | Enum
    '''
    WELD_COMPONENT_TYPE_BUTT, WELD_COMPONENT_TYPE_FILLET = range(2)


class WeldingMethod(Enum):
    '''
    Aluminum Member Transverse Weld Welding Method | Enum
    '''
    WELDING_METHOD_TIG, WELDING_METHOD_MIG = range(2)


class WeldLongitudalArrangement(Enum):
    """
    Weld Longitudat Arrangement Type | Enum
    """
    CHAIN_INTERMITTENT, CONTINUOUS, STAGGERED_INTERMITTENT = range(3)


class LineMeshRefinementsType(Enum):
    """
    Line Mesh Refinements Type | Enum
    """
    TYPE_LENGTH, TYPE_ELEMENTS, TYPE_GRADUAL = range(3)


class StaticAnalysisType(Enum):
    '''
    Static Analysis Type
    '''
    GEOMETRICALLY_LINEAR, LARGE_DEFORMATIONS, LARGE_DEFORMATIONS_POSTRCRITICAL, SECOND_ORDER_P_DELTA = range(4)


class StaticAnalysisSettingsIterativeMethodForNonlinearAnalysis(Enum):
    '''
    Static Analysis Settings Iterative Method For Nonlinear Analysis | Enum
    '''
    DYNAMIC_RELAXATION, NEWTON_RAPHSON, NEWTON_RAPHSON_COMBINED_WITH_PICARD, NEWTON_RAPHSON_WITH_CONSTANT_STIFFNESS,\
    NEWTON_RAPHSON_WITH_POSTCRITICAL_ANALYSIS, PICARD = range(6)


class StaticAnalysisSettingsMethodOfEquationSystem(Enum):
    '''
    Static Analysis Settings Method of Equation System | Enum
    '''
    METHOD_OF_EQUATION_SYSTEM_DIRECT, METHOD_OF_EQUATION_SYSTEM_ITERATIVE = range(2)


class StaticAnalysisSettingsPlateBendingTheory(Enum):
    '''
    Static Analysis Settings Plate Bending Theory | Enum
    '''
    PLATE_BENDING_THEORY_MINDLIN, PLATE_BENDING_THEORY_KIRCHHOFF = range(2)


class AnalysisType(Enum):
    '''
    Analysis Type
    '''
    ANALYSIS_TYPE_CREEP_AND_SHRINKAGE, ANALYSIS_TYPE_CUTTING_PATTERN, ANALYSIS_TYPE_MODAL, ANALYSIS_TYPE_RESPONSE_SPECTRUM,\
    ANALYSIS_TYPE_STATIC, ANALYSIS_TYPE_TIME_DEPENDENT, ANALYSIS_TYPE_TIME_HISTORY, ANALYSIS_TYPE_WIND_SIMULATION = range(8)


class LoadDirectionType(Enum):
    '''
    Load Direction Type
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(6)


class MemberLoadDirection(Enum):
    '''
    Member Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_PRINCIPAL_U,\
    LOAD_DIRECTION_PRINCIPAL_V = range(11)


class MemberLoadType(Enum):
    '''
    Member Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_AXIAL_DISPLACEMENT, LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_DISPLACEMENT, LOAD_TYPE_FORCE,\
    LOAD_TYPE_FORM_FINDING, LOAD_TYPE_INITIAL_PRESTRESS, LOAD_TYPE_MOMENT, LOAD_TYPE_PIPE_CONTENT_FULL,\
    LOAD_TYPE_PIPE_CONTENT_PARTIAL, LOAD_TYPE_PIPE_INTERNAL_PRESSURE, LOAD_TYPE_PRECAMBER, LOAD_TYPE_ROTARY_MOTION,\
    LOAD_TYPE_ROTATION, LOAD_TYPE_TEMPERATURE, LOAD_TYPE_TEMPERATURE_CHANGE = range(16)


class MemberLoadDistribution(Enum):
    '''
    Member Load Distribution
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING, LOAD_DISTRIBUTION_VARYING_IN_Z = range(12)


class MemberHingeAxialRelease(Enum):
    '''
    Member Hinge Axial Release
    '''
    NONLINEARITY_TYPE_DIAGRAM, NONLINEARITY_TYPE_FAILURE_ALL_IF_NEGATIVE, NONLINEARITY_TYPE_FAILURE_ALL_IF_POSITIVE,\
    NONLINEARITY_TYPE_FAILURE_IF_NEGATIVE, NONLINEARITY_TYPE_FAILURE_IF_POSITIVE, NONLINEARITY_TYPE_FRICTION_DIRECTION_1,\
    NONLINEARITY_TYPE_FRICTION_DIRECTION_1_2, NONLINEARITY_TYPE_FRICTION_DIRECTION_1_PLUS_2, NONLINEARITY_TYPE_FRICTION_DIRECTION_2,\
    NONLINEARITY_TYPE_NONE, NONLINEARITY_TYPE_PARTIAL_ACTIVITY, NONLINEARITY_TYPE_STIFFNESS_DIAGRAM = range(12)


class LineLoadType(Enum):
    '''
    Line Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_FORCE, LOAD_TYPE_MOMENT = range(3)


class LineSetLoadType(Enum):
    '''
    Lineset Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_FORCE, LOAD_TYPE_MOMENT = range(3)


class LineLoadDistribution(Enum):
    '''
    Line Load Distribution
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING = range(11)


class LineSetLoadDistribution(Enum):
    '''
    Line Load Distribution
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING = range(11)


class SurfaceGeometry(Enum):
    '''
    Geometry Type
    '''
    GEOMETRY_PLANE, GEOMETRY_QUADRANGLE, GEOMETRY_NURBS, GEOMETRY_ROTATED, GEOMETRY_PIPE = range(5)


class SurfaceType(Enum):
    '''
    Stiffness Type
    '''
    TYPE_LOAD_TRANSFER, TYPE_MEMBRANE, TYPE_RIGID, TYPE_STANDARD, TYPE_WITHOUT_MEMBRANE_TENSION, TYPE_WITHOUT_THICKNESS = range(6)


class SurfaceLoadDistribution(Enum):
    '''
    Surface Load Distribution
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z,\
    LOAD_DISTRIBUTION_RADIAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_VARYING_IN_Z = range(7)


class SurfaceLoadDirection(Enum):
    '''
    Surface Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)


class SurfaceLoadType(Enum):
    '''
    Surface Load Type | Enum
    '''
    LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_MASS, LOAD_TYPE_PRECAMBER,\
    LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_TEMPERATURE = range(7)


class SurfaceLoadDistributionDirection(Enum):
    '''
    Surface Load Distribution Direction
    '''
    LOAD_TRANSFER_DIRECTION_IN_BOTH, LOAD_TRANSFER_DIRECTION_IN_X, LOAD_TRANSFER_DIRECTION_IN_Y = range(3)


class SetType(Enum):
    '''
    Line, Member, Surface, and Solid Set Type
    '''
    SET_TYPE_CONTINUOUS, SET_TYPE_GROUP = range(2)


class NodalLoadType(Enum):
    '''
    Nodal Load Type
    '''
    LOAD_TYPE_COMPONENTS, LOAD_TYPE_FORCE, LOAD_TYPE_MASS, LOAD_TYPE_MOMENT = range(4)


class NodalLoadSpecificDirectionType(Enum):
    '''
    Nodal Load Specific Direction Type
    '''
    DIRECTION_TYPE_DIRECTED_TO_NODE, DIRECTION_TYPE_PARALLEL_TO_CS_OF_LINE, DIRECTION_TYPE_PARALLEL_TO_CS_OF_MEMBER, DIRECTION_TYPE_PARALLEL_TO_TWO_NODES, DIRECTION_TYPE_ROTATED_VIA_3_ANGLES = range(5)


class NodalLoadAxesSequence(Enum):
    '''
    Nodal Load Axes Sequence
    '''
    SEQUENCE_XYZ, SEQUENCE_XZY, SEQUENCE_YXZ, SEQUENCE_YZX, SEQUENCE_ZXY, SEQUENCE_ZYX = range(6)


class NodalLoadMassAxisRotation(Enum):
    '''
    Nodal Load Mass Axis Rotation
    '''
    AXIS_OF_ROTATION_X_NEGATIVE, AXIS_OF_ROTATION_X_POSITIVE, AXIS_OF_ROTATION_Y_NEGATIVE, AXIS_OF_ROTATION_Y_POSITIVE, AXIS_OF_ROTATION_Z_NEGATIVE, AXIS_OF_ROTATION_Z_POSITIVE = range(6)


class ThicknessType(Enum):
    '''
    Thickness Type
    '''
    TYPE_LAYERS, TYPE_SHAPE_ORTHOTROPY, TYPE_STIFFNESS_MATRIX, TYPE_THICKNESS_PHASE, TYPE_UNIFORM,\
    TYPE_VARIABLE_CIRCLE, TYPE_VARIABLE_FOUR_SURFACE_CORNERS, TYPE_VARIABLE_THREE_NODES, \
    TYPE_VARIABLE_TWO_NODES_AND_DIRECTION = range(9)

class LayerType(Enum):
    '''
    Layer Type
    '''
    E_LAYER_TYPE_LAYER, E_LAYER_TYPE_CONTACT, E_LAYER_TYPE_GAS = range(3)


class ThicknessDirection(Enum):
    '''
    Thickness Direction
    '''
    THICKNESS_DIRECTION_IN_SMALL_X, THICKNESS_DIRECTION_IN_SMALL_Y, THICKNESS_DIRECTION_IN_X, \
    THICKNESS_DIRECTION_IN_Y, THICKNESS_DIRECTION_IN_Z = range(5)


class ThicknessSelfWeightDefinitionType(Enum):
    SELF_WEIGHT_COMPUTED_FROM_PARAMETERS, SELF_WEIGHT_DEFINED_VIA_FICTITIOUS_THICKNESS, \
    SELF_WEIGHT_DEFINED_VIA_WEIGHT = range(3)


class ThicknessShapeOrthotropySelfWeightDefinitionType(Enum):
    '''
    Thickness Shape Orthotropy Self Weight Definition Type | Enum
    '''
    SELF_WEIGHT_COMPUTED_FROM_PARAMETERS, SELF_WEIGHT_DEFINED_VIA_FICTITIOUS_THICKNESS, \
    SELF_WEIGHT_DEFINED_VIA_WEIGHT = range(3)


class ThicknessStiffnessMatrixSelfWeightDefinitionType(Enum):
    '''
    Thickness Stiffness Matrix Self Weight Definition Type | Enum
    '''
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_BULK_DENSITY_AND_AREA_DENSITY, \
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_FICTITIOUS_THICKNESS_AND_AREA_DENSITY, \
    SELF_WEIGHT_DEFINITION_TYPE_DEFINED_VIA_FICTITIOUS_THICKNESS_AND_BULK_DENSITY = range(3)


class ThicknessOrthotropyType(Enum):
    BIDIRECTIONAL_RIBBED_PLATE, COUPLING, EFFECTIVE_THICKNESS, GRILLAGE, \
    HOLLOW_CORE_SLAB, TRAPEZOIDAL_SHEET, UNIDIRECTIONAL_RIBBED_PLATE = range(7)


class LineLoadDirection(Enum):
    '''
    Line Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)


class LineSetLoadDirection(Enum):
    '''
    Lineset Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)


class MemberLoadEccentricityHorizontalAlignment(Enum):
    '''
    Member Load Eccentricity Horizontal Alignment
    '''

    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)


class MemberLoadEccentricityVerticalAlignment(Enum):
    '''
    Member Load Eccentricity Vertical Alignment
    '''

    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)


class MemberLoadEccentricitySectionMiddle(Enum):
    '''
    Member Load Eccentricity Section Middle
    '''

    LOAD_ECCENTRICITY_SECTION_MIDDLE_CENTER_OF_GRAVITY, LOAD_ECCENTRICITY_SECTION_MIDDLE_NONE, LOAD_ECCENTRICITY_SECTION_MIDDLE_SHEAR_CENTER = range(3)


class MemberLoadFormFindingDefinitionType(Enum):
    '''
    Member Load Form Finding Definition Type
    '''
    FORM_FINDING_TYPE_FORCE, FORM_FINDING_TYPE_GEOMETRIC = range(2)


class MemberLoadFormFindingForceDefinition(Enum):
    '''
    Member Load Form Finding Force Definition
    '''
    FORM_FINDING_FORCE_INPUT_PARAMETER_AVERAGE, FORM_FINDING_FORCE_INPUT_PARAMETER_DENSITY, FORM_FINDING_FORCE_INPUT_PARAMETER_HORIZONTAL_TENSION_COMPONENT, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MAXIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_I_END, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_J_END, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMUM_FORCE_IN_MEMBER,\
    FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_J_END = range(9)


class MemberLoadFormFindingGeometryDefinition(Enum):
    '''
    Member Load Form Finding Geometry Definition
    '''
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LENGTH, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LOW_POINT_VERTICAL_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_MAXIMUM_VERTICAL_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_UNSTRESSED_LENGTH = range(5)


class MemberLoadFormFindingInternalForce(Enum):
    '''
    Member Load Form Finding Internal Force
    '''
    FORM_FINDING_INTERNAL_FORCE_COMPRESSION, FORM_FINDING_INTERNAL_FORCE_TENSION = range(2)


class MemberLoadDirectionOrientation(Enum):
    '''
    Member Load Direction Orientation
    '''
    LOAD_DIRECTION_FORWARD, LOAD_DIRECTION_REVERSED = range(2)


class MemberLoadAxisDefinitionType(Enum):
    '''
    Member Load Axis Definition
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)


class MemberLoadAxisDefinition(Enum):
    '''
    Member Load Axis Definition
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)


class MemberLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Member Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)


class SurfaceLoadAxisDefinitionAxis(Enum):
    '''
    Surface Load Axis Definition Axis
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)


class SurfaceLoadAxisDirectionType(Enum):
    '''
    Surface Load Axis Direction Type
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)


class SurfaceLoadAxisDefinitionType(Enum):
    '''
    Surface Load Axis Definition Type
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)


class NodeType(Enum):
    '''
    Node Type | Enum
    '''
    TYPE_BETWEEN_TWO_NODES, TYPE_BETWEEN_TWO_POINTS, TYPE_ON_LINE, TYPE_ON_MEMBER, TYPE_STANDARD = range(5)


class NodeCoordinateSystemType(Enum):
    '''
    Node Coordinate System Type | Enum
    '''
    COORDINATE_SYSTEM_CARTESIAN, COORDINATE_SYSTEM_POLAR, COORDINATE_SYSTEM_X_CYLINDRICAL, COORDINATE_SYSTEM_Y_CYLINDRICAL, COORDINATE_SYSTEM_Z_CYLINDRICAL = range(5)


class NodeReferenceType(Enum):
    '''
    Node Reference Type| Enum
    '''
    REFERENCE_TYPE_L, REFERENCE_TYPE_XY, REFERENCE_TYPE_XZ, REFERENCE_TYPE_YZ = range(4)


class LineArcAlphaAdjustmentTarget(Enum):
    '''
    Line Arc Alpha Adjustment Target | Enum
    '''
    ALPHA_ADJUSTMENT_TARGET_ARC_CONTROL_POINT, ALPHA_ADJUSTMENT_TARGET_BEGINNING_OF_ARC, ALPHA_ADJUSTMENT_TARGET_END_OF_ARC = range(3)


class MemberSetLoadType(Enum):
    '''
    Member Set Load Load Type
    '''
    E_TYPE_MASS, LOAD_TYPE_AXIAL_DISPLACEMENT, LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_DISPLACEMENT, \
    LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_INITIAL_PRESTRESS, LOAD_TYPE_MOMENT, \
    LOAD_TYPE_PIPE_CONTENT_FULL, LOAD_TYPE_PIPE_CONTENT_PARTIAL, LOAD_TYPE_PIPE_INTERNAL_PRESSURE, \
    LOAD_TYPE_PRECAMBER, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_ROTATION, LOAD_TYPE_TEMPERATURE, LOAD_TYPE_TEMPERATURE_CHANGE = range(16)


class MemberSetLoadDistribution(Enum):
    '''
    Member Set Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_CONCENTRATED_1, LOAD_DISTRIBUTION_CONCENTRATED_2, LOAD_DISTRIBUTION_CONCENTRATED_2x2,\
    LOAD_DISTRIBUTION_CONCENTRATED_N, LOAD_DISTRIBUTION_CONCENTRATED_VARYING, LOAD_DISTRIBUTION_PARABOLIC,\
    LOAD_DISTRIBUTION_TAPERED, LOAD_DISTRIBUTION_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_UNIFORM_TOTAL,\
    LOAD_DISTRIBUTION_VARYING, LOAD_DISTRIBUTION_VARYING_IN_Z = range(12)


class MemberSetLoadDirection(Enum):
    '''
    Member Set Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_PRINCIPAL_U,\
    LOAD_DIRECTION_PRINCIPAL_V = range(11)


class MemberSetLoadDirectionOrientation(Enum):
    '''
    Member Set Load Direction Orientation
    '''
    LOAD_DIRECTION_FORWARD, LOAD_DIRECTION_REVERSED = range(2)


class MemberSetLoadFormFindingDefinitionType(Enum):
    '''
    Member Set Load Form Finding Definition Type
    '''
    FORM_FINDING_TYPE_FORCE, FORM_FINDING_TYPE_GEOMETRIC = range(2)


class MemberSetLoadAxisDefinitionType(Enum):
    '''
    Member Set Load Axis Definition
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)


class MemberSetLoadAxisDefinition(Enum):
    '''
    Member Set Load Axis Definition
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)


class MemberSetLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Member Set Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)


class MemberSetLoadEccentricityHorizontalAlignment(Enum):
    '''
    Member Set Load Eccentricity Horizontal Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_RIGHT = range(4)


class MemberSetLoadEccentricityVerticalAlignment(Enum):
    '''
    Member Set Load Eccentricity Vertical Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_NONE, ALIGN_TOP = range(4)


class MemberSetLoadEccentricitySectionMiddle(Enum):
    '''
    Member Set Load Eccentricity Section Middle
    '''
    LOAD_ECCENTRICITY_SECTION_MIDDLE_CENTER_OF_GRAVITY, LOAD_ECCENTRICITY_SECTION_MIDDLE_NONE, LOAD_ECCENTRICITY_SECTION_MIDDLE_SHEAR_CENTER = range(3)


class MemberSetLoadFormFindingInternalForce(Enum):
    '''
    Member Set Load Form Finding Internal Force
    '''
    FORM_FINDING_INTERNAL_FORCE_COMPRESSION, FORM_FINDING_INTERNAL_FORCE_TENSION = range(2)


class MemberSetLoadFormFindingGeometryDefinition(Enum):
    '''
    Member Set Load Form Finding Geometry Definition
    '''
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LENGTH, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_LOW_POINT_VERTICAL_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_MAXIMUM_VERTICAL_SAG, \
    FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_SAG, FORM_FINDING_GEOMETRIC_INPUT_PARAMETER_UNSTRESSED_LENGTH = range(5)


class MemberSetLoadFormFindingForceDefinition(Enum):
    '''
    Member Set Load Form Finding Force Definition
    '''
    FORM_FINDING_FORCE_INPUT_PARAMETER_AVERAGE, FORM_FINDING_FORCE_INPUT_PARAMETER_DENSITY, FORM_FINDING_FORCE_INPUT_PARAMETER_HORIZONTAL_TENSION_COMPONENT, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MAXIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMAL_TENSION_AT_J_END, \
    FORM_FINDING_FORCE_INPUT_PARAMETER_MINIMUM_FORCE_IN_MEMBER, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_I_END, FORM_FINDING_FORCE_INPUT_PARAMETER_TENSION_AT_J_END = range(9)


class SurfaceSetLoadType(Enum):
    '''
    Surface Set Load Load Type
    '''
    LOAD_TYPE_AXIAL_STRAIN, LOAD_TYPE_FORCE, LOAD_TYPE_FORM_FINDING, LOAD_TYPE_MASS, LOAD_TYPE_PRECAMBER,\
        LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_TEMPERATURE = range(7)


class SurfaceSetLoadDistribution(Enum):
    '''
    Surface Set Load Load Distribution
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z,\
    LOAD_DISTRIBUTION_RADIAL, LOAD_DISTRIBUTION_UNIFORM, LOAD_DISTRIBUTION_VARYING_IN_Z = range(7)


class SurfaceSetLoadDirection(Enum):
    '''
    Surface Set Load Direction
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE,\
    LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE,\
    LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE,\
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z = range(9)


class SurfaceSetLoadAxisDefinitionType(Enum):
    '''
    Surface Set Load Axis Definiton Type
    '''
    AXIS_DEFINITION_POINT_AND_AXIS, AXIS_DEFINITION_TWO_POINTS = range(2)


class SurfaceSetLoadAxisDefinitionAxis(Enum):
    '''
    Surface Set Load Axis Definition Axis
    '''
    AXIS_X, AXIS_Y, AXIS_Z = range(3)


class SurfaceSetLoadAxisDefinitionAxisOrientation(Enum):
    '''
    Surface Set Load Axis Definition Axis Orientation
    '''
    AXIS_NEGATIVE, AXIS_POSITIVE = range(2)


class SurfaceSetLoadFormFindingDefinition(Enum):
    '''
    Surface Set Load Form Finding Definition
    '''
    FORM_FINDING_DEFINITION_FORCE, FORM_FINDING_DEFINITION_STRESS = range(2)


class SurfaceSetLoadFormFindingCalculationMethod(Enum):
    '''
    Surface Set Load Form Finding Calculation Method
    '''
    FORM_FINDING_CALCULATION_METHOD_PROJECTION, FORM_FINDING_CALCULATION_METHOD_STANDARD = range(2)


class GlobalParameterUnitGroup(Enum):
    '''
    Global Parameter Unit Group | Enum
    '''
    ANGLE, AREA, DENSITY, DIMENSIONLESS, DYNAMIC_INCREASE_FACTOR, EG_MODULE, FRICTION_COEFFICIENT, \
    GEOGRAPHIC_COORDINATES, GRAVITATIONAL_ACCELERATION, LENGTH, LOADS_ANGULAR_ACCELERATION, LOADS_ANGULAR_VELOCITY, \
    LOADS_AREA_MASS, LOADS_AXIAL_STRAIN, LOADS_DENSITY, LOADS_DISPLACEMENT, LOADS_DISPLACEMENT_PER_UNIT_LENGTH, \
    LOADS_FORCE, LOADS_FORCE_PER_UNIT_LENGTH, LOADS_IMPOSED_DISPLACEMENT, LOADS_IMPOSED_ROTATION, LOADS_KINEMATIC_VISCOSITY, \
    LOADS_KINETIC_ENERGY, LOADS_LENGTH, LOADS_MASS, LOADS_MOMENT, LOADS_MOMENT_PER_UNIT_LENGTH, LOADS_PRECAMBER, \
    LOADS_PRESSURE, LOADS_RELATIVE_LENGTH, LOADS_ROTATION, LOADS_ROTATION_PER_UNIT_LENGTH, LOADS_SOLID_TYPE_LOAD, \
    LOADS_SPECIFIC_ENERGY, LOADS_SURFACE_TYPE_LOAD, LOADS_TEMPERATURE, LOADS_TEMPERATURE_CHANGE, LOADS_VELOCITY, \
    MASS, MASS_MOMENT_PER_UNIT_AREA, MATERIAL_ANGLE, MATERIAL_DEFORMATION, MATERIAL_FACTOR, MATERIAL_QUANTITY_INTEGER, \
    MATERIAL_SPECIFIC_WEIGHT, MATERIAL_THICKNESS, PARTIAL_FACTOR, POISSONS_RATIO, PRECISION_FACTOR, QUANTITY, QUANTITY_INTEGER,\
    RATIO, RELATIVE_LENGTH, SECTION_ANGLE, SECTION_AREA, SECTION_BIMOMENT, SECTION_COMPLIANCE, SECTION_DIMENSION, \
    SECTION_EFFECTIVE_SECOND_MOMENT_OF_AREA, SECTION_FORCE, SECTION_MOMENT, SECTION_MOMENT_OF_INERTIA, \
    SECTION_NORMALIZED_WARPING_CONSTANT, SECTION_PERIMETER, SECTION_QUANTITY, SECTION_SECTION_FACTOR, SECTION_SECTION_MODULUS, \
    SECTION_STATICAL_MOMENT_OF_AREA, SECTION_TENSION_FIELD_COEFFICIENT_1, SECTION_TENSION_FIELD_COEFFICIENT_2, \
    SECTION_UNIT_STRESSES, SECTION_UNIT_WARPING_FUNCTION, SECTION_WARPING_CONSTANT, SECTION_WARPING_STATICAL_MOMENT, \
    SELF_WEIGHT_FACTOR, STIFFNESS_MULTIPLICATION_FACTOR, STRAIN, STRAIN_RATE, STRESSES, THERMAL_EXPANSION_COEFFICIENT, \
    THICKNESS, TIME, VOLUME, WEIGHT_AND_KNOT = range(84)


class GlobalParameterDefinitionType(Enum):
    '''
    Global Parameter Definition Type
    '''
    DEFINITION_TYPE_FORMULA, DEFINITION_TYPE_OPTIMIZATION, DEFINITION_TYPE_OPTIMIZATION_ASCENDING, \
    DEFINITION_TYPE_OPTIMIZATION_DESCENDING, DEFINITION_TYPE_VALUE = range(5)


class FreeConcentratedLoadLoadDirection(Enum):
    '''
    Load Concentrated Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X, LOAD_DIRECTION_GLOBAL_Y, LOAD_DIRECTION_GLOBAL_Z, LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, \
    LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U, LOAD_DIRECTION_USER_DEFINED_V, LOAD_DIRECTION_USER_DEFINED_W = range(9)


class FreeLoadLoadProjection(Enum):
    '''
    Free Load Load Projection | Enum
    '''
    LOAD_PROJECTION_XY_OR_UV, LOAD_PROJECTION_XZ_OR_UW, LOAD_PROJECTION_YZ_OR_VW = range(3)


class FreeConcentratedLoadLoadType(Enum):
    '''
    Free Concentrated Load Load Type | Enum
    '''
    LOAD_TYPE_FORCE, LOAD_TYPE_MOMENT = range(2)


class FreeLineLoadLoadDirection(Enum):
    '''
    Free Line Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)


class FreeLineLoadLoadDistribution(Enum):
    '''
    Free Line Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_UNIFORM = range(2)


class FreeRectangularLoadLoadDirection(Enum):
    '''
    Free Rectangular Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)


class FreeRectangularLoadLoadDistribution(Enum):
    '''
    Free Rectangular Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_FIRST, LOAD_DISTRIBUTION_LINEAR_SECOND, LOAD_DISTRIBUTION_UNIFORM, \
    LOAD_DISTRIBUTION_VARYING_ALONG_PERIMETER, LOAD_DISTRIBUTION_VARYING_IN_Z, \
    LOAD_DISTRIBUTION_VARYING_IN_Z_AND_ALONG_PERIMETER = range(6)


class FreeRectangularLoadLoadLocationRectangle(Enum):
    '''
    Free Rectangular Load Load Location Rectangle | Enum
    '''
    LOAD_LOCATION_RECTANGLE_CENTER_AND_SIDES, LOAD_LOCATION_RECTANGLE_CORNER_POINTS = range(2)


class FreeCircularLoadLoadDirection(Enum):
    '''
    Free Circular Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)


class FreeCircularLoadLoadDistribution(Enum):
    '''
    Free Circular Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_UNIFORM = range(2)


class FreePolygonLoadLoadDirection(Enum):
    '''
    Free Polygon Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_PROJECTED, LOAD_DIRECTION_GLOBAL_X_TRUE, LOAD_DIRECTION_GLOBAL_Y_PROJECTED, \
    LOAD_DIRECTION_GLOBAL_Y_TRUE, LOAD_DIRECTION_GLOBAL_Z_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_TRUE, \
    LOAD_DIRECTION_LOCAL_X, LOAD_DIRECTION_LOCAL_Y, LOAD_DIRECTION_LOCAL_Z, LOAD_DIRECTION_USER_DEFINED_U_PROJECTED, \
    LOAD_DIRECTION_USER_DEFINED_U_TRUE, LOAD_DIRECTION_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_USER_DEFINED_V_TRUE, \
    LOAD_DIRECTION_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_USER_DEFINED_W_TRUE = range(15)


class FreePolygonLoadLoadDistribution(Enum):
    '''
    Free Polygon Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR, LOAD_DISTRIBUTION_LINEAR_FIRST, LOAD_DISTRIBUTION_LINEAR_SECOND, LOAD_DISTRIBUTION_UNIFORM = range(4)


class RigidLinkType(Enum):
    '''
    Rigid Link Type | Enum
    '''
    TYPE_LINE_TO_LINE, TYPE_LINE_TO_SURFACE, TYPE_DIAPHRAGM = range(3)


class SolidType(Enum):
    '''
    Solid Type | Enum
    '''
    TYPE_STANDARD, TYPE_GAS, TYPE_CONTACT, TYPE_HOLE, TYPE_SOIL = range(5)


class SolidLoadType(Enum):
    '''
    Solid Load Load Type | Enum
    '''
    LOAD_TYPE_BUOYANCY, LOAD_TYPE_FORCE, LOAD_TYPE_GAS, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_STRAIN, LOAD_TYPE_TEMPERATURE = range(6)


class SolidLoadDistribution(Enum):
    '''
    Solid Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z, LOAD_DISTRIBUTION_UNIFORM = range(4)


class SolidLoadDirection(Enum):
    '''
    Solid Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE = range(3)


class SolidSetLoadType(Enum):
    '''
    Solidset Load Load Type | Enum
    '''
    LOAD_TYPE_BUOYANCY, LOAD_TYPE_FORCE, LOAD_TYPE_GAS, LOAD_TYPE_ROTARY_MOTION, LOAD_TYPE_STRAIN, LOAD_TYPE_TEMPERATURE = range(6)


class SolidSetLoadDistribution(Enum):
    '''
    Solidset Load Load Distribution | Enum
    '''
    LOAD_DISTRIBUTION_LINEAR_IN_X, LOAD_DISTRIBUTION_LINEAR_IN_Y, LOAD_DISTRIBUTION_LINEAR_IN_Z, LOAD_DISTRIBUTION_UNIFORM = range(4)


class SolidSetLoadDirection(Enum):
    '''
    Solidset Load Load Direction | Enum
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE = range(3)


class StabilityAnalysisSettingsAnalysisType(Enum):
    '''
    Stability Analysis Settings Analysis Type | Enum
    '''
    EIGENVALUE_METHOD, INCREMENTALY_METHOD_WITHOUT_EIGENVALUE, INCREMENTALY_METHOD_WITH_EIGENVALUE = range(3)


class StabilityAnalysisSettingsEigenvalueMethod(Enum):
    '''
    Stability Analysis Settings Eigenvalue Method | Enum
    '''
    EIGENVALUE_METHOD_ICG_ITERATION, EIGENVALUE_METHOD_LANCZOS, EIGENVALUE_METHOD_ROOTS_OF_CHARACTERISTIC_POLYNOMIAL, \
    EIGENVALUE_METHOD_SUBSPACE_ITERATION, E_EIGENVALUE_METHOD_SHIFTED_INVERSE_POWER_METHOD = range(5)


class StabilityAnalysisSettingsMatrixType(Enum):
    '''
    Stability Analysis Settings Matrix Type | Enum
    '''
    MATRIX_TYPE_STANDARD, MATRIX_TYPE_UNIT = range(2)


class StabilityAnalysisSettingsStoppingOfLoadIncreasingResult(Enum):
    '''
    Stability Analysis Settings Stopping Of Load Increasing Result | Enum
    '''
    RESULT_TYPE_DISPLACEMENT_U, RESULT_TYPE_DISPLACEMENT_U_X, RESULT_TYPE_DISPLACEMENT_U_Y, \
    RESULT_TYPE_DISPLACEMENT_U_Z, RESULT_TYPE_ROTATION_PHI, RESULT_TYPE_ROTATION_PHI_X, \
    RESULT_TYPE_ROTATION_PHI_Y, RESULT_TYPE_ROTATION_PHI_Z = range(8)


class LineType(Enum):
    '''
    Line Type
    '''
    TYPE_ARC, TYPE_CIRCLE, TYPE_CUT_VIA_SECTION, TYPE_CUT_VIA_TWO_LINES, TYPE_ELLIPTICAL_ARC, TYPE_ELLIPSE, TYPE_NURBS, TYPE_PARABOLA, TYPE_POLYLINE, TYPE_SPLINE = range(10)


class ObjectTypes(Enum):
    '''
    Object Types
    '''
    E_OBJECT_TYPE_ACTION, E_OBJECT_TYPE_ACTION_COMBINATION, E_OBJECT_TYPE_ALUMINUM_EFFECTIVE_LENGTHS, E_OBJECT_TYPE_ALUMINUM_MEMBER_LOCAL_SECTION_REDUCTION, \
    E_OBJECT_TYPE_ALUMINUM_MEMBER_ROTATIONAL_RESTRAINT, E_OBJECT_TYPE_ALUMINUM_MEMBER_SHEAR_PANEL, E_OBJECT_TYPE_ALUMINUM_MEMBER_TRANSVERSE_WELD, E_OBJECT_TYPE_BOREHOLE, \
    E_OBJECT_TYPE_BUILDING_STORY, E_OBJECT_TYPE_CLIPPING_BOX, E_OBJECT_TYPE_CLIPPING_PLANE, E_OBJECT_TYPE_COMBINATION_WIZARD, E_OBJECT_TYPE_CONSTRUCTION_STAGE,  \
    E_OBJECT_TYPE_COORDINATE_SYSTEM, E_OBJECT_TYPE_DESIGN_SITUATION, E_OBJECT_TYPE_DESIGN_SUPPORT, E_OBJECT_TYPE_DIMENSION, E_OBJECT_TYPE_DXF_FILE_MODEL_OBJECT,  \
    E_OBJECT_TYPE_DXF_MODEL_OBJECT, E_OBJECT_TYPE_FREE_CIRCULAR_LOAD, E_OBJECT_TYPE_FREE_CONCENTRATED_LOAD, E_OBJECT_TYPE_FREE_LINE_LOAD, E_OBJECT_TYPE_FREE_POLYGON_LOAD,  \
    E_OBJECT_TYPE_FREE_RECTANGULAR_LOAD, E_OBJECT_TYPE_GLOBAL_PARAMETER, E_OBJECT_TYPE_IMPERFECTION_CASE, E_OBJECT_TYPE_IMPOSED_LINE_DEFORMATION, E_OBJECT_TYPE_IMPOSED_NODAL_DEFORMATION, \
    E_OBJECT_TYPE_INTERSECTION, E_OBJECT_TYPE_LINE, E_OBJECT_TYPE_LINE_GRID, E_OBJECT_TYPE_LINE_HINGE, E_OBJECT_TYPE_LINE_LOAD, E_OBJECT_TYPE_LINE_MESH_REFINEMENT, E_OBJECT_TYPE_LINE_SET, \
    E_OBJECT_TYPE_LINE_SET_LOAD, E_OBJECT_TYPE_LINE_SUPPORT, E_OBJECT_TYPE_LINE_WELDED_JOINT, E_OBJECT_TYPE_LOAD_CASE, E_OBJECT_TYPE_LOAD_COMBINATION, E_OBJECT_TYPE_MATERIAL, \
    E_OBJECT_TYPE_MEMBER, E_OBJECT_TYPE_MEMBER_DEFINABLE_STIFFNESS, E_OBJECT_TYPE_MEMBER_ECCENTRICITY, E_OBJECT_TYPE_MEMBER_HINGE, E_OBJECT_TYPE_MEMBER_IMPERFECTION, E_OBJECT_TYPE_MEMBER_LOAD, \
    E_OBJECT_TYPE_MEMBER_NONLINEARITY, E_OBJECT_TYPE_MEMBER_REPRESENTATIVE, E_OBJECT_TYPE_MEMBER_RESULT_INTERMEDIATE_POINT, E_OBJECT_TYPE_MEMBER_SET, E_OBJECT_TYPE_MEMBER_SET_IMPERFECTION, \
    E_OBJECT_TYPE_MEMBER_SET_LOAD, E_OBJECT_TYPE_MEMBER_SET_REPRESENTATIVE, E_OBJECT_TYPE_MEMBER_STIFFNESS_MODIFICATION, E_OBJECT_TYPE_MEMBER_SUPPORT, E_OBJECT_TYPE_MEMBER_TRANSVERSE_STIFFENER, \
    E_OBJECT_TYPE_MODAL_ANALYSIS_SETTINGS, E_OBJECT_TYPE_NODAL_LOAD, E_OBJECT_TYPE_NODAL_MESH_REFINEMENT, E_OBJECT_TYPE_NODAL_SUPPORT, E_OBJECT_TYPE_NODE, E_OBJECT_TYPE_NOTE, \
    E_OBJECT_TYPE_OBJECT_SNAP, E_OBJECT_TYPE_OPENING, E_OBJECT_TYPE_OPENING_LOAD, E_OBJECT_TYPE_PUNCHING_REINFORCEMENT, E_OBJECT_TYPE_RELATIONSHIP_BETWEEN_LOAD_CASES, \
    E_OBJECT_TYPE_RESULT_COMBINATION, E_OBJECT_TYPE_RESULT_SECTION, E_OBJECT_TYPE_RIGID_LINK, E_OBJECT_TYPE_SECTION, E_OBJECT_TYPE_SOIL_MASSIF, E_OBJECT_TYPE_SOLID, E_OBJECT_TYPE_SOLID_CONTACTS, \
    E_OBJECT_TYPE_SOLID_GAS, E_OBJECT_TYPE_SOLID_LOAD, E_OBJECT_TYPE_SOLID_MESH_REFINEMENT, E_OBJECT_TYPE_SOLID_SET, E_OBJECT_TYPE_SOLID_SET_LOAD, E_OBJECT_TYPE_SPECTRAL_ANALYSIS_SETTINGS, \
    E_OBJECT_TYPE_STABILITY_ANALYSIS_SETTINGS, E_OBJECT_TYPE_STATIC_ANALYSIS_SETTINGS, E_OBJECT_TYPE_STEEL_BOUNDARY_CONDITIONS, E_OBJECT_TYPE_STEEL_EFFECTIVE_LENGTHS, \
    E_OBJECT_TYPE_STEEL_MEMBER_LOCAL_SECTION_REDUCTION, E_OBJECT_TYPE_STEEL_MEMBER_ROTATIONAL_RESTRAINT, E_OBJECT_TYPE_STEEL_MEMBER_SHEAR_PANEL, E_OBJECT_TYPE_STRUCTURE_MODIFICATION, \
    E_OBJECT_TYPE_SURFACE, E_OBJECT_TYPE_SURFACES_CONTACT, E_OBJECT_TYPE_SURFACES_CONTACT_TYPE, E_OBJECT_TYPE_SURFACE_ECCENTRICITY, E_OBJECT_TYPE_SURFACE_IMPERFECTION, E_OBJECT_TYPE_SURFACE_LOAD, \
    E_OBJECT_TYPE_SURFACE_MESH_REFINEMENT, E_OBJECT_TYPE_SURFACE_RESULTS_ADJUSTMENT, E_OBJECT_TYPE_SURFACE_SET, E_OBJECT_TYPE_SURFACE_SET_IMPERFECTION, E_OBJECT_TYPE_SURFACE_SET_LOAD, \
    E_OBJECT_TYPE_SURFACE_STIFFNESS_MODIFICATION, E_OBJECT_TYPE_SURFACE_SUPPORT, E_OBJECT_TYPE_TERRAIN, E_OBJECT_TYPE_THICKNESS, E_OBJECT_TYPE_TIMBER_EFFECTIVE_LENGTHS, \
    E_OBJECT_TYPE_TIMBER_MEMBER_LOCAL_SECTION_REDUCTION, E_OBJECT_TYPE_TIMBER_MEMBER_ROTATIONAL_RESTRAINT, E_OBJECT_TYPE_TIMBER_MEMBER_SHEAR_PANEL, E_OBJECT_TYPE_TIMBER_MOISTURE_CLASS, \
    E_OBJECT_TYPE_TIMBER_SERVICE_CLASS, E_OBJECT_TYPE_TIMBER_SERVICE_CONDITIONS, E_OBJECT_TYPE_VISUAL_OBJECT, E_OBJECT_TYPE_WIND_PROFILE, E_OBJECT_TYPE_WIND_SIMULATION, E_OBJECT_TYPE_WIND_SIMULATION_ANALYSIS_SETTINGS = range(115)


class export_to_ifc_axis_rotation_sequence_type(Enum):
    '''
    Export to IFC Axis Rotation Sequence Type
    '''
    XYZ, XZY, YXZ, YZX, ZXY, ZYX = range(6)


class export_to_ifc_axis_type(Enum):
    '''
    Export to IFC Axis Type
    '''
    X, Y, Z = range(3)


class export_to_ifc_export_type(Enum):
    '''
    Export to IFC Export Type
    '''
    E_EXPORT_IFC4_REFERENCE_VIEW, E_EXPORT_IFC4_STRUCTURAL_ANALYSIS_VIEW = range(2)


class MemberSectionDistributionType(Enum):
    '''
    Member Section Distribution Type
    '''
    SECTION_DISTRIBUTION_TYPE_LINEAR, SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES, SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER, \
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_SADDLE, SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES, \
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER, SECTION_DISTRIBUTION_TYPE_UNIFORM = range(9)


class MemberReferenceType(Enum):
    '''
    Member Reference Type
    '''
    REFERENCE_TYPE_L, REFERENCE_TYPE_XY, REFERENCE_TYPE_XZ, REFERENCE_TYPE_YZ = range(4)


class MemberTypeRibAlignment(Enum):
    '''
    Member Type Rib Alignment
    '''
    ALIGNMENT_CENTRIC, ALIGNMENT_ON_Z_SIDE_NEGATIVE, ALIGNMENT_ON_Z_SIDE_POSITIVE, ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY = range(4)


class MemberReferenceLengthType(Enum):
    '''
    Member Reference Length Definition Type
    '''
    REFERENCE_LENGTH_TYPE_MEMBER_LENGTH, REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH, REFERENCE_LENGTH_TYPE_USER_DEFINED = range(3)


class MemberReferenceLengthWidthType(Enum):
    '''
    Member Reference Length Width Type
    '''
    REFERENCE_LENGTH_WIDTH_EC2, REFERENCE_LENGTH_WIDTH_EIGHTH, REFERENCE_LENGTH_WIDTH_NONE, REFERENCE_LENGTH_WIDTH_SIXTH = range(4)


class MemberResultBeamIntegration(Enum):
    '''
    Member Result Beam Integrate Stresses and Forces
    '''
    INTEGRATE_FROM_LISTED_OBJECT, INTEGRATE_WITHIN_CUBOID_GENERAL, INTEGRATE_WITHIN_CUBOID_QUADRATIC, INTEGRATE_WITHIN_CYLINDER = range(4)


class MemberSectionAlignment(Enum):
    '''
    Member Section Alignment
    '''
    SECTION_ALIGNMENT_BOTTOM, SECTION_ALIGNMENT_CENTRIC, SECTION_ALIGNMENT_TOP = range(3)


class MemberCurvedCantileversType(Enum):
    '''
    Member Curved Member Cantilevers Type
    '''
    CANTILEVERS_TYPE_HORIZONTAL, CANTILEVERS_TYPE_OFFSET, CANTILEVERS_TYPE_PARALLEL, CANTILEVERS_TYPE_TAPER = range(4)


class MemberRotationSpecificationType(Enum):
    ''''
    Member Rotation Specification Type
    '''
    COORDINATE_SYSTEM_ROTATION_VIA_ANGLE, COORDINATE_SYSTEM_ROTATION_VIA_HELP_NODE, COORDINATE_SYSTEM_ROTATION_VIA_INSIDE_NODE, COORDINATE_SYSTEM_ROTATION_VIA_SURFACE = range(4)


class MemberRotationPlaneType(Enum):
    '''
    Member Rotation Plane Type
    '''
    ROTATION_PLANE_XY, ROTATION_PLANE_XZ = range(2)


class StirrupType(Enum):
    '''
    Stirrup Type
    '''
    STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180, \
    STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180, \
    STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135, STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90, STIRRUP_TYPE_TWO_LEGGED_OPEN, \
    STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180 = range(10)


class SpanPositionReferenceType(Enum):
    '''
    Span Position Reference Type
    '''
    SHEAR_REINFORCEMENT_SPAN_INTERNAL_NODE, SHEAR_REINFORCEMENT_SPAN_REFERENCE_END, SHEAR_REINFORCEMENT_SPAN_REFERENCE_START = range(3)


class SpanPositionDefinitionFormatType(Enum):
    '''
    Span Position Definition Format Type
    '''
    SHEAR_REINFORCEMENT_SPAN_DEFINITION_FORMAT_ABSOLUTE, SHEAR_REINFORCEMENT_SPAN_DEFINITION_FORMAT_RELATIVE = range(2)


class StirrupLayoutRuleType(Enum):
    '''
    Stirrup Layout Rule Type
    '''
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_END_DEFINED, SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED,\
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_DEFINED, SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_EQUALS_END, \
    SHEAR_REINFORCEMENT_STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED = range(5)


class RebarType(Enum):
    '''
    Rebar Type
    '''
    REBAR_TYPE_LINE, REBAR_TYPE_SINGLE, REBAR_TYPE_SYMMETRICAL, REBAR_TYPE_UNIFORMLY_SURROUNDING, REBAR_TYPE_UNSYMMETRICAL = range(5)


class AdditionalOffsetType(Enum):
    '''
    Additional Offset Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_NONE = range(4)


class AdditionalOffsetSingleLineType(Enum):
    '''
    Additional Offset Single Line Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_TYPE_NONE = range(4)


class AdditionalOffsetReferenceType(Enum):
    '''
    Additional Offset Reference Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)


class AdditionalOffsetReferenceStartType(Enum):
    '''
    Additional Offset Reference Type at Start Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)


class AdditionalOffsetReferenceEndType(Enum):
    '''
    Additional Offset Reference Type at End Type
    '''
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM, LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER, \
    LONGITUDINAL_REINFORCEMENT_ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP = range(9)


class AnchorageStartAnchorType(Enum):
    '''
    Anchorage Start Anchor Type
    '''
    ANCHORAGE_TYPE_BEND, ANCHORAGE_TYPE_HOOK, ANCHORAGE_TYPE_HOOK_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_NONE,\
    ANCHORAGE_TYPE_STRAIGHT, ANCHORAGE_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS = range(7)


class AnchorageEndAnchorType(Enum):
    '''
    Anchorage End Anchor Type
    '''
    ANCHORAGE_TYPE_BEND, ANCHORAGE_TYPE_HOOK, ANCHORAGE_TYPE_HOOK_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_NONE,\
    ANCHORAGE_TYPE_STRAIGHT, ANCHORAGE_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR, ANCHORAGE_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS = range(7)


class SelectedObjectInformation(Enum):
    '''
    Information About Members | Enum
    '''
    LENGTH, VOLUME, MASS, AREA = range(4)


class GlobalAxesOrientationType(Enum):
    '''
    Model Settings and Options Global Axes Orientation Type
    '''
    E_GLOBAL_AXES_ORIENTATION_ZDOWN, E_GLOBAL_AXES_ORIENTATION_ZUP = range(2)


class LocalAxesOrientationType(Enum):
    '''
    Model Settings and Local Axes Orientation Type
    '''
    E_LOCAL_AXES_ORIENTATION_YUPX, E_LOCAL_AXES_ORIENTATION_YUPZ, E_LOCAL_AXES_ORIENTATION_ZDOWN, E_LOCAL_AXES_ORIENTATION_ZUP = range(4)


class ModelType(Enum):
    '''
    Model Type | Enum
    '''
    E_MODEL_TYPE_1D_X_3D, E_MODEL_TYPE_1D_X_AXIAL, E_MODEL_TYPE_2D_XY_3D, \
    E_MODEL_TYPE_2D_XY_PLATE, E_MODEL_TYPE_2D_XZ_3D, E_MODEL_TYPE_2D_XZ_PLANE_STRAIN, \
    E_MODEL_TYPE_2D_XZ_PLANE_STRESS, E_MODEL_TYPE_3D = range(8)


class ModalSolutionMethod(Enum):
    '''
    Modal Analysis Settings Solution Method
    '''
    METHOD_ICG_ITERATION, METHOD_LANCZOS, METHOD_ROOT_OF_CHARACTERISTIC_POLYNOMIAL, METHOD_SUBSPACE_ITERATION, SOLUTION_METHOD_SHIFTED_INVERSE_POWER_METHOD = range(5)


class ModalMassConversionType(Enum):
    '''
    Modal Analysis Settings Mass Conversion Type
    '''
    MASS_CONVERSION_TYPE_FULL_LOADS_AS_MASS, MASS_CONVERSION_TYPE_Z_COMPONENTS_OF_LOADS, MASS_CONVERSION_TYPE_Z_COMPONENTS_OF_LOADS_IN_DIRECTION_OF_GRAVITY = range(3)


class ModalMassMatrixType(Enum):
    '''
    Modal Analysis Settings Mass Matrix Type
    '''
    MASS_MATRIX_TYPE_CONSISTENT, MASS_MATRIX_TYPE_DIAGONAL, MASS_MATRIX_TYPE_DIAGONAL_WITH_TORSIONAL_ELEMENTS, MASS_MATRIX_TYPE_UNIT = range(4)


class ModalModeNumberMethod(Enum):
    '''
    Modal Analysis Settings Number of Modes Method
    '''
    NUMBER_OF_MODES_METHOD_EFFECTIVE_MASS_FACTORS, NUMBER_OF_MODES_METHOD_MAXIMUM_FREQUENCY, NUMBER_OF_MODES_METHOD_USER_DEFINED = range(3)


class ModalNeglectMasses(Enum):
    '''
    Modal Analysis Settings Neglect Masses
    '''
    E_NEGLECT_MASSES_IN_ALL_FIXED_SUPPORTS, E_NEGLECT_MASSES_NO_NEGLECTION, E_NEGLECT_MASSES_USER_DEFINED = range(3)


class PeriodicResponseCombinationRule(Enum):
    '''
    Spectral Analysis Settings Combination Rule For Periodic Responses
    '''
    ABSOLUTE_SUM, CQC, SRSS = range(3)


class DirectionalComponentCombinationRule(Enum):
    '''
    Spectral Analysis Settings Combination Rule For Directional Components
    '''
    ABSOLUTE_SUM, SCALED_SUM, SRSS = range(3)


class CqsDampingRule(Enum):
    '''
    Spectal Analysis Settings Damping for CQC Rule
    '''
    CONSTANT_FOR_EACH_MODE, DIFFERENT_FOR_EACH_MODE = range(2)


class DurabilityCorrosionCarbonation(Enum):
    '''
    Concrete Durability Corrosion Induced by Carbonation
    '''
    CORROSION_INDUCED_BY_CARBONATION_TYPE_CYCLIC_WET_AND_DRY, CORROSION_INDUCED_BY_CARBONATION_TYPE_DRY_OR_PERMANENTLY_WET,\
    CORROSION_INDUCED_BY_CARBONATION_TYPE_MODERATE_HUMIDITY, CORROSION_INDUCED_BY_CARBONATION_TYPE_WET_RARELY_DRY = range(4)


class DurabilityCorrosionChlorides(Enum):
    '''
    Concrete Durability Corrosion Induced by Chlorides
    '''
    CORROSION_INDUCED_BY_CHLORIDES_TYPE_CYCLIC_WET_AND_DRY, CORROSION_INDUCED_BY_CHLORIDES_TYPE_MODERATE_HUMIDITY, CORROSION_INDUCED_BY_CHLORIDES_TYPE_WET_RARELY_DRY = range(3)


class DurabilityCorrosionSeaWater(Enum):
    '''
    Concrete Durability Corrosion Induced by Chlorised From Sea Water
    '''
    CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_AIRBORNE_SALT, CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_PERMANENTLY_SUBMERGED,\
    CORROSION_INDUCED_BY_CHLORIDES_FROM_SEA_WATER_TYPE_SPLASH_AND_SPRAY_ZONES = range(3)


class DurabilityFreezeThawAttack(Enum):
    '''
    Concrete Durability Freeze Thaw Attack
    '''
    FREEZE_THAW_ATTACK_TYPE_HIGH_SATURATION_DEICING, FREEZE_THAW_ATTACK_TYPE_HIGH_SATURATION_NO_DEICING,\
    FREEZE_THAW_ATTACK_TYPE_MODERATE_SATURATION_DEICING, FREEZE_THAW_ATTACK_TYPE_MODERATE_SATURATION_NO_DEICING = range(4)


class DurabilityChemicalAttack(Enum):
    '''
    Concrete Durability Chemical Attack
    '''
    CHEMICAL_ATTACK_TYPE_HIGHLY_AGGRESSIVE, CHEMICAL_ATTACK_TYPE_MODERATELY_AGGRESSIVE, CHEMICAL_ATTACK_TYPE_SLIGHTLY_AGGRESSIVE = range(3)


class DurabilityCorrosionWear(Enum):
    '''
    Concrete Durability Concrete Corrosion Induced by the Wear
    '''
    CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_HIGH, CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_MODERATE, CONCRETE_CORROSION_INDUCED_BY_WEAR_TYPE_VERY_HIGH = range(3)


class DurabilityStructuralClassType(Enum):
    '''
    Concrete Durability Structural Class Type
    '''
    DEFINED, STANDARD = range(2)


class DurabilityStructuralClass(Enum):
    '''
    Concrete Durability User Defined Structural Class
    '''
    S1, S2, S3, S4, S5, S6 = range(6)


class DurabilityMaxWaterToCementRatio(Enum):
    '''
    Concrete Durability Maximum Equivalent Water To Cement Ratio
    '''
    ZERO_POINT_FIVE, ZERO_POINT_FIVE_FIVE, ZERO_POINT_FOUR, ZERO_POINT_FOUR_FIVE, ZERO_POINT_NINE, ZERO_POINT_SIX, ZERO_POINT_THREE_FIVE = range(7)


class DurabilityConcreteCoverType(Enum):
    '''
    Concrete Durability Increase of Minimum Concrete Cover Type
    '''
    DEFINED, STANDARD = range(2)


class DurabilityStainlessSteelType(Enum):
    '''
    Concrete Durability Additional Protection Type
    '''
    DEFINED, STANDARD = range(2)


class DurabilityAdditionalProtectionType(Enum):
    '''
    Concrete Durability Additional Protection Type
    '''
    DEFINED, STANDARD = range(2)


class DurabilityAllowanceDeviationType(Enum):
    '''
    Concrete Durability Allowance of Deviation Type
    '''
    DEFINED, STANDARD = range(2)


class DurabilityConcreteCast(Enum):
    '''
    Concrete Durability Concrete Cast
    '''
    AGAINST_PREPARED_GROUND, DIRECTLY_AGAINST_SOIL = range(2)


class ConcreteEffectiveLengthsAxisZ(Enum):
    '''
    Concrete Effective Lengths Structure Type About Axis Z
    '''
    STRUCTURE_TYPE_BRACED, STRUCTURE_TYPE_UNBRACED = range(2)


class ConcreteEffectiveLengthAxisY(Enum):
    '''
    Concrete Effective Lengths Structure Type About Axis Y
    '''
    STRUCTURE_TYPE_BRACED, STRUCTURE_TYPE_UNBRACED = range(2)


class EffectiveLengthSupportType(Enum):
    '''
    Effective Length Nodal Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Z, SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION,\
    SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION_AND_WARPING, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION_AND_WARPING,\
    SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_RESTRAINT_ABOUT_X = range(10)


class EffectiveLengthEccentricityType(Enum):
    '''
    Effective Length Eccentricity Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)


class SupportStatus(Enum):
    '''
    Support Status
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class RestraintTypeAboutX(Enum):
    '''
    Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class RestraintTypeAboutZ(Enum):
    '''
    Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class RestraintTypeWarping(Enum):
    '''
    Restraint About Warping
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class ReinforcementDirectionType(Enum):
    '''
    Reinforcement Direction Type
    '''
    REINFORCEMENT_DIRECTION_TYPE_FIRST_REINFORCEMENT_IN_X, REINFORCEMENT_DIRECTION_TYPE_FIRST_REINFORCEMENT_IN_Y, REINFORCEMENT_DIRECTION_TYPE_ROTATED = range(3)


class SurfaceReinforcementLocationType(Enum):
    '''
    Surface Reinforcement Location Type
    '''
    LOCATION_TYPE_FREE_CIRCULAR, LOCATION_TYPE_FREE_POLYGON, LOCATION_TYPE_FREE_RECTANGULAR, LOCATION_TYPE_ON_SURFACE = range(4)


class SurfaceReinforcementType(Enum):
    '''
    Surface Reinforcement Type
    '''
    REINFORCEMENT_TYPE_MESH, REINFORCEMENT_TYPE_REBAR, REINFORCEMENT_TYPE_STIRRUPS = range(3)


class SurfaceReinforcementDirectionType(Enum):
    '''
    Surface Reinforcement Direction Type
    '''
    REINFORCEMENT_DIRECTION_TYPE_IN_DESIGN_REINFORCEMENT_DIRECTION, REINFORCEMENT_DIRECTION_TYPE_PARALLEL_TO_TWO_POINTS = range(2)


class SurfaceReinforcementMeshProductRange(Enum):
    '''
    Surface Reinforcement Mesh Product Range
    '''
    MESHSTANDARD_AUSTRIA_2002_01_01, MESHSTANDARD_CZECH_REPUBLIC, MESHSTANDARD_FRANCE, MESHSTANDARD_GERMANY_1997_01_01, MESHSTANDARD_GERMANY_2001_10_01, MESHSTANDARD_GERMANY_2008_01_01, MESHSTANDARD_NETHERLANDS, MESHSTANDARD_UNITED_STATES = range(8)

class SurfaceReinforcementMeshShape(Enum):
    '''
    Surface Reinforcement Mesh Shape
    '''
    MESHSHAPE_AQS_MESH, MESHSHAPE_AQ_MESH, MESHSHAPE_AS_MESH, MESHSHAPE_A_MESH, MESHSHAPE_B_MESH, MESHSHAPE_CQS_MESH, MESHSHAPE_CS_MESH, MESHSHAPE_E_MESH, MESHSHAPE_G_MESH, MESHSHAPE_KA_MESH, MESHSHAPE_KD_MESH, \
    MESHSHAPE_KH_MESH, MESHSHAPE_KY_MESH, MESHSHAPE_K_MESH, MESHSHAPE_L_MESH, MESHSHAPE_PAF, MESHSHAPE_P_MESH, MESHSHAPE_Q_MESH, MESHSHAPE_ROLLS, MESHSHAPE_R_MESH, MESHSHAPE_SHEETS = range(21)


class SurfaceReinforcementDesignDirection(Enum):
    '''
    Surface Design Reinforcement Direction
    '''
    DESIGN_REINFORCEMENT_DIRECTION_A_S_1, DESIGN_REINFORCEMENT_DIRECTION_A_S_2 = range(2)


class SurfaceReinforcementProjectionPlane(Enum):
    '''
    Surface Reinforcement Projection Plane
    '''

    PROJECTION_PLANE_XY_OR_UV, PROJECTION_PLANE_XZ_OR_UW, PROJECTION_PLANE_YZ_OR_VW = range(3)


class SurfaceReinforcementLocationRectangleType(Enum):
    '''
    Surface Reinforcement Location Type
    '''
    RECTANGLE_TYPE_CENTER_AND_SIDES, RECTANGLE_TYPE_CORNER_POINTS = range(2)


class AmplitudeFunctionType(Enum):
    '''
    Amplitude Function Type
    '''
    CONSTANT, LINEAR, QUADRATIC = range(3)


class PlausibilityCheckResult(Enum):
    '''
    Plausibility Check Result
    '''
    CHECK_IS_OK, CHECK_FAILED = range(2)


class ModelCheckGetOptionType(Enum):
    '''
    Model Check Get Object Groups Option Type
    '''
    CROSSING_LINES, CROSSING_MEMBERS, IDENTICAL_NODES, OVERLAPPING_LINES, OVERLAPPING_MEMBERS = range(5)


class ModelCheckProcessOptionType(Enum):
    '''
    Model Check Process Object Groups Option Type
    '''
    CROSS_LINES, CROSS_MEMBERS, DELETE_UNUSED_NODES, UNITE_NODES_AND_DELETE_UNUSED_NODES = range(4)


class ImperfectionType(Enum):
    '''
    Types for Imperfection
    '''
    IMPERFECTION_TYPE_LOCAL_IMPERFECTIONS, IMPERFECTION_TYPE_INITIAL_SWAY_VIA_TABLE, IMPERFECTION_TYPE_NOTIONAL_LOADS_FROM_LOAD_CASE, IMPERFECTION_TYPE_STATIC_DEFORMATION, IMPERFECTION_TYPE_IMPERFECTION_CASES_GROUP, \
    IMPERFECTION_TYPE_BUCKLING_MODE, IMPERFECTION_TYPE_DYNAMIC_EIGENMODE = range(7)


class MemberImperfectionType(Enum):
    '''
    Member Imperfection Type
    '''
    IMPERFECTION_TYPE_INITIAL_SWAY, IMPERFECTION_TYPE_INITIAL_BOW, IMPERFECTION_TYPE_INITIAL_BOW_AND_CRITERION = range(3)


class ImperfectionDirection(Enum):
    '''
    Direction of member imperfection
    '''
    IMPERFECTION_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, IMPERFECTION_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, IMPERFECTION_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE, \
    IMPERFECTION_DIRECTION_LOCAL_Y, IMPERFECTION_DIRECTION_LOCAL_Y_NEGATIVE, IMPERFECTION_DIRECTION_LOCAL_Z, IMPERFECTION_DIRECTION_LOCAL_Z_NEGATIVE, IMPERFECTION_DIRECTION_PRINCIPAL_U, \
    IMPERFECTION_DIRECTION_PRINCIPAL_U_NEGATIVE, IMPERFECTION_DIRECTION_PRINCIPAL_V, IMPERFECTION_DIRECTION_PRINCIPAL_V_NEGATIVE = range(11)


class MemberImperfectionDefinitionType(Enum):
    '''
    Member Imperfection Definition Type
    '''
    DEFINITION_TYPE_ABSOLUTE, DEFINITION_TYPE_ANSI_CURRENT, DEFINITION_TYPE_ANSI_GRAVITY_LOAD, DEFINITION_TYPE_CSA_CURRENT, DEFINITION_TYPE_CSA_GRAVITY_LOAD, \
    DEFINITION_TYPE_EN_1992_1, DEFINITION_TYPE_EN_1993_1_1, DEFINITION_TYPE_EN_1995_1_1, DEFINITION_TYPE_EN_1999_1_1, DEFINITION_TYPE_GB_50017_2017, DEFINITION_TYPE_GB_50017_2017_CURRENT, \
    DEFINITION_TYPE_GB_50017_2017_GRAVITY_LOAD, DEFINITION_TYPE_NOTIONAL_LOAD, DEFINITION_TYPE_RELATIVE = range(14)


class MemberImperfectionCoordinateSystem(Enum):
    '''
    Member Imperfection Coordinate System
    '''
    COORDINATE_SYSTEM_TYPE_LOCAL, COORDINATE_SYSTEM_TYPE_PRINCIPAL = range(2)


class MemberImperfectionSectionDesign(Enum):
    '''
    Member Imperfection Section Design
    '''
    SECTION_DESIGN_ELASTIC, SECTION_DESIGN_PLASTIC = range(2)

class MemberImperfectionActiveCriterion(Enum):
    '''
    Member Imperfection Active Criterion
    '''
    ACTIVITY_CRITERION_ALWAYS, ACTIVITY_CRITERION_EN_1993, ACTIVITY_CRITERION_EN_1999, ACTIVITY_CRITERION_DIN_18800, ACTIVITY_CRITERION_DEFINE = range(5)


class MemberImperfectionStandardFactor(Enum):
    '''
    Member Imperfection Standard Factor
    '''
    STANDARD_FACTOR_LRFD, STANDARD_FACTOR_ASD = range(2)

class ImperfectionActivationCriterion(Enum):
    '''
    Activation criterion for bow
    '''
    ACTIVITY_CRITERION_ALWAYS, ACTIVITY_CRITERION_DEFINE, ACTIVITY_CRITERION_DIN_18800, ACTIVITY_CRITERION_EN_1993, ACTIVITY_CRITERION_EN_1999 = range(5)


class ImperfectionCaseSourceType(Enum):
    '''
    Imperfection Case, Static Deformation Type, Source Type
    '''
    SOURCE_TYPE_LOAD_CASE, SOURCE_TYPE_LOAD_COMBINATION = range(2)


class ImperfectionCaseAssignmentType(Enum):
    '''
    Imperfection Case, Static Deformation Type, Magnitude Assignment Type
    '''
    MAGNITUDE_ASSIGNMENT_SPECIFIC_NODE, MAGNITUDE_ASSIGNMENT_LOCATION_WITH_LARGEST_DISPLACEMENT = range(2)


class OptimizeOnType(Enum):
    '''
    Optimization Settings Optimize On Type
    '''
    E_OPTIMIZE_ON_TYPE_MIN_WHOLE_WEIGHT, E_OPTIMIZE_ON_TYPE_MIN_VECTORIAL_DISPLACEMENT, E_OPTIMIZE_ON_TYPE_MIN_MEMBER_DEFORMATION, \
    E_OPTIMIZE_ON_TYPE_MIN_SURFACE_DEFORMATION, E_OPTIMIZE_ON_TYPE_MIN_COST, E_OPTIMIZE_ON_TYPE_MIN_CO2_EMISSIONS = range(6)


class Optimizer(Enum):
    '''
    Optimization Settings Optimizer
    '''
    E_OPTIMIZER_TYPE_ALL_MUTATIONS, E_OPTIMIZER_TYPE_PERCENTS_OF_RANDOM_MUTATIONS, E_OPTIMIZER_TYPE_PARTICLE_SWARM = range(3)


class SurfacesShapeOfFiniteElements(Enum):
    '''
    Surfaces Shape of Finite Elements
    '''
    E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__TRIANGLES_AND_QUADRANGLES, E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__QUADRANGLES_ONLY, \
        E_SHAPE_OF_FINITE_ELEMENTS_FOR_SURFACES__TRIANGLES_ONLY = range(3)


class AddOn(Enum):
    '''
    AddOn types
    '''
    stress_analysis_active, concrete_design_active, steel_design_active, timber_design_active, aluminum_design_active, \
    steel_joints_active, timber_joints_active, craneway_design_active, masonry_design_active, multilayer_surfaces_design_active, \
    material_nonlinear_analysis_active, structure_stability_active, construction_stages_active, time_dependent_active, \
    form_finding_active, cutting_patterns_active, torsional_warping_active, cost_estimation_active, modal_active, spectral_active, \
    time_history_active, pushover_active, harmonic_response_active, building_model_active, wind_simulation_active, \
    geotechnical_analysis_active = range(26)


class IFCExportType(Enum):
    '''
    IFC Export Type
    '''
    E_EXPORT_IFC4_REFERENCE_VIEW, E_EXPORT_IFC4_STRUCTURAL_ANALYSIS_VIEW = range(2)


class SteelEffectiveLengthsBucklingFactorValueType(Enum):
    '''
    Steel Effective Lengths Buckling Factor Value Type
    '''
    BUCKLING_FACTOR_VALUE_TYPE_RECOMMENDED, BUCKLING_FACTOR_VALUE_TYPE_THEORETICAL = range(2)


class SteelEffectiveLengthsSupportType(Enum):
    '''
    Steel Effective Lengths Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Z, SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION, \
    SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION_AND_WARPING, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION_AND_WARPING, \
    SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_RESTRAINT_ABOUT_X = range(10)


class SteelEffectiveLengthsEccentricityType(Enum):
    '''
    Steel Effective Lengths Eccentricity Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)


class SteelEffectiveLengthsSupportTypeInY(Enum):
    '''
    Steel Effective Lengths Support in Y Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class SteelEffectiveLengthsRestraintTypeAboutX(Enum):
    '''
    Steel Effective Lengths Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class SteelEffectiveLengthsRestraintTypeAboutZ(Enum):
    '''
    Steel Effective Lengths Restraint About Z Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class SteelEffectiveLengthsRestraintTypeWarping(Enum):
    '''
    Steel Effective Lengths Restraint Warping Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)


class SteelEffectiveLengthsDeterminationMcrEurope(Enum):
    '''
    Steel Effective Lengths Determination MCR Europe
    '''
    DETERMINATION_EUROPE_EIGENVALUE, DETERMINATION_EUROPE_USER_DEFINED = range(2)

class TimberEffectiveLengthsSupportType(Enum):
    '''
    Timber Effective Lengths Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Z, SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION, \
    SUPPORT_TYPE_FIXED_IN_Z_AND_TORSION_AND_WARPING, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Z_Y_AND_TORSION_AND_WARPING, \
    SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_RESTRAINT_ABOUT_X = range(10)

class TimberEffectiveLengthsEccentricityType(Enum):
    '''
    Timber Effective Lengths Eccentricity Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)

class TimberEffectiveLengthsSupportTypeInY(Enum):
    '''
    Timber Effective Lengths Support in Y Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class TimberEffectiveLengthsRestraintTypeAboutX(Enum):
    '''
    Timber Effective Lengths Restraint About X Type
    '''
    SUPPORT_STATUS_NO, SUPPORT_STATUS_SPRING, SUPPORT_STATUS_YES = range(3)

class TimberEffectiveLengthsDeterminationType(Enum):
    '''
    Timber Effective Lengths Determination Type
    '''
    DETERMINATION_ANALYTICAL, DETERMINATION_EIGENVALUE_SOLVER, DETERMINATION_USER_DEFINED = range(3)

class TimberMemberLocalSectionReductionType(Enum):
    '''
    Timber Member Local Section Reduction Type
    '''
    REDUCTION_COMPONENT_TYPE_CIRCLE_OPENING, REDUCTION_COMPONENT_TYPE_END_NOTCH, REDUCTION_COMPONENT_TYPE_INNER_NOTCH, \
    REDUCTION_COMPONENT_TYPE_RECTANGLE_OPENING, REDUCTION_COMPONENT_TYPE_START_NOTCH = range(5)

class ZAxisReferenceType(Enum):
    '''
    Timber Member Local Section Reduction Z Axis Reference Type
    '''
    E_POSITION_REFERENCE_CENTER, E_POSITION_REFERENCE_TOP, E_POSITION_REFERENCE_BOTTOM = range(3)

class OrientationType(Enum):
    '''
    Timber Member Local Section Reduction Orientation Type
    '''
    E_ORIENTATION_DEPTH, E_ORIENTATION_WIDTH = range(2)

class DirectionType(Enum):
    '''
    Timber Member Local Section Reduction Direction Type
    '''
    E_DIRECTION_DEPTH_NEGATIVE, E_DIRECTION_DEPTH_POSITIVE, E_DIRECTION_WIDTH_NEGATIVE, E_DIRECTION_WIDTH_POSITIVE = range(4)

class PositionOnSection(Enum):
    '''
    Timber Member Shear Panel Position On Section
    '''
    POSITION_DEFINE, POSITION_IN_CENTROID, POSITION_ON_LOWER_FLANGE, POSITION_ON_UPPER_FLANGE = range(4)

class TimberServiceClassServiceClass(Enum):
    '''
    Timber Service Class Service Classs
    '''
    TIMBER_SERVICE_CLASS_TYPE_1, TIMBER_SERVICE_CLASS_TYPE_2, TIMBER_SERVICE_CLASS_TYPE_3 = range(3)

class AluminumEffectiveLengthsDeterminationMcrEurope(Enum):
    '''
    Aluminum Effective Lengths Determination MCR Europe
    '''
    DETERMINATION_EUROPE_EIGENVALUE, DETERMINATION_EUROPE_USER_DEFINED = range(2)

class AluminumMemberRotationalRestraintType(Enum):
    '''
    Aluminum Member Rotational Restraint Type
    '''
    TYPE_CONTINUOUS, TYPE_DISCRETE, TYPE_MANUALLY = range(3)

class AluminumMemberRotationalRestraintContinuousBeamEffect(Enum):
    '''
    Aluminum Member Rotational Restraint Continuous Beam Effect
    '''
    CONTINUOUS_BEAM_EFFECT_END_PANEL, CONTINUOUS_BEAM_EFFECT_INTERNAL_PANEL = range(2)

class AluminumMemberRotationalRestraintPositionofSheeting(Enum):
    '''
    Aluminum Member Rotational Restraint Position of Sheeting
    '''
    SHEETING_POSITION_NEGATIVE, SHEETING_POSITION_POSITIVE = range(2)

class AluminumMemberRotationalRestraintRotationalStiffness(Enum):
    '''
    Steel Member Rotational Restraint Rotational Stiffness
    '''
    ROTATIONAL_STIFFNESS_INFINITELY, ROTATIONAL_STIFFNESS_MANUALLY = range(2)

class AluminumMemberShearPanelDefinitionType(Enum):
    '''
    Aluminum Member Shear Panel Definition Type
    '''
    DEFINITION_TYPE_BRACING, DEFINITION_TYPE_DEFINE_S_PROV, DEFINITION_TYPE_TRAPEZOIDAL_SHEETING, DEFINITION_TYPE_TRAPEZOIDAL_SHEETING_AND_BRACING = range(4)

class AluminumMemberShearPanelPositionOnSection(Enum):
    '''
    Aluminum Member Shear Panel Position On Section
    '''
    POSITION_DEFINE, POSITION_IN_CENTROID, POSITION_ON_LOWER_FLANGE, POSITION_ON_UPPER_FLANGE = range(4)

class AluminumMemberShearPanelFasteningArrangement(Enum):
    '''
    Aluminum Member Shear Panel Fastening Arrangement
    '''
    FASTENING_ARRANGEMENT_EVERY_RIB, FASTENING_ARRANGEMENT_EVERY_SECOND_RIB = range(2)

class SteelEffectiveLengthsDeterminationMcrIs800(Enum):
    '''
    Steel Effective Lengths Determination MCR IS 800
    '''
    DETERMINATION_IS800_EIGENVALUE, DETERMINATION_IS800_USER_DEFINED = range(2)


class SteelEffectiveLengthsDeterminationMcrAisc(Enum):
    '''
    Steel Effective Lengths Determination MCR AISC
    '''
    DETERMINATION_AISC_ACC_TO_CHAPTER_F, DETERMINATION_AISC_EIGENVALUE, DETERMINATION_AISC_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationMcrGb50(Enum):
    '''
    Steel Effective Lengths Determination MCR GB 50
    '''
    DETERMINATION_GB50_EIGENVALUE, DETERMINATION_GB50_NOT_USED, DETERMINATION_GB50_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationCbAisc(Enum):
    '''
    Steel Effective Lengths Determination CB AISC
    '''
    DETERMINATION_CB_ACC_TO_CHAPTER_F, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationMcrCsa(Enum):
    '''
    Steel Effective Lengths Determination MCR CSA
    '''
    DETERMINATION_CSA_ACC_TO_CHAPTER_13_6, DETERMINATION_CSA_EIGENVALUE, DETERMINATION_CSA_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationCbCsa(Enum):
    '''
    Steel Effective Lengths Determination CB CSA
    '''
    DETERMINATION_CB_ACC_TO_CHAPTER_13_6, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationMcrBs5(Enum):
    '''
    Steel Effective Lengths Determination MCR BS5
    '''
    DETERMINATION_BS5_ACC_TO_CHAPTER_F, DETERMINATION_BS5_EIGENVALUE, DETERMINATION_BS5_USER_DEFINED = range(3)


class SteelEffectiveLengthsDeterminationCbNbr(Enum):
    '''
    Steel Effective Lengths Determination CB NBR
    '''
    DETERMINATION_CB_ACC_TO_5423, DETERMINATION_CB_BASIC_VALUE, DETERMINATION_CB_USER_DEFINED = range(3)


class SteelEffectiveLengthsMomentModificationRestrainedSegments(Enum):
    '''
    Steel Effective Lengths Moment Modification Restrained Segments
    '''
    MOMENT_ALPHA_ACC_TO_5611_II, MOMENT_ALPHA_ACC_TO_5611_III, MOMENT_ALPHA_BASIC_VALUE, \
    MOMENT_ALPHA_EIGENVALUE_METHOD, MOMENT_ALPHA_USER_DEFINED = range(5)


class SteelEffectiveLengthsMomentModificationUnrestrainedSegments(Enum):
    '''
    Steel Effective Lengths Moment Modification Unrestrained Segments
    '''
    MOMENT_ALPHA_ACC_TO_5611_II, MOMENT_ALPHA_BASIC_VALUE, MOMENT_ALPHA_USER_DEFINED = range(3)


class SteelEffectiveLengthsSlendernessReductionRestrainedSegments(Enum):
    '''
    Steel Effective Lengths Slenderness Reduction Restrained Segments
    '''
    SLENDERNESS_ALPHA_ACC_TO_5611, SLENDERNESS_ALPHA_EIGENVALUE_METHOD = range(2)


class SteelEffectiveLengthsSlendernessReductionUnrestrainedSegments(Enum):
    '''
    Steel Effective Lengths Slenderness Reduction Unrestrained Segments
    '''
    SLENDERNESS_ALPHA_ACC_TO_5611, SLENDERNESS_ALPHA_EIGENVALUE_METHOD = range(2)


class SteelEffectiveLengthsMemberType(Enum):
    '''
    Steel Effective Lengths Member Type
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)


class SteelEffectiveLengthsMemberTypeYY(Enum):
    '''
    Steel Effective Lengths Member Type YY
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)


class SteelEffectiveLengthsMemberTypeZZ(Enum):
    '''
    Steel Effective Lengths Member Type ZZ
    '''
    MEMBER_TYPE_BEAM, MEMBER_TYPE_CANTILEVER = range(2)

class SteelMemberShearPanelDefinitionType(Enum):
    '''
    Steel Member Shear Panel Definition Type
    '''
    DEFINITION_TYPE_BRACING, DEFINITION_TYPE_DEFINE_S_PROV, DEFINITION_TYPE_TRAPEZOIDAL_SHEETING, DEFINITION_TYPE_TRAPEZOIDAL_SHEETING_AND_BRACING = range(4)

class SteelMemberShearPanelPositionOnSection(Enum):
    '''
    Steel Member Shear Panel Position On Section
    '''
    POSITION_DEFINE, POSITION_IN_CENTROID, POSITION_ON_LOWER_FLANGE, POSITION_ON_UPPER_FLANGE = range(4)

class SteelMemberShearPanelFasteningArrangement(Enum):
    '''
    Steel Member Shear Panel Fastening Arrangement
    '''
    FASTENING_ARRANGEMENT_EVERY_RIB, FASTENING_ARRANGEMENT_EVERY_SECOND_RIB = range(2)

class SteelMemberRotationalRestraintType(Enum):
    '''
    Steel Member Rotational Restraint Type
    '''
    TYPE_CONTINUOUS, TYPE_DISCRETE, TYPE_MANUALLY = range(3)

class SteelMemberRotationalRestraintContinuousBeamEffect(Enum):
    '''
    Steel Member Rotational Restraint Continuous Beam Effect
    '''
    CONTINUOUS_BEAM_EFFECT_END_PANEL, CONTINUOUS_BEAM_EFFECT_INTERNAL_PANEL = range(2)

class SteelMemberRotationalRestraintPositionofSheeting(Enum):
    '''
    Steel Member Rotational Restraint Position of Sheeting
    '''
    SHEETING_POSITION_NEGATIVE, SHEETING_POSITION_POSITIVE = range(2)

class SteelMemberRotationalRestraintRotationalStiffness(Enum):
    '''
    Steel Member Rotational Restraint Rotational Stiffness
    '''
    ROTATIONAL_STIFFNESS_INFINITELY, ROTATIONAL_STIFFNESS_MANUALLY = range(2)

class SteelBoundaryConditionsSupportType(Enum):
    '''
    Steel Boundary Conditions Support Type
    '''
    SUPPORT_TYPE_FIXED_ALL, SUPPORT_TYPE_FIXED_IN_Y, SUPPORT_TYPE_FIXED_IN_Y_AND_TORSION, SUPPORT_TYPE_FIXED_IN_Y_AND_TORSION_AND_WARPING, \
    SUPPORT_TYPE_FIXED_IN_Y_AND_WARPING, SUPPORT_TYPE_INDIVIDUALLY, SUPPORT_TYPE_NONE, SUPPORT_TYPE_TORSION, SUPPORT_TYPE_TORSION_AND_WARPING = range(9)

class SteelBoundaryConditionsEccentricityTypeZ(Enum):
    '''
    Steel Boundary Conditions Eccentricity Type Z Type
    '''
    ECCENTRICITY_TYPE_AT_LOWER_FLANGE, ECCENTRICITY_TYPE_AT_UPPER_FLANGE, ECCENTRICITY_TYPE_NONE, ECCENTRICITY_TYPE_USER_VALUE = range(4)

class ImperfectionCaseDirection(Enum):
    '''
    Imperfection Case Sway via Table Direction
    '''
    IMPERFECTION_CASE_DIRECTION_LOCAL_X, IMPERFECTION_CASE_DIRECTION_LOCAL_Y, IMPERFECTION_CASE_DIRECTION_LOCAL_Z, IMPERFECTION_CASE_DIRECTION_LOCAL_Y_NEGATIVE, IMPERFECTION_CASE_DIRECTION_LOCAL_Z_NEGATIVE, \
    IMPERFECTION_CASE_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, IMPERFECTION_CASE_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, IMPERFECTION_CASE_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE, \
    IMPERFECTION_CASE_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_NEGATIVE, IMPERFECTION_CASE_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_NEGATIVE, IMPERFECTION_CASE_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_NEGATIVE, \
    IMPERFECTION_CASE_DIRECTION_SPATIAL = range(12)

class DirectionForLevelDirection(Enum):
    '''
    Imperfection Case, Sway via Table, Direction for Level Direction
    '''
    DIRECTION_X, DIRECTION_Y, DIRECTION_Z, DIRECTION_XY, DIRECTION_XZ, DIRECTION_YZ = range(6)

class SurfaceStiffnessModificationType(Enum):
    '''
    Surface Stiffness Modification Type
    '''
    TYPE_PARTIAL_STIFFNESSES_FACTORS, TYPE_STIFFNESS_MATRIX_ELEMENTS_FACTORS, TYPE_TOTAL_STIFFNESS_FACTOR = range(3)

class SurfaceEccentricityAlignment(Enum):
    '''
    Surface Eccentricity Alignment
    '''
    ALIGN_TOP, ALIGN_MIDDLE, ALIGN_BOTTOM = range(3)

class SolidContactPerpendicularType(Enum):
    '''
    Solid Contact Perpendicular To Surfaces
    '''
    FULL_FORCE_TRANSMISSION, FAILURE_UNDER_COMPRESSION, FAILURE_UNDER_TENSION = range(3)

class SolidContactParallelType(Enum):
    '''
    Solid Contact Parallel To Surfaces
    '''
    FAILURE_IF_CONTACT_PERPENDICULAR_TO_SURFACES_FAILED, FULL_FORCE_TRANSMISSION, RIGID_FRICTION, RIGID_FRICTION_LIMIT, \
    ELASTIC_FRICTION, ELASTIC_FRICTION_LIMIT, ELASTIC_SOLID = range(7)

class NodalMeshRefinementType(Enum):
    '''
    Nodal Mesh Refinement
    '''
    TYPE_CIRCULAR, TYPE_RECTANGULAR = range(2)

class SurfaceResultsAdjustmentShape(Enum):
    '''
    Surface Result Adjustment Shape Type
    '''
    SHAPE_RECTANGLE, SHAPE_CIRCLE, SHAPE_ELLIPSE = range(3)

class SurfaceResultsAdjustmentType(Enum):
    '''
    Surface Result Adjustment Type. ZERO left out intentionaly.
    '''
    AVERAGING_OF_MY_MXY_VY_NY_NXY, AVERAGING_OF_MX_MXY_VX_NX_NXY, USER_DEFINED, NONE = range(4)

class SurfaceResultsAdjustmentProjection(Enum):
    '''
    Surface Result Adjustment Projection
    '''
    PERPENDICULAR, GLOBAL_IN_X, GLOBAL_IN_Y, GLOBAL_IN_Z, VECTOR = range(5)

class ResultSectionType(Enum):
    '''
    Result Section Type
    '''
    TYPE_2_POINTS_AND_VECTOR, TYPE_LINE = range(2)

class ResultSectionProjection(Enum):
    '''
    Resul Section Projection
    '''
    PROJECTION_IN_GLOBAL_X, PROJECTION_IN_GLOBAL_Y, PROJECTION_IN_GLOBAL_Z, PROJECTION_IN_VECTOR = range(4)

class ResultSectionResultDirection(Enum):
    '''
    Result Section Result Direction
    '''
    SHOW_RESULTS_IN_LOCAL_PLUS_Z, SHOW_RESULTS_IN_LOCAL_MINUS_Z, SHOW_RESULTS_IN_LOCAL_PLUS_Y, SHOW_RESULTS_IN_GLOBAL_PLUS_X, SHOW_RESULTS_IN_GLOBAL_MINUS_X, \
    SHOW_RESULTS_IN_GLOBAL_PLUS_Y, SHOW_RESULTS_IN_GLOBAL_MINUS_Y, SHOW_RESULTS_IN_GLOBAL_PLUS_Z, SHOW_RESULTS_IN_GLOBAL_MINUS_Z = range(9)

class SurfaceContactPerpendicularType(Enum):
    '''
    Surface Contact Perpendicular To Surfaces
    '''
    FULL_FORCE_TRANSMISSION, FAILURE_UNDER_COMPRESSION, FAILURE_UNDER_TENSION = range(3)

class SurfaceContactParallelType(Enum):
    '''
    Surface Contact Parallel To Surfaces
    '''
    FULL_FORCE_TRANSMISSION, RIGID_FRICTION, ELASTIC_FRICTION, ELASTIC_SURFACE = range(4)

class SurfaceContactFrictionType(Enum):
    '''
    Rigid Friction Type
    '''
    LIMIT_STRESS, FRICTION_COEFFICIENT = range(2)

class ActionCategoryType(Enum):
    '''
    Load Case Action Category
    '''
    ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A, ACTION_CATEGORY_ACCIDENTAL_ACTION_A, ACTION_CATEGORY_ACCIDENTAL_LOAD_AL, ACTION_CATEGORY_ACTIONS_DUE_TO_CRANES_HORIZONTAL_AND_VERTICAL_Q_CR, ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX, ACTION_CATEGORY_ACTIONS_WITH_LIMITED_MAXIMUM_VALUES_Q_LI, \
    ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_LOADS_GS, ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_PRESSURE_GS, ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_WATER_PRESSURE_GS, ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_EARTH_PRESSURE_GS, ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_WATER_PRESSURE_GS, \
    ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_ADJACENT_TO_BLAST_FURNACE_TABLE_5_4_1_2_Q_AS, ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_TABLE_5_4_1_1_Q_AS, ACTION_CATEGORY_CIVIL_BUILDINGS_ASSEMBLY_HALL_THEATER_CINEMA_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_BUS_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_ROOF_BUS_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_OTHER_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_POPULATION_MAY_BE_CONCENTRATED_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_BUILDINGS_IN_ITEM_NO_1_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_FOR_OTHER_BUILDINGS_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_CANTEEN_DINING_HALL_ORDINARY_ARCHIVES_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_CLASSROOM_LABORATORY_READING_ROOM_MEETING_ROOM_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_DANCE_HALL_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_DWELLING_HOSTEL_HOTEL_OFFICE_HOSPITAL_WARD_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_GYMNASIUM_ARENA_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_FOR_DINING_HALL_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_OTHER_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_LAUNDRY_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_HOSTEL_HOTEL_NURSERY_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_OFFICE_CLASSROOM_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_THICK_STREAM_OF_PEOPLE_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_APARTMENT_HOUSE_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_OTHER_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_STANDS_WITHOUT_FIXED_SEAT_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_STOREHOUSE_FOR_COLLECTING_BOOKS_ARCHIVES_STOREROOMS_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_STORES_AND_SHOPS_EXHIBITION_HALLS_STATION_PORT_AIRPORT_Q_CB, ACTION_CATEGORY_CIVIL_BUILDINGS_VENTILATOR_MOTOR_ROOM_ELEVATOR_MOTOR_ROOM_Q_CB, \
    ACTION_CATEGORY_CIVIL_BUILDINGS_WAREHOUSE_WITH_A_DENSE_CONCENTRATION_OF_SHELVING_Q_CB, ACTION_CATEGORY_CONCENTRATED_AND_RAILING_LOADS_Q_CO, ACTION_CATEGORY_CONCRETE_PRESSURE_Q4_2, ACTION_CATEGORY_CONSTRUCTION_AND_MAINTENANCE_LOADS_AND_HORIZONTAL_LOAD_ON_RAILINGS_ACC_TO_5_5_3_Q_CM, \
    ACTION_CATEGORY_CONSTRUCTION_LOADS_DUE_TO_WORKING_PERSONNEL_Q_CP, ACTION_CATEGORY_CONSTRUCTION_OPERATIONS_LOADING_Q2_3, ACTION_CATEGORY_CRANE_LOADS_LIFTING_HOOK_CRANES_OF_WORKING_GRADE_A8_Q_CR, ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A1_A3_Q_CR, ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A4_A5_Q_CR, \
    ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A6_A7_Q_CR, ACTION_CATEGORY_CRANE_LOAD_CL, ACTION_CATEGORY_DEAD_LOAD_D, ACTION_CATEGORY_DEAD_LOAD_DL, ACTION_CATEGORY_DEAD_LOAD_GK, ACTION_CATEGORY_DEAD_LOAD_SOIL_DLS, ACTION_CATEGORY_DEAD_LOAD_SOIL_DS, ACTION_CATEGORY_DEAD_LOAD_SOIL_GKS, \
    ACTION_CATEGORY_DEBRIS_EFFECT_Q6_2, ACTION_CATEGORY_EARTHQUAKE_LOAD_E, ACTION_CATEGORY_EARTHQUAKE_LOAD_EL, ACTION_CATEGORY_EARTHQUAKE_LOAD_HORIZONTAL_EH, ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV, ACTION_CATEGORY_EARTH_PRESSURE_FE, ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE, \
    ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LIQUID_Q_E3, ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LOOSE_Q_E4, ACTION_CATEGORY_EQUIPMENT_FORKLIFTS_AND_ELECTRIC_TRUCKS_Q_E5, ACTION_CATEGORY_EQUIPMENT_ISOLATION_OF_EQUIPMENT_Q_E2, ACTION_CATEGORY_EQUIPMENT_PERMANENT_EQUIPMENT_Q_E1, \
    ACTION_CATEGORY_EQUIPMENT_STORED_MATERIALS_AND_PRODUCTS_Q_M, ACTION_CATEGORY_ERECTION_LOAD_ER, ACTION_CATEGORY_EXCEPTIONAL_EXC, ACTION_CATEGORY_FLOOD_LOAD_FA, ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF, ACTION_CATEGORY_GENERAL_CONSTRUCTION_ELEMENTS_AND_EQUIPMENT_G_GE, ACTION_CATEGORY_GENERAL_VARIABLE_ACTIONS_Q_GE, \
    ACTION_CATEGORY_GEOTECHNICAL_LOADS_PERMANENT_GEP, ACTION_CATEGORY_GEOTECHNICAL_LOADS_VARIABLE_GEV, ACTION_CATEGORY_GR1A_LM1_PEDESTRIAN_CYCLE_TRACK_GR1A, ACTION_CATEGORY_GR1B_SINGLE_AXLE_GR1B, ACTION_CATEGORY_GR2_HORIZONTAL_FORCES_LM1_GR2, ACTION_CATEGORY_GR3_PEDESTRIAN_LOAD_GR3, \
    ACTION_CATEGORY_GR4_CROWD_LOADING_PEDESTRIAN_LOAD_GR4, ACTION_CATEGORY_GR5_SPECIAL_VEHICLES_LM1_GR5, ACTION_CATEGORY_GR6_LOADS_FOR_BEARINGS_EXCHANGE_GR6, ACTION_CATEGORY_GROUND_WATER_FGW, ACTION_CATEGORY_HORIZONTAL_EARTHQUAKE_ACTION_EH, ACTION_CATEGORY_ICE_ACTION_FICE, ACTION_CATEGORY_ICE_LOADINGS_Q_I, \
    ACTION_CATEGORY_ICE_QI, ACTION_CATEGORY_IMPOSED_ACTION_Q, ACTION_CATEGORY_IMPOSED_DEFORMATIONS_DUE_TO_PRE_STRESSING_P, ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_EXCLUDING_CATEGORIES_A_TO_D_Q_J, ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_A_Q_KA, \
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_B_Q_KB, ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_C_Q_KC, ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_D_Q_KD, ACTION_CATEGORY_IMPOSED_LOADS_AREAS_WHERE_PEOPLE_CAN_CONGREGATE_Q_C, \
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E, \
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_E, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_ROOFS_ACCESSIBLE_ONLY_PRIVATELY_QI_F, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F, \
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G1_ROOFS_SLOPE_LESS_THAN_20_Q_G1, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G2_ROOFS_SLOPE_MORE_THAN_40_Q_G2, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H, \
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_ACCESSIBLE_ONLY_FOR_MAINTENANCE_QI_H, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_ACCESSIBLE_QI_I, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I, \
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K, ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_ROOFS_FOR_SPECIAL_USES_HELIPORTS_QI_K, \
    ACTION_CATEGORY_IMPOSED_LOADS_DOMESTIC_AND_RESIDENTIAL_AREAS_Q_A, ACTION_CATEGORY_IMPOSED_LOADS_FORK_LIFTS_Q_FL, ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_11_12_13_Q_CR, ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_1_7_Q_CR, ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_8_Q_CR, \
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_9_10_Q_CR, ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_SUPPORT_FORCES_Q_CR, ACTION_CATEGORY_IMPOSED_LOADS_HELICOPTER_LOAD_Q_HC, ACTION_CATEGORY_IMPOSED_LOADS_INACCESSIBLE_ROOFS_Q_H, ACTION_CATEGORY_IMPOSED_LOADS_INDUSTRIAL_USE_Q_E2, \
    ACTION_CATEGORY_IMPOSED_LOADS_LIGHT_INDUSTRIAL_USE_Q_E1, ACTION_CATEGORY_IMPOSED_LOADS_LIVE_LOADS_LL, ACTION_CATEGORY_IMPOSED_LOADS_PUBLIC_AREAS_NOT_SUSCEPTIBLE_TO_CROWDING_Q_B, ACTION_CATEGORY_IMPOSED_LOADS_SHOPPING_AREAS_Q_D, ACTION_CATEGORY_IMPOSED_LOADS_STORAGE_AREAS_Q_E3, \
    ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_Q_F, ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_TO_160_KN_Q_G, ACTION_CATEGORY_IMPOSED_LOAD_QK, ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_G_IN, ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_WITH_ADDITION_ON_SITE_G_IS, \
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_COTTON_MILLING_WORKSHOP_TABLE_D_0_1_4_Q_IB, ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_GRAIN_PROCESSING_WORKSHOP_TABLE_D_0_1_6_Q_IB, ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_1_2_4_6_Q_IB, ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_3_5_Q_IB, \
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_7_Q_IB, ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_METAL_WORKING_WORKSHOP_TABLE_D_0_1_1_Q_IB, ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_PREPARATORY_WORKSHOP_FOR_TIRE_PLANT_TABLE_D_0_1_5_Q_IB, \
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_SEMICONDUCTOR_PRODUCTION_WORKSHOP_TABLE_D_0_1_3_Q_IB, ACTION_CATEGORY_INFLUENCES_RESULTING_FROM_TEMPERATURE_CHANGES_SHRINKAGE_OR_CREEP_ETC_T, ACTION_CATEGORY_IN_SITU_CONCRETE_LOADING_ALLOWANCE_Q4_1, ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H, ACTION_CATEGORY_LIQUID_PRESSURE_FLP, \
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_HELICOPTER_ON_THE_ROOF_ACC_TO_5_3_2_Q_LR, ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_MANNED_ROOF_Q_LR, ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_GARDEN_Q_LR, ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_SPORTS_GROUND_Q_LR, ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_UNMANNED_ROOF_Q_LR, \
    ACTION_CATEGORY_LIVE_LOAD_DUE_TO_EARTHQUAKE_E, ACTION_CATEGORY_LIVE_LOAD_DUE_TO_WIND_W, ACTION_CATEGORY_LIVE_LOAD_L, ACTION_CATEGORY_LIVE_LOAD_Q,ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_6K_Q_C4, ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_7K_Q_C3, ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_ELASTIC_Q_C2, \
    ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_RIGID_Q_C1, ACTION_CATEGORY_LOADS_FROM_CRANES_IN_GENERAL_Q_C1, ACTION_CATEGORY_LOADS_FROM_CRANES_OTHER_GROUPS_Q_C5, ACTION_CATEGORY_LOADS_FROM_VEHICLES_Q_V, ACTION_CATEGORY_LOADS_PRODUCED_BY_FLOWING_WATER_Q6_1, ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK, \
    ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F, ACTION_CATEGORY_LOAD_DUE_TO_GROUND_WATER_PRESSURE_HW, ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H, ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_OR_PRESSURE_OF_BULK_MATERIALS_HEB, \
    ACTION_CATEGORY_MAXIMUM_WIND_Q5_1, ACTION_CATEGORY_NONE_NONE, ACTION_CATEGORY_NOTIONAL_HORIZONTAL_FORCES_ACCORDING_TO_BS_5950_NK, ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N, ACTION_CATEGORY_OTHER_ACTIONS_QO, ACTION_CATEGORY_OTHER_CONSTRUCTION_LOADS_Q_CO, ACTION_CATEGORY_OTHER_IMPOSED_PERMANENT_DEFORMATIONS_FOR_EXAMPLE_SETTLEMENT_G_OT, \
    ACTION_CATEGORY_OTHER_LIVE_LOADS_QO, ACTION_CATEGORY_OTHER_LOADS_Q9, ACTION_CATEGORY_OTHER_TYPES_OF_VARIABLE_LOADS_Q_OT, ACTION_CATEGORY_PERMANENT_EARTH_PRESSURE_G_E, ACTION_CATEGORY_PERMANENT_FROM_CRANES_G_CR, ACTION_CATEGORY_PERMANENT_G, ACTION_CATEGORY_PERMANENT_G1, ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_G_GF, \
    ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_G_GU, ACTION_CATEGORY_PERMANENT_IMPOSED_GQ, ACTION_CATEGORY_PERMANENT_IMPOSED_NON_STRUCTURAL_G2, ACTION_CATEGORY_PERMANENT_LOADS_FROM_FLUIDS_G_FL, ACTION_CATEGORY_PERMANENT_NON_STRUCTURAL_G2, ACTION_CATEGORY_PERMANENT_SELF_WEIGHT_SELF_WEIGHT_OF_SOIL_G, \
    ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK, ACTION_CATEGORY_PERMANENT_SOIL_GS, ACTION_CATEGORY_PERMANENT_WATER_PRESSURE_G_W, ACTION_CATEGORY_PLACEMENT_LOADS_QP, ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_2_KN_M2_AND_MORE_Q_U2, ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_LESS_THAN_2_KN_M2_Q_U1, \
    ACTION_CATEGORY_PRESTRESSING_Q8_3, ACTION_CATEGORY_PRESTRESS_P, ACTION_CATEGORY_RAINWATER_PONDING_FPND, ACTION_CATEGORY_RAIN_LOAD_QR, ACTION_CATEGORY_RAIN_LOAD_R, ACTION_CATEGORY_ROOF_LIVE_LOAD_LR, ACTION_CATEGORY_ROOF_LIVE_LOAD_QR, ACTION_CATEGORY_SEISMIC_ACTIONS_AE, ACTION_CATEGORY_SEISMIC_AE, \
    ACTION_CATEGORY_SEISMIC_EFFECTS_Q7, ACTION_CATEGORY_SELF_STRAINING_FORCE_PERMANENT_TP, ACTION_CATEGORY_SELF_STRAINING_FORCE_VARIABLE_TV, ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_ON_BUILDING_SITE_G_C3, ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_PREFABRICATED_G_C2, \
    ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_MORE_THAN_1600_KG_M3_STONE_TIMBER_G_C1, ACTION_CATEGORY_SELF_WEIGHT_G, ACTION_CATEGORY_SELF_WEIGHT_OF_METAL_STRUCTURES_G_ME, ACTION_CATEGORY_SELF_WEIGHT_OF_PREFABRICATED_STRUCTURES_G_PR, ACTION_CATEGORY_SELF_WEIGHT_OF_STRUCTURES_BUILT_ON_SITE_G_SI, \
    ACTION_CATEGORY_SELF_WEIGHT_Q1_1, ACTION_CATEGORY_SELF_WEIGHT_SOIL_MODIFIED_G_SM, ACTION_CATEGORY_SELF_WEIGHT_SOIL_NATURAL_G_SN, ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_G_S1, ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_OVER_50_OF_TOTAL_LOAD_G_S2, ACTION_CATEGORY_SERVICEABILITY_EARTHQUAKE_ACTION_ES, \
    ACTION_CATEGORY_SERVICEABILITY_WIND_ACTION_WS, ACTION_CATEGORY_SETTLEMENTS_OF_SUPPORTS_SHRINKAGE_SETT, ACTION_CATEGORY_SETTLEMENT_Q8_2, ACTION_CATEGORY_SNOW_ACTION_FSN, ACTION_CATEGORY_SNOW_AND_ICE_Q2_4, ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S, ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS, \
    ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS, \
    ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS, ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS, \
    ACTION_CATEGORY_SNOW_LOADINGS_Q_S, ACTION_CATEGORY_SNOW_LOAD_S, ACTION_CATEGORY_SNOW_LOAD_ZONE_III_S, ACTION_CATEGORY_SNOW_LOAD_ZONE_II_S, ACTION_CATEGORY_SNOW_LOAD_ZONE_I_S, ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS, ACTION_CATEGORY_SOIL_Q1_2, ACTION_CATEGORY_SPECIAL_LOADINGS_PS, \
    ACTION_CATEGORY_STORAGE_AREAS_Q2_2, ACTION_CATEGORY_SUPPORTED_CONSTRUCTION_Q2_1, ACTION_CATEGORY_TEMPERATURE_CLIMATIC_INFLUENCES_Q_T, ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT, ACTION_CATEGORY_TEMPERATURE_Q8_1, ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T, ACTION_CATEGORY_THERMAL_ACTIONS_ARISING_FROM_THE_FIRE_T, \
    ACTION_CATEGORY_THERMAL_ACTIONS_QT, ACTION_CATEGORY_THERMAL_ACTION_ACCORDING_TO_9_1_3_T, ACTION_CATEGORY_TORNADO_LOAD_WT, ACTION_CATEGORY_ULTIMATE_EARTHQUAKE_ACTION_EU, ACTION_CATEGORY_ULTIMATE_WIND_ACTION_WU, ACTION_CATEGORY_UNEVEN_SETTLEMENTS_G_US, ACTION_CATEGORY_UNIT_LOADS_QU, \
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUNDWATER_GEF1, ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUND_WATER_FLUIDS_GEF2, ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_OTHER_ACTIONS_GEF3, ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUNDWATER_GEU1, \
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUND_WATER_FLUIDS_GEU2, ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_OTHER_ACTIONS_GEU3, ACTION_CATEGORY_VARIABLE_LOADS_FROM_FLUIDS_Q_FL, ACTION_CATEGORY_VARIABLE_PERSISTENT_HORIZONTAL_IMPOSED_ACTIONS_Q3, \
    ACTION_CATEGORY_VARIABLE_Q, ACTION_CATEGORY_VERTICAL_EARTHQUAKE_ACTION_EV, ACTION_CATEGORY_WEIGHT_OF_ICE_DI, ACTION_CATEGORY_WIND_LOADINGS_Q_W, ACTION_CATEGORY_WIND_LOADS_FWK_EXECUTION_QWE, ACTION_CATEGORY_WIND_LOADS_FWK_PERSISTENT_DESIGN_SITUATIONS_QWP, ACTION_CATEGORY_WIND_LOADS_FW_QW, \
    ACTION_CATEGORY_WIND_LOAD_ACCORDING_TO_8_1_4_W, ACTION_CATEGORY_WIND_LOAD_W, ACTION_CATEGORY_WIND_LOAD_WK, ACTION_CATEGORY_WIND_LOAD_WL, ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI, ACTION_CATEGORY_WIND_QW, ACTION_CATEGORY_WORKING_WIND_Q5_2 = range(284)

class DesignSituationType(Enum):
    '''
    Design Situation Type
    '''
    DESIGN_SITUATION_TYPE_ACCIDENTAL_SANS, DESIGN_SITUATION_TYPE_APPENDIX_C, DESIGN_SITUATION_TYPE_APPENDIX_C_08, DESIGN_SITUATION_TYPE_APPENDIX_C_1, DESIGN_SITUATION_TYPE_APPENDIX_C_1_08, DESIGN_SITUATION_TYPE_ACCIDENTAL, DESIGN_SITUATION_TYPE_APPENDIX_C_2, DESIGN_SITUATION_TYPE_APPENDIX_C_2_08, \
    DESIGN_SITUATION_TYPE_APPENDIX_C_3, DESIGN_SITUATION_TYPE_APPENDIX_C_3_08, DESIGN_SITUATION_TYPE_APPENDIX_C_4, DESIGN_SITUATION_TYPE_APPENDIX_C_4_08, DESIGN_SITUATION_TYPE_APPENDIX_C_5, DESIGN_SITUATION_TYPE_APPENDIX_C_5_08, DESIGN_SITUATION_TYPE_APPENDIX_C_6, DESIGN_SITUATION_TYPE_APPENDIX_C_6_08, \
    DESIGN_SITUATION_TYPE_A_ACCIDENTAL, DESIGN_SITUATION_TYPE_CHAPTER_5, DESIGN_SITUATION_TYPE_CHAPTER_5_A, DESIGN_SITUATION_TYPE_CHAPTER_5_B, DESIGN_SITUATION_TYPE_CHAPTER_5_C, DESIGN_SITUATION_TYPE_CHAPTER_5_D, DESIGN_SITUATION_TYPE_CHAPTER_5_E, DESIGN_SITUATION_TYPE_CHAPTER_5_F, DESIGN_SITUATION_TYPE_CHAPTER_5_G, \
    DESIGN_SITUATION_TYPE_CHAPTER_5_P, DESIGN_SITUATION_TYPE_CHAPTER_5_P_A, DESIGN_SITUATION_TYPE_CHAPTER_5_P_B, DESIGN_SITUATION_TYPE_CHAPTER_5_P_C, DESIGN_SITUATION_TYPE_CHAPTER_5_P_D, DESIGN_SITUATION_TYPE_CHAPTER_5_P_E, DESIGN_SITUATION_TYPE_CHAPTER_5_P_F, DESIGN_SITUATION_TYPE_CHAPTER_5_P_G, \
    DESIGN_SITUATION_TYPE_CHAPTER_9, DESIGN_SITUATION_TYPE_CHAPTER_9_08, DESIGN_SITUATION_TYPE_CHAPTER_9_1, DESIGN_SITUATION_TYPE_CHAPTER_9_1_08, DESIGN_SITUATION_TYPE_CHAPTER_9_2, DESIGN_SITUATION_TYPE_CHAPTER_9_2_08, DESIGN_SITUATION_TYPE_CHAPTER_9_3, DESIGN_SITUATION_TYPE_CHAPTER_9_3_08, \
    DESIGN_SITUATION_TYPE_CHAPTER_9_4, DESIGN_SITUATION_TYPE_CHAPTER_9_4_08, DESIGN_SITUATION_TYPE_CHAPTER_9_5, DESIGN_SITUATION_TYPE_CHAPTER_9_5_08, DESIGN_SITUATION_TYPE_CHAPTER_9_6, DESIGN_SITUATION_TYPE_CHAPTER_9_6_08, DESIGN_SITUATION_TYPE_CHAPTER_9_7, DESIGN_SITUATION_TYPE_CHAPTER_9_7_08, \
    DESIGN_SITUATION_TYPE_CLAUSE_7_2_2, DESIGN_SITUATION_TYPE_CLAUSE_7_2_6_A, DESIGN_SITUATION_TYPE_CLAUSE_7_2_6_B, DESIGN_SITUATION_TYPE_CLAUSE_7_2_6_C, DESIGN_SITUATION_TYPE_EARTHQUAKE_LIMIT_STATE_AISC341_ASD, DESIGN_SITUATION_TYPE_EARTHQUAKE_LIMIT_STATE_AISC341_ASD_OVERSTRENGTH, \
    DESIGN_SITUATION_TYPE_EARTHQUAKE_LIMIT_STATE_AISC341_LRFD, DESIGN_SITUATION_TYPE_EARTHQUAKE_LIMIT_STATE_AISC341_LRFD_OVERSTRENGTH, DESIGN_SITUATION_TYPE_EARTHQUAKE_LIMIT_STATE_CSA_S16, DESIGN_SITUATION_TYPE_EFFECTIVE_SEISMIC_WEIGHT, DESIGN_SITUATION_TYPE_EQUILIBRIUM_ACCIDENTAL, \
    DESIGN_SITUATION_TYPE_EQUILIBRIUM_FUNDAMENTAL, DESIGN_SITUATION_TYPE_EQUILIBRIUM_SEISMIC, DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_FIRE, DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_SNOW_PSI_1_1, \
    DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_SNOW_PSI_2_1, DESIGN_SITUATION_TYPE_EQU_ACCIDENTAL_TWO_STARS, DESIGN_SITUATION_TYPE_EQU_EXCEPTIONAL_SNOW, DESIGN_SITUATION_TYPE_EQU_LOAD_CASE_1, DESIGN_SITUATION_TYPE_EQU_LOAD_CASE_2, DESIGN_SITUATION_TYPE_EQU_LOAD_CASE_3, DESIGN_SITUATION_TYPE_EQU_LOAD_CASE_4, \
    DESIGN_SITUATION_TYPE_EQU_PERMANENT_AND_TRANSIENT, DESIGN_SITUATION_TYPE_EQU_PERMANENT_FUNDAMENTAL, DESIGN_SITUATION_TYPE_EQU_PERMANENT_TRANSIENT_BEARINGS_EXCHANGE, DESIGN_SITUATION_TYPE_EQU_SEISMIC, DESIGN_SITUATION_TYPE_E_SEISMIC, DESIGN_SITUATION_TYPE_FAILURE_OF_STRUCTURE_ACCIDENTAL, \
    DESIGN_SITUATION_TYPE_FAILURE_OF_STRUCTURE_FUNDAMENTAL, DESIGN_SITUATION_TYPE_FAILURE_OF_STRUCTURE_SEISMIC, DESIGN_SITUATION_TYPE_FATIGUE, DESIGN_SITUATION_TYPE_FIRE_LIMIT_STATE_AISC360, DESIGN_SITUATION_TYPE_FIRE_LIMIT_STATE_NDS, DESIGN_SITUATION_TYPE_FUNDAMENTAL_PERMANENT, \
    DESIGN_SITUATION_TYPE_FUNDAMENTAL_VARIABLE, DESIGN_SITUATION_TYPE_GEO_1_1_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_GEO_1_1_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_GEO_1_1_PERMANENT_AND_TRANSIENT_6_10, DESIGN_SITUATION_TYPE_GEO_1_1_PERMANENT_AND_TRANSIENT_6_10A_AND_6_10B, \
    DESIGN_SITUATION_TYPE_GEO_1_1_SEISMIC, DESIGN_SITUATION_TYPE_GEO_1_2_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_GEO_1_2_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_GEO_1_2_PERMANENT_AND_TRANSIENT_6_10, DESIGN_SITUATION_TYPE_GEO_1_2_PERMANENT_AND_TRANSIENT_6_10A_AND_6_10B, \
    DESIGN_SITUATION_TYPE_GEO_1_2_SEISMIC, DESIGN_SITUATION_TYPE_GEO_2_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_GEO_2_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_GEO_2_PERMANENT_AND_TRANSIENT_6_10, DESIGN_SITUATION_TYPE_GEO_2_PERMANENT_AND_TRANSIENT_6_10A_AND_6_10B, DESIGN_SITUATION_TYPE_GEO_2_SEISMIC, \
    DESIGN_SITUATION_TYPE_GEO_3_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_GEO_3_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_GEO_3_PERMANENT_AND_TRANSIENT_6_10, DESIGN_SITUATION_TYPE_GEO_3_PERMANENT_AND_TRANSIENT_6_10A_AND_6_10B, DESIGN_SITUATION_TYPE_GEO_3_SEISMIC, DESIGN_SITUATION_TYPE_GEO_ACCIDENTAL_PSI_1_1, \
    DESIGN_SITUATION_TYPE_GEO_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_GEO_PERMANENT_AND_TRANSIENT_SANS, DESIGN_SITUATION_TYPE_GEO_PERMANENT_FUNDAMENTAL, DESIGN_SITUATION_TYPE_GEO_PERMANENT_TRANSIENT, DESIGN_SITUATION_TYPE_GEO_SEISMIC, DESIGN_SITUATION_TYPE_HYD_ACCIDENTAL_PSI_1_1, \
    DESIGN_SITUATION_TYPE_HYD_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_HYD_PERMANENT_AND_TRANSIENT, DESIGN_SITUATION_TYPE_HYD_SEISMIC, DESIGN_SITUATION_TYPE_IRREVERSIBLE_SANS, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_FIRE, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY, \
    DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_1, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_2, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_3, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_CASE, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_CASE_1, \
    DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_CASE_2, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_CASE_3, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_LIVE_LOAD, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_PERMANENT_LOAD, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_SERVICEABILITY_TOTAL_LOAD, \
    DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_1, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_2, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_3, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_4, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_5, \
    DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_6, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE_1, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE_2, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE_3, DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE_4, \
    DESIGN_SITUATION_TYPE_LIMIT_STATE_OF_STRENGTH_CASE_5, DESIGN_SITUATION_TYPE_REVERSIBLE_SANS, DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY, DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY_D_L, DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY_KCR_D_L, DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY_L, \
    DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY_L_OR_LR, DESIGN_SITUATION_TYPE_SECTION_1604_3_SERVICEABILITY_S_W, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_1, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_2, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_3, \
    DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_4, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_5, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_6, DESIGN_SITUATION_TYPE_SECTION_1605_2_LRFD_16_7, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_10, \
    DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_11, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_12, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_13, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_14, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_15, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_16, \
    DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_8, DESIGN_SITUATION_TYPE_SECTION_1605_3_1_ASD_16_9, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_17, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_18, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_19, \
    DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_20, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_21, DESIGN_SITUATION_TYPE_SECTION_1605_3_2_ASD_16_22, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_1, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_2, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_3, \
    DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_4, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_5, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_5_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_6, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_1, \
    DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_2, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_3, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_4, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_5, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_5_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_6, \
    DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_7, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_10_7_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16_5, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16_6, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16_6_OVERSTRENGTH, \
    DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16_7, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_16_7_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_3_LRFD_7_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_1, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_2, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_3, \
    DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_4, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_5, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_5_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_6, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_6_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10, \
    DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_1, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_2, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_3, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_4, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_5, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_5_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_6A, \
    DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_6B, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_6B_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_7, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_8, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_10_8_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16, \
    DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_10, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_10_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_5, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_6, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_8, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_8_OVERSTRENGTH, \
    DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_9, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_7_16_9_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_8, DESIGN_SITUATION_TYPE_SECTION_2_4_ASD_8_OVERSTRENGTH, DESIGN_SITUATION_TYPE_SECTION_2_5_EXTRAORDINARY_7_10, DESIGN_SITUATION_TYPE_SECTION_2_5_EXTRAORDINARY_7_10_1, \
    DESIGN_SITUATION_TYPE_SECTION_2_5_EXTRAORDINARY_7_10_2, DESIGN_SITUATION_TYPE_SECTION_2_6_1_STR_INT_7_16, DESIGN_SITUATION_TYPE_SECTION_2_6_1_STR_INT_7_16_1, DESIGN_SITUATION_TYPE_SECTION_2_6_1_STR_INT_7_16_2, DESIGN_SITUATION_TYPE_SECTION_2_6_2_STR_INT_7_16, DESIGN_SITUATION_TYPE_SECTION_2_6_2_STR_INT_7_16_1, \
    DESIGN_SITUATION_TYPE_SECTION_2_6_2_STR_INT_7_16_2, DESIGN_SITUATION_TYPE_SECTION_2_6_2_STR_INT_7_16_3, DESIGN_SITUATION_TYPE_SEIO_SEISMIC_DESIGN_OVERSTRENGTH_LRFD, DESIGN_SITUATION_TYPE_SEISMIC_MASS, DESIGN_SITUATION_TYPE_SEISMIC_MASS_NTC, DESIGN_SITUATION_TYPE_SEISMIC_WEIGHT_IS, DESIGN_SITUATION_TYPE_SEI_SEISMIC_DESIGN_LRFD, \
    DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATES, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATES_1, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATES_2, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATES_3, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATES_VIBRATION, \
    DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_1, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_2, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_3, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_4, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_ADM, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_AISC360, \
    DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_LONG_TERM_EFFECT, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_NDS, DESIGN_SITUATION_TYPE_SERVICEABILITY_LIMIT_STATE_SHORT_TERM_EFFECT, DESIGN_SITUATION_TYPE_SER_SERVICEABILITY_DESIGN, DESIGN_SITUATION_TYPE_SLS_ALL_VARIABLE_ACTIONS_STORAGE, \
    DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_1, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_2, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_BEARINGS_EXCHANGE, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_COMFORT, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_GB_50011, \
    DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_INTEGRITY, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_NTC, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_QUASI_PERMANENT, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_WITH_DIRECT_LOAD, DESIGN_SITUATION_TYPE_SLS_CHARACTERISTIC_WITH_IMPOSED_DEFORMATION, DESIGN_SITUATION_TYPE_SLS_CSA_A23_3, \
    DESIGN_SITUATION_TYPE_SLS_EARTHQUAKE, DESIGN_SITUATION_TYPE_SLS_FREQUENT, DESIGN_SITUATION_TYPE_SLS_FREQUENT_FUNCTIONALITY_COMFORT, DESIGN_SITUATION_TYPE_SLS_FREQUENT_NTC, DESIGN_SITUATION_TYPE_SLS_G_NZS, DESIGN_SITUATION_TYPE_SLS_G_PSI_L_Q_NZS, DESIGN_SITUATION_TYPE_SLS_G_PSI_S_Q_NZS, DESIGN_SITUATION_TYPE_SLS_G_PSI_S_Q_OR_W_S_NZS, \
    DESIGN_SITUATION_TYPE_SLS_NON_FREQUENT, DESIGN_SITUATION_TYPE_SLS_ONE_VARIABLE_ACTION_STORAGE, DESIGN_SITUATION_TYPE_SLS_PERMANENT_AND_VARIABLE_GB50, DESIGN_SITUATION_TYPE_SLS_QUASI_PERMANENT, DESIGN_SITUATION_TYPE_SLS_QUASI_PERMANENT_1, DESIGN_SITUATION_TYPE_SLS_QUASI_PERMANENT_2, DESIGN_SITUATION_TYPE_SLS_QUASI_PERMANENT_NTC, \
    DESIGN_SITUATION_TYPE_SLS_RARE, DESIGN_SITUATION_TYPE_SLS_SCAFFOLDING, DESIGN_SITUATION_TYPE_SLS_SERVICEABILITY_NZS, DESIGN_SITUATION_TYPE_SLS_SNIP, DESIGN_SITUATION_TYPE_SLS_SP63_13330, DESIGN_SITUATION_TYPE_SLS_SP63_13330_LONG_TERM_EFFECT, DESIGN_SITUATION_TYPE_SLS_SP63_13330_SHORT_TERM_EFFECT, DESIGN_SITUATION_TYPE_SLS_VARIABLE_GB50, \
    DESIGN_SITUATION_TYPE_SLS_VIBRATION, DESIGN_SITUATION_TYPE_SLS_W_S_NZS, DESIGN_SITUATION_TYPE_SLS_W_S_OR_E_S_NZS, DESIGN_SITUATION_TYPE_STABILITY_II_NZS, DESIGN_SITUATION_TYPE_STABILITY_IV_NZS, DESIGN_SITUATION_TYPE_STABILITY_I_NZS, DESIGN_SITUATION_TYPE_STABILITY_VI_NZS, DESIGN_SITUATION_TYPE_STABILITY_V_NZS, \
    DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY, DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY_1, DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY_2, DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY_3, DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY_4, DESIGN_SITUATION_TYPE_STRENGTH_AND_STABILITY_LIMIT_STATES, DESIGN_SITUATION_TYPE_STRENGTH_A_NZS, \
    DESIGN_SITUATION_TYPE_STRENGTH_B_NZS, DESIGN_SITUATION_TYPE_STRENGTH_C_NZS, DESIGN_SITUATION_TYPE_STRENGTH_D_NZS, DESIGN_SITUATION_TYPE_STRENGTH_E_NZS, DESIGN_SITUATION_TYPE_STRENGTH_F_NZS, DESIGN_SITUATION_TYPE_STRENGTH_G_NZS, DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_ADM_ASD, DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_ADM_LRFD, \
    DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_AISC360_ASD, DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_AISC360_LRFD, DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_NDS_ASD, DESIGN_SITUATION_TYPE_STRENGTH_LIMIT_STATE_NDS_LRFD, DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_FIRE, DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_ONE_STAR, \
    DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_SNOW_PSI_1_1, DESIGN_SITUATION_TYPE_STR_ACCIDENTAL_SNOW_PSI_2_1, DESIGN_SITUATION_TYPE_STR_EXCEPTIONAL_SNOW, DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10, \
    DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10AMOD_6_10B, DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10A_6_10B, DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10_G_1, DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10_G_2, DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_6_10_G_3, \
    DESIGN_SITUATION_TYPE_STR_PERMANENT_AND_TRANSIENT_SANS, DESIGN_SITUATION_TYPE_STR_PERMANENT_FUNDAMENTAL, DESIGN_SITUATION_TYPE_STR_PERMANENT_TRANSIENT_BEARINGS_EXCHANGE, DESIGN_SITUATION_TYPE_STR_P_PERMANENT_AND_TRANSIENT_SANS, DESIGN_SITUATION_TYPE_STR_SEISMIC, DESIGN_SITUATION_TYPE_STR_STRENGTH_DESIGN_LRFD, \
    DESIGN_SITUATION_TYPE_TYPE_1_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_TYPE_1_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_TYPE_1_FUNDAMENTAL, DESIGN_SITUATION_TYPE_TYPE_2_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_TYPE_2_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_TYPE_2_FUNDAMENTAL, DESIGN_SITUATION_TYPE_TYPE_3_ACCIDENTAL_PSI_1_1, \
    DESIGN_SITUATION_TYPE_TYPE_3_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_TYPE_3_FUNDAMENTAL, DESIGN_SITUATION_TYPE_ULS_ACCIDENTAL_GB_50068, DESIGN_SITUATION_TYPE_ULS_ACCIDENTAL_STORAGE, DESIGN_SITUATION_TYPE_ULS_ALL_VARIABLE_ACTIONS_STORAGE, DESIGN_SITUATION_TYPE_ULS_CSA_A23_3, DESIGN_SITUATION_TYPE_ULS_EXCEPTIONAL, \
    DESIGN_SITUATION_TYPE_ULS_FUNDAMENTAL_EARTHQUAKE_GB_50011, DESIGN_SITUATION_TYPE_ULS_FUNDAMENTAL_GB_50068, DESIGN_SITUATION_TYPE_ULS_LOAD_CASE_1, DESIGN_SITUATION_TYPE_ULS_LOAD_CASE_2, DESIGN_SITUATION_TYPE_ULS_LOAD_CASE_3, DESIGN_SITUATION_TYPE_ULS_LOAD_CASE_4, DESIGN_SITUATION_TYPE_ULS_NORMAL, \
    DESIGN_SITUATION_TYPE_ULS_ONE_VARIABLE_ACTION_STORAGE, DESIGN_SITUATION_TYPE_ULS_SNIP_BASIC, DESIGN_SITUATION_TYPE_ULS_SNIP_SPECIAL, DESIGN_SITUATION_TYPE_ULS_SP63_13330, DESIGN_SITUATION_TYPE_ULS_SPECIAL, DESIGN_SITUATION_TYPE_ULS_STABILITY_AS_NZS, DESIGN_SITUATION_TYPE_ULS_STRENGTH_AS_NZS, DESIGN_SITUATION_TYPE_ULS_STRENGTH_FIRE_NZS, \
    DESIGN_SITUATION_TYPE_ULS_STR_GEO_PERMANENT_AND_TRANSIENT, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE_1, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE_2, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE_3, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE_4, DESIGN_SITUATION_TYPE_ULTIMATE_LIMIT_STATE_5, \
    DESIGN_SITUATION_TYPE_UPL_ACCIDENTAL_PSI_1_1, DESIGN_SITUATION_TYPE_UPL_ACCIDENTAL_PSI_2_1, DESIGN_SITUATION_TYPE_UPL_PERMANENT_AND_TRANSIENT, DESIGN_SITUATION_TYPE_UPL_SEISMIC = range(387)

class MemberEccentricityHorizontalSectionAlignment(Enum):
    '''
    Member Eccentricity Horizontal Section Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_RIGHT = range(3)

class MemberEccentricitySpecificationType(Enum):
    '''
    Member Eccentricity Specification Type
    '''
    TYPE_ABSOLUTE, TYPE_RELATIVE, TYPE_RELATIVE_AND_ABSOLUTE = range(3)

class MemberEccentricityTransverseOffsetType(Enum):
    '''
    Member Eccentricity Transverse Offset Reference Type
    '''
    TRANSVERSE_OFFSET_TYPE_FROM_MEMBER_SECTION, TRANSVERSE_OFFSET_TYPE_FROM_SURFACE_THICKNESS, TRANSVERSE_OFFSET_TYPE_NONE = range(3)

class MemberEccentricityTransverseOffsetHorizontalAlignment(Enum):
    '''
    Member Eccentricity Transverse Offset Horizontal Alignment
    '''
    ALIGN_LEFT, ALIGN_MIDDLE, ALIGN_RIGHT = range(3)

class MemberEccentricityTransverseOffsetVerticalAlignment(Enum):
    '''
    Member Eccentricity Transverse Vertical Alignment
    '''
    ALIGN_BOTTOM, ALIGN_MIDDLE, ALIGN_TOP = range(3)

class MemberEccentricityVerticalSectionAlignment(Enum):
    '''
    Member Eccentricity Vertical Section Alignment
    '''
    ALIGN_BOTTOM, ALIGN_MIDDLE, ALIGN_TOP = range(3)

class MemberHingeNonlinearity(Enum):
    '''
    Member Hinge Nonlinearity
    '''
    NONLINEARITY_TYPE_DIAGRAM, NONLINEARITY_TYPE_FAILURE_ALL_IF_NEGATIVE, NONLINEARITY_TYPE_FAILURE_ALL_IF_POSITIVE, NONLINEARITY_TYPE_FAILURE_IF_NEGATIVE, \
    NONLINEARITY_TYPE_FAILURE_IF_POSITIVE, NONLINEARITY_TYPE_FORCE_MOMENT_DIAGRAM, NONLINEARITY_TYPE_FRICTION_DIRECTION_1, NONLINEARITY_TYPE_FRICTION_DIRECTION_1_2, \
    NONLINEARITY_TYPE_FRICTION_DIRECTION_1_PLUS_2, NONLINEARITY_TYPE_FRICTION_DIRECTION_2, NONLINEARITY_TYPE_NONE, NONLINEARITY_TYPE_PARTIAL_ACTIVITY, \
    NONLINEARITY_TYPE_PLASTIC_BILINEAR, NONLINEARITY_TYPE_PLASTIC_DIAGRAM, NONLINEARITY_TYPE_PLASTIC_FEMA_356_ELASTIC, NONLINEARITY_TYPE_PLASTIC_FEMA_356_RIGID, \
    NONLINEARITY_TYPE_STIFFNESS_DIAGRAM = range(17)

class MemberHingeDiagramType(Enum):
    '''
    Member Hinge Diagram Type
    '''
    DIAGRAM_ENDING_TYPE_CONTINUOUS, DIAGRAM_ENDING_TYPE_STOP, DIAGRAM_ENDING_TYPE_FAILURE, DIAGRAM_ENDING_TYPE_YIELDING = range(4)

class MemberHingePartialActivityType(Enum):
    '''
    Member Hinge Partial Activity Type
    '''
    PARTIAL_ACTIVITY_TYPE_COMPLETE, PARTIAL_ACTIVITY_TYPE_FIXED, PARTIAL_ACTIVITY_TYPE_INEFFECTIVNESS, PARTIAL_ACTIVITY_TYPE_TEARING, PARTIAL_ACTIVITY_TYPE_YIELDING = range(5)

class MemberNonlinearityType(Enum):
    '''
    Member Nonlinearity Type
    '''
    TYPE_FAILURE_IF_COMPRESSION, TYPE_FAILURE_IF_COMPRESSION_WITH_SLIPPAGE, TYPE_FAILURE_IF_TENSION, TYPE_FAILURE_IF_TENSION_WITH_SLIPPAGE, \
    TYPE_SLIPPAGE, TYPE_TEARING, TYPE_TEARING_IF_COMPRESSION, TYPE_TEARING_IF_TENSION, TYPE_YIELDING, TYPE_YIELDING_IF_COMPRESSION, TYPE_YIELDING_IF_TENSION = range(11)

class MemberStiffnessModificationType(Enum):
    '''
    Member Stiffness Modification Type
    '''
    TYPE_CONCRETE_STRUCTURES_ACI, TYPE_CONCRETE_STRUCTURES_CSA, TYPE_PARTIAL_STIFFNESSES_FACTORS, TYPE_STEEL_STRUCTURES, TYPE_STEEL_STRUCTURES_CSA, TYPE_TOTAL_STIFFNESSES_FACTORS = range(6)

class MemberStiffnessModificationSteelTaub(Enum):
    '''
    Member Stiffness Modification Steel Structure tau_b Determination
    '''
    ITERATIVE, SET_TO_1 = range(2)

class MemberStiffnessModificationSteelDesignMethod(Enum):
    '''
    Member Stiffness Modification Steel Structure Design Method
    '''
    ASD, LRFD = range(2)

class MemberStiffnessModificationConcreteComponentType(Enum):
    '''
    Member Stiffness Modification Concrete Structure Component Type
    '''
    COMPONENT_TYPE_BEAMS, COMPONENT_TYPE_COLUMNS = range(2)

class MemberSupportNonlinearity(Enum):
    '''
    Member Support Nonlinearity
    '''
    NONLINEARITY_FAILURE_IF_NEGATIVE_CONTACT_STRESS_Z, NONLINEARITY_FAILURE_IF_POSITIVE_CONTACT_STRESS_Z, NONLINEARITY_NONE = range(3)

class MemberTransverseStiffenerType(Enum):
    '''
    Member Transverse Stiffeners Stiffener Type
    '''
    STIFFENER_COMPONENT_TYPE_ANGLE, STIFFENER_COMPONENT_TYPE_CHANNEL_SECTION, STIFFENER_COMPONENT_TYPE_CONNECTING_COLUMN_END, \
    STIFFENER_COMPONENT_TYPE_CONNECTING_COLUMN_START, STIFFENER_COMPONENT_TYPE_END_PLATE_END, STIFFENER_COMPONENT_TYPE_END_PLATE_START, \
    STIFFENER_COMPONENT_TYPE_FLAT,STIFFENER_COMPONENT_TYPE_WARPING_RESTRAINT = range(8)

class MemberTransverseStiffenerDefinitionType(Enum):
    '''
    Member Transverse Stiffeners Stiffener Definition Type
    '''
    DIMENSION_TYPE_OFFSET, DIMENSION_TYPE_SIZE = range(2)

class MemberTransverseStiffenerPosition(Enum):
    '''
    Member Transverse Stiffener Position Type
    '''
    STIFFENER_COMPONENT_POSITION_DOUBLE_SIDED, STIFFENER_COMPONENT_POSITION_SINGLE_SIDED_LEFT, STIFFENER_COMPONENT_POSITION_SINGLE_SIDED_RIGHT = range(3)

class MemberTransverseStiffenerOffsetType(Enum):
    '''
    Member Transverse Stiffener Multiple Offset Definition Type
    '''
    OFFSET_DEFINITION_TYPE_ABSOLUTE, OFFSET_DEFINITION_TYPE_RELATIVE = range(2)

class OpeningLoadDistribution(Enum):
    '''
    Opening Load Distribution Type
    '''
    LOAD_DISTRIBUTION_LINEAR_TRAPEZOIDAL, LOAD_DISTRIBUTION_UNIFORM_TRAPEZOIDAL = range(2)

class OpeningLoadDirection(Enum):
    '''
    Opening Load Direction Type
    '''
    LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_PROJECTED, LOAD_DIRECTION_GLOBAL_X_OR_USER_DEFINED_U_TRUE, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_PROJECTED, LOAD_DIRECTION_GLOBAL_Y_OR_USER_DEFINED_V_TRUE, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_PROJECTED, LOAD_DIRECTION_GLOBAL_Z_OR_USER_DEFINED_W_TRUE, LOAD_DIRECTION_LOCAL_Z = range(7)

class AluminumMemberLocalSectionReductionType(Enum):
    '''
    Aluminum Member Local Section Reduction Type
    '''
    REDUCTION_COMPONENT_TYPE_DESIGN_PARAMETERS = range(1)

class SteelMemberLocalSectionReductionType(Enum):
    '''
    Steel Member Local Section Reduction Type
    '''
    REDUCTION_COMPONENT_TYPE_DESIGN_PARAMETERS, REDUCTION_COMPONENT_TYPE_SECTION_VALUES = range(2)

class FastenerDefinitionType(Enum):
    '''
    Steel Member Local Section Reduction Fastener Definition Type
    '''
    DEFINITION_TYPE_ABSOLUTE, DEFINITION_TYPE_RELATIVE = range(2)

class DefinitionType(Enum):
    '''
    Steel Member Local Section Reduction Definition Type
    '''
    DIMENSION_TYPE_OFFSET, DIMENSION_TYPE_SIZE = range(2)

class MultipleOffsetDefinitionType(Enum):
    '''
    Member Local Section Reduction Multiple Offset Definition Type
    '''
    OFFSET_DEFINITION_TYPE_ABSOLUTE, OFFSET_DEFINITION_TYPE_RELATIVE = range(2)

class CaseObjectType(Enum):
    '''
    Case Object Type (Result Tables)
    '''
    E_OBJECT_TYPE_CONSTRUCTION_STAGE, E_OBJECT_TYPE_DESIGN_SITUATION, E_OBJECT_TYPE_LOAD_CASE, E_OBJECT_TYPE_LOAD_COMBINATION, E_OBJECT_TYPE_RESULT_COMBINATION = range(5)

class ProgramLanguage(Enum):
    '''
    Program Language Type
    '''
    CHINESE, CZECH, DUTCH, ENGLISH, FRENCH, GERMAN, GREEK, ITALIAN, POLISH, PORTUGUESE, RUSSIAN, SPANISH = range(12)

class ActionType(Enum):
    '''
    Action Type
    '''
    ACTING_ALTERNATIVELY, ACTING_DIFFERENTLY, ACTING_SIMULTANEOUSLY, DYNAMIC_LOAD_CASE = range(4)

class ImposedLoadCategory(Enum):
    '''
    Imposed Load Category
    '''
    IMPOSED_LOADS_CATEGORY_A, IMPOSED_LOADS_CATEGORY_B, IMPOSED_LOADS_CATEGORY_C, IMPOSED_LOADS_CATEGORY_D, IMPOSED_LOADS_CATEGORY_E = range(5)

class ActionCombinationItems(Enum):
    '''
    Action Combination Items
    '''
    ENVELOPE_PERMANENT, ENVELOPE_TRANSIENT, GENERAL, SUPERPOSITION = range(4)

class FormulaParameter(Enum):
    '''
    Formula Parameter to Return from Formula.Get Function
    '''
    ALL, FORMULA, IS_VALID, CALCULATED_VALUE = range(4)

class ResponseSpectrumDefinitionType(Enum):
    '''
    Response Spectrum Definition Type
    '''
    ACCORDING_TO_STANDARD, GENERATED_FROM_ACCELEROGRAM, USER_DEFINED, USER_DEFINED_IN_G_FACTOR = range(4)