[![Build Status](https://github.com/dstein64/pastiche/workflows/build/badge.svg)](https://github.com/dstein64/pastiche/actions)

pastiche
========

A PyTorch-based Python implementation of Neural Style Transfer [1].

<div align="center">
 <img src="https://github.com/dstein64/pastiche/blob/master/example/vangogh_starry_night.jpg?raw=true" height="256"/>
 <img src="https://github.com/dstein64/pastiche/blob/master/example/boston.jpg?raw=true" height="256"/>
 <br>
 <img src="https://github.com/dstein64/pastiche/blob/master/example/pastiche.jpg?raw=true" width="710"/>
</div>

Features
--------

- Support for saving intermediate images during optimization
- An option for preserving colors from the content image

Installation
------------

#### Requirements

- Python 3.6 or greater

#### Install

```sh
$ pip3 install pastiche
```

#### Update

```sh
$ pip3 install --upgrade pastiche
```

Usage
-----

The program is intended to be used from the command line.

The general command line usage is shown below.

```sh
$ pastiche CONTENT STYLE OUTPUT
```

`CONTENT` is the path to the content image, `STYLE` is the path to the style image, and `OUTPUT` is the path to save
the synthesized pastiche PNG file.

If the launcher script was not installed within a directory on your PATH, pastiche can be launched by passing its
module name to Python.

```sh
$ python3 -m pastiche CONTENT STYLE OUTPUT
```

There are various options, including but not limited to:
- Device (CPU versus GPU)
- Number of optimization iterations
- VGG layers to utilize
- Loss function term weights

For the full list of options and the corresponding documentation, see the source code or use `--help`.

```sh
$ pastiche --help
```

Example
-------

<img src="https://github.com/dstein64/pastiche/blob/master/example/pastiche.jpg?raw=true" width="384"/>

The image above was generated by applying the style from Vincent van Gogh's `The Starry Night` to a photo I took in
Boston in 2015. The high-resolution image was generated incrementally, with increasing resolution, using the
coarse-to-fine approach described in [2]. The commands are shown below. Depending on GPU memory availability, the
commands may necessitate execution on a CPU (`--device cpu`).

```sh
$ pastiche \
    --num-steps 2000 \
    boston.jpg \
    vangogh_starry_night.jpg \
    pastiche0.png

$ pastiche \
    --size 1024 \
    --num-steps 1000 \
    --init pastiche0.png \
    boston.jpg \
    vangogh_starry_night.jpg \
    pastiche1.png

$ pastiche \
    --size 2048 \
    --num-steps 500 \
    --init pastiche1.png \
    boston.jpg \
    vangogh_starry_night.jpg \
    pastiche2.png

$ pastiche \
    --size 4096 \
    --num-steps 100 \
    --init pastiche2.png \
    boston.jpg \
    vangogh_starry_night.jpg \
    pastiche3.png

$ convert pastiche3.png pastiche.jpg  # requires ImageMagick
```

The `--preserve-color` option can be used to retain colors from the content image. The image below was generated
using the same commands as above (up to `--size 2048`), with the addition of `--preserve-color`.

<img src="https://github.com/dstein64/pastiche/blob/master/example/pastiche_preserve_color.jpg?raw=true" width="384"/>

License
-------

The source code has an [MIT License](https://en.wikipedia.org/wiki/MIT_License).

See [LICENSE](https://github.com/dstein64/pastiche/blob/master/LICENSE).

References
----------

[1] Gatys, Leon A., Alexander S. Ecker, and Matthias Bethge. "A Neural Algorithm of Artistic Style."
ArXiv:1508.06576 [Cs, q-Bio], August 26, 2015. http://arxiv.org/abs/1508.06576.

[2] Gatys, Leon A., Alexander S. Ecker, Matthias Bethge, Aaron Hertzmann, and Eli Shechtman.
"Controlling Perceptual Factors in Neural Style Transfer." ArXiv:1611.07865 [Cs], November 23, 2016.
http://arxiv.org/abs/1611.07865.
