"""
Autogenerated Enums for CP2K RunType, TaskType, and CalcType.

Do not edit this by hand. Edit generate.py or run_types.yaml instead.
"""

from emmet.core.utils import ValueEnum


class RunType(ValueEnum):
    """CP2K calculation run types."""

    PADE = "PADE"
    PADE_U = "PADE+U"
    PADE_RVV10 = "PADE-RVV10"
    PADE_RVV10_U = "PADE-RVV10+U"
    PADE_LMKLL = "PADE-LMKLL"
    PADE_LMKLL_U = "PADE-LMKLL+U"
    PADE_DRSLL = "PADE-DRSLL"
    PADE_DRSLL_U = "PADE-DRSLL+U"
    PADE_D3 = "PADE-D3"
    PADE_D3_U = "PADE-D3+U"
    PADE_D2 = "PADE-D2"
    PADE_D2_U = "PADE-D2+U"
    PADE_D3_BJ = "PADE-D3(BJ)"
    PADE_D3_BJ_U = "PADE-D3(BJ)+U"
    PBE = "PBE"
    PBE_U = "PBE+U"
    PBE_RVV10 = "PBE-RVV10"
    PBE_RVV10_U = "PBE-RVV10+U"
    PBE_LMKLL = "PBE-LMKLL"
    PBE_LMKLL_U = "PBE-LMKLL+U"
    PBE_DRSLL = "PBE-DRSLL"
    PBE_DRSLL_U = "PBE-DRSLL+U"
    PBE_D3 = "PBE-D3"
    PBE_D3_U = "PBE-D3+U"
    PBE_D2 = "PBE-D2"
    PBE_D2_U = "PBE-D2+U"
    PBE_D3_BJ = "PBE-D3(BJ)"
    PBE_D3_BJ_U = "PBE-D3(BJ)+U"
    PBEsol = "PBEsol"
    PBEsol_U = "PBEsol+U"
    PBEsol_RVV10 = "PBEsol-RVV10"
    PBEsol_RVV10_U = "PBEsol-RVV10+U"
    PBEsol_LMKLL = "PBEsol-LMKLL"
    PBEsol_LMKLL_U = "PBEsol-LMKLL+U"
    PBEsol_DRSLL = "PBEsol-DRSLL"
    PBEsol_DRSLL_U = "PBEsol-DRSLL+U"
    PBEsol_D3 = "PBEsol-D3"
    PBEsol_D3_U = "PBEsol-D3+U"
    PBEsol_D2 = "PBEsol-D2"
    PBEsol_D2_U = "PBEsol-D2+U"
    PBEsol_D3_BJ = "PBEsol-D3(BJ)"
    PBEsol_D3_BJ_U = "PBEsol-D3(BJ)+U"
    GGA = "GGA"
    GGA_U = "GGA+U"
    GGA_RVV10 = "GGA-RVV10"
    GGA_RVV10_U = "GGA-RVV10+U"
    GGA_LMKLL = "GGA-LMKLL"
    GGA_LMKLL_U = "GGA-LMKLL+U"
    GGA_DRSLL = "GGA-DRSLL"
    GGA_DRSLL_U = "GGA-DRSLL+U"
    GGA_D3 = "GGA-D3"
    GGA_D3_U = "GGA-D3+U"
    GGA_D2 = "GGA-D2"
    GGA_D2_U = "GGA-D2+U"
    GGA_D3_BJ = "GGA-D3(BJ)"
    GGA_D3_BJ_U = "GGA-D3(BJ)+U"
    R2SCAN = "R2SCAN"
    R2SCAN_U = "R2SCAN+U"
    R2SCAN_RVV10 = "R2SCAN-RVV10"
    R2SCAN_RVV10_U = "R2SCAN-RVV10+U"
    R2SCAN_LMKLL = "R2SCAN-LMKLL"
    R2SCAN_LMKLL_U = "R2SCAN-LMKLL+U"
    R2SCAN_DRSLL = "R2SCAN-DRSLL"
    R2SCAN_DRSLL_U = "R2SCAN-DRSLL+U"
    R2SCAN_D3 = "R2SCAN-D3"
    R2SCAN_D3_U = "R2SCAN-D3+U"
    R2SCAN_D2 = "R2SCAN-D2"
    R2SCAN_D2_U = "R2SCAN-D2+U"
    R2SCAN_D3_BJ = "R2SCAN-D3(BJ)"
    R2SCAN_D3_BJ_U = "R2SCAN-D3(BJ)+U"
    METAGGA = "METAGGA"
    METAGGA_U = "METAGGA+U"
    METAGGA_RVV10 = "METAGGA-RVV10"
    METAGGA_RVV10_U = "METAGGA-RVV10+U"
    METAGGA_LMKLL = "METAGGA-LMKLL"
    METAGGA_LMKLL_U = "METAGGA-LMKLL+U"
    METAGGA_DRSLL = "METAGGA-DRSLL"
    METAGGA_DRSLL_U = "METAGGA-DRSLL+U"
    METAGGA_D3 = "METAGGA-D3"
    METAGGA_D3_U = "METAGGA-D3+U"
    METAGGA_D2 = "METAGGA-D2"
    METAGGA_D2_U = "METAGGA-D2+U"
    METAGGA_D3_BJ = "METAGGA-D3(BJ)"
    METAGGA_D3_BJ_U = "METAGGA-D3(BJ)+U"
    HYBRID = "HYBRID"
    HYBRID_U = "HYBRID+U"
    HYBRID_RVV10 = "HYBRID-RVV10"
    HYBRID_RVV10_U = "HYBRID-RVV10+U"
    HYBRID_LMKLL = "HYBRID-LMKLL"
    HYBRID_LMKLL_U = "HYBRID-LMKLL+U"
    HYBRID_DRSLL = "HYBRID-DRSLL"
    HYBRID_DRSLL_U = "HYBRID-DRSLL+U"
    HYBRID_D3 = "HYBRID-D3"
    HYBRID_D3_U = "HYBRID-D3+U"
    HYBRID_D2 = "HYBRID-D2"
    HYBRID_D2_U = "HYBRID-D2+U"
    HYBRID_D3_BJ = "HYBRID-D3(BJ)"
    HYBRID_D3_BJ_U = "HYBRID-D3(BJ)+U"
    HSE06 = "HSE06"
    HSE06_U = "HSE06+U"
    HSE06_RVV10 = "HSE06-RVV10"
    HSE06_RVV10_U = "HSE06-RVV10+U"
    HSE06_LMKLL = "HSE06-LMKLL"
    HSE06_LMKLL_U = "HSE06-LMKLL+U"
    HSE06_DRSLL = "HSE06-DRSLL"
    HSE06_DRSLL_U = "HSE06-DRSLL+U"
    HSE06_D3 = "HSE06-D3"
    HSE06_D3_U = "HSE06-D3+U"
    HSE06_D2 = "HSE06-D2"
    HSE06_D2_U = "HSE06-D2+U"
    HSE06_D3_BJ = "HSE06-D3(BJ)"
    HSE06_D3_BJ_U = "HSE06-D3(BJ)+U"
    PBE0 = "PBE0"
    PBE0_U = "PBE0+U"
    PBE0_RVV10 = "PBE0-RVV10"
    PBE0_RVV10_U = "PBE0-RVV10+U"
    PBE0_LMKLL = "PBE0-LMKLL"
    PBE0_LMKLL_U = "PBE0-LMKLL+U"
    PBE0_DRSLL = "PBE0-DRSLL"
    PBE0_DRSLL_U = "PBE0-DRSLL+U"
    PBE0_D3 = "PBE0-D3"
    PBE0_D3_U = "PBE0-D3+U"
    PBE0_D2 = "PBE0-D2"
    PBE0_D2_U = "PBE0-D2+U"
    PBE0_D3_BJ = "PBE0-D3(BJ)"
    PBE0_D3_BJ_U = "PBE0-D3(BJ)+U"
    RSH = "RSH"
    RSH_U = "RSH+U"
    RSH_RVV10 = "RSH-RVV10"
    RSH_RVV10_U = "RSH-RVV10+U"
    RSH_LMKLL = "RSH-LMKLL"
    RSH_LMKLL_U = "RSH-LMKLL+U"
    RSH_DRSLL = "RSH-DRSLL"
    RSH_DRSLL_U = "RSH-DRSLL+U"
    RSH_D3 = "RSH-D3"
    RSH_D3_U = "RSH-D3+U"
    RSH_D2 = "RSH-D2"
    RSH_D2_U = "RSH-D2+U"
    RSH_D3_BJ = "RSH-D3(BJ)"
    RSH_D3_BJ_U = "RSH-D3(BJ)+U"


class TaskType(ValueEnum):
    """CP2K calculation task types."""

    Static = "Static"
    Structure_Optimization = "Structure Optimization"
    Constrained_Structure_Optimization = "Constrained Structure Optimization"
    Molecular_Dynamics = "Molecular Dynamics"
    NSCF_Line = "NSCF Line"
    NSCF_Uniform = "NSCF Uniform"
    Unrecognized = "Unrecognized"


class CalcType(ValueEnum):
    """CP2K calculation types."""

    PADE_Static = "PADE Static"
    PADE_Structure_Optimization = "PADE Structure Optimization"
    PADE_Constrained_Structure_Optimization = "PADE Constrained Structure Optimization"
    PADE_Molecular_Dynamics = "PADE Molecular Dynamics"
    PADE_NSCF_Line = "PADE NSCF Line"
    PADE_NSCF_Uniform = "PADE NSCF Uniform"
    PADE_Unrecognized = "PADE Unrecognized"
    PADE_U_Static = "PADE+U Static"
    PADE_U_Structure_Optimization = "PADE+U Structure Optimization"
    PADE_U_Constrained_Structure_Optimization = (
        "PADE+U Constrained Structure Optimization"
    )
    PADE_U_Molecular_Dynamics = "PADE+U Molecular Dynamics"
    PADE_U_NSCF_Line = "PADE+U NSCF Line"
    PADE_U_NSCF_Uniform = "PADE+U NSCF Uniform"
    PADE_U_Unrecognized = "PADE+U Unrecognized"
    PADE_RVV10_Static = "PADE-RVV10 Static"
    PADE_RVV10_Structure_Optimization = "PADE-RVV10 Structure Optimization"
    PADE_RVV10_Constrained_Structure_Optimization = (
        "PADE-RVV10 Constrained Structure Optimization"
    )
    PADE_RVV10_Molecular_Dynamics = "PADE-RVV10 Molecular Dynamics"
    PADE_RVV10_NSCF_Line = "PADE-RVV10 NSCF Line"
    PADE_RVV10_NSCF_Uniform = "PADE-RVV10 NSCF Uniform"
    PADE_RVV10_Unrecognized = "PADE-RVV10 Unrecognized"
    PADE_RVV10_U_Static = "PADE-RVV10+U Static"
    PADE_RVV10_U_Structure_Optimization = "PADE-RVV10+U Structure Optimization"
    PADE_RVV10_U_Constrained_Structure_Optimization = (
        "PADE-RVV10+U Constrained Structure Optimization"
    )
    PADE_RVV10_U_Molecular_Dynamics = "PADE-RVV10+U Molecular Dynamics"
    PADE_RVV10_U_NSCF_Line = "PADE-RVV10+U NSCF Line"
    PADE_RVV10_U_NSCF_Uniform = "PADE-RVV10+U NSCF Uniform"
    PADE_RVV10_U_Unrecognized = "PADE-RVV10+U Unrecognized"
    PADE_LMKLL_Static = "PADE-LMKLL Static"
    PADE_LMKLL_Structure_Optimization = "PADE-LMKLL Structure Optimization"
    PADE_LMKLL_Constrained_Structure_Optimization = (
        "PADE-LMKLL Constrained Structure Optimization"
    )
    PADE_LMKLL_Molecular_Dynamics = "PADE-LMKLL Molecular Dynamics"
    PADE_LMKLL_NSCF_Line = "PADE-LMKLL NSCF Line"
    PADE_LMKLL_NSCF_Uniform = "PADE-LMKLL NSCF Uniform"
    PADE_LMKLL_Unrecognized = "PADE-LMKLL Unrecognized"
    PADE_LMKLL_U_Static = "PADE-LMKLL+U Static"
    PADE_LMKLL_U_Structure_Optimization = "PADE-LMKLL+U Structure Optimization"
    PADE_LMKLL_U_Constrained_Structure_Optimization = (
        "PADE-LMKLL+U Constrained Structure Optimization"
    )
    PADE_LMKLL_U_Molecular_Dynamics = "PADE-LMKLL+U Molecular Dynamics"
    PADE_LMKLL_U_NSCF_Line = "PADE-LMKLL+U NSCF Line"
    PADE_LMKLL_U_NSCF_Uniform = "PADE-LMKLL+U NSCF Uniform"
    PADE_LMKLL_U_Unrecognized = "PADE-LMKLL+U Unrecognized"
    PADE_DRSLL_Static = "PADE-DRSLL Static"
    PADE_DRSLL_Structure_Optimization = "PADE-DRSLL Structure Optimization"
    PADE_DRSLL_Constrained_Structure_Optimization = (
        "PADE-DRSLL Constrained Structure Optimization"
    )
    PADE_DRSLL_Molecular_Dynamics = "PADE-DRSLL Molecular Dynamics"
    PADE_DRSLL_NSCF_Line = "PADE-DRSLL NSCF Line"
    PADE_DRSLL_NSCF_Uniform = "PADE-DRSLL NSCF Uniform"
    PADE_DRSLL_Unrecognized = "PADE-DRSLL Unrecognized"
    PADE_DRSLL_U_Static = "PADE-DRSLL+U Static"
    PADE_DRSLL_U_Structure_Optimization = "PADE-DRSLL+U Structure Optimization"
    PADE_DRSLL_U_Constrained_Structure_Optimization = (
        "PADE-DRSLL+U Constrained Structure Optimization"
    )
    PADE_DRSLL_U_Molecular_Dynamics = "PADE-DRSLL+U Molecular Dynamics"
    PADE_DRSLL_U_NSCF_Line = "PADE-DRSLL+U NSCF Line"
    PADE_DRSLL_U_NSCF_Uniform = "PADE-DRSLL+U NSCF Uniform"
    PADE_DRSLL_U_Unrecognized = "PADE-DRSLL+U Unrecognized"
    PADE_D3_Static = "PADE-D3 Static"
    PADE_D3_Structure_Optimization = "PADE-D3 Structure Optimization"
    PADE_D3_Constrained_Structure_Optimization = (
        "PADE-D3 Constrained Structure Optimization"
    )
    PADE_D3_Molecular_Dynamics = "PADE-D3 Molecular Dynamics"
    PADE_D3_NSCF_Line = "PADE-D3 NSCF Line"
    PADE_D3_NSCF_Uniform = "PADE-D3 NSCF Uniform"
    PADE_D3_Unrecognized = "PADE-D3 Unrecognized"
    PADE_D3_U_Static = "PADE-D3+U Static"
    PADE_D3_U_Structure_Optimization = "PADE-D3+U Structure Optimization"
    PADE_D3_U_Constrained_Structure_Optimization = (
        "PADE-D3+U Constrained Structure Optimization"
    )
    PADE_D3_U_Molecular_Dynamics = "PADE-D3+U Molecular Dynamics"
    PADE_D3_U_NSCF_Line = "PADE-D3+U NSCF Line"
    PADE_D3_U_NSCF_Uniform = "PADE-D3+U NSCF Uniform"
    PADE_D3_U_Unrecognized = "PADE-D3+U Unrecognized"
    PADE_D2_Static = "PADE-D2 Static"
    PADE_D2_Structure_Optimization = "PADE-D2 Structure Optimization"
    PADE_D2_Constrained_Structure_Optimization = (
        "PADE-D2 Constrained Structure Optimization"
    )
    PADE_D2_Molecular_Dynamics = "PADE-D2 Molecular Dynamics"
    PADE_D2_NSCF_Line = "PADE-D2 NSCF Line"
    PADE_D2_NSCF_Uniform = "PADE-D2 NSCF Uniform"
    PADE_D2_Unrecognized = "PADE-D2 Unrecognized"
    PADE_D2_U_Static = "PADE-D2+U Static"
    PADE_D2_U_Structure_Optimization = "PADE-D2+U Structure Optimization"
    PADE_D2_U_Constrained_Structure_Optimization = (
        "PADE-D2+U Constrained Structure Optimization"
    )
    PADE_D2_U_Molecular_Dynamics = "PADE-D2+U Molecular Dynamics"
    PADE_D2_U_NSCF_Line = "PADE-D2+U NSCF Line"
    PADE_D2_U_NSCF_Uniform = "PADE-D2+U NSCF Uniform"
    PADE_D2_U_Unrecognized = "PADE-D2+U Unrecognized"
    PADE_D3_BJ_Static = "PADE-D3(BJ) Static"
    PADE_D3_BJ_Structure_Optimization = "PADE-D3(BJ) Structure Optimization"
    PADE_D3_BJ_Constrained_Structure_Optimization = (
        "PADE-D3(BJ) Constrained Structure Optimization"
    )
    PADE_D3_BJ_Molecular_Dynamics = "PADE-D3(BJ) Molecular Dynamics"
    PADE_D3_BJ_NSCF_Line = "PADE-D3(BJ) NSCF Line"
    PADE_D3_BJ_NSCF_Uniform = "PADE-D3(BJ) NSCF Uniform"
    PADE_D3_BJ_Unrecognized = "PADE-D3(BJ) Unrecognized"
    PADE_D3_BJ_U_Static = "PADE-D3(BJ)+U Static"
    PADE_D3_BJ_U_Structure_Optimization = "PADE-D3(BJ)+U Structure Optimization"
    PADE_D3_BJ_U_Constrained_Structure_Optimization = (
        "PADE-D3(BJ)+U Constrained Structure Optimization"
    )
    PADE_D3_BJ_U_Molecular_Dynamics = "PADE-D3(BJ)+U Molecular Dynamics"
    PADE_D3_BJ_U_NSCF_Line = "PADE-D3(BJ)+U NSCF Line"
    PADE_D3_BJ_U_NSCF_Uniform = "PADE-D3(BJ)+U NSCF Uniform"
    PADE_D3_BJ_U_Unrecognized = "PADE-D3(BJ)+U Unrecognized"
    PBE_Static = "PBE Static"
    PBE_Structure_Optimization = "PBE Structure Optimization"
    PBE_Constrained_Structure_Optimization = "PBE Constrained Structure Optimization"
    PBE_Molecular_Dynamics = "PBE Molecular Dynamics"
    PBE_NSCF_Line = "PBE NSCF Line"
    PBE_NSCF_Uniform = "PBE NSCF Uniform"
    PBE_Unrecognized = "PBE Unrecognized"
    PBE_U_Static = "PBE+U Static"
    PBE_U_Structure_Optimization = "PBE+U Structure Optimization"
    PBE_U_Constrained_Structure_Optimization = (
        "PBE+U Constrained Structure Optimization"
    )
    PBE_U_Molecular_Dynamics = "PBE+U Molecular Dynamics"
    PBE_U_NSCF_Line = "PBE+U NSCF Line"
    PBE_U_NSCF_Uniform = "PBE+U NSCF Uniform"
    PBE_U_Unrecognized = "PBE+U Unrecognized"
    PBE_RVV10_Static = "PBE-RVV10 Static"
    PBE_RVV10_Structure_Optimization = "PBE-RVV10 Structure Optimization"
    PBE_RVV10_Constrained_Structure_Optimization = (
        "PBE-RVV10 Constrained Structure Optimization"
    )
    PBE_RVV10_Molecular_Dynamics = "PBE-RVV10 Molecular Dynamics"
    PBE_RVV10_NSCF_Line = "PBE-RVV10 NSCF Line"
    PBE_RVV10_NSCF_Uniform = "PBE-RVV10 NSCF Uniform"
    PBE_RVV10_Unrecognized = "PBE-RVV10 Unrecognized"
    PBE_RVV10_U_Static = "PBE-RVV10+U Static"
    PBE_RVV10_U_Structure_Optimization = "PBE-RVV10+U Structure Optimization"
    PBE_RVV10_U_Constrained_Structure_Optimization = (
        "PBE-RVV10+U Constrained Structure Optimization"
    )
    PBE_RVV10_U_Molecular_Dynamics = "PBE-RVV10+U Molecular Dynamics"
    PBE_RVV10_U_NSCF_Line = "PBE-RVV10+U NSCF Line"
    PBE_RVV10_U_NSCF_Uniform = "PBE-RVV10+U NSCF Uniform"
    PBE_RVV10_U_Unrecognized = "PBE-RVV10+U Unrecognized"
    PBE_LMKLL_Static = "PBE-LMKLL Static"
    PBE_LMKLL_Structure_Optimization = "PBE-LMKLL Structure Optimization"
    PBE_LMKLL_Constrained_Structure_Optimization = (
        "PBE-LMKLL Constrained Structure Optimization"
    )
    PBE_LMKLL_Molecular_Dynamics = "PBE-LMKLL Molecular Dynamics"
    PBE_LMKLL_NSCF_Line = "PBE-LMKLL NSCF Line"
    PBE_LMKLL_NSCF_Uniform = "PBE-LMKLL NSCF Uniform"
    PBE_LMKLL_Unrecognized = "PBE-LMKLL Unrecognized"
    PBE_LMKLL_U_Static = "PBE-LMKLL+U Static"
    PBE_LMKLL_U_Structure_Optimization = "PBE-LMKLL+U Structure Optimization"
    PBE_LMKLL_U_Constrained_Structure_Optimization = (
        "PBE-LMKLL+U Constrained Structure Optimization"
    )
    PBE_LMKLL_U_Molecular_Dynamics = "PBE-LMKLL+U Molecular Dynamics"
    PBE_LMKLL_U_NSCF_Line = "PBE-LMKLL+U NSCF Line"
    PBE_LMKLL_U_NSCF_Uniform = "PBE-LMKLL+U NSCF Uniform"
    PBE_LMKLL_U_Unrecognized = "PBE-LMKLL+U Unrecognized"
    PBE_DRSLL_Static = "PBE-DRSLL Static"
    PBE_DRSLL_Structure_Optimization = "PBE-DRSLL Structure Optimization"
    PBE_DRSLL_Constrained_Structure_Optimization = (
        "PBE-DRSLL Constrained Structure Optimization"
    )
    PBE_DRSLL_Molecular_Dynamics = "PBE-DRSLL Molecular Dynamics"
    PBE_DRSLL_NSCF_Line = "PBE-DRSLL NSCF Line"
    PBE_DRSLL_NSCF_Uniform = "PBE-DRSLL NSCF Uniform"
    PBE_DRSLL_Unrecognized = "PBE-DRSLL Unrecognized"
    PBE_DRSLL_U_Static = "PBE-DRSLL+U Static"
    PBE_DRSLL_U_Structure_Optimization = "PBE-DRSLL+U Structure Optimization"
    PBE_DRSLL_U_Constrained_Structure_Optimization = (
        "PBE-DRSLL+U Constrained Structure Optimization"
    )
    PBE_DRSLL_U_Molecular_Dynamics = "PBE-DRSLL+U Molecular Dynamics"
    PBE_DRSLL_U_NSCF_Line = "PBE-DRSLL+U NSCF Line"
    PBE_DRSLL_U_NSCF_Uniform = "PBE-DRSLL+U NSCF Uniform"
    PBE_DRSLL_U_Unrecognized = "PBE-DRSLL+U Unrecognized"
    PBE_D3_Static = "PBE-D3 Static"
    PBE_D3_Structure_Optimization = "PBE-D3 Structure Optimization"
    PBE_D3_Constrained_Structure_Optimization = (
        "PBE-D3 Constrained Structure Optimization"
    )
    PBE_D3_Molecular_Dynamics = "PBE-D3 Molecular Dynamics"
    PBE_D3_NSCF_Line = "PBE-D3 NSCF Line"
    PBE_D3_NSCF_Uniform = "PBE-D3 NSCF Uniform"
    PBE_D3_Unrecognized = "PBE-D3 Unrecognized"
    PBE_D3_U_Static = "PBE-D3+U Static"
    PBE_D3_U_Structure_Optimization = "PBE-D3+U Structure Optimization"
    PBE_D3_U_Constrained_Structure_Optimization = (
        "PBE-D3+U Constrained Structure Optimization"
    )
    PBE_D3_U_Molecular_Dynamics = "PBE-D3+U Molecular Dynamics"
    PBE_D3_U_NSCF_Line = "PBE-D3+U NSCF Line"
    PBE_D3_U_NSCF_Uniform = "PBE-D3+U NSCF Uniform"
    PBE_D3_U_Unrecognized = "PBE-D3+U Unrecognized"
    PBE_D2_Static = "PBE-D2 Static"
    PBE_D2_Structure_Optimization = "PBE-D2 Structure Optimization"
    PBE_D2_Constrained_Structure_Optimization = (
        "PBE-D2 Constrained Structure Optimization"
    )
    PBE_D2_Molecular_Dynamics = "PBE-D2 Molecular Dynamics"
    PBE_D2_NSCF_Line = "PBE-D2 NSCF Line"
    PBE_D2_NSCF_Uniform = "PBE-D2 NSCF Uniform"
    PBE_D2_Unrecognized = "PBE-D2 Unrecognized"
    PBE_D2_U_Static = "PBE-D2+U Static"
    PBE_D2_U_Structure_Optimization = "PBE-D2+U Structure Optimization"
    PBE_D2_U_Constrained_Structure_Optimization = (
        "PBE-D2+U Constrained Structure Optimization"
    )
    PBE_D2_U_Molecular_Dynamics = "PBE-D2+U Molecular Dynamics"
    PBE_D2_U_NSCF_Line = "PBE-D2+U NSCF Line"
    PBE_D2_U_NSCF_Uniform = "PBE-D2+U NSCF Uniform"
    PBE_D2_U_Unrecognized = "PBE-D2+U Unrecognized"
    PBE_D3_BJ_Static = "PBE-D3(BJ) Static"
    PBE_D3_BJ_Structure_Optimization = "PBE-D3(BJ) Structure Optimization"
    PBE_D3_BJ_Constrained_Structure_Optimization = (
        "PBE-D3(BJ) Constrained Structure Optimization"
    )
    PBE_D3_BJ_Molecular_Dynamics = "PBE-D3(BJ) Molecular Dynamics"
    PBE_D3_BJ_NSCF_Line = "PBE-D3(BJ) NSCF Line"
    PBE_D3_BJ_NSCF_Uniform = "PBE-D3(BJ) NSCF Uniform"
    PBE_D3_BJ_Unrecognized = "PBE-D3(BJ) Unrecognized"
    PBE_D3_BJ_U_Static = "PBE-D3(BJ)+U Static"
    PBE_D3_BJ_U_Structure_Optimization = "PBE-D3(BJ)+U Structure Optimization"
    PBE_D3_BJ_U_Constrained_Structure_Optimization = (
        "PBE-D3(BJ)+U Constrained Structure Optimization"
    )
    PBE_D3_BJ_U_Molecular_Dynamics = "PBE-D3(BJ)+U Molecular Dynamics"
    PBE_D3_BJ_U_NSCF_Line = "PBE-D3(BJ)+U NSCF Line"
    PBE_D3_BJ_U_NSCF_Uniform = "PBE-D3(BJ)+U NSCF Uniform"
    PBE_D3_BJ_U_Unrecognized = "PBE-D3(BJ)+U Unrecognized"
    PBEsol_Static = "PBEsol Static"
    PBEsol_Structure_Optimization = "PBEsol Structure Optimization"
    PBEsol_Constrained_Structure_Optimization = (
        "PBEsol Constrained Structure Optimization"
    )
    PBEsol_Molecular_Dynamics = "PBEsol Molecular Dynamics"
    PBEsol_NSCF_Line = "PBEsol NSCF Line"
    PBEsol_NSCF_Uniform = "PBEsol NSCF Uniform"
    PBEsol_Unrecognized = "PBEsol Unrecognized"
    PBEsol_U_Static = "PBEsol+U Static"
    PBEsol_U_Structure_Optimization = "PBEsol+U Structure Optimization"
    PBEsol_U_Constrained_Structure_Optimization = (
        "PBEsol+U Constrained Structure Optimization"
    )
    PBEsol_U_Molecular_Dynamics = "PBEsol+U Molecular Dynamics"
    PBEsol_U_NSCF_Line = "PBEsol+U NSCF Line"
    PBEsol_U_NSCF_Uniform = "PBEsol+U NSCF Uniform"
    PBEsol_U_Unrecognized = "PBEsol+U Unrecognized"
    PBEsol_RVV10_Static = "PBEsol-RVV10 Static"
    PBEsol_RVV10_Structure_Optimization = "PBEsol-RVV10 Structure Optimization"
    PBEsol_RVV10_Constrained_Structure_Optimization = (
        "PBEsol-RVV10 Constrained Structure Optimization"
    )
    PBEsol_RVV10_Molecular_Dynamics = "PBEsol-RVV10 Molecular Dynamics"
    PBEsol_RVV10_NSCF_Line = "PBEsol-RVV10 NSCF Line"
    PBEsol_RVV10_NSCF_Uniform = "PBEsol-RVV10 NSCF Uniform"
    PBEsol_RVV10_Unrecognized = "PBEsol-RVV10 Unrecognized"
    PBEsol_RVV10_U_Static = "PBEsol-RVV10+U Static"
    PBEsol_RVV10_U_Structure_Optimization = "PBEsol-RVV10+U Structure Optimization"
    PBEsol_RVV10_U_Constrained_Structure_Optimization = (
        "PBEsol-RVV10+U Constrained Structure Optimization"
    )
    PBEsol_RVV10_U_Molecular_Dynamics = "PBEsol-RVV10+U Molecular Dynamics"
    PBEsol_RVV10_U_NSCF_Line = "PBEsol-RVV10+U NSCF Line"
    PBEsol_RVV10_U_NSCF_Uniform = "PBEsol-RVV10+U NSCF Uniform"
    PBEsol_RVV10_U_Unrecognized = "PBEsol-RVV10+U Unrecognized"
    PBEsol_LMKLL_Static = "PBEsol-LMKLL Static"
    PBEsol_LMKLL_Structure_Optimization = "PBEsol-LMKLL Structure Optimization"
    PBEsol_LMKLL_Constrained_Structure_Optimization = (
        "PBEsol-LMKLL Constrained Structure Optimization"
    )
    PBEsol_LMKLL_Molecular_Dynamics = "PBEsol-LMKLL Molecular Dynamics"
    PBEsol_LMKLL_NSCF_Line = "PBEsol-LMKLL NSCF Line"
    PBEsol_LMKLL_NSCF_Uniform = "PBEsol-LMKLL NSCF Uniform"
    PBEsol_LMKLL_Unrecognized = "PBEsol-LMKLL Unrecognized"
    PBEsol_LMKLL_U_Static = "PBEsol-LMKLL+U Static"
    PBEsol_LMKLL_U_Structure_Optimization = "PBEsol-LMKLL+U Structure Optimization"
    PBEsol_LMKLL_U_Constrained_Structure_Optimization = (
        "PBEsol-LMKLL+U Constrained Structure Optimization"
    )
    PBEsol_LMKLL_U_Molecular_Dynamics = "PBEsol-LMKLL+U Molecular Dynamics"
    PBEsol_LMKLL_U_NSCF_Line = "PBEsol-LMKLL+U NSCF Line"
    PBEsol_LMKLL_U_NSCF_Uniform = "PBEsol-LMKLL+U NSCF Uniform"
    PBEsol_LMKLL_U_Unrecognized = "PBEsol-LMKLL+U Unrecognized"
    PBEsol_DRSLL_Static = "PBEsol-DRSLL Static"
    PBEsol_DRSLL_Structure_Optimization = "PBEsol-DRSLL Structure Optimization"
    PBEsol_DRSLL_Constrained_Structure_Optimization = (
        "PBEsol-DRSLL Constrained Structure Optimization"
    )
    PBEsol_DRSLL_Molecular_Dynamics = "PBEsol-DRSLL Molecular Dynamics"
    PBEsol_DRSLL_NSCF_Line = "PBEsol-DRSLL NSCF Line"
    PBEsol_DRSLL_NSCF_Uniform = "PBEsol-DRSLL NSCF Uniform"
    PBEsol_DRSLL_Unrecognized = "PBEsol-DRSLL Unrecognized"
    PBEsol_DRSLL_U_Static = "PBEsol-DRSLL+U Static"
    PBEsol_DRSLL_U_Structure_Optimization = "PBEsol-DRSLL+U Structure Optimization"
    PBEsol_DRSLL_U_Constrained_Structure_Optimization = (
        "PBEsol-DRSLL+U Constrained Structure Optimization"
    )
    PBEsol_DRSLL_U_Molecular_Dynamics = "PBEsol-DRSLL+U Molecular Dynamics"
    PBEsol_DRSLL_U_NSCF_Line = "PBEsol-DRSLL+U NSCF Line"
    PBEsol_DRSLL_U_NSCF_Uniform = "PBEsol-DRSLL+U NSCF Uniform"
    PBEsol_DRSLL_U_Unrecognized = "PBEsol-DRSLL+U Unrecognized"
    PBEsol_D3_Static = "PBEsol-D3 Static"
    PBEsol_D3_Structure_Optimization = "PBEsol-D3 Structure Optimization"
    PBEsol_D3_Constrained_Structure_Optimization = (
        "PBEsol-D3 Constrained Structure Optimization"
    )
    PBEsol_D3_Molecular_Dynamics = "PBEsol-D3 Molecular Dynamics"
    PBEsol_D3_NSCF_Line = "PBEsol-D3 NSCF Line"
    PBEsol_D3_NSCF_Uniform = "PBEsol-D3 NSCF Uniform"
    PBEsol_D3_Unrecognized = "PBEsol-D3 Unrecognized"
    PBEsol_D3_U_Static = "PBEsol-D3+U Static"
    PBEsol_D3_U_Structure_Optimization = "PBEsol-D3+U Structure Optimization"
    PBEsol_D3_U_Constrained_Structure_Optimization = (
        "PBEsol-D3+U Constrained Structure Optimization"
    )
    PBEsol_D3_U_Molecular_Dynamics = "PBEsol-D3+U Molecular Dynamics"
    PBEsol_D3_U_NSCF_Line = "PBEsol-D3+U NSCF Line"
    PBEsol_D3_U_NSCF_Uniform = "PBEsol-D3+U NSCF Uniform"
    PBEsol_D3_U_Unrecognized = "PBEsol-D3+U Unrecognized"
    PBEsol_D2_Static = "PBEsol-D2 Static"
    PBEsol_D2_Structure_Optimization = "PBEsol-D2 Structure Optimization"
    PBEsol_D2_Constrained_Structure_Optimization = (
        "PBEsol-D2 Constrained Structure Optimization"
    )
    PBEsol_D2_Molecular_Dynamics = "PBEsol-D2 Molecular Dynamics"
    PBEsol_D2_NSCF_Line = "PBEsol-D2 NSCF Line"
    PBEsol_D2_NSCF_Uniform = "PBEsol-D2 NSCF Uniform"
    PBEsol_D2_Unrecognized = "PBEsol-D2 Unrecognized"
    PBEsol_D2_U_Static = "PBEsol-D2+U Static"
    PBEsol_D2_U_Structure_Optimization = "PBEsol-D2+U Structure Optimization"
    PBEsol_D2_U_Constrained_Structure_Optimization = (
        "PBEsol-D2+U Constrained Structure Optimization"
    )
    PBEsol_D2_U_Molecular_Dynamics = "PBEsol-D2+U Molecular Dynamics"
    PBEsol_D2_U_NSCF_Line = "PBEsol-D2+U NSCF Line"
    PBEsol_D2_U_NSCF_Uniform = "PBEsol-D2+U NSCF Uniform"
    PBEsol_D2_U_Unrecognized = "PBEsol-D2+U Unrecognized"
    PBEsol_D3_BJ_Static = "PBEsol-D3(BJ) Static"
    PBEsol_D3_BJ_Structure_Optimization = "PBEsol-D3(BJ) Structure Optimization"
    PBEsol_D3_BJ_Constrained_Structure_Optimization = (
        "PBEsol-D3(BJ) Constrained Structure Optimization"
    )
    PBEsol_D3_BJ_Molecular_Dynamics = "PBEsol-D3(BJ) Molecular Dynamics"
    PBEsol_D3_BJ_NSCF_Line = "PBEsol-D3(BJ) NSCF Line"
    PBEsol_D3_BJ_NSCF_Uniform = "PBEsol-D3(BJ) NSCF Uniform"
    PBEsol_D3_BJ_Unrecognized = "PBEsol-D3(BJ) Unrecognized"
    PBEsol_D3_BJ_U_Static = "PBEsol-D3(BJ)+U Static"
    PBEsol_D3_BJ_U_Structure_Optimization = "PBEsol-D3(BJ)+U Structure Optimization"
    PBEsol_D3_BJ_U_Constrained_Structure_Optimization = (
        "PBEsol-D3(BJ)+U Constrained Structure Optimization"
    )
    PBEsol_D3_BJ_U_Molecular_Dynamics = "PBEsol-D3(BJ)+U Molecular Dynamics"
    PBEsol_D3_BJ_U_NSCF_Line = "PBEsol-D3(BJ)+U NSCF Line"
    PBEsol_D3_BJ_U_NSCF_Uniform = "PBEsol-D3(BJ)+U NSCF Uniform"
    PBEsol_D3_BJ_U_Unrecognized = "PBEsol-D3(BJ)+U Unrecognized"
    GGA_Static = "GGA Static"
    GGA_Structure_Optimization = "GGA Structure Optimization"
    GGA_Constrained_Structure_Optimization = "GGA Constrained Structure Optimization"
    GGA_Molecular_Dynamics = "GGA Molecular Dynamics"
    GGA_NSCF_Line = "GGA NSCF Line"
    GGA_NSCF_Uniform = "GGA NSCF Uniform"
    GGA_Unrecognized = "GGA Unrecognized"
    GGA_U_Static = "GGA+U Static"
    GGA_U_Structure_Optimization = "GGA+U Structure Optimization"
    GGA_U_Constrained_Structure_Optimization = (
        "GGA+U Constrained Structure Optimization"
    )
    GGA_U_Molecular_Dynamics = "GGA+U Molecular Dynamics"
    GGA_U_NSCF_Line = "GGA+U NSCF Line"
    GGA_U_NSCF_Uniform = "GGA+U NSCF Uniform"
    GGA_U_Unrecognized = "GGA+U Unrecognized"
    GGA_RVV10_Static = "GGA-RVV10 Static"
    GGA_RVV10_Structure_Optimization = "GGA-RVV10 Structure Optimization"
    GGA_RVV10_Constrained_Structure_Optimization = (
        "GGA-RVV10 Constrained Structure Optimization"
    )
    GGA_RVV10_Molecular_Dynamics = "GGA-RVV10 Molecular Dynamics"
    GGA_RVV10_NSCF_Line = "GGA-RVV10 NSCF Line"
    GGA_RVV10_NSCF_Uniform = "GGA-RVV10 NSCF Uniform"
    GGA_RVV10_Unrecognized = "GGA-RVV10 Unrecognized"
    GGA_RVV10_U_Static = "GGA-RVV10+U Static"
    GGA_RVV10_U_Structure_Optimization = "GGA-RVV10+U Structure Optimization"
    GGA_RVV10_U_Constrained_Structure_Optimization = (
        "GGA-RVV10+U Constrained Structure Optimization"
    )
    GGA_RVV10_U_Molecular_Dynamics = "GGA-RVV10+U Molecular Dynamics"
    GGA_RVV10_U_NSCF_Line = "GGA-RVV10+U NSCF Line"
    GGA_RVV10_U_NSCF_Uniform = "GGA-RVV10+U NSCF Uniform"
    GGA_RVV10_U_Unrecognized = "GGA-RVV10+U Unrecognized"
    GGA_LMKLL_Static = "GGA-LMKLL Static"
    GGA_LMKLL_Structure_Optimization = "GGA-LMKLL Structure Optimization"
    GGA_LMKLL_Constrained_Structure_Optimization = (
        "GGA-LMKLL Constrained Structure Optimization"
    )
    GGA_LMKLL_Molecular_Dynamics = "GGA-LMKLL Molecular Dynamics"
    GGA_LMKLL_NSCF_Line = "GGA-LMKLL NSCF Line"
    GGA_LMKLL_NSCF_Uniform = "GGA-LMKLL NSCF Uniform"
    GGA_LMKLL_Unrecognized = "GGA-LMKLL Unrecognized"
    GGA_LMKLL_U_Static = "GGA-LMKLL+U Static"
    GGA_LMKLL_U_Structure_Optimization = "GGA-LMKLL+U Structure Optimization"
    GGA_LMKLL_U_Constrained_Structure_Optimization = (
        "GGA-LMKLL+U Constrained Structure Optimization"
    )
    GGA_LMKLL_U_Molecular_Dynamics = "GGA-LMKLL+U Molecular Dynamics"
    GGA_LMKLL_U_NSCF_Line = "GGA-LMKLL+U NSCF Line"
    GGA_LMKLL_U_NSCF_Uniform = "GGA-LMKLL+U NSCF Uniform"
    GGA_LMKLL_U_Unrecognized = "GGA-LMKLL+U Unrecognized"
    GGA_DRSLL_Static = "GGA-DRSLL Static"
    GGA_DRSLL_Structure_Optimization = "GGA-DRSLL Structure Optimization"
    GGA_DRSLL_Constrained_Structure_Optimization = (
        "GGA-DRSLL Constrained Structure Optimization"
    )
    GGA_DRSLL_Molecular_Dynamics = "GGA-DRSLL Molecular Dynamics"
    GGA_DRSLL_NSCF_Line = "GGA-DRSLL NSCF Line"
    GGA_DRSLL_NSCF_Uniform = "GGA-DRSLL NSCF Uniform"
    GGA_DRSLL_Unrecognized = "GGA-DRSLL Unrecognized"
    GGA_DRSLL_U_Static = "GGA-DRSLL+U Static"
    GGA_DRSLL_U_Structure_Optimization = "GGA-DRSLL+U Structure Optimization"
    GGA_DRSLL_U_Constrained_Structure_Optimization = (
        "GGA-DRSLL+U Constrained Structure Optimization"
    )
    GGA_DRSLL_U_Molecular_Dynamics = "GGA-DRSLL+U Molecular Dynamics"
    GGA_DRSLL_U_NSCF_Line = "GGA-DRSLL+U NSCF Line"
    GGA_DRSLL_U_NSCF_Uniform = "GGA-DRSLL+U NSCF Uniform"
    GGA_DRSLL_U_Unrecognized = "GGA-DRSLL+U Unrecognized"
    GGA_D3_Static = "GGA-D3 Static"
    GGA_D3_Structure_Optimization = "GGA-D3 Structure Optimization"
    GGA_D3_Constrained_Structure_Optimization = (
        "GGA-D3 Constrained Structure Optimization"
    )
    GGA_D3_Molecular_Dynamics = "GGA-D3 Molecular Dynamics"
    GGA_D3_NSCF_Line = "GGA-D3 NSCF Line"
    GGA_D3_NSCF_Uniform = "GGA-D3 NSCF Uniform"
    GGA_D3_Unrecognized = "GGA-D3 Unrecognized"
    GGA_D3_U_Static = "GGA-D3+U Static"
    GGA_D3_U_Structure_Optimization = "GGA-D3+U Structure Optimization"
    GGA_D3_U_Constrained_Structure_Optimization = (
        "GGA-D3+U Constrained Structure Optimization"
    )
    GGA_D3_U_Molecular_Dynamics = "GGA-D3+U Molecular Dynamics"
    GGA_D3_U_NSCF_Line = "GGA-D3+U NSCF Line"
    GGA_D3_U_NSCF_Uniform = "GGA-D3+U NSCF Uniform"
    GGA_D3_U_Unrecognized = "GGA-D3+U Unrecognized"
    GGA_D2_Static = "GGA-D2 Static"
    GGA_D2_Structure_Optimization = "GGA-D2 Structure Optimization"
    GGA_D2_Constrained_Structure_Optimization = (
        "GGA-D2 Constrained Structure Optimization"
    )
    GGA_D2_Molecular_Dynamics = "GGA-D2 Molecular Dynamics"
    GGA_D2_NSCF_Line = "GGA-D2 NSCF Line"
    GGA_D2_NSCF_Uniform = "GGA-D2 NSCF Uniform"
    GGA_D2_Unrecognized = "GGA-D2 Unrecognized"
    GGA_D2_U_Static = "GGA-D2+U Static"
    GGA_D2_U_Structure_Optimization = "GGA-D2+U Structure Optimization"
    GGA_D2_U_Constrained_Structure_Optimization = (
        "GGA-D2+U Constrained Structure Optimization"
    )
    GGA_D2_U_Molecular_Dynamics = "GGA-D2+U Molecular Dynamics"
    GGA_D2_U_NSCF_Line = "GGA-D2+U NSCF Line"
    GGA_D2_U_NSCF_Uniform = "GGA-D2+U NSCF Uniform"
    GGA_D2_U_Unrecognized = "GGA-D2+U Unrecognized"
    GGA_D3_BJ_Static = "GGA-D3(BJ) Static"
    GGA_D3_BJ_Structure_Optimization = "GGA-D3(BJ) Structure Optimization"
    GGA_D3_BJ_Constrained_Structure_Optimization = (
        "GGA-D3(BJ) Constrained Structure Optimization"
    )
    GGA_D3_BJ_Molecular_Dynamics = "GGA-D3(BJ) Molecular Dynamics"
    GGA_D3_BJ_NSCF_Line = "GGA-D3(BJ) NSCF Line"
    GGA_D3_BJ_NSCF_Uniform = "GGA-D3(BJ) NSCF Uniform"
    GGA_D3_BJ_Unrecognized = "GGA-D3(BJ) Unrecognized"
    GGA_D3_BJ_U_Static = "GGA-D3(BJ)+U Static"
    GGA_D3_BJ_U_Structure_Optimization = "GGA-D3(BJ)+U Structure Optimization"
    GGA_D3_BJ_U_Constrained_Structure_Optimization = (
        "GGA-D3(BJ)+U Constrained Structure Optimization"
    )
    GGA_D3_BJ_U_Molecular_Dynamics = "GGA-D3(BJ)+U Molecular Dynamics"
    GGA_D3_BJ_U_NSCF_Line = "GGA-D3(BJ)+U NSCF Line"
    GGA_D3_BJ_U_NSCF_Uniform = "GGA-D3(BJ)+U NSCF Uniform"
    GGA_D3_BJ_U_Unrecognized = "GGA-D3(BJ)+U Unrecognized"
    R2SCAN_Static = "R2SCAN Static"
    R2SCAN_Structure_Optimization = "R2SCAN Structure Optimization"
    R2SCAN_Constrained_Structure_Optimization = (
        "R2SCAN Constrained Structure Optimization"
    )
    R2SCAN_Molecular_Dynamics = "R2SCAN Molecular Dynamics"
    R2SCAN_NSCF_Line = "R2SCAN NSCF Line"
    R2SCAN_NSCF_Uniform = "R2SCAN NSCF Uniform"
    R2SCAN_Unrecognized = "R2SCAN Unrecognized"
    R2SCAN_U_Static = "R2SCAN+U Static"
    R2SCAN_U_Structure_Optimization = "R2SCAN+U Structure Optimization"
    R2SCAN_U_Constrained_Structure_Optimization = (
        "R2SCAN+U Constrained Structure Optimization"
    )
    R2SCAN_U_Molecular_Dynamics = "R2SCAN+U Molecular Dynamics"
    R2SCAN_U_NSCF_Line = "R2SCAN+U NSCF Line"
    R2SCAN_U_NSCF_Uniform = "R2SCAN+U NSCF Uniform"
    R2SCAN_U_Unrecognized = "R2SCAN+U Unrecognized"
    R2SCAN_RVV10_Static = "R2SCAN-RVV10 Static"
    R2SCAN_RVV10_Structure_Optimization = "R2SCAN-RVV10 Structure Optimization"
    R2SCAN_RVV10_Constrained_Structure_Optimization = (
        "R2SCAN-RVV10 Constrained Structure Optimization"
    )
    R2SCAN_RVV10_Molecular_Dynamics = "R2SCAN-RVV10 Molecular Dynamics"
    R2SCAN_RVV10_NSCF_Line = "R2SCAN-RVV10 NSCF Line"
    R2SCAN_RVV10_NSCF_Uniform = "R2SCAN-RVV10 NSCF Uniform"
    R2SCAN_RVV10_Unrecognized = "R2SCAN-RVV10 Unrecognized"
    R2SCAN_RVV10_U_Static = "R2SCAN-RVV10+U Static"
    R2SCAN_RVV10_U_Structure_Optimization = "R2SCAN-RVV10+U Structure Optimization"
    R2SCAN_RVV10_U_Constrained_Structure_Optimization = (
        "R2SCAN-RVV10+U Constrained Structure Optimization"
    )
    R2SCAN_RVV10_U_Molecular_Dynamics = "R2SCAN-RVV10+U Molecular Dynamics"
    R2SCAN_RVV10_U_NSCF_Line = "R2SCAN-RVV10+U NSCF Line"
    R2SCAN_RVV10_U_NSCF_Uniform = "R2SCAN-RVV10+U NSCF Uniform"
    R2SCAN_RVV10_U_Unrecognized = "R2SCAN-RVV10+U Unrecognized"
    R2SCAN_LMKLL_Static = "R2SCAN-LMKLL Static"
    R2SCAN_LMKLL_Structure_Optimization = "R2SCAN-LMKLL Structure Optimization"
    R2SCAN_LMKLL_Constrained_Structure_Optimization = (
        "R2SCAN-LMKLL Constrained Structure Optimization"
    )
    R2SCAN_LMKLL_Molecular_Dynamics = "R2SCAN-LMKLL Molecular Dynamics"
    R2SCAN_LMKLL_NSCF_Line = "R2SCAN-LMKLL NSCF Line"
    R2SCAN_LMKLL_NSCF_Uniform = "R2SCAN-LMKLL NSCF Uniform"
    R2SCAN_LMKLL_Unrecognized = "R2SCAN-LMKLL Unrecognized"
    R2SCAN_LMKLL_U_Static = "R2SCAN-LMKLL+U Static"
    R2SCAN_LMKLL_U_Structure_Optimization = "R2SCAN-LMKLL+U Structure Optimization"
    R2SCAN_LMKLL_U_Constrained_Structure_Optimization = (
        "R2SCAN-LMKLL+U Constrained Structure Optimization"
    )
    R2SCAN_LMKLL_U_Molecular_Dynamics = "R2SCAN-LMKLL+U Molecular Dynamics"
    R2SCAN_LMKLL_U_NSCF_Line = "R2SCAN-LMKLL+U NSCF Line"
    R2SCAN_LMKLL_U_NSCF_Uniform = "R2SCAN-LMKLL+U NSCF Uniform"
    R2SCAN_LMKLL_U_Unrecognized = "R2SCAN-LMKLL+U Unrecognized"
    R2SCAN_DRSLL_Static = "R2SCAN-DRSLL Static"
    R2SCAN_DRSLL_Structure_Optimization = "R2SCAN-DRSLL Structure Optimization"
    R2SCAN_DRSLL_Constrained_Structure_Optimization = (
        "R2SCAN-DRSLL Constrained Structure Optimization"
    )
    R2SCAN_DRSLL_Molecular_Dynamics = "R2SCAN-DRSLL Molecular Dynamics"
    R2SCAN_DRSLL_NSCF_Line = "R2SCAN-DRSLL NSCF Line"
    R2SCAN_DRSLL_NSCF_Uniform = "R2SCAN-DRSLL NSCF Uniform"
    R2SCAN_DRSLL_Unrecognized = "R2SCAN-DRSLL Unrecognized"
    R2SCAN_DRSLL_U_Static = "R2SCAN-DRSLL+U Static"
    R2SCAN_DRSLL_U_Structure_Optimization = "R2SCAN-DRSLL+U Structure Optimization"
    R2SCAN_DRSLL_U_Constrained_Structure_Optimization = (
        "R2SCAN-DRSLL+U Constrained Structure Optimization"
    )
    R2SCAN_DRSLL_U_Molecular_Dynamics = "R2SCAN-DRSLL+U Molecular Dynamics"
    R2SCAN_DRSLL_U_NSCF_Line = "R2SCAN-DRSLL+U NSCF Line"
    R2SCAN_DRSLL_U_NSCF_Uniform = "R2SCAN-DRSLL+U NSCF Uniform"
    R2SCAN_DRSLL_U_Unrecognized = "R2SCAN-DRSLL+U Unrecognized"
    R2SCAN_D3_Static = "R2SCAN-D3 Static"
    R2SCAN_D3_Structure_Optimization = "R2SCAN-D3 Structure Optimization"
    R2SCAN_D3_Constrained_Structure_Optimization = (
        "R2SCAN-D3 Constrained Structure Optimization"
    )
    R2SCAN_D3_Molecular_Dynamics = "R2SCAN-D3 Molecular Dynamics"
    R2SCAN_D3_NSCF_Line = "R2SCAN-D3 NSCF Line"
    R2SCAN_D3_NSCF_Uniform = "R2SCAN-D3 NSCF Uniform"
    R2SCAN_D3_Unrecognized = "R2SCAN-D3 Unrecognized"
    R2SCAN_D3_U_Static = "R2SCAN-D3+U Static"
    R2SCAN_D3_U_Structure_Optimization = "R2SCAN-D3+U Structure Optimization"
    R2SCAN_D3_U_Constrained_Structure_Optimization = (
        "R2SCAN-D3+U Constrained Structure Optimization"
    )
    R2SCAN_D3_U_Molecular_Dynamics = "R2SCAN-D3+U Molecular Dynamics"
    R2SCAN_D3_U_NSCF_Line = "R2SCAN-D3+U NSCF Line"
    R2SCAN_D3_U_NSCF_Uniform = "R2SCAN-D3+U NSCF Uniform"
    R2SCAN_D3_U_Unrecognized = "R2SCAN-D3+U Unrecognized"
    R2SCAN_D2_Static = "R2SCAN-D2 Static"
    R2SCAN_D2_Structure_Optimization = "R2SCAN-D2 Structure Optimization"
    R2SCAN_D2_Constrained_Structure_Optimization = (
        "R2SCAN-D2 Constrained Structure Optimization"
    )
    R2SCAN_D2_Molecular_Dynamics = "R2SCAN-D2 Molecular Dynamics"
    R2SCAN_D2_NSCF_Line = "R2SCAN-D2 NSCF Line"
    R2SCAN_D2_NSCF_Uniform = "R2SCAN-D2 NSCF Uniform"
    R2SCAN_D2_Unrecognized = "R2SCAN-D2 Unrecognized"
    R2SCAN_D2_U_Static = "R2SCAN-D2+U Static"
    R2SCAN_D2_U_Structure_Optimization = "R2SCAN-D2+U Structure Optimization"
    R2SCAN_D2_U_Constrained_Structure_Optimization = (
        "R2SCAN-D2+U Constrained Structure Optimization"
    )
    R2SCAN_D2_U_Molecular_Dynamics = "R2SCAN-D2+U Molecular Dynamics"
    R2SCAN_D2_U_NSCF_Line = "R2SCAN-D2+U NSCF Line"
    R2SCAN_D2_U_NSCF_Uniform = "R2SCAN-D2+U NSCF Uniform"
    R2SCAN_D2_U_Unrecognized = "R2SCAN-D2+U Unrecognized"
    R2SCAN_D3_BJ_Static = "R2SCAN-D3(BJ) Static"
    R2SCAN_D3_BJ_Structure_Optimization = "R2SCAN-D3(BJ) Structure Optimization"
    R2SCAN_D3_BJ_Constrained_Structure_Optimization = (
        "R2SCAN-D3(BJ) Constrained Structure Optimization"
    )
    R2SCAN_D3_BJ_Molecular_Dynamics = "R2SCAN-D3(BJ) Molecular Dynamics"
    R2SCAN_D3_BJ_NSCF_Line = "R2SCAN-D3(BJ) NSCF Line"
    R2SCAN_D3_BJ_NSCF_Uniform = "R2SCAN-D3(BJ) NSCF Uniform"
    R2SCAN_D3_BJ_Unrecognized = "R2SCAN-D3(BJ) Unrecognized"
    R2SCAN_D3_BJ_U_Static = "R2SCAN-D3(BJ)+U Static"
    R2SCAN_D3_BJ_U_Structure_Optimization = "R2SCAN-D3(BJ)+U Structure Optimization"
    R2SCAN_D3_BJ_U_Constrained_Structure_Optimization = (
        "R2SCAN-D3(BJ)+U Constrained Structure Optimization"
    )
    R2SCAN_D3_BJ_U_Molecular_Dynamics = "R2SCAN-D3(BJ)+U Molecular Dynamics"
    R2SCAN_D3_BJ_U_NSCF_Line = "R2SCAN-D3(BJ)+U NSCF Line"
    R2SCAN_D3_BJ_U_NSCF_Uniform = "R2SCAN-D3(BJ)+U NSCF Uniform"
    R2SCAN_D3_BJ_U_Unrecognized = "R2SCAN-D3(BJ)+U Unrecognized"
    METAGGA_Static = "METAGGA Static"
    METAGGA_Structure_Optimization = "METAGGA Structure Optimization"
    METAGGA_Constrained_Structure_Optimization = (
        "METAGGA Constrained Structure Optimization"
    )
    METAGGA_Molecular_Dynamics = "METAGGA Molecular Dynamics"
    METAGGA_NSCF_Line = "METAGGA NSCF Line"
    METAGGA_NSCF_Uniform = "METAGGA NSCF Uniform"
    METAGGA_Unrecognized = "METAGGA Unrecognized"
    METAGGA_U_Static = "METAGGA+U Static"
    METAGGA_U_Structure_Optimization = "METAGGA+U Structure Optimization"
    METAGGA_U_Constrained_Structure_Optimization = (
        "METAGGA+U Constrained Structure Optimization"
    )
    METAGGA_U_Molecular_Dynamics = "METAGGA+U Molecular Dynamics"
    METAGGA_U_NSCF_Line = "METAGGA+U NSCF Line"
    METAGGA_U_NSCF_Uniform = "METAGGA+U NSCF Uniform"
    METAGGA_U_Unrecognized = "METAGGA+U Unrecognized"
    METAGGA_RVV10_Static = "METAGGA-RVV10 Static"
    METAGGA_RVV10_Structure_Optimization = "METAGGA-RVV10 Structure Optimization"
    METAGGA_RVV10_Constrained_Structure_Optimization = (
        "METAGGA-RVV10 Constrained Structure Optimization"
    )
    METAGGA_RVV10_Molecular_Dynamics = "METAGGA-RVV10 Molecular Dynamics"
    METAGGA_RVV10_NSCF_Line = "METAGGA-RVV10 NSCF Line"
    METAGGA_RVV10_NSCF_Uniform = "METAGGA-RVV10 NSCF Uniform"
    METAGGA_RVV10_Unrecognized = "METAGGA-RVV10 Unrecognized"
    METAGGA_RVV10_U_Static = "METAGGA-RVV10+U Static"
    METAGGA_RVV10_U_Structure_Optimization = "METAGGA-RVV10+U Structure Optimization"
    METAGGA_RVV10_U_Constrained_Structure_Optimization = (
        "METAGGA-RVV10+U Constrained Structure Optimization"
    )
    METAGGA_RVV10_U_Molecular_Dynamics = "METAGGA-RVV10+U Molecular Dynamics"
    METAGGA_RVV10_U_NSCF_Line = "METAGGA-RVV10+U NSCF Line"
    METAGGA_RVV10_U_NSCF_Uniform = "METAGGA-RVV10+U NSCF Uniform"
    METAGGA_RVV10_U_Unrecognized = "METAGGA-RVV10+U Unrecognized"
    METAGGA_LMKLL_Static = "METAGGA-LMKLL Static"
    METAGGA_LMKLL_Structure_Optimization = "METAGGA-LMKLL Structure Optimization"
    METAGGA_LMKLL_Constrained_Structure_Optimization = (
        "METAGGA-LMKLL Constrained Structure Optimization"
    )
    METAGGA_LMKLL_Molecular_Dynamics = "METAGGA-LMKLL Molecular Dynamics"
    METAGGA_LMKLL_NSCF_Line = "METAGGA-LMKLL NSCF Line"
    METAGGA_LMKLL_NSCF_Uniform = "METAGGA-LMKLL NSCF Uniform"
    METAGGA_LMKLL_Unrecognized = "METAGGA-LMKLL Unrecognized"
    METAGGA_LMKLL_U_Static = "METAGGA-LMKLL+U Static"
    METAGGA_LMKLL_U_Structure_Optimization = "METAGGA-LMKLL+U Structure Optimization"
    METAGGA_LMKLL_U_Constrained_Structure_Optimization = (
        "METAGGA-LMKLL+U Constrained Structure Optimization"
    )
    METAGGA_LMKLL_U_Molecular_Dynamics = "METAGGA-LMKLL+U Molecular Dynamics"
    METAGGA_LMKLL_U_NSCF_Line = "METAGGA-LMKLL+U NSCF Line"
    METAGGA_LMKLL_U_NSCF_Uniform = "METAGGA-LMKLL+U NSCF Uniform"
    METAGGA_LMKLL_U_Unrecognized = "METAGGA-LMKLL+U Unrecognized"
    METAGGA_DRSLL_Static = "METAGGA-DRSLL Static"
    METAGGA_DRSLL_Structure_Optimization = "METAGGA-DRSLL Structure Optimization"
    METAGGA_DRSLL_Constrained_Structure_Optimization = (
        "METAGGA-DRSLL Constrained Structure Optimization"
    )
    METAGGA_DRSLL_Molecular_Dynamics = "METAGGA-DRSLL Molecular Dynamics"
    METAGGA_DRSLL_NSCF_Line = "METAGGA-DRSLL NSCF Line"
    METAGGA_DRSLL_NSCF_Uniform = "METAGGA-DRSLL NSCF Uniform"
    METAGGA_DRSLL_Unrecognized = "METAGGA-DRSLL Unrecognized"
    METAGGA_DRSLL_U_Static = "METAGGA-DRSLL+U Static"
    METAGGA_DRSLL_U_Structure_Optimization = "METAGGA-DRSLL+U Structure Optimization"
    METAGGA_DRSLL_U_Constrained_Structure_Optimization = (
        "METAGGA-DRSLL+U Constrained Structure Optimization"
    )
    METAGGA_DRSLL_U_Molecular_Dynamics = "METAGGA-DRSLL+U Molecular Dynamics"
    METAGGA_DRSLL_U_NSCF_Line = "METAGGA-DRSLL+U NSCF Line"
    METAGGA_DRSLL_U_NSCF_Uniform = "METAGGA-DRSLL+U NSCF Uniform"
    METAGGA_DRSLL_U_Unrecognized = "METAGGA-DRSLL+U Unrecognized"
    METAGGA_D3_Static = "METAGGA-D3 Static"
    METAGGA_D3_Structure_Optimization = "METAGGA-D3 Structure Optimization"
    METAGGA_D3_Constrained_Structure_Optimization = (
        "METAGGA-D3 Constrained Structure Optimization"
    )
    METAGGA_D3_Molecular_Dynamics = "METAGGA-D3 Molecular Dynamics"
    METAGGA_D3_NSCF_Line = "METAGGA-D3 NSCF Line"
    METAGGA_D3_NSCF_Uniform = "METAGGA-D3 NSCF Uniform"
    METAGGA_D3_Unrecognized = "METAGGA-D3 Unrecognized"
    METAGGA_D3_U_Static = "METAGGA-D3+U Static"
    METAGGA_D3_U_Structure_Optimization = "METAGGA-D3+U Structure Optimization"
    METAGGA_D3_U_Constrained_Structure_Optimization = (
        "METAGGA-D3+U Constrained Structure Optimization"
    )
    METAGGA_D3_U_Molecular_Dynamics = "METAGGA-D3+U Molecular Dynamics"
    METAGGA_D3_U_NSCF_Line = "METAGGA-D3+U NSCF Line"
    METAGGA_D3_U_NSCF_Uniform = "METAGGA-D3+U NSCF Uniform"
    METAGGA_D3_U_Unrecognized = "METAGGA-D3+U Unrecognized"
    METAGGA_D2_Static = "METAGGA-D2 Static"
    METAGGA_D2_Structure_Optimization = "METAGGA-D2 Structure Optimization"
    METAGGA_D2_Constrained_Structure_Optimization = (
        "METAGGA-D2 Constrained Structure Optimization"
    )
    METAGGA_D2_Molecular_Dynamics = "METAGGA-D2 Molecular Dynamics"
    METAGGA_D2_NSCF_Line = "METAGGA-D2 NSCF Line"
    METAGGA_D2_NSCF_Uniform = "METAGGA-D2 NSCF Uniform"
    METAGGA_D2_Unrecognized = "METAGGA-D2 Unrecognized"
    METAGGA_D2_U_Static = "METAGGA-D2+U Static"
    METAGGA_D2_U_Structure_Optimization = "METAGGA-D2+U Structure Optimization"
    METAGGA_D2_U_Constrained_Structure_Optimization = (
        "METAGGA-D2+U Constrained Structure Optimization"
    )
    METAGGA_D2_U_Molecular_Dynamics = "METAGGA-D2+U Molecular Dynamics"
    METAGGA_D2_U_NSCF_Line = "METAGGA-D2+U NSCF Line"
    METAGGA_D2_U_NSCF_Uniform = "METAGGA-D2+U NSCF Uniform"
    METAGGA_D2_U_Unrecognized = "METAGGA-D2+U Unrecognized"
    METAGGA_D3_BJ_Static = "METAGGA-D3(BJ) Static"
    METAGGA_D3_BJ_Structure_Optimization = "METAGGA-D3(BJ) Structure Optimization"
    METAGGA_D3_BJ_Constrained_Structure_Optimization = (
        "METAGGA-D3(BJ) Constrained Structure Optimization"
    )
    METAGGA_D3_BJ_Molecular_Dynamics = "METAGGA-D3(BJ) Molecular Dynamics"
    METAGGA_D3_BJ_NSCF_Line = "METAGGA-D3(BJ) NSCF Line"
    METAGGA_D3_BJ_NSCF_Uniform = "METAGGA-D3(BJ) NSCF Uniform"
    METAGGA_D3_BJ_Unrecognized = "METAGGA-D3(BJ) Unrecognized"
    METAGGA_D3_BJ_U_Static = "METAGGA-D3(BJ)+U Static"
    METAGGA_D3_BJ_U_Structure_Optimization = "METAGGA-D3(BJ)+U Structure Optimization"
    METAGGA_D3_BJ_U_Constrained_Structure_Optimization = (
        "METAGGA-D3(BJ)+U Constrained Structure Optimization"
    )
    METAGGA_D3_BJ_U_Molecular_Dynamics = "METAGGA-D3(BJ)+U Molecular Dynamics"
    METAGGA_D3_BJ_U_NSCF_Line = "METAGGA-D3(BJ)+U NSCF Line"
    METAGGA_D3_BJ_U_NSCF_Uniform = "METAGGA-D3(BJ)+U NSCF Uniform"
    METAGGA_D3_BJ_U_Unrecognized = "METAGGA-D3(BJ)+U Unrecognized"
    HYBRID_Static = "HYBRID Static"
    HYBRID_Structure_Optimization = "HYBRID Structure Optimization"
    HYBRID_Constrained_Structure_Optimization = (
        "HYBRID Constrained Structure Optimization"
    )
    HYBRID_Molecular_Dynamics = "HYBRID Molecular Dynamics"
    HYBRID_NSCF_Line = "HYBRID NSCF Line"
    HYBRID_NSCF_Uniform = "HYBRID NSCF Uniform"
    HYBRID_Unrecognized = "HYBRID Unrecognized"
    HYBRID_U_Static = "HYBRID+U Static"
    HYBRID_U_Structure_Optimization = "HYBRID+U Structure Optimization"
    HYBRID_U_Constrained_Structure_Optimization = (
        "HYBRID+U Constrained Structure Optimization"
    )
    HYBRID_U_Molecular_Dynamics = "HYBRID+U Molecular Dynamics"
    HYBRID_U_NSCF_Line = "HYBRID+U NSCF Line"
    HYBRID_U_NSCF_Uniform = "HYBRID+U NSCF Uniform"
    HYBRID_U_Unrecognized = "HYBRID+U Unrecognized"
    HYBRID_RVV10_Static = "HYBRID-RVV10 Static"
    HYBRID_RVV10_Structure_Optimization = "HYBRID-RVV10 Structure Optimization"
    HYBRID_RVV10_Constrained_Structure_Optimization = (
        "HYBRID-RVV10 Constrained Structure Optimization"
    )
    HYBRID_RVV10_Molecular_Dynamics = "HYBRID-RVV10 Molecular Dynamics"
    HYBRID_RVV10_NSCF_Line = "HYBRID-RVV10 NSCF Line"
    HYBRID_RVV10_NSCF_Uniform = "HYBRID-RVV10 NSCF Uniform"
    HYBRID_RVV10_Unrecognized = "HYBRID-RVV10 Unrecognized"
    HYBRID_RVV10_U_Static = "HYBRID-RVV10+U Static"
    HYBRID_RVV10_U_Structure_Optimization = "HYBRID-RVV10+U Structure Optimization"
    HYBRID_RVV10_U_Constrained_Structure_Optimization = (
        "HYBRID-RVV10+U Constrained Structure Optimization"
    )
    HYBRID_RVV10_U_Molecular_Dynamics = "HYBRID-RVV10+U Molecular Dynamics"
    HYBRID_RVV10_U_NSCF_Line = "HYBRID-RVV10+U NSCF Line"
    HYBRID_RVV10_U_NSCF_Uniform = "HYBRID-RVV10+U NSCF Uniform"
    HYBRID_RVV10_U_Unrecognized = "HYBRID-RVV10+U Unrecognized"
    HYBRID_LMKLL_Static = "HYBRID-LMKLL Static"
    HYBRID_LMKLL_Structure_Optimization = "HYBRID-LMKLL Structure Optimization"
    HYBRID_LMKLL_Constrained_Structure_Optimization = (
        "HYBRID-LMKLL Constrained Structure Optimization"
    )
    HYBRID_LMKLL_Molecular_Dynamics = "HYBRID-LMKLL Molecular Dynamics"
    HYBRID_LMKLL_NSCF_Line = "HYBRID-LMKLL NSCF Line"
    HYBRID_LMKLL_NSCF_Uniform = "HYBRID-LMKLL NSCF Uniform"
    HYBRID_LMKLL_Unrecognized = "HYBRID-LMKLL Unrecognized"
    HYBRID_LMKLL_U_Static = "HYBRID-LMKLL+U Static"
    HYBRID_LMKLL_U_Structure_Optimization = "HYBRID-LMKLL+U Structure Optimization"
    HYBRID_LMKLL_U_Constrained_Structure_Optimization = (
        "HYBRID-LMKLL+U Constrained Structure Optimization"
    )
    HYBRID_LMKLL_U_Molecular_Dynamics = "HYBRID-LMKLL+U Molecular Dynamics"
    HYBRID_LMKLL_U_NSCF_Line = "HYBRID-LMKLL+U NSCF Line"
    HYBRID_LMKLL_U_NSCF_Uniform = "HYBRID-LMKLL+U NSCF Uniform"
    HYBRID_LMKLL_U_Unrecognized = "HYBRID-LMKLL+U Unrecognized"
    HYBRID_DRSLL_Static = "HYBRID-DRSLL Static"
    HYBRID_DRSLL_Structure_Optimization = "HYBRID-DRSLL Structure Optimization"
    HYBRID_DRSLL_Constrained_Structure_Optimization = (
        "HYBRID-DRSLL Constrained Structure Optimization"
    )
    HYBRID_DRSLL_Molecular_Dynamics = "HYBRID-DRSLL Molecular Dynamics"
    HYBRID_DRSLL_NSCF_Line = "HYBRID-DRSLL NSCF Line"
    HYBRID_DRSLL_NSCF_Uniform = "HYBRID-DRSLL NSCF Uniform"
    HYBRID_DRSLL_Unrecognized = "HYBRID-DRSLL Unrecognized"
    HYBRID_DRSLL_U_Static = "HYBRID-DRSLL+U Static"
    HYBRID_DRSLL_U_Structure_Optimization = "HYBRID-DRSLL+U Structure Optimization"
    HYBRID_DRSLL_U_Constrained_Structure_Optimization = (
        "HYBRID-DRSLL+U Constrained Structure Optimization"
    )
    HYBRID_DRSLL_U_Molecular_Dynamics = "HYBRID-DRSLL+U Molecular Dynamics"
    HYBRID_DRSLL_U_NSCF_Line = "HYBRID-DRSLL+U NSCF Line"
    HYBRID_DRSLL_U_NSCF_Uniform = "HYBRID-DRSLL+U NSCF Uniform"
    HYBRID_DRSLL_U_Unrecognized = "HYBRID-DRSLL+U Unrecognized"
    HYBRID_D3_Static = "HYBRID-D3 Static"
    HYBRID_D3_Structure_Optimization = "HYBRID-D3 Structure Optimization"
    HYBRID_D3_Constrained_Structure_Optimization = (
        "HYBRID-D3 Constrained Structure Optimization"
    )
    HYBRID_D3_Molecular_Dynamics = "HYBRID-D3 Molecular Dynamics"
    HYBRID_D3_NSCF_Line = "HYBRID-D3 NSCF Line"
    HYBRID_D3_NSCF_Uniform = "HYBRID-D3 NSCF Uniform"
    HYBRID_D3_Unrecognized = "HYBRID-D3 Unrecognized"
    HYBRID_D3_U_Static = "HYBRID-D3+U Static"
    HYBRID_D3_U_Structure_Optimization = "HYBRID-D3+U Structure Optimization"
    HYBRID_D3_U_Constrained_Structure_Optimization = (
        "HYBRID-D3+U Constrained Structure Optimization"
    )
    HYBRID_D3_U_Molecular_Dynamics = "HYBRID-D3+U Molecular Dynamics"
    HYBRID_D3_U_NSCF_Line = "HYBRID-D3+U NSCF Line"
    HYBRID_D3_U_NSCF_Uniform = "HYBRID-D3+U NSCF Uniform"
    HYBRID_D3_U_Unrecognized = "HYBRID-D3+U Unrecognized"
    HYBRID_D2_Static = "HYBRID-D2 Static"
    HYBRID_D2_Structure_Optimization = "HYBRID-D2 Structure Optimization"
    HYBRID_D2_Constrained_Structure_Optimization = (
        "HYBRID-D2 Constrained Structure Optimization"
    )
    HYBRID_D2_Molecular_Dynamics = "HYBRID-D2 Molecular Dynamics"
    HYBRID_D2_NSCF_Line = "HYBRID-D2 NSCF Line"
    HYBRID_D2_NSCF_Uniform = "HYBRID-D2 NSCF Uniform"
    HYBRID_D2_Unrecognized = "HYBRID-D2 Unrecognized"
    HYBRID_D2_U_Static = "HYBRID-D2+U Static"
    HYBRID_D2_U_Structure_Optimization = "HYBRID-D2+U Structure Optimization"
    HYBRID_D2_U_Constrained_Structure_Optimization = (
        "HYBRID-D2+U Constrained Structure Optimization"
    )
    HYBRID_D2_U_Molecular_Dynamics = "HYBRID-D2+U Molecular Dynamics"
    HYBRID_D2_U_NSCF_Line = "HYBRID-D2+U NSCF Line"
    HYBRID_D2_U_NSCF_Uniform = "HYBRID-D2+U NSCF Uniform"
    HYBRID_D2_U_Unrecognized = "HYBRID-D2+U Unrecognized"
    HYBRID_D3_BJ_Static = "HYBRID-D3(BJ) Static"
    HYBRID_D3_BJ_Structure_Optimization = "HYBRID-D3(BJ) Structure Optimization"
    HYBRID_D3_BJ_Constrained_Structure_Optimization = (
        "HYBRID-D3(BJ) Constrained Structure Optimization"
    )
    HYBRID_D3_BJ_Molecular_Dynamics = "HYBRID-D3(BJ) Molecular Dynamics"
    HYBRID_D3_BJ_NSCF_Line = "HYBRID-D3(BJ) NSCF Line"
    HYBRID_D3_BJ_NSCF_Uniform = "HYBRID-D3(BJ) NSCF Uniform"
    HYBRID_D3_BJ_Unrecognized = "HYBRID-D3(BJ) Unrecognized"
    HYBRID_D3_BJ_U_Static = "HYBRID-D3(BJ)+U Static"
    HYBRID_D3_BJ_U_Structure_Optimization = "HYBRID-D3(BJ)+U Structure Optimization"
    HYBRID_D3_BJ_U_Constrained_Structure_Optimization = (
        "HYBRID-D3(BJ)+U Constrained Structure Optimization"
    )
    HYBRID_D3_BJ_U_Molecular_Dynamics = "HYBRID-D3(BJ)+U Molecular Dynamics"
    HYBRID_D3_BJ_U_NSCF_Line = "HYBRID-D3(BJ)+U NSCF Line"
    HYBRID_D3_BJ_U_NSCF_Uniform = "HYBRID-D3(BJ)+U NSCF Uniform"
    HYBRID_D3_BJ_U_Unrecognized = "HYBRID-D3(BJ)+U Unrecognized"
    HSE06_Static = "HSE06 Static"
    HSE06_Structure_Optimization = "HSE06 Structure Optimization"
    HSE06_Constrained_Structure_Optimization = (
        "HSE06 Constrained Structure Optimization"
    )
    HSE06_Molecular_Dynamics = "HSE06 Molecular Dynamics"
    HSE06_NSCF_Line = "HSE06 NSCF Line"
    HSE06_NSCF_Uniform = "HSE06 NSCF Uniform"
    HSE06_Unrecognized = "HSE06 Unrecognized"
    HSE06_U_Static = "HSE06+U Static"
    HSE06_U_Structure_Optimization = "HSE06+U Structure Optimization"
    HSE06_U_Constrained_Structure_Optimization = (
        "HSE06+U Constrained Structure Optimization"
    )
    HSE06_U_Molecular_Dynamics = "HSE06+U Molecular Dynamics"
    HSE06_U_NSCF_Line = "HSE06+U NSCF Line"
    HSE06_U_NSCF_Uniform = "HSE06+U NSCF Uniform"
    HSE06_U_Unrecognized = "HSE06+U Unrecognized"
    HSE06_RVV10_Static = "HSE06-RVV10 Static"
    HSE06_RVV10_Structure_Optimization = "HSE06-RVV10 Structure Optimization"
    HSE06_RVV10_Constrained_Structure_Optimization = (
        "HSE06-RVV10 Constrained Structure Optimization"
    )
    HSE06_RVV10_Molecular_Dynamics = "HSE06-RVV10 Molecular Dynamics"
    HSE06_RVV10_NSCF_Line = "HSE06-RVV10 NSCF Line"
    HSE06_RVV10_NSCF_Uniform = "HSE06-RVV10 NSCF Uniform"
    HSE06_RVV10_Unrecognized = "HSE06-RVV10 Unrecognized"
    HSE06_RVV10_U_Static = "HSE06-RVV10+U Static"
    HSE06_RVV10_U_Structure_Optimization = "HSE06-RVV10+U Structure Optimization"
    HSE06_RVV10_U_Constrained_Structure_Optimization = (
        "HSE06-RVV10+U Constrained Structure Optimization"
    )
    HSE06_RVV10_U_Molecular_Dynamics = "HSE06-RVV10+U Molecular Dynamics"
    HSE06_RVV10_U_NSCF_Line = "HSE06-RVV10+U NSCF Line"
    HSE06_RVV10_U_NSCF_Uniform = "HSE06-RVV10+U NSCF Uniform"
    HSE06_RVV10_U_Unrecognized = "HSE06-RVV10+U Unrecognized"
    HSE06_LMKLL_Static = "HSE06-LMKLL Static"
    HSE06_LMKLL_Structure_Optimization = "HSE06-LMKLL Structure Optimization"
    HSE06_LMKLL_Constrained_Structure_Optimization = (
        "HSE06-LMKLL Constrained Structure Optimization"
    )
    HSE06_LMKLL_Molecular_Dynamics = "HSE06-LMKLL Molecular Dynamics"
    HSE06_LMKLL_NSCF_Line = "HSE06-LMKLL NSCF Line"
    HSE06_LMKLL_NSCF_Uniform = "HSE06-LMKLL NSCF Uniform"
    HSE06_LMKLL_Unrecognized = "HSE06-LMKLL Unrecognized"
    HSE06_LMKLL_U_Static = "HSE06-LMKLL+U Static"
    HSE06_LMKLL_U_Structure_Optimization = "HSE06-LMKLL+U Structure Optimization"
    HSE06_LMKLL_U_Constrained_Structure_Optimization = (
        "HSE06-LMKLL+U Constrained Structure Optimization"
    )
    HSE06_LMKLL_U_Molecular_Dynamics = "HSE06-LMKLL+U Molecular Dynamics"
    HSE06_LMKLL_U_NSCF_Line = "HSE06-LMKLL+U NSCF Line"
    HSE06_LMKLL_U_NSCF_Uniform = "HSE06-LMKLL+U NSCF Uniform"
    HSE06_LMKLL_U_Unrecognized = "HSE06-LMKLL+U Unrecognized"
    HSE06_DRSLL_Static = "HSE06-DRSLL Static"
    HSE06_DRSLL_Structure_Optimization = "HSE06-DRSLL Structure Optimization"
    HSE06_DRSLL_Constrained_Structure_Optimization = (
        "HSE06-DRSLL Constrained Structure Optimization"
    )
    HSE06_DRSLL_Molecular_Dynamics = "HSE06-DRSLL Molecular Dynamics"
    HSE06_DRSLL_NSCF_Line = "HSE06-DRSLL NSCF Line"
    HSE06_DRSLL_NSCF_Uniform = "HSE06-DRSLL NSCF Uniform"
    HSE06_DRSLL_Unrecognized = "HSE06-DRSLL Unrecognized"
    HSE06_DRSLL_U_Static = "HSE06-DRSLL+U Static"
    HSE06_DRSLL_U_Structure_Optimization = "HSE06-DRSLL+U Structure Optimization"
    HSE06_DRSLL_U_Constrained_Structure_Optimization = (
        "HSE06-DRSLL+U Constrained Structure Optimization"
    )
    HSE06_DRSLL_U_Molecular_Dynamics = "HSE06-DRSLL+U Molecular Dynamics"
    HSE06_DRSLL_U_NSCF_Line = "HSE06-DRSLL+U NSCF Line"
    HSE06_DRSLL_U_NSCF_Uniform = "HSE06-DRSLL+U NSCF Uniform"
    HSE06_DRSLL_U_Unrecognized = "HSE06-DRSLL+U Unrecognized"
    HSE06_D3_Static = "HSE06-D3 Static"
    HSE06_D3_Structure_Optimization = "HSE06-D3 Structure Optimization"
    HSE06_D3_Constrained_Structure_Optimization = (
        "HSE06-D3 Constrained Structure Optimization"
    )
    HSE06_D3_Molecular_Dynamics = "HSE06-D3 Molecular Dynamics"
    HSE06_D3_NSCF_Line = "HSE06-D3 NSCF Line"
    HSE06_D3_NSCF_Uniform = "HSE06-D3 NSCF Uniform"
    HSE06_D3_Unrecognized = "HSE06-D3 Unrecognized"
    HSE06_D3_U_Static = "HSE06-D3+U Static"
    HSE06_D3_U_Structure_Optimization = "HSE06-D3+U Structure Optimization"
    HSE06_D3_U_Constrained_Structure_Optimization = (
        "HSE06-D3+U Constrained Structure Optimization"
    )
    HSE06_D3_U_Molecular_Dynamics = "HSE06-D3+U Molecular Dynamics"
    HSE06_D3_U_NSCF_Line = "HSE06-D3+U NSCF Line"
    HSE06_D3_U_NSCF_Uniform = "HSE06-D3+U NSCF Uniform"
    HSE06_D3_U_Unrecognized = "HSE06-D3+U Unrecognized"
    HSE06_D2_Static = "HSE06-D2 Static"
    HSE06_D2_Structure_Optimization = "HSE06-D2 Structure Optimization"
    HSE06_D2_Constrained_Structure_Optimization = (
        "HSE06-D2 Constrained Structure Optimization"
    )
    HSE06_D2_Molecular_Dynamics = "HSE06-D2 Molecular Dynamics"
    HSE06_D2_NSCF_Line = "HSE06-D2 NSCF Line"
    HSE06_D2_NSCF_Uniform = "HSE06-D2 NSCF Uniform"
    HSE06_D2_Unrecognized = "HSE06-D2 Unrecognized"
    HSE06_D2_U_Static = "HSE06-D2+U Static"
    HSE06_D2_U_Structure_Optimization = "HSE06-D2+U Structure Optimization"
    HSE06_D2_U_Constrained_Structure_Optimization = (
        "HSE06-D2+U Constrained Structure Optimization"
    )
    HSE06_D2_U_Molecular_Dynamics = "HSE06-D2+U Molecular Dynamics"
    HSE06_D2_U_NSCF_Line = "HSE06-D2+U NSCF Line"
    HSE06_D2_U_NSCF_Uniform = "HSE06-D2+U NSCF Uniform"
    HSE06_D2_U_Unrecognized = "HSE06-D2+U Unrecognized"
    HSE06_D3_BJ_Static = "HSE06-D3(BJ) Static"
    HSE06_D3_BJ_Structure_Optimization = "HSE06-D3(BJ) Structure Optimization"
    HSE06_D3_BJ_Constrained_Structure_Optimization = (
        "HSE06-D3(BJ) Constrained Structure Optimization"
    )
    HSE06_D3_BJ_Molecular_Dynamics = "HSE06-D3(BJ) Molecular Dynamics"
    HSE06_D3_BJ_NSCF_Line = "HSE06-D3(BJ) NSCF Line"
    HSE06_D3_BJ_NSCF_Uniform = "HSE06-D3(BJ) NSCF Uniform"
    HSE06_D3_BJ_Unrecognized = "HSE06-D3(BJ) Unrecognized"
    HSE06_D3_BJ_U_Static = "HSE06-D3(BJ)+U Static"
    HSE06_D3_BJ_U_Structure_Optimization = "HSE06-D3(BJ)+U Structure Optimization"
    HSE06_D3_BJ_U_Constrained_Structure_Optimization = (
        "HSE06-D3(BJ)+U Constrained Structure Optimization"
    )
    HSE06_D3_BJ_U_Molecular_Dynamics = "HSE06-D3(BJ)+U Molecular Dynamics"
    HSE06_D3_BJ_U_NSCF_Line = "HSE06-D3(BJ)+U NSCF Line"
    HSE06_D3_BJ_U_NSCF_Uniform = "HSE06-D3(BJ)+U NSCF Uniform"
    HSE06_D3_BJ_U_Unrecognized = "HSE06-D3(BJ)+U Unrecognized"
    PBE0_Static = "PBE0 Static"
    PBE0_Structure_Optimization = "PBE0 Structure Optimization"
    PBE0_Constrained_Structure_Optimization = "PBE0 Constrained Structure Optimization"
    PBE0_Molecular_Dynamics = "PBE0 Molecular Dynamics"
    PBE0_NSCF_Line = "PBE0 NSCF Line"
    PBE0_NSCF_Uniform = "PBE0 NSCF Uniform"
    PBE0_Unrecognized = "PBE0 Unrecognized"
    PBE0_U_Static = "PBE0+U Static"
    PBE0_U_Structure_Optimization = "PBE0+U Structure Optimization"
    PBE0_U_Constrained_Structure_Optimization = (
        "PBE0+U Constrained Structure Optimization"
    )
    PBE0_U_Molecular_Dynamics = "PBE0+U Molecular Dynamics"
    PBE0_U_NSCF_Line = "PBE0+U NSCF Line"
    PBE0_U_NSCF_Uniform = "PBE0+U NSCF Uniform"
    PBE0_U_Unrecognized = "PBE0+U Unrecognized"
    PBE0_RVV10_Static = "PBE0-RVV10 Static"
    PBE0_RVV10_Structure_Optimization = "PBE0-RVV10 Structure Optimization"
    PBE0_RVV10_Constrained_Structure_Optimization = (
        "PBE0-RVV10 Constrained Structure Optimization"
    )
    PBE0_RVV10_Molecular_Dynamics = "PBE0-RVV10 Molecular Dynamics"
    PBE0_RVV10_NSCF_Line = "PBE0-RVV10 NSCF Line"
    PBE0_RVV10_NSCF_Uniform = "PBE0-RVV10 NSCF Uniform"
    PBE0_RVV10_Unrecognized = "PBE0-RVV10 Unrecognized"
    PBE0_RVV10_U_Static = "PBE0-RVV10+U Static"
    PBE0_RVV10_U_Structure_Optimization = "PBE0-RVV10+U Structure Optimization"
    PBE0_RVV10_U_Constrained_Structure_Optimization = (
        "PBE0-RVV10+U Constrained Structure Optimization"
    )
    PBE0_RVV10_U_Molecular_Dynamics = "PBE0-RVV10+U Molecular Dynamics"
    PBE0_RVV10_U_NSCF_Line = "PBE0-RVV10+U NSCF Line"
    PBE0_RVV10_U_NSCF_Uniform = "PBE0-RVV10+U NSCF Uniform"
    PBE0_RVV10_U_Unrecognized = "PBE0-RVV10+U Unrecognized"
    PBE0_LMKLL_Static = "PBE0-LMKLL Static"
    PBE0_LMKLL_Structure_Optimization = "PBE0-LMKLL Structure Optimization"
    PBE0_LMKLL_Constrained_Structure_Optimization = (
        "PBE0-LMKLL Constrained Structure Optimization"
    )
    PBE0_LMKLL_Molecular_Dynamics = "PBE0-LMKLL Molecular Dynamics"
    PBE0_LMKLL_NSCF_Line = "PBE0-LMKLL NSCF Line"
    PBE0_LMKLL_NSCF_Uniform = "PBE0-LMKLL NSCF Uniform"
    PBE0_LMKLL_Unrecognized = "PBE0-LMKLL Unrecognized"
    PBE0_LMKLL_U_Static = "PBE0-LMKLL+U Static"
    PBE0_LMKLL_U_Structure_Optimization = "PBE0-LMKLL+U Structure Optimization"
    PBE0_LMKLL_U_Constrained_Structure_Optimization = (
        "PBE0-LMKLL+U Constrained Structure Optimization"
    )
    PBE0_LMKLL_U_Molecular_Dynamics = "PBE0-LMKLL+U Molecular Dynamics"
    PBE0_LMKLL_U_NSCF_Line = "PBE0-LMKLL+U NSCF Line"
    PBE0_LMKLL_U_NSCF_Uniform = "PBE0-LMKLL+U NSCF Uniform"
    PBE0_LMKLL_U_Unrecognized = "PBE0-LMKLL+U Unrecognized"
    PBE0_DRSLL_Static = "PBE0-DRSLL Static"
    PBE0_DRSLL_Structure_Optimization = "PBE0-DRSLL Structure Optimization"
    PBE0_DRSLL_Constrained_Structure_Optimization = (
        "PBE0-DRSLL Constrained Structure Optimization"
    )
    PBE0_DRSLL_Molecular_Dynamics = "PBE0-DRSLL Molecular Dynamics"
    PBE0_DRSLL_NSCF_Line = "PBE0-DRSLL NSCF Line"
    PBE0_DRSLL_NSCF_Uniform = "PBE0-DRSLL NSCF Uniform"
    PBE0_DRSLL_Unrecognized = "PBE0-DRSLL Unrecognized"
    PBE0_DRSLL_U_Static = "PBE0-DRSLL+U Static"
    PBE0_DRSLL_U_Structure_Optimization = "PBE0-DRSLL+U Structure Optimization"
    PBE0_DRSLL_U_Constrained_Structure_Optimization = (
        "PBE0-DRSLL+U Constrained Structure Optimization"
    )
    PBE0_DRSLL_U_Molecular_Dynamics = "PBE0-DRSLL+U Molecular Dynamics"
    PBE0_DRSLL_U_NSCF_Line = "PBE0-DRSLL+U NSCF Line"
    PBE0_DRSLL_U_NSCF_Uniform = "PBE0-DRSLL+U NSCF Uniform"
    PBE0_DRSLL_U_Unrecognized = "PBE0-DRSLL+U Unrecognized"
    PBE0_D3_Static = "PBE0-D3 Static"
    PBE0_D3_Structure_Optimization = "PBE0-D3 Structure Optimization"
    PBE0_D3_Constrained_Structure_Optimization = (
        "PBE0-D3 Constrained Structure Optimization"
    )
    PBE0_D3_Molecular_Dynamics = "PBE0-D3 Molecular Dynamics"
    PBE0_D3_NSCF_Line = "PBE0-D3 NSCF Line"
    PBE0_D3_NSCF_Uniform = "PBE0-D3 NSCF Uniform"
    PBE0_D3_Unrecognized = "PBE0-D3 Unrecognized"
    PBE0_D3_U_Static = "PBE0-D3+U Static"
    PBE0_D3_U_Structure_Optimization = "PBE0-D3+U Structure Optimization"
    PBE0_D3_U_Constrained_Structure_Optimization = (
        "PBE0-D3+U Constrained Structure Optimization"
    )
    PBE0_D3_U_Molecular_Dynamics = "PBE0-D3+U Molecular Dynamics"
    PBE0_D3_U_NSCF_Line = "PBE0-D3+U NSCF Line"
    PBE0_D3_U_NSCF_Uniform = "PBE0-D3+U NSCF Uniform"
    PBE0_D3_U_Unrecognized = "PBE0-D3+U Unrecognized"
    PBE0_D2_Static = "PBE0-D2 Static"
    PBE0_D2_Structure_Optimization = "PBE0-D2 Structure Optimization"
    PBE0_D2_Constrained_Structure_Optimization = (
        "PBE0-D2 Constrained Structure Optimization"
    )
    PBE0_D2_Molecular_Dynamics = "PBE0-D2 Molecular Dynamics"
    PBE0_D2_NSCF_Line = "PBE0-D2 NSCF Line"
    PBE0_D2_NSCF_Uniform = "PBE0-D2 NSCF Uniform"
    PBE0_D2_Unrecognized = "PBE0-D2 Unrecognized"
    PBE0_D2_U_Static = "PBE0-D2+U Static"
    PBE0_D2_U_Structure_Optimization = "PBE0-D2+U Structure Optimization"
    PBE0_D2_U_Constrained_Structure_Optimization = (
        "PBE0-D2+U Constrained Structure Optimization"
    )
    PBE0_D2_U_Molecular_Dynamics = "PBE0-D2+U Molecular Dynamics"
    PBE0_D2_U_NSCF_Line = "PBE0-D2+U NSCF Line"
    PBE0_D2_U_NSCF_Uniform = "PBE0-D2+U NSCF Uniform"
    PBE0_D2_U_Unrecognized = "PBE0-D2+U Unrecognized"
    PBE0_D3_BJ_Static = "PBE0-D3(BJ) Static"
    PBE0_D3_BJ_Structure_Optimization = "PBE0-D3(BJ) Structure Optimization"
    PBE0_D3_BJ_Constrained_Structure_Optimization = (
        "PBE0-D3(BJ) Constrained Structure Optimization"
    )
    PBE0_D3_BJ_Molecular_Dynamics = "PBE0-D3(BJ) Molecular Dynamics"
    PBE0_D3_BJ_NSCF_Line = "PBE0-D3(BJ) NSCF Line"
    PBE0_D3_BJ_NSCF_Uniform = "PBE0-D3(BJ) NSCF Uniform"
    PBE0_D3_BJ_Unrecognized = "PBE0-D3(BJ) Unrecognized"
    PBE0_D3_BJ_U_Static = "PBE0-D3(BJ)+U Static"
    PBE0_D3_BJ_U_Structure_Optimization = "PBE0-D3(BJ)+U Structure Optimization"
    PBE0_D3_BJ_U_Constrained_Structure_Optimization = (
        "PBE0-D3(BJ)+U Constrained Structure Optimization"
    )
    PBE0_D3_BJ_U_Molecular_Dynamics = "PBE0-D3(BJ)+U Molecular Dynamics"
    PBE0_D3_BJ_U_NSCF_Line = "PBE0-D3(BJ)+U NSCF Line"
    PBE0_D3_BJ_U_NSCF_Uniform = "PBE0-D3(BJ)+U NSCF Uniform"
    PBE0_D3_BJ_U_Unrecognized = "PBE0-D3(BJ)+U Unrecognized"
    RSH_Static = "RSH Static"
    RSH_Structure_Optimization = "RSH Structure Optimization"
    RSH_Constrained_Structure_Optimization = "RSH Constrained Structure Optimization"
    RSH_Molecular_Dynamics = "RSH Molecular Dynamics"
    RSH_NSCF_Line = "RSH NSCF Line"
    RSH_NSCF_Uniform = "RSH NSCF Uniform"
    RSH_Unrecognized = "RSH Unrecognized"
    RSH_U_Static = "RSH+U Static"
    RSH_U_Structure_Optimization = "RSH+U Structure Optimization"
    RSH_U_Constrained_Structure_Optimization = (
        "RSH+U Constrained Structure Optimization"
    )
    RSH_U_Molecular_Dynamics = "RSH+U Molecular Dynamics"
    RSH_U_NSCF_Line = "RSH+U NSCF Line"
    RSH_U_NSCF_Uniform = "RSH+U NSCF Uniform"
    RSH_U_Unrecognized = "RSH+U Unrecognized"
    RSH_RVV10_Static = "RSH-RVV10 Static"
    RSH_RVV10_Structure_Optimization = "RSH-RVV10 Structure Optimization"
    RSH_RVV10_Constrained_Structure_Optimization = (
        "RSH-RVV10 Constrained Structure Optimization"
    )
    RSH_RVV10_Molecular_Dynamics = "RSH-RVV10 Molecular Dynamics"
    RSH_RVV10_NSCF_Line = "RSH-RVV10 NSCF Line"
    RSH_RVV10_NSCF_Uniform = "RSH-RVV10 NSCF Uniform"
    RSH_RVV10_Unrecognized = "RSH-RVV10 Unrecognized"
    RSH_RVV10_U_Static = "RSH-RVV10+U Static"
    RSH_RVV10_U_Structure_Optimization = "RSH-RVV10+U Structure Optimization"
    RSH_RVV10_U_Constrained_Structure_Optimization = (
        "RSH-RVV10+U Constrained Structure Optimization"
    )
    RSH_RVV10_U_Molecular_Dynamics = "RSH-RVV10+U Molecular Dynamics"
    RSH_RVV10_U_NSCF_Line = "RSH-RVV10+U NSCF Line"
    RSH_RVV10_U_NSCF_Uniform = "RSH-RVV10+U NSCF Uniform"
    RSH_RVV10_U_Unrecognized = "RSH-RVV10+U Unrecognized"
    RSH_LMKLL_Static = "RSH-LMKLL Static"
    RSH_LMKLL_Structure_Optimization = "RSH-LMKLL Structure Optimization"
    RSH_LMKLL_Constrained_Structure_Optimization = (
        "RSH-LMKLL Constrained Structure Optimization"
    )
    RSH_LMKLL_Molecular_Dynamics = "RSH-LMKLL Molecular Dynamics"
    RSH_LMKLL_NSCF_Line = "RSH-LMKLL NSCF Line"
    RSH_LMKLL_NSCF_Uniform = "RSH-LMKLL NSCF Uniform"
    RSH_LMKLL_Unrecognized = "RSH-LMKLL Unrecognized"
    RSH_LMKLL_U_Static = "RSH-LMKLL+U Static"
    RSH_LMKLL_U_Structure_Optimization = "RSH-LMKLL+U Structure Optimization"
    RSH_LMKLL_U_Constrained_Structure_Optimization = (
        "RSH-LMKLL+U Constrained Structure Optimization"
    )
    RSH_LMKLL_U_Molecular_Dynamics = "RSH-LMKLL+U Molecular Dynamics"
    RSH_LMKLL_U_NSCF_Line = "RSH-LMKLL+U NSCF Line"
    RSH_LMKLL_U_NSCF_Uniform = "RSH-LMKLL+U NSCF Uniform"
    RSH_LMKLL_U_Unrecognized = "RSH-LMKLL+U Unrecognized"
    RSH_DRSLL_Static = "RSH-DRSLL Static"
    RSH_DRSLL_Structure_Optimization = "RSH-DRSLL Structure Optimization"
    RSH_DRSLL_Constrained_Structure_Optimization = (
        "RSH-DRSLL Constrained Structure Optimization"
    )
    RSH_DRSLL_Molecular_Dynamics = "RSH-DRSLL Molecular Dynamics"
    RSH_DRSLL_NSCF_Line = "RSH-DRSLL NSCF Line"
    RSH_DRSLL_NSCF_Uniform = "RSH-DRSLL NSCF Uniform"
    RSH_DRSLL_Unrecognized = "RSH-DRSLL Unrecognized"
    RSH_DRSLL_U_Static = "RSH-DRSLL+U Static"
    RSH_DRSLL_U_Structure_Optimization = "RSH-DRSLL+U Structure Optimization"
    RSH_DRSLL_U_Constrained_Structure_Optimization = (
        "RSH-DRSLL+U Constrained Structure Optimization"
    )
    RSH_DRSLL_U_Molecular_Dynamics = "RSH-DRSLL+U Molecular Dynamics"
    RSH_DRSLL_U_NSCF_Line = "RSH-DRSLL+U NSCF Line"
    RSH_DRSLL_U_NSCF_Uniform = "RSH-DRSLL+U NSCF Uniform"
    RSH_DRSLL_U_Unrecognized = "RSH-DRSLL+U Unrecognized"
    RSH_D3_Static = "RSH-D3 Static"
    RSH_D3_Structure_Optimization = "RSH-D3 Structure Optimization"
    RSH_D3_Constrained_Structure_Optimization = (
        "RSH-D3 Constrained Structure Optimization"
    )
    RSH_D3_Molecular_Dynamics = "RSH-D3 Molecular Dynamics"
    RSH_D3_NSCF_Line = "RSH-D3 NSCF Line"
    RSH_D3_NSCF_Uniform = "RSH-D3 NSCF Uniform"
    RSH_D3_Unrecognized = "RSH-D3 Unrecognized"
    RSH_D3_U_Static = "RSH-D3+U Static"
    RSH_D3_U_Structure_Optimization = "RSH-D3+U Structure Optimization"
    RSH_D3_U_Constrained_Structure_Optimization = (
        "RSH-D3+U Constrained Structure Optimization"
    )
    RSH_D3_U_Molecular_Dynamics = "RSH-D3+U Molecular Dynamics"
    RSH_D3_U_NSCF_Line = "RSH-D3+U NSCF Line"
    RSH_D3_U_NSCF_Uniform = "RSH-D3+U NSCF Uniform"
    RSH_D3_U_Unrecognized = "RSH-D3+U Unrecognized"
    RSH_D2_Static = "RSH-D2 Static"
    RSH_D2_Structure_Optimization = "RSH-D2 Structure Optimization"
    RSH_D2_Constrained_Structure_Optimization = (
        "RSH-D2 Constrained Structure Optimization"
    )
    RSH_D2_Molecular_Dynamics = "RSH-D2 Molecular Dynamics"
    RSH_D2_NSCF_Line = "RSH-D2 NSCF Line"
    RSH_D2_NSCF_Uniform = "RSH-D2 NSCF Uniform"
    RSH_D2_Unrecognized = "RSH-D2 Unrecognized"
    RSH_D2_U_Static = "RSH-D2+U Static"
    RSH_D2_U_Structure_Optimization = "RSH-D2+U Structure Optimization"
    RSH_D2_U_Constrained_Structure_Optimization = (
        "RSH-D2+U Constrained Structure Optimization"
    )
    RSH_D2_U_Molecular_Dynamics = "RSH-D2+U Molecular Dynamics"
    RSH_D2_U_NSCF_Line = "RSH-D2+U NSCF Line"
    RSH_D2_U_NSCF_Uniform = "RSH-D2+U NSCF Uniform"
    RSH_D2_U_Unrecognized = "RSH-D2+U Unrecognized"
    RSH_D3_BJ_Static = "RSH-D3(BJ) Static"
    RSH_D3_BJ_Structure_Optimization = "RSH-D3(BJ) Structure Optimization"
    RSH_D3_BJ_Constrained_Structure_Optimization = (
        "RSH-D3(BJ) Constrained Structure Optimization"
    )
    RSH_D3_BJ_Molecular_Dynamics = "RSH-D3(BJ) Molecular Dynamics"
    RSH_D3_BJ_NSCF_Line = "RSH-D3(BJ) NSCF Line"
    RSH_D3_BJ_NSCF_Uniform = "RSH-D3(BJ) NSCF Uniform"
    RSH_D3_BJ_Unrecognized = "RSH-D3(BJ) Unrecognized"
    RSH_D3_BJ_U_Static = "RSH-D3(BJ)+U Static"
    RSH_D3_BJ_U_Structure_Optimization = "RSH-D3(BJ)+U Structure Optimization"
    RSH_D3_BJ_U_Constrained_Structure_Optimization = (
        "RSH-D3(BJ)+U Constrained Structure Optimization"
    )
    RSH_D3_BJ_U_Molecular_Dynamics = "RSH-D3(BJ)+U Molecular Dynamics"
    RSH_D3_BJ_U_NSCF_Line = "RSH-D3(BJ)+U NSCF Line"
    RSH_D3_BJ_U_NSCF_Uniform = "RSH-D3(BJ)+U NSCF Uniform"
    RSH_D3_BJ_U_Unrecognized = "RSH-D3(BJ)+U Unrecognized"
