# luxor-openapi-asyncio
API specification for FXLuminaire's Luxor lighting system.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import luxor_openapi_asyncio
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import luxor_openapi_asyncio
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import luxor_openapi_asyncio
from luxor_openapi_asyncio.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = luxor_openapi_asyncio.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with luxor_openapi_asyncio.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = luxor_openapi_asyncio.ControllerApi(api_client)
    
    try:
        # Retrieve controller details
        api_response = api_instance.controller_name()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ControllerApi->controller_name: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ControllerApi* | [**controller_name**](docs/ControllerApi.md#controller_name) | **POST** /ControllerName.json | Retrieve controller details
*GroupsApi* | [**group_list_add**](docs/GroupsApi.md#group_list_add) | **POST** /GroupListAdd.json | Add a group
*GroupsApi* | [**group_list_clear**](docs/GroupsApi.md#group_list_clear) | **POST** /GroupListClear.json | TBD
*GroupsApi* | [**group_list_delete**](docs/GroupsApi.md#group_list_delete) | **POST** /GroupListDelete.json | Delete a group
*GroupsApi* | [**group_list_get**](docs/GroupsApi.md#group_list_get) | **POST** /GroupListGet.json | Retrieve all groups
*GroupsApi* | [**group_list_rename**](docs/GroupsApi.md#group_list_rename) | **POST** /GroupListRename.json | Rename a group
*GroupsApi* | [**group_list_reorder**](docs/GroupsApi.md#group_list_reorder) | **POST** /GroupListReorder.json | Reorder all groups
*GroupsApi* | [**illuminate_group**](docs/GroupsApi.md#illuminate_group) | **POST** /IlluminateGroup.json | Turn on a group of lights
*LightsApi* | [**assign_light**](docs/LightsApi.md#assign_light) | **POST** /AssignLight.json | Assign a light to a group
*LightsApi* | [**extinguish_all**](docs/LightsApi.md#extinguish_all) | **POST** /ExtinguishAll.json | Turn off all lights
*LightsApi* | [**flash_lights**](docs/LightsApi.md#flash_lights) | **POST** /FlashLights.json | Flash all lights
*LightsApi* | [**illuminate_all**](docs/LightsApi.md#illuminate_all) | **POST** /IlluminateAll.json | Turn on all lights
*ThemesApi* | [**illuminate_theme**](docs/ThemesApi.md#illuminate_theme) | **POST** /IlluminateTheme.json | Activate a theme
*ThemesApi* | [**theme_clear**](docs/ThemesApi.md#theme_clear) | **POST** /ThemeClear.json | TBD
*ThemesApi* | [**theme_get**](docs/ThemesApi.md#theme_get) | **POST** /ThemeGet.json | Retrieve a theme
*ThemesApi* | [**theme_list_add**](docs/ThemesApi.md#theme_list_add) | **POST** /ThemeListAdd.json | Add a theme
*ThemesApi* | [**theme_list_clear**](docs/ThemesApi.md#theme_list_clear) | **POST** /ThemeListClear.json | TBD
*ThemesApi* | [**theme_list_delete**](docs/ThemesApi.md#theme_list_delete) | **POST** /ThemeListDelete.json | Delete a theme
*ThemesApi* | [**theme_list_get**](docs/ThemesApi.md#theme_list_get) | **POST** /ThemeListGet.json | Retrieve list of themes
*ThemesApi* | [**theme_list_rename**](docs/ThemesApi.md#theme_list_rename) | **POST** /ThemeListRename.json | Rename a theme
*ThemesApi* | [**theme_list_reorder**](docs/ThemesApi.md#theme_list_reorder) | **POST** /ThemeListReorder.json | Rename a theme
*ThemesApi* | [**theme_set**](docs/ThemesApi.md#theme_set) | **POST** /ThemeSet.json | Activate a theme


## Documentation For Models

 - [AssignLightRequest](docs/AssignLightRequest.md)
 - [AssignLightResponse](docs/AssignLightResponse.md)
 - [ControllerNameResponse](docs/ControllerNameResponse.md)
 - [ExtinguishAllResponse](docs/ExtinguishAllResponse.md)
 - [FlashLightsRequest](docs/FlashLightsRequest.md)
 - [FlashLightsResponse](docs/FlashLightsResponse.md)
 - [Group](docs/Group.md)
 - [GroupListAddRequest](docs/GroupListAddRequest.md)
 - [GroupListAddResponse](docs/GroupListAddResponse.md)
 - [GroupListClearResponse](docs/GroupListClearResponse.md)
 - [GroupListDeleteRequest](docs/GroupListDeleteRequest.md)
 - [GroupListDeleteResponse](docs/GroupListDeleteResponse.md)
 - [GroupListGetResponse](docs/GroupListGetResponse.md)
 - [GroupListRenameRequest](docs/GroupListRenameRequest.md)
 - [GroupListRenameResponse](docs/GroupListRenameResponse.md)
 - [GroupListReorderRequest](docs/GroupListReorderRequest.md)
 - [GroupListReorderResponse](docs/GroupListReorderResponse.md)
 - [IlluminateAllResponse](docs/IlluminateAllResponse.md)
 - [IlluminateGroupRequest](docs/IlluminateGroupRequest.md)
 - [IlluminateGroupResponse](docs/IlluminateGroupResponse.md)
 - [IlluminateThemeRequest](docs/IlluminateThemeRequest.md)
 - [IlluminateThemeResponse](docs/IlluminateThemeResponse.md)
 - [Theme](docs/Theme.md)
 - [ThemeClearRequest](docs/ThemeClearRequest.md)
 - [ThemeClearResponse](docs/ThemeClearResponse.md)
 - [ThemeGetRequest](docs/ThemeGetRequest.md)
 - [ThemeGetResponse](docs/ThemeGetResponse.md)
 - [ThemeGroup](docs/ThemeGroup.md)
 - [ThemeListAddRequest](docs/ThemeListAddRequest.md)
 - [ThemeListAddResponse](docs/ThemeListAddResponse.md)
 - [ThemeListClearResponse](docs/ThemeListClearResponse.md)
 - [ThemeListDeleteRequest](docs/ThemeListDeleteRequest.md)
 - [ThemeListDeleteResponse](docs/ThemeListDeleteResponse.md)
 - [ThemeListGetResponse](docs/ThemeListGetResponse.md)
 - [ThemeListRenameRequest](docs/ThemeListRenameRequest.md)
 - [ThemeListRenameResponse](docs/ThemeListRenameResponse.md)
 - [ThemeListReorderRequest](docs/ThemeListReorderRequest.md)
 - [ThemeListReorderResponse](docs/ThemeListReorderResponse.md)
 - [ThemeSetRequest](docs/ThemeSetRequest.md)
 - [ThemeSetResponse](docs/ThemeSetResponse.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




