def set_icon_color(theme, user_dir):
    icon_list = {'arrow_right.svg': f"""
        <svg width="96" height="96" xmlns="http://www.w3.org/2000/svg">
            <path style="fill:{theme.fg};fill-opacity:1;fill-rule:nonzero;stroke:none" d="M46.3 64c-1.6 1.465-3.3 
            1.816-5.1 1.05-1.802-.765-2.7-2.218-2.7-4.35V35.2c0-2.067.898-3.485 2.7-4.25 1.8-.766 3.5-.415 5.1 
            1.05L59 44.8c.332.4.648.9.95 1.5.3.598.448 1.165.448 1.7 0 .602-.148 1.184-.449 1.75-.3.566-.617 
            1.016-.949 1.352Zm0 0" transform="matrix(1.4853 0 0 1.4853 -24.074 -23.607)"/> </svg> """,

                 'arrow_right(tree_item).svg': f"""
            <svg width="96" height="96" xmlns="http://www.w3.org/2000/svg">
                <path style="fill:{theme.container['fg']};fill-opacity:1;fill-rule:nonzero;stroke:none" d="M46.3 64c-1.6 1.465-3.3 
                1.816-5.1 1.05-1.802-.765-2.7-2.218-2.7-4.35V35.2c0-2.067.898-3.485 2.7-4.25 1.8-.766 3.5-.415 5.1 
                1.05L59 44.8c.332.4.648.9.95 1.5.3.598.448 1.165.448 1.7 0 .602-.148 1.184-.449 1.75-.3.566-.617 
                1.016-.949 1.352Zm0 0" transform="matrix(1.4853 0 0 1.4853 -24.074 -23.607)"/> </svg> """,

                 'arrow_left.svg': f"""
        <svg width="96" height="96" xmlns="http://www.w3.org/2000/svg">
            <path style="fill:{theme.fg};fill-opacity:1;fill-rule:nonzero;stroke:none" d="M46.3 64c-1.6 1.465-3.3 
            1.816-5.1 1.05-1.802-.765-2.7-2.218-2.7-4.35V35.2c0-2.067.898-3.485 2.7-4.25 1.8-.766 3.5-.415 5.1 
            1.05L59 44.8c.332.4.648.9.95 1.5.3.598.448 1.165.448 1.7 0 .602-.148 1.184-.449 1.75-.3.566-.617 
            1.016-.949 1.352Zm0 0" transform="matrix(-1.4853 0 0 1.4853 120.82 -23.607)"/> </svg> """,

                 'arrow_down.svg': f""" <svg width="96" height="96" xmlns="http://www.w3.org/2000/svg"> <path 
                 style="fill:{theme.line_edit['fg']};fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1.4853" d="M25.608 
                 43.01c-2.176-2.376-2.698-4.901-1.56-7.575 1.136-2.676 3.295-4.01 6.461-4.01h37.875c3.07 0 5.177 
                 1.334 6.313 4.01 1.138 2.674.616 5.199-1.56 7.575L54.126 61.874c-.595.493-1.337.962-2.228 
                 1.41-.889.446-1.73.666-2.525.666a5.46 5.46 0 0 1-2.6-.667c-.84-.446-1.509-.916-2.008-1.41zm0 0"/> 
                 </svg> """,

                 'arrow_down(tree_item).svg': f""" <svg width="96" height="96" xmlns="http://www.w3.org/2000/svg"> <path 
                 style="fill:{theme.container['fg']};fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1.4853" d="M25.608 
                 43.01c-2.176-2.376-2.698-4.901-1.56-7.575 1.136-2.676 3.295-4.01 6.461-4.01h37.875c3.07 0 5.177 
                 1.334 6.313 4.01 1.138 2.674.616 5.199-1.56 7.575L54.126 61.874c-.595.493-1.337.962-2.228 
                 1.41-.889.446-1.73.666-2.525.666a5.46 5.46 0 0 1-2.6-.667c-.84-.446-1.509-.916-2.008-1.41zm0 0"/> 
                 </svg> """,

                 'update.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M23.9 
                 41.05q-7.15 0-12.125-4.975T6.8 24q0-7.1 4.975-12.1t12.125-5q4.45 0 7.95 1.8t6 
                 5.15V8.6q0-.7.45-1.2t1.2-.5q.75 0 1.275.5.525.5.525 1.2v10.25q0 1-.7 1.65-.7.65-1.65.65H28.7q-.75 
                 0-1.225-.45Q27 20.25 27 19.45t.475-1.25q.475-.45 
                 1.225-.45h6.4q-2-2.9-4.725-4.6-2.725-1.7-6.475-1.7-5.25 0-8.9 3.625Q11.35 18.7 11.35 24q0 5.25 3.65 
                 8.875t8.9 3.625q3.45 0 6.55-1.875 3.1-1.875 4.7-5.075.25-.5.9-.85t1.25-.35q1.4 0 2.05.925.65.925 0 
                 2.075-2.1 4.4-6.275 7.05-4.175 2.65-9.175 2.65Z" style="fill:{theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'home.svg': f""" <svg height="48" viewBox="0 0 24 24" width="48" xmlns="http://www.w3.org/2000/svg"> 
                 <path d="M0 0h24v24H0V0z" fill="none"/> <path d="M10 19v-5h4v5c0 .55.45 1 1 1h3c.55 0 1-.45 
                 1-1v-7h1.7c.46 0 .68-.57.33-.87L12.67 3.6c-.38-.34-.96-.34-1.34 0l-8.36 
                 7.53c-.34.3-.13.87.33.87H5v7c0 .55.45 1 1 1h3c.55 0 1-.45 1-1z" style="fill:
                 {theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'bookmark.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M12.15 
                 42.3q-1.15.45-2.2-.2-1.05-.65-1.05-1.85v-31q0-1.85 1.375-3.225T13.45 4.65h21.1q1.8 0 3.2 1.375 1.4 
                 1.375 1.4 3.225v31q0 1.2-1.075 1.85-1.075.65-2.175.2L24 37.25Z" style="fill:
                 {theme.address_line_frame['fg']};fill-opacity:1"/> 
        </svg>""",

                 'bookmark_empty.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path 
                 d="M13.45 36.75 24 32.35l10.55 4.4V9.25h-21.1Zm-1.3 
                 5.55q-1.15.45-2.2-.2-1.05-.65-1.05-1.85v-31q0-1.9 1.375-3.25t3.175-1.35h21.1q1.8 0 3.2 1.35 1.4 1.35 
                 1.4 3.25v31q0 1.2-1.075 1.85-1.075.65-2.175.2L24 37.25Zm1.3-33.05h21.1H24Z" style="fill:
                 {theme.address_line_frame['fg']};fill-opacity:1"/> 
        </svg>""",

                 'bookmark_empty(sections).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path 
                     d="M13.45 36.75 24 32.35l10.55 4.4V9.25h-21.1Zm-1.3 
                     5.55q-1.15.45-2.2-.2-1.05-.65-1.05-1.85v-31q0-1.9 1.375-3.25t3.175-1.35h21.1q1.8 0 3.2 1.35 1.4 1.35 
                     1.4 3.25v31q0 1.2-1.075 1.85-1.075.65-2.175.2L24 37.25Zm1.3-33.05h21.1H24Z" style="fill:
                     {theme.sections_panel['fg']};fill-opacity:1"/> 
            </svg>""",

                 'options.svg': f""" <svg viewBox="0 0 72 72" width="64" height="64" 
                 xmlns="http://www.w3.org/2000/svg"> <path d="M56 48a4 4 0 0 1 0 8H16a4 4 0 0 1 0-8h40zm0-16a4 4 0 0 
                 1 0 8H16a4 4 0 0 1 0-8h40zm0-16a4 4 0 0 1 0 8H16a4 4 0 0 1 0-8h40z" style="fill:
                 {theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'save.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M9.5 
                 43.05q-1.85 0-3.2-1.35t-1.35-3.2v-29q0-1.85 1.35-3.225T9.5 4.9h23.2q.9 0 1.75.35t1.5 1.05l5.75 
                 5.75q.7.65 1.05 1.5.35.85.35 1.75v23.2q0 1.85-1.375 3.2T38.5 43.05ZM24 35.2q2.1 0 
                 3.6-1.475t1.5-3.625q0-2.1-1.475-3.6T24 25q-2.1 0-3.6 1.475T18.9 30.1q0 2.1 1.475 3.6T24 
                 35.2Zm-9.55-16.05H27.6q1 0 1.65-.65.65-.65.65-1.6v-2.45q0-.95-.65-1.6-.65-.65-1.65-.65H14.45q-.95 
                 0-1.6.65-.65.65-.65 1.6v2.45q0 .95.65 1.6.65.65 1.6.65Z" style="fill:{theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'select.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M18.9 
                 35.85q-.45 0-.875-.175t-.675-.525l-9.05-9q-.65-.65-.65-1.65 0-1 .65-1.65.65-.65 
                 1.625-.65t1.675.65l7.3 7.35 17.5-17.5q.7-.65 1.65-.675.95-.025 1.6.675.7.7.7 1.675 0 .975-.7 
                 1.625L20.5 35.15q-.3.35-.725.525-.425.175-.875.175Z" style="fill:{theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'hide.svg': f"""
        <svg width="256" height="256" xmlns="http://www.w3.org/2000/svg">
            <circle style="fill:{theme.title_buttons_color['min']};fill-rule:evenodd;stroke-width:4.79418;stroke
            -linecap:round;stroke-linejoin:round;stroke-dashoffset:8.7005;fill-opacity:1" cx="127.87" cy="128.17" 
            r="125.364"/> </svg>""",

                 'close_window.svg': f"""
        <svg width="256" height="256" xmlns="http://www.w3.org/2000/svg">
            <circle style="fill:{theme.title_buttons_color['close']};fill-rule:evenodd;stroke-width:4.79418;stroke
            -linecap:round;stroke-linejoin:round;stroke-dashoffset:8.7005;fill-opacity:1" cx="127.87" cy="128.17" 
            r="125.364"/> </svg>""",

                 'settings.svg': f"""
        <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg">
            <path d="M27.6 44.85h-7.2q-.7 0-1.275-.425T18.5 43.25l-.8-4.95q-.75-.25-1.7-.775t-1.65-1.075l-4.5 2.1q-.65.35-1.4.075-.75-.275-1.1-.975l-3.6-6.45q-.4-.65-.2-1.35.2-.7.8-1.1l4.1-3.05q-.05-.35-.075-.875-.025-.525-.025-.925 0-.35.025-.825t.075-.875l-4.1-3q-.65-.45-.825-1.15-.175-.7.225-1.35l3.6-6.4q.45-.65 1.125-.9t1.375.05l4.45 2.05q.65-.5 1.625-1.05T17.7 9.6l.8-4.9q.05-.75.625-1.175Q19.7 3.1 20.4 3.1h7.2q.7 0 1.275.425T29.55 4.7l.75 4.9q.8.3 1.8.85t1.6 1.05l4.45-2.05q.65-.35 1.4-.075.75.275 1.1.925l3.6 6.35q.4.65.225 1.375-.175.725-.775 1.175l-4.2 2.9q.05.45.1.975.05.525.05.925t-.05.9-.05.9l4.15 2.95q.55.45.75 1.15.2.7-.2 1.35l-3.6 6.45q-.45.7-1.15.95t-1.35-.1l-4.5-2.1q-.7.5-1.625 1.075t-1.675.775l-.8 4.95q-.1.75-.675 1.175-.575.425-1.275.425Zm-3.65-13.9q2.9 0 4.95-2.05 2.05-2.05 2.05-4.95 0-2.85-2.05-4.925-2.05-2.075-4.95-2.075-2.95 0-4.975 2.05-2.025 2.05-2.025 4.95 0 2.9 2.025 4.95Q21 30.95 23.95 30.95Zm-.05-3.45q-1.45 0-2.475-1.05-1.025-1.05-1.025-2.5t1.025-2.5q1.025-1.05 2.525-1.05 1.45 0 2.5 1.05t1.05 2.5q0 1.5-1.05 2.525T23.9 27.5Zm.1-3.55ZM21.9 41h4.2l.7-5.65q1.7-.4 3.2-1.25 1.5-.85 2.8-2.1l5.25 2.3 1.85-3.45-4.65-3.4q.25-.85.4-1.725.15-.875.15-1.775 0-.9-.15-1.725-.15-.825-.35-1.725l4.65-3.4-1.9-3.45-5.3 2.3q-1.15-1.35-2.65-2.275-1.5-.925-3.3-1.175l-.65-5.55h-4.3l-.65 5.55q-1.8.4-3.325 1.275-1.525.875-2.675 2.125L10 13.65 8.05 17.1l4.65 3.4q-.25.9-.375 1.75t-.125 1.7q0 .85.125 1.725.125.875.375 1.775l-4.65 3.4L10 34.3l5.2-2.3q1.3 1.3 2.825 2.175 1.525.875 3.175 1.225Z" style="fill:{theme.sections_panel['fg']};fill-opacity:1"/> 
        </svg>""",

                 'history.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="m25.75 
                 23.2 5.6 5.5q.6.6.575 1.325-.025.725-.575 
                 1.275-.55.55-1.25.55t-1.25-.55l-6.15-6.05q-.25-.25-.4-.6-.15-.35-.15-.8v-8.5q0-.75.525-1.275.525
                 -.525 1.225-.525.8 0 1.325.525.525.525.525 1.275ZM24.1 42.85q-7.2 0-12.325-4.55Q6.65 33.75 5.6 
                 26.85q-.2-.85.3-1.55.5-.7 1.35-.75.7-.05 1.3.375.6.425.75 1.075.95 5.55 4.975 9.275Q18.3 39 24.05 
                 39q6.3 0 10.7-4.45 4.4-4.45 4.4-10.8 0-6.2-4.425-10.475Q30.3 9 24.1 9q-3.45 0-6.45 1.55t-5.15 
                 4.1h3.35q.8 0 1.325.525.525.525.525 1.325 0 .75-.525 1.275-.525.525-1.325.525h-7.8q-.9 
                 0-1.425-.55t-.525-1.4v-7.8q0-.75.525-1.25t1.225-.5q.8 0 1.325.5.525.5.525 1.25v3.4q2.6-3.2 6.375-5 
                 3.775-1.8 8.025-1.8 3.9 0 7.35 1.475 3.45 1.475 6 4t4.075 5.95Q43.05 20 43.05 23.9q0 3.9-1.525 
                 7.375t-4.075 6.05q-2.55 2.575-6 4.05Q28 42.85 24.1 42.85Z" style="fill:{theme.sections_panel['fg']};fill-opacity:1"/> 
        </svg>""",

                 'downloads.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M24 
                 31.45q-.35 0-.7-.15t-.65-.45L14.6 22.8q-.55-.55-.55-1.375T14.7 20q.55-.55 1.325-.55.775 0 
                 1.425.6l4.65 4.75V8.45q0-.8.575-1.375T24.05 6.5q.8 0 1.35.575t.55 1.375V24.8l4.75-4.75q.55-.6 
                 1.35-.6t1.4.6q.55.55.55 1.375t-.55 1.375l-8.1 8.05q-.25.3-.625.45-.375.15-.725.15ZM10.75 41.1q-1.55 
                 0-2.7-1.15Q6.9 38.8 6.9 37.2v-5.75q0-.8.575-1.375T8.85 29.5q.8 0 1.35.575t.55 
                 1.375v5.75h26.5v-5.75q0-.8.575-1.375T39.2 29.5q.8 0 1.35.575t.55 1.375v5.75q0 1.6-1.175 2.75T37.25 
                 41.1Z" style="fill:{theme.sections_panel['fg']};fill-opacity:1"/> 
        </svg>""",

                 'folder.svg': f"""<svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M7 
                 40q-1.15 0-2.075-.925Q4 38.15 4 37V11q0-1.15.925-2.075Q5.85 8 7 8h14.05l3 3H41q1.15 0 2.075.925Q44 
                 12.85 44 14H7v23l5.1-20H47l-5.35 20.7q-.3 1.2-1.1 1.75T38.5 40Z" style="fill:{theme.container_title_btn['fg']};fill-opacity:1"/> 
                 </svg>""",

                 'folder(tree_item).svg': f"""<svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M7 
                     40q-1.15 0-2.075-.925Q4 38.15 4 37V11q0-1.15.925-2.075Q5.85 8 7 8h14.05l3 3H41q1.15 0 2.075.925Q44 
                     12.85 44 14H7v23l5.1-20H47l-5.35 20.7q-.3 1.2-1.1 1.75T38.5 40Z" style="fill:{theme.tree_widget['button_fg']};fill-opacity:1"/> 
                     </svg>""",

                 'restart.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M20.1 
                 42.45q-5.65-1.3-9.35-5.85-3.7-4.55-3.7-10.5 0-3.4 1.35-6.4 1.35-3 3.85-5.15.45-.7 1.35-.675.9.025 
                 1.6.625.5.55.525 1.325.025.775-.575 1.425-1.85 1.75-2.9 4.025Q11.2 23.55 11.2 26.1q0 4.45 2.675 
                 7.825T20.8 38.3q.7.2 1.2.8.5.6.5 1.3 0 1.15-.775 1.7t-1.625.35Zm8 
                 0q-.95.3-1.7-.325t-.75-1.675q0-.6.475-1.275.475-.675 1.225-.875 4.25-1 6.875-4.375T36.85 
                 26.1q0-5.2-3.525-8.925Q29.8 13.45 24.6 13.3h-1.05l1.85 1.85q.45.55.425 1.275-.025.725-.475 
                 1.175-.5.5-1.275.5-.775 0-1.275-.5l-5.1-5.05q-.25-.3-.45-.675-.2-.375-.2-.775 
                 0-.45.2-.8.2-.35.45-.65l5.1-5.2q.5-.45 1.25-.425.75.025 1.3.475.45.55.45 1.3t-.4 1.15L23.25 
                 9.1h1.05q7 0 11.875 5t4.875 12q0 5.95-3.675 10.525T28.1 42.45Z" style="fill:
                 {theme.container_title_btn['fg']};fill-opacity:1"/></svg>""",

                 'clean.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M36.35 
                 26.05h-24.7q-.9 0-1.5-.6T9.55 24q0-.85.6-1.475.6-.625 1.5-.625h24.7q.9 0 1.5.625t.6 1.475q0 .85-.6 
                 1.45t-1.5.6Zm-4.5 9.9H7.15q-.9 0-1.5-.625t-.6-1.475q0-.9.6-1.5t1.5-.6h24.7q.9 0 1.5.6t.6 1.5q0 .9-.6 
                 1.5t-1.5.6Zm9-19.75h-24.7q-.85 0-1.475-.6-.625-.6-.625-1.5 0-.85.625-1.475Q15.3 12 16.15 12h24.7q.9 
                 0 1.525.625Q43 13.25 43 14.1q0 .95-.625 1.525t-1.525.575Z" style="fill:{theme.fg};fill-opacity:1"/> 
        </svg>""",

                 'clean(container_title_btn).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M36.35 
                     26.05h-24.7q-.9 0-1.5-.6T9.55 24q0-.85.6-1.475.6-.625 1.5-.625h24.7q.9 0 1.5.625t.6 1.475q0 .85-.6 
                     1.45t-1.5.6Zm-4.5 9.9H7.15q-.9 0-1.5-.625t-.6-1.475q0-.9.6-1.5t1.5-.6h24.7q.9 0 1.5.6t.6 1.5q0 .9-.6 
                     1.5t-1.5.6Zm9-19.75h-24.7q-.85 0-1.475-.6-.625-.6-.625-1.5 0-.85.625-1.475Q15.3 12 16.15 12h24.7q.9 
                     0 1.525.625Q43 13.25 43 14.1q0 .95-.625 1.525t-1.525.575Z" style="fill:{theme.container_title_btn['fg']};fill-opacity:1"/> 
            </svg>""",

                 'close.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="m24 
                 27.2-9.9 9.9q-.7.7-1.625.7t-1.575-.7q-.7-.65-.7-1.575 0-.925.7-1.575L20.8 
                 24l-9.9-9.9q-.65-.65-.65-1.6 0-.95.65-1.6.6-.65 1.55-.65.95 0 1.65.65l9.9 9.95 9.95-10q.65-.65 
                 1.575-.65.925 0 1.625.65.65.7.65 1.625t-.65 1.575l-9.95 9.9 9.9 9.95q.7.7.7 1.625t-.7 
                 1.575q-.65.7-1.6.7-.95 0-1.55-.7Z" style="fill:{theme.fg};fill-opacity:1"/> 
        </svg> """,

                 'close(tab_bar).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="m24 
                     27.2-9.9 9.9q-.7.7-1.625.7t-1.575-.7q-.7-.65-.7-1.575 0-.925.7-1.575L20.8 
                     24l-9.9-9.9q-.65-.65-.65-1.6 0-.95.65-1.6.6-.65 1.55-.65.95 0 1.65.65l9.9 9.95 9.95-10q.65-.65 
                     1.575-.65.925 0 1.625.65.65.7.65 1.625t-.65 1.575l-9.95 9.9 9.9 9.95q.7.7.7 1.625t-.7 
                     1.575q-.65.7-1.6.7-.95 0-1.55-.7Z" style="fill:{theme.tab_widget['fg']};fill-opacity:1"/> 
            </svg> """,

                 'close(address_line_frame).svg': f""" <svg height="48" width="48" 
                 xmlns="http://www.w3.org/2000/svg"> <path d="m24 27.2-9.9 
                 9.9q-.7.7-1.625.7t-1.575-.7q-.7-.65-.7-1.575 0-.925.7-1.575L20.8 24l-9.9-9.9q-.65-.65-.65-1.6 
                 0-.95.65-1.6.6-.65 1.55-.65.95 0 1.65.65l9.9 9.95 9.95-10q.65-.65 1.575-.65.925 0 1.625.65.65.7.65 
                 1.625t-.65 1.575l-9.95 9.9 9.9 9.95q.7.7.7 1.625t-.7 1.575q-.65.7-1.6.7-.95 0-1.55-.7Z" 
                 style="fill:{theme.address_line_frame['fg']};fill-opacity:1"/> </svg> """,

                 'close(address_panel).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> 
                 <path d="m24 27.2-9.9 9.9q-.7.7-1.625.7t-1.575-.7q-.7-.65-.7-1.575 0-.925.7-1.575L20.8 
                 24l-9.9-9.9q-.65-.65-.65-1.6 0-.95.65-1.6.6-.65 1.55-.65.95 0 1.65.65l9.9 9.95 9.95-10q.65-.65 
                 1.575-.65.925 0 1.625.65.65.7.65 1.625t-.65 1.575l-9.95 9.9 9.9 9.95q.7.7.7 1.625t-.7 
                 1.575q-.65.7-1.6.7-.95 0-1.55-.7Z" style="fill:{theme.fg};fill-opacity:1"/></svg> """,

                 'close(tree_item).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> 
                     <path d="m24 27.2-9.9 9.9q-.7.7-1.625.7t-1.575-.7q-.7-.65-.7-1.575 0-.925.7-1.575L20.8 
                     24l-9.9-9.9q-.65-.65-.65-1.6 0-.95.65-1.6.6-.65 1.55-.65.95 0 1.65.65l9.9 9.95 9.95-10q.65-.65 
                     1.575-.65.925 0 1.625.65.65.7.65 1.625t-.65 1.575l-9.95 9.9 9.9 9.95q.7.7.7 1.625t-.7 
                     1.575q-.65.7-1.6.7-.95 0-1.55-.7Z" style="fill:{theme.tree_widget['button_fg']};fill-opacity:1"/>
                        </svg> """,

                 'add.svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path d="M24 
                 38.75q-.95 0-1.6-.625-.65-.625-.65-1.675V26.3H11.5q-.9 0-1.575-.675Q9.25 24.95 9.25 24q0-1 
                 .675-1.625t1.575-.625h10.25V11.5q0-1 .675-1.625T24 9.25q.95 0 1.625.625T26.3 11.5v10.25h10.2q.95 0 
                 1.625.625T38.8 24q0 1-.675 1.65-.675.65-1.625.65H26.3v10.15q0 1.05-.675 1.675T24 38.75Z" 
                 style="fill:{theme.fg};fill-opacity:1"/></svg>""",

                 'add(tab_bar).svg': f""" <svg height="48" width="48" xmlns="http://www.w3.org/2000/svg"> <path 
                 d="M24 38.75q-.95 0-1.6-.625-.65-.625-.65-1.675V26.3H11.5q-.9 0-1.575-.675Q9.25 24.95 9.25 24q0-1 
                 .675-1.625t1.575-.625h10.25V11.5q0-1 .675-1.625T24 9.25q.95 0 1.625.625T26.3 11.5v10.25h10.2q.95 0 
                 1.625.625T38.8 24q0 1-.675 1.65-.675.65-1.625.65H26.3v10.15q0 1.05-.675 1.675T24 38.75Z" 
                 style="fill:{theme.tab_widget['button_fg']};fill-opacity:1"/></svg>""",

                 'lock(address_panel).svg': f"""<svg height="48" viewBox="0 96 960 960" width="48" 
                 xmlns="http://www.w3.org/2000/svg"> <path d="M222.152 981.5q-28.104 
                 0-48.117-20.013-20.013-20.014-20.013-48.117V483.674q0-28.203 20.013-48.286 20.013-20.084 
                 48.117-20.084h65.218v-90.739q0-80.366 56.265-136.857 56.266-56.491 136.414-56.491 80.147 0 136.364 
                 56.491t56.217 136.857v90.739h65.218q28.202 0 48.286 20.084 20.084 20.083 20.084 48.286V913.37q0 
                 28.103-20.084 48.117Q766.05 981.5 737.848 981.5H222.152Zm258.016-205.978q31.832 0 54.332-22.032 
                 22.5-22.031 22.5-52.968 0-30-22.668-54.5t-54.5-24.5q-31.832 0-54.332 24.5t-22.5 55q0 30.5 22.668 
                 52.5t54.5 22ZM355.5 415.304h249V324.62q0-52.388-36.152-88.711-36.152-36.322-88.174-36.322-52.022 
                 0-88.348 36.322Q355.5 272.232 355.5 324.62v90.684Z" style="fill:{theme.address_line_frame['fg']}
                 ;fill-opacity:1"/> </svg>""",

                 'no_encryption(address_panel).svg': f"""<svg height="48" viewBox="0 96 960 960" width="48" 
                 xmlns="http://www.w3.org/2000/svg"> <path d="M806.218 807.087 414.674 
                 415.304H604.5v-89.739q0-52.848-37.946-89.413-37.945-36.565-90.793-36.565-52.609 0-90.174 
                 36.326-37.565 36.326-37.565 89.174v23.565L288 288.63q9.717-68.804 63.217-113.108 53.5-44.305 
                 124.544-44.305 82.196 0 139.533 56.337 57.336 56.337 57.336 137.533v90.217h65.218q28.587 0 48.478 
                 19.892 19.892 19.891 19.892 48.478v323.413Zm65.326 270.743L767.826 974.109q-7.196 3.435-14.75 
                 5.413-7.554 1.978-15.228 1.978H222.152q-28.587 
                 0-48.359-19.891-19.771-19.892-19.771-48.239V483.674q0-24.913 16.239-44.207 16.239-19.293 
                 40.913-22.011L-14 192.522l44.913-44.152 885.305 885.54-44.674 43.92ZM429.239 634.522q-11 10.761-16.5 
                 24.88-5.5 14.12-5.5 29.12 0 31 22 52.5t53 21.5q15 0 28.5-5.12 13.5-5.119 24.5-15.88l-106-107Z" 
                 style="fill:{theme.address_line_frame['fg']};fill-opacity:1"/> </svg>""",
                 
                 'more(address_panel).svg': f"""<svg xmlns="http://www.w3.org/2000/svg" height="48" width="48"><path 
                 d="M9.25 26.95q-1.2 0-2.075-.875Q6.3 25.2 6.3 24q0-1.25.875-2.1.875-.85 2.075-.85 1.2 0 
                 2.1.85.9.85.9 2.05 0 1.25-.9 2.125t-2.1.875Zm14.8 0q-1.25 0-2.125-.875T21.05 
                 24q0-1.25.875-2.1.875-.85 2.075-.85 1.25 0 2.1.85.85.85.85 2.05 0 1.25-.85 2.125t-2.05.875Zm14.7 
                 0q-1.25 0-2.125-.875T35.75 24q0-1.25.875-2.1.875-.85 2.125-.85t2.125.85q.875.85.875 2.05 0 1.25-.875 
                 2.125t-2.125.875Z" style="fill:{theme.address_line_frame['fg']};fill-opacity:1"/></svg>""",

                 'file(address_panel).svg': f"""<svg xmlns="http://www.w3.org/2000/svg" height="48" width="48"><path 
                 d="M11.45 45.25q-1.95 0-3.325-1.375Q6.75 42.5 6.75 40.55V7.45q0-1.95 1.375-3.35Q9.5 2.7 11.45 
                 2.7H29.6l11.7 11.7v26.15q0 1.95-1.4 3.325-1.4 1.375-3.35 
                 1.375Zm15.65-28.5v-9.3H11.45v33.1h25.1v-23.8Zm-15.65-9.3v9.3-9.3 33.1-33.1Z" 
                 style="fill:{theme.address_line_frame['fg']};fill-opacity:1"/></svg>""",

                 'chip(address_panel).svg': f"""<svg xmlns="http://www.w3.org/2000/svg" height="48" viewBox="0 96 960 
                 960" width="48"><path d="M377 679V474h205v205H377Zm60-60h85v-85h-85v85Zm-81.065 
                 325.848v-82.87h-93.783q-27.599 
                 0-47.865-20.265-20.265-20.266-20.265-47.865v-93.783h-82.87v-62.71h82.87v-126.71h-82.87v-62.71h82.87v
                 -93.783q0-27.697 20.265-48.033 20.266-20.337 
                 47.865-20.337h93.783v-78.63h62.71v78.63h126.71v-78.63h62.71v78.63h93.783q27.697 0 48.033 20.337 
                 20.337 20.336 20.337 48.033v93.783h78.63v62.71h-78.63v126.71h78.63v62.71h-78.63v93.783q0 
                 27.599-20.337 47.865-20.336 20.265-48.033 
                 20.265h-93.783v82.87h-62.71v-82.87h-126.71v82.87h-62.71Zm345.913-151V354.152H262.152v439.696h439
                 .696ZM480 576Z" style="fill:{theme.address_line_frame['fg']};fill-opacity:1"/>/></svg>"""

                 }

    for name, data in icon_list.items():
        with open(f'{user_dir}/generated_icons/{name}', 'w') as file:
            file.write(data)
