# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cloudmage', 'cloudmage.gitutils']

package_data = \
{'': ['*'], 'cloudmage.gitutils': ['templates/*']}

install_requires = \
['PyGithub>=1.47,<2.0',
 'cloudmage-jinjautils>=1.0.5,<2.0.0',
 'progress>=1.5,<2.0',
 'requests>=2.22.0,<3.0.0']

setup_kwargs = {
    'name': 'cloudmage-gitutils',
    'version': '1.0.1',
    'description': 'Git based helpers and Report Templates',
    'long_description': '# CloudMage GitUtils Python3 Utility and Reporting Package\n\n<br/>\n\n![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/banners/cloudmage-nebula-glow.png)\n\n<br/>\n\n![PyTests](https://github.com/CloudMages/PyPkgs-GitUtils/workflows/PyTests/badge.svg)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![Coverage](https://github.com/CloudMages/PyPkgs-GitUtils/workflows/Coverage/badge.svg)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![codecov](https://codecov.io/gh/CloudMages/PyPkgs-GitUtils/branch/master/graph/badge.svg)](https://codecov.io/gh/CloudMages/PyPkgs-GitUtils)\n\n<br/><br/>\n\n## Table of Contents\n\n* [Description](#description)\n* [Road Map](#road-map)\n* [Python Version Support](#python-version-support)\n* [Package Installation](#package-installation)\n* [Package Dependencies](#package-dependencies)\n* [GitConfigParser Class](#gitconfigparser-class)\n  * [GitConfigParser Constructor Arguments](#gitconfigparser-constructor-arguments)\n  * [GitConfigParser Attributes and Properties](#gitconfigparser-attributes-and-properties)\n  * [GitConfigParser Available Methods](#gitconfigparser-available-methods)\n  * [GitConfigParser Class Usage](#gitconfigparser-class-usage)\n* [GithubReports Class](#githubreports-class)\n  * [GithubReports Constructor Arguments](#githubreports-constructor-arguments)\n  * [GithubReports Attributes and Properties](#githubreports-attributes-and-properties)\n  * [GithubReports Available Methods](#githubreports-available-methods)\n  * [GithubReports Class Usage](#githubreports-class-usage)\n* [ChangeLog](#changelog)\n* [Contacts and Contributions](#contacts-and-contributions)\n\n<br/><br/>\n\n## Description\n\nIn part, the purpose of this library is to be able to either automatically detect a projects configured Git repository by searching for and parsing a .git/config file in a given file path, or to take an input consisting simply of the repositories URL (HTTP | Git formatted). The object has the repository url, provider, and any users configured within the git URL string. The Second part of this utility package is to provide a few pre-packaged reports that can be retrieved from Github such as an Open Pull Request report, showing all pull requests opened within a given repository user or organization namespace.\n\n<br/><br/>\n\n## Road Map\n\nCurrently this library gathers data from the Githubs API, however, future development will include Gitlab and Bitbucket repository API reporting as well.\n\n<br/><br/>\n\n## Python Version Support\n\nThis library is compatible with Python 3.6 and higher. It may work with earlier versions of Python3 but was not tested against anything earlier then 3.6. As Python 2.x is soon to be end of life, backward compatibility was not taken into consideration.\n\n<br/><br/>\n\n## Package Installation\n\nThis library has been published to [PyPi](https://pypi.org/project/cloudmage-gitutils/) and can be installed via normal python package manager conventions such as [pip](https://pip.pypa.io/en/stable/) or [poetry](https://pypi.org/project/poetry/).\n\n<br/>\n\n```python\npip3 install cloudmage-gitutils\n```\n\n<br/><br/>\n\n## Package Dependencies\n\nThis package installs and imports the following python modules during installation:\n\n* pyGithub\n* progress\n* cloudmage.jinjautils\n\n<br/>\n\nAdditionally the package takes advantage of the following built in python modules:\n\n* os\n* sys\n* json\n* inspect\n* datetime\n\n<br/><br/>\n\n## GitConfigParser Class\n\nThis class takes a directory path argument, which it uses as a target directory to search for a .git/config file. If a file is found, then the class will parse the URL from the config, and determines the git platform provider from the parsed URL path. This data is then used to return back an object instance with properties set to the parsed values.\n\n<br/>\n\n### GitConfigParser Constructor Arguments\n\n-----\n\nThe following arguments can be used to instantiate a new object instance:\n\n<br/>\n\n| __[path](\'\')__ |  *A valid directory path where a `.git/config` file can be found. <br/> Must be valid directory path, checked with `os.path.exists()`* |\n|:---------------|:-------------------------------------------------------|\n| *required*     | [true](\'\')                                             |\n| *type*         | [str](https://docs.python.org/3/library/stdtypes.html) |\n\n<br/>\n\n| __[verbose](\'\')__ |  *Enables verbose mode. &nbsp; [[true](\'\')=enable &nbsp; [false](\'\')=disable]* |\n|:------------------|:--------------------------------------------------------|\n| *required*        | [false](\'\')                                             |\n| *type*            | [bool](https://docs.python.org/3/library/stdtypes.html) |\n| *default*         | [false](\'\') *(disabled)*                                |\n\n<br/>\n\n| __[log](\'\')__ |  *Redirects object standard log messaging to provided log object.* |\n|:--------------|:-----------------------------------------------------------|\n| *required*    | [false](\'\')                                                |\n| *type*        | [obj](https://docs.python.org/3/library/stdtypes.html)     |\n| *default*     | [None](\'\') *(log to stdout, stderr if verbose=[true](\'\'))* |\n\n<br/><br/>\n\n### GitConfigParser Attributes and Properties\n\n-----\n\nThe following attributes/properties are available to an instantiated object instance. Any of the attributes or properties can be accessed with standard object dot notation as in the example: `verbose_mode = GitConfigParserObj.verbose`\n\n<br/>\n\n| __[verbose](\'\')__ |  *Verbose setting that controls logging level within the object. &nbsp; [[true](\'\')=enabled, [false](\'\')=disabled]* |\n|:---------------------|:--------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(enabled or disabled)*  |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html) |\n| *instantiated value* | [false](false)                                          |\n\n<br/>\n\n| __[url](\'\')__ |  *Verbose setting that controls logging level within the object. &nbsp; [[true](\'\')=enabled, [false](\'\')=disabled]* |\n|:---------------------|:---------------------------------------------------------------------------------------------|\n| *returns*            | *url string* [->](->) `https://github.com/namespace/repository`                              |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                                       |\n| *instantiated value* | *URL string parsed from .git/config in directory path specified during object instantiation* |\n\n<br/>\n\n| __[provider](\'\')__   |  *The parsed provider (*github.com*, *gitlab.com*, or *bitbucket.org*) from a given URL string* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Provider string [->](->) `github.com`                                          |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | *Provider string parsed from object url property during object instantiation*  |\n\n<br/>\n\n| __[user](\'\')__       |  *If a user was used in the config url, then the value of the user will be assigned to this property* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | User string [->](->) `username`                                                |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | *User string parsed from object url property during object instantiation*      |\n\n<br/>\n\n| __[log](\'\')__        |  *The class logger. Will either write directly to stdout, stderr, or to a lob object if passed into the object constructor during object instantiation* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Log Event Stream                                                               |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | *Logs written to stdout, stderr*                                               |\n\n<br/><br/>\n\n### GitConfigParser Available Methods\n\n-----\n\nThe following methods are available to an instantiated object instance. Some of the methods are simply setter methods that run the logic required to discover and then set one of the above instance properties.\n\n<br/>\n\n__[verbose](\'\')__\n\nSetter method for `verbose` property that enables or disables verbose mode\n\n<br/>\n\n| parameter   | type       | required     | arg info                                                   |\n|:-----------:|:----------:|:------------:|:-----------------------------------------------------------|\n| verbose | [bool](\'\')  | [true](true) | *[True](\'\') enables verbose logging, [False](\'\') disables it* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nverbose_setting = GitConfigParserObj.verbose\n\n# Setter method\nGitConfigParserObj.verbose = True\n```\n\n<br/><br/>\n\n__[log](\'\')__\n\nMethod to enable logging throughout the class. Log messages are sent to the log method providing the log message, the message type being one of `[debug, info, warning, error]`, and finally the function or method id that is automatically derived within the function or method using the python inspect module. If a log object such as a logger or an already instantiated log object instance was passed to the class constructor during the objects instantiation, then all logs will be written to the provided log object. If no log object was provided during instantiation then all `debug`, `info`, and `warning` logs will be written to stdout, while any encountered `error` log entries will be written to stderr. Note that debug or verbose mode needs to be enabled to receive the event log stream.\n\n<br/>\n\n| arg      | type       | required     | arg info                                          |\n|:--------:|:----------:|:------------:|:--------------------------------------------------|\n| log_msg  | [str](\'\')  | [true](true) | *The actual message being sent to the log method* |\n| log_type | [str](\'\')  | [true](true) | *The type of message that is being sent to the log method, one of `[debug, info, warning, error]`*    |\n| log_id   | [str](\'\')  | [true](true) | *A string value identifying the sender method or function, consisting of the method or function name* |\n\n<br/>\n\n__Examples:__\n\n```python\ndef my_function():\n  __function_id = inspect.stack()[0][3]\n  GitConfigParserObj.log(\n    f"{__function_id} called.",\n    \'info\',\n    __function_id\n  )\n```\n\n<br/><br/>\n\n__[url](\'\')__\n\nSetter method for `url` property that will search the object instances set directory path and look for a .git/config directory in that path. If found, then the setter method will parse the .git/config file and look for a URL line to parse and extract the URL. It will then update the object property with the parsed value. If this method is called post instantiation, then a valid directory path must be provided as an argument.\n\n<br/>\n\n| parameter   | type       | required     | arg info                                          |\n|:-----------:|:----------:|:------------:|:--------------------------------------------------|\n| config_path | [str](\'\')  | [true](true) | *Must be a valid directory path. This value is checked by `os.path.exists()` and will write an error to the log if the provided argument directory path does not exist* |\n\n<br/>\n\n__Examples:__\n\n```python\nGitConfigParserObj.url = /home/projects/my_project_directory\n```\n\n<br/><br/>\n\n__[provider](\'\')__\n\nSetter method for `provider` property that will search the object instances updated url property for a valid git provider string. Currently the provider setter will look specifically for a value that matches one of `[github.com, gitlab.com, bitbucket.org]`. If this method is called post instantiation, then a valid git repository url must be provided as an argument. The provider property setter will parse either an http, https, git or ssh formatted URL string. During the parse operation, if a user is identified in the provider string such as user@bitbucket.org, then the username will also be parsed and used to update the `user` object property.\n\n<br/>\n\n| parameter      | type       | required     | arg info                                          |\n|:--------------:|:----------:|:------------:|:--------------------------------------------------|\n| repository_url | [str](\'\')  | [true](true) | *Must be a properly formatted URL string starting with one of `[http, https, git, ssh]` and must end in `.git`* |\n\n<br/>\n\n__Examples:__\n\n```python\nGitConfigParserObj.provider = "git@github.com:namespace/repository.git"\n```\n\n<br/><br/>\n\n### GitConfigParser Class Usage\n\n-----\n\n<br/>\n\n#### GitConfigParser Default Instantiation\n\n```python\nfrom cloudmage-gitutils import GitConfigParser\n\nProjectPath = \'/Projects/MyCoolProject\'\n# Contains .git/config with\n# url = https://github.com/GithubNamespace/MyCoolProject-Repo.git\n\nRepo = GitConfigParser(ProjectPath)\n\nrepo_url = Repo.url\nprint(repo_url) # https://github.com/GithubNamespace/MyCoolProject-Repo\n\nrepo_provider = Repo.provider\nprint(repo_provider) # github.com\n\nrepo_user = Repo.user\nprint(repo_user) # None\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Verbose Class Constructor Argument:__](Note) <br/> When instantiating the class an optional `verbose` argument can be provided. The argument expects a bool value of either `True` or `False`. By default verbose is set to False. If `verbose=True` is passed during object instantiation, then debug mode is turned on allowing the class to output DEBUG, INFO, and WARNING messages to stdout, and ERROR messages to stderr.\n\n<br/><br/>\n\n#### GitConfigParser Verbose Instantiation\n\n```python\nfrom cloudmage-gitutils import GitConfigParser\n\nProjectPath = \'/Projects/MyCoolProject\'\n# Contains .git/config with\n# url = https://github.com/GithubNamespace/MyCoolProject-Repo.git\n\nRepo = GitConfigParser(ProjectPath, verbose=True)\n\nrepo_url = Repo.url\nprint(repo_url) # https://github.com/GithubNamespace/MyCoolProject-Repo\n\nrepo_provider = Repo.provider\nprint(repo_provider) # github.com\n\nrepo_user = Repo.user\nprint(repo_user) # None\n\n# Class DEBUG, INFO, and WARNING messages will be printed to stdout, and ERROR messages will be printed to stderr\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Log Object:__](Note) <br/> When instantiating the class an optional `log` argument can also be provided. The argument expects an Logger object to be passed as an input. If passed then all DEBUG, INFO, WARNING, and ERROR messages will be printed to the standard log levels [`log.debug()`, `log.info()`, `log.warning()`, `log.error()`] and printed to the passed respective logger object method.\n\n<br/><br/>\n\n#### GitConfigParser Log Instantiation\n\n```python\nfrom cloudmage-gitutils import GitConfigParser\n\n# Define test log class\n# This is an example log object that simply appends any DEBUG, INFO and ERROR received class messages\n# to the respective log level list. Normally this would be a logger or custom log object.\nclass Log(object):\n        """Test Log Object"""\n\n        def __init__(self):\n            """Class Constructor"""\n            self.debug_logs = []\n            self.info_logs = []\n            self.error_logs = []\n\n        def debug(self, message):\n            """Log Debug Messages"""\n            self.debug_logs.append(message)\n\n        def info(self, message):\n            """Log Debug Messages"""\n            self.info_logs.append(message)\n\n        def error(self, message):\n            """Log Debug Messages"""\n            self.error_logs.append(message)\n\n# Instantiate test log class\nGitLog = Log()\n\nProjectPath = \'/Projects/MyCoolProject\'\n# Contains .git/config with\n# url = https://github.com/GithubNamespace/MyCoolProject-Repo.git\n\nRepo = GitConfigParser(ProjectPath, verbose=True, log=GitLog)\n\nrepo_url = Repo.url\nprint(repo_url) # https://github.com/GithubNamespace/MyCoolProject-Repo\n\nrepo_provider = Repo.provider\nprint(repo_provider) # github.com\n\nrepo_user = Repo.user\nprint(repo_user) # None\n\nfor items in GitLog.debug_logs:\n    print(item) # Prints stored debug logs\n```\n\n<br/><br/>\n\n## GithubReports Class\n\nThis class will take an auth_token, and user/organization namespace name and run a query against the namespace for all open pull requests in any repositories living within that user/org namespace. Once the pull request data is returned, it can be then be used to generate the included HTML template report that will list the repository, pull request title, submitter, reviewers, creation date and days open count for each found repository.\n\n<br/>\n\n### GithubReports Constructor Arguments\n\n-----\n\nThe following arguments can be used to instantiate a new object instance:\n\n<br/>\n\n| __[verbose](\'\')__ |  *Enables verbose mode. &nbsp; [[true](\'\')=enable &nbsp; [false](\'\')=disable]* |\n|:------------------|:--------------------------------------------------------|\n| *required*        | [false](\'\')                                             |\n| *type*            | [bool](https://docs.python.org/3/library/stdtypes.html) |\n| *default*         | [false](\'\') *(disabled)*                                |\n\n<br/>\n\n| __[auth_token](\'\')__ |  *A valid Github personal access token used to search issues within the user/organization namespace account.* |\n|:---------------|:-------------------------------------------------------|\n| *required*     | [true](\'\')                                             |\n| *type*         | [str](https://docs.python.org/3/library/stdtypes.html) |\n\n<br\\>\n\n| __[log](\'\')__ |  *Redirects object standard log messaging to provided log object.* |\n|:--------------|:-----------------------------------------------------------|\n| *required*    | [false](\'\')                                                |\n| *type*        | [obj](https://docs.python.org/3/library/stdtypes.html)     |\n| *default*     | [None](\'\') *(log to stdout, stderr if verbose=[true](\'\'))* |\n\n<br/><br/>\n\n### GithubReports Attributes and Properties\n\n-----\n\nThe following attributes/properties are available to an instantiated object instance. Any of the attributes or properties can be accessed with standard object dot notation as in the example: `verbose_mode = GithubReportsObj.verbose`\n\n<br/>\n\n| __[verbose](\'\')__ |  *Verbose setting that controls logging level within the object. &nbsp; [[true](\'\')=enabled, [false](\'\')=disabled]* |\n|:---------------------|:--------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(enabled or disabled)*  |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html) |\n| *instantiated value* | [false](false)                                          |\n\n<br/>\n\n| __[auth_token](\'\')__ |  *Property to set/re-set the Github Authentication Token required to make calls against Github APIs.* |\n|:---------------------|:------------------------------------------------------------------------------------------------------|\n| *returns*            | *string* [->](->) `0123456789109876543210`                                                            |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                                                |\n| *instantiated value* | *Provided Token, If token not provided during object construction, use Obj.auth_token = "<Token>"*    |\n\n<br/>\n\n| __[repo_namespace](\'\')__ |  *The user / organization namespace that will be used as the search target*       |\n|:-------------------------|:----------------------------------------------------------------------------------|\n| *returns*                | string [->](->) `CloudMages`                                                      |\n| *type*                   | [str](https://docs.python.org/3/library/stdtypes.html)                            |\n| *instantiated value*     | *None, set with Obj.repo_namespace = "<CloudMages>"*                              |\n\n<br/>\n\n| __[is_organization](\'\')__  |  *Flag to indicate if the provided namespace is an organization namespace (affects API calls).  &nbsp; [[true](\'\')=organization, [false](\'\')=user]* |\n|:---------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------|\n| *returns*                  | [true](true) or [false](false) *(organization or user) namespace*                                                                                   |\n| *type*                     | [bool](https://docs.python.org/3/library/stdtypes.html)                                                                                             |\n| *instantiated value*       | [false](false)                                                                                                                                      |\n\n<br/>\n\n| __[notify](\'\')__     |  *Flag to specify if, when running reports, a comment should be left on a repository that has exceeded the open days threshold. &nbsp; [[true](\'\')=leave_comment, [false](\'\')=do_not_comment]* |\n|:---------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(leave comments or do not leave comments)                                                                                                                      |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html)                                                                                                                                        |\n| *instantiated value* | [false](false)                                                                                                                                                                                 |\n\n<br/>\n\n| __[open_pr_threshold](\'\')__   |  *Number value indicating a days threshold used for reports such as open pull requests. This value will be used to determine if a PR has exceeded desired days open.* |\n|:------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| *returns*                     | int [->](->) 5                                                                                                                                                         |\n| *type*                        | [int](https://docs.python.org/3/library/stdtypes.html)                                                                                                                 |\n| *instantiated value*          | [5](5) days                                                                                                                                                            |\n\n<br/>\n\n| __[template_path](\'\')__       |  *String value of the path where reporting templates are stored.* |\n|:------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| *returns*                     | str [->](->) /Path/to/template/files                                                                                                                                   |\n| *type*                        | [str](https://docs.python.org/3/library/stdtypes.html)                                                                                                                 |\n| *instantiated value*          | /{installation/path}/templates                                                                                                                                         |\n\n<br/>\n\n| __[log](\'\')__        |  *The class logger. Will either write directly to stdout, stderr, or to a lob object if passed into the object constructor during object instantiation* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Log Event Stream                                                               |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | *Logs written to stdout, stderr*                                               |\n\n<br/><br/>\n\n### GithubReports Available Methods\n\n-----\n\nThe following methods are available to an instantiated object instance. Some of the methods are simply setter methods that run the logic required to discover and then set one of the above instance properties.\n\n<br/>\n\n__[verbose](\'\')__\n\nSetter method for `verbose` property that enables or disables verbose mode\n\n<br/>\n\n| parameter   | type       | required     | arg info                                                   |\n|:-----------:|:----------:|:------------:|:-----------------------------------------------------------|\n| verbose     | [bool](\'\') | [true](true) | *[True](\'\') enables verbose logging, [False](\'\') disables it* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nverbose_setting = GitHubReportObj.verbose\n\n# Setter method\nGitHubReportObj.verbose = True\n```\n\n<br/><br/>\n\n__[log](\'\')__\n\nMethod to enable logging throughout the class. Log messages are sent to the log method providing the log message, the message type being one of `[debug, info, warning, error]`, and finally the function or method id that is automatically derived within the function or method using the python inspect module. If a log object such as a logger or an already instantiated log object instance was passed to the class constructor during the objects instantiation, then all logs will be written to the provided log object. If no log object was provided during instantiation then all `debug`, `info`, and `warning` logs will be written to stdout, while any encountered `error` log entries will be written to stderr. Note that debug or verbose mode needs to be enabled to receive the event log stream.\n\n<br/>\n\n| arg      | type       | required     | arg info                                          |\n|:--------:|:----------:|:------------:|:--------------------------------------------------|\n| log_msg  | [str](\'\')  | [true](true) | *The actual message being sent to the log method* |\n| log_type | [str](\'\')  | [true](true) | *The type of message that is being sent to the log method, one of `[debug, info, warning, error]`*    |\n| log_id   | [str](\'\')  | [true](true) | *A string value identifying the sender method or function, consisting of the method or function name* |\n\n<br/>\n\n__Examples:__\n\n```python\ndef my_function():\n  __function_id = inspect.stack()[0][3]\n  GitConfigParserObj.log(\n    f"{__function_id} called.",\n    \'info\',\n    __function_id\n  )\n```\n\n<br/><br/>\n\n__[auth_token](\'\')__\n\nSetter method for `auth_token` property that will be used to make calls to Githubs API for authentication. The provided auth_token must be valid, and have access to read repositories and issues. An auth_token can be set during instance instantiation, using the property setter, or passed directly into a reporting method. This allows the versatility of using different tokens if necessary.\n\n<br/>\n\n| parameter   | type       | required     | arg info                                          |\n|:-----------:|:----------:|:------------:|:--------------------------------------------------|\n| auth_token  | [str](\'\')  | [true](true) | *Must be a valid Github auth token. The search methods will throw a BadCredentials exception if an invalid token is provided.* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nset_auth_token = GitHubReportObj.auth_token\n\n\n# Setter method\nGitHubReportObj = GitHubReports(auth_token="0123456789109876543210")\n\n# Set using property setter\nGitHubReportObj.auth_token = "0123456789109876543210"\n\nexport TOKEN="0123456789109876543210"\nGitHubReportObj.search_open_pulls(auth_token=$TOKEN)\n```\n\n<br/><br/>\n\n__[repo_namespace](\'\')__\n\nSetter method for `repo_namespace` property that will be used to specify what repository namespace will be targeted for reporting. The repository namespace must be a string value, and a valid Github user or organization namespace. The `repo_namespace` can be set by the property setter method, or by being passed directly into the search method as a method argument.\n\n<br/>\n\n| parameter        | type       | required     | arg info                                          |\n|:----------------:|:----------:|:------------:|:--------------------------------------------------|\n| repo_namespace   | [str](\'\')  | [true](true) | *Must be a valid Github user or organization namespace or reporting and/or any form of desired data collection will fail.* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nnamespace = GitHubReportObj.repo_namespace\n\n\n# Setter method\nGitHubReportObj = GitHubReports(auth_token="0123456789109876543210")\n\n# Set using property setter\nGitHubReportObj.repo_namespace = "CloudMages"\n\n# Set within the reporting method call\nexport TOKEN="0123456789109876543210"\nGitHubReportObj.search_open_pulls(\n  auth_token=$TOKEN\n  repo_namespace="CloudMages"\n)\n```\n\n<br/><br/>\n\n__[is_organization](\'\')__\n\nSetter method for `is_organization` property that will be used as a flag to determine if the provided repo_namespace is a user namespace or organization namespace. This information is relevant as the APIs that will be called to fetch data for or about the specified repository as such with repository or issues searchs will be affected by this flag. If an organization namespace is passed, but not signaled that the namespace is an organization, reports or other calls to the API could fail.\n\n> Default value of this flag is set to [false](false).\n\n<br/>\n\n| parameter        | type       | required       | arg info                                                             |\n|:----------------:|:----------:|:--------------:|:---------------------------------------------------------------------|\n| is_organization  | [bool](\'\') | [false](false) | *[True](\'\') signals organization, [False](\'\') signals user namepace* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nOrgFlag = GitHubReportObj.is_organization\n\n\n# Setter method\nGitHubReportObj.repo_namespace = "CloudMages"\nGitHubReportObj.is_organization = True\nSearchIssues = GitHubReportObj.search_open_pulls()\n```\n\n<br/>\n\n__[notify](\'\')__\n\nSetter method for `notify` property that will be used as a flag to publish a @mentioned comment on any open pull requests or issues that were found within the searched namespace if the open pull request or issue has been opened for a period of time exceeding the value set in `open_pr_threshold`. If an open pull request or issue is discovered, and Obj.notify is set to [True](\'\'), then a message that specifically @mentions the issue submitter and all listed issue reviewers will be constructed and written on any offending issue as a comment indicating that the issue has been open in access of the threshold and should be reviewed and closed immediately. If the value is set to [True](\'\'), then messages will be sent to the log, but will not be published or commented on the repository issue itself.\n\n> By Default this value is set to [False](False)\n\n<br/>\n\n| parameter        | type       | required       | arg info                                                             |\n|:----------------:|:----------:|:--------------:|:---------------------------------------------------------------------|\n| notify           | [bool](\'\') | [false](false) | *[True](\'\') signals notify, [False](\'\') signals write log only*      |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nPublishComment = GitHubReportObj.notify\n\n# Setter method\nGitHubReportObj.notify = True\nSearchIssues = GitHubReportObj.search_open_pulls()\n```\n\n<br/>\n\n__[open_pr_threshold](\'\')__\n\nSetter method for `open_pr_threshold` property that is used as the threshold metric for any open pull requests or issues discovered during namespace search. If a issue or pull request is open and the created date is greater then the value that is set for this flag in days old, then the issue or pull request will be added to reporting, and can be commented on by the search method to indicate that the pull request or issue has been open for an extended amount of time and should be reviewed and / or merged / closed immediately.\n\n> By Default this value is set to [5](5) days\n\n<br/>\n\n| parameter        | type       | required       | arg info                                                             |\n|:----------------:|:----------:|:--------------:|:---------------------------------------------------------------------|\n| days             | [int](\'\')  | [false](false) | *Number of days threshold for pull requests / Github Issues.*        |\n\n<br/>\n\n__[template_path](\'\')__\n\nGetter only method for `template_path` property that is used to simply get the file location of where the modules HTML report templates are stored. This value can not, nor does not need to have its value altered as the included model templates will always be packaged in the /templates direcotry, held within the project root.\n\n> By Default this value is {/path/to/this/module}/templates/\n\n<br/>\n\n| parameter        | type       | required       | arg info                                                             |\n|:----------------:|:----------:|:--------------:|:---------------------------------------------------------------------|\n| None             | [N/A](\'\')  | [N/A](\'\')      | *No Parameter Value, this is a Getter method only.*                  |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nTemplatePath = GitHubReportObj.template_path\n```\n\n<br/>\n\n__[search_open_pulls](\'\')__\n\nThe `search_open_pulls` reporting method will search a provided namespace for all open pull requests. For each open pull request item, the pull request Name, HTML URL, Title, Body, Submitter, Reviewers, Merge Data, Creation Data, Age, and Review States will be collected and returned back as a list of dictionaries. This data can then be used with the provided module template to render into an HTML report. The report will indicate by a green background any pull requests that have been approved and are awaiting either additional approvers or the submitter. The report will also indicate with a red background in the PR Days Open field if the pull request has been open longer then the configured `open_pr_threshold` number of days.\n\n<br/>\n\n| parameter        | type       | required       | arg info                                                             |\n|:----------------:|:----------:|:--------------:|:---------------------------------------------------------------------|\n| auth_token       | [str](\'\')  | [true](true)   | *Must be a valid Github auth token. The search methods will throw a BadCredentials exception if an invalid token is provided.* |\n| repo_namespace   | [str](\'\')  | [true](true)   | *Must be a valid Github user or organization namespace or reporting and/or any form of desired data collection will fail.*     |\n\n<br/>\n\n__Examples:__\n\n```python\nOpen_PRs = GitHubReportObj.search_open_pulls(\n  auth_token=$TOKEN\n  repo_namespace="CloudMages"\n)\n```\n\n<br/><br/>\n\n__Execution Example:__\n\n```json\nConstructing search query for CloudMages repository namespace...\n    Open Pull Request Threshold:          5 days\n    Notifications Enabled:                False\n    Repository Namespace is Organization: True\n    Verbose Mode Enabled:                 True\n\nInstantiated Github API Connector Object\nSearch Results: 1 open PullRequests were returned!\n\nOpen PR Search returned 1 results\nValidating Search Results...\n\nhttps://github.com/DaCloudMage/UnitTest-GitUtils/pull/1 Within the Open Days Limit.\n\nPrinting Collected Open Pull Request DataSet:\n\n[{\n  "id": 123456789,\n  "repository": "UnitTest-GitUtils",\n  "repository_url": "https://github.com/DaCloudMage/UnitTest-GitUtils",\n  "number": 1,\n  "submitter": "user_1",\n  "reviewers": [],\n  "link": "https://github.com/DaCloudMage/UnitTest-GitUtils/pull/1",\n  "title": "Open pr",\n  "body": "Test Open PR Report",\n  "created": datetime.datetime(2020, 4, 9, 0, 29, 56),\n  "age": datetime.timedelta(days=-1, seconds=66866, microseconds=735729),\n  "age_days": 1,\n  "state": "open",\n  "is_merged": False,\n  "merged": None,\n  "mergable": True,\n  "merge_state": "clean",\n  "merged_by": None,\n  "review_count": 0,\n  "days_open_threshold": 5\n}]\n\n1 / 1 of the returned search results were verified as open pull requests.\n```\n\n<br/><br/>\n\n### GithubReports Class Usage\n\n-----\n\n#### GithubReports Default Instantiation\n\n```python\nfrom cloudmage-gitutils import GitHubReports\nimport os\n\n# Fetch exported Token\nAUTH_TOKEN = os.environ[\'GITHUB_TOKEN\']\n\n# Instantiate the object\nOpenPRs = GitHubReports(auth_token=AUTH_TOKEN)\nOpenPRs.repo_namespace = "CloudMages"\nOpenPrs.is_organization = True\nSearchOpenPRs = OpenPrs.search_open_pulls()\n\nprint(len(SearchOpenPRs))\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Verbose Class Constructor Argument:__](Note) <br/> When instantiating the class an optional `verbose` argument can be provided. The argument expects a bool value of either `True` or `False`. By default verbose is set to False. If `verbose=True` is passed during object instantiation, then debug mode is turned on allowing the class to output DEBUG, INFO, and WARNING messages to stdout, and ERROR messages to stderr.\n\n<br/><br/>\n\n#### GithubReports Verbose Instantiation\n\n```python\nfrom cloudmage-gitutils import GitHubReports\nimport os\n\n# Fetch exported Token\nAUTH_TOKEN = os.environ[\'GITHUB_TOKEN\']\n\n# Instantiate the object\nOpenPRs = GitHubReports(auth_token=AUTH_TOKEN, verbose=True)\nOpenPRs.repo_namespace = "CloudMages"\nOpenPrs.is_organization = True\nSearchOpenPRs = OpenPrs.search_open_pulls()\n\nprint(len(SearchOpenPRs))\n\n# Class DEBUG, INFO, and WARNING messages will be printed to stdout, and ERROR messages will be printed to stderr\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Log Object:__](Note) <br/> When instantiating the class an optional `log` argument can also be provided. The argument expects an Logger object to be passed as an input. If passed then all DEBUG, INFO, WARNING, and ERROR messages will be printed to the standard log levels [`log.debug()`, `log.info()`, `log.warning()`, `log.error()`] and printed to the passed respective logger object method.\n\n<br/><br/>\n\n#### GithubReports Log Instantiation\n\n```python\nfrom cloudmage-gitutils import GitHubReports\nimport os\n\n# Define test log class\n# This is an example log object that simply appends any DEBUG, INFO and ERROR received class messages\n# to the respective log level list. Normally this would be a logger or custom log object.\nclass Log(object):\n        """Test Log Object"""\n\n        def __init__(self):\n            """Class Constructor"""\n            self.debug_logs = []\n            self.info_logs = []\n            self.error_logs = []\n\n        def debug(self, message):\n            """Log Debug Messages"""\n            self.debug_logs.append(message)\n\n        def info(self, message):\n            """Log Debug Messages"""\n            self.info_logs.append(message)\n\n        def error(self, message):\n            """Log Debug Messages"""\n            self.error_logs.append(message)\n\n# Instantiate test log class\nGitLog = Log()\n\n# Fetch exported Token\nAUTH_TOKEN = os.environ[\'GITHUB_TOKEN\']\n\n# Instantiate the object\nOpenPRs = GitHubReports(auth_token=AUTH_TOKEN, verbose=True, log=GitLog)\nOpenPRs.repo_namespace = "CloudMages"\nOpenPrs.is_organization = True\nSearchOpenPRs = OpenPrs.search_open_pulls()\n\nfor item in GitLog.debug_logs:\n    print(item) # Prints stored debug logs\n```\n\n<br/><br/>\n\n## Changelog\n\nTo view the project changelog see: [ChangeLog:](CHANGELOG.md)\n\n<br/><br/>\n\n## ![TheCloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/logo.png) &nbsp;&nbsp;Contacts and Contributions\n\nThis project is owned and maintained by: [@TheCloudMage](https://github.com/TheCloudMage)\n\n<br/>\n\nTo contribute, please:\n\n* Fork the project\n* Create a local branch\n* Submit Changes\n* Create A Pull Request\n',
    'author': 'Rich Nason',
    'author_email': 'rnason@cloudmage.io',
    'maintainer': 'Rich Nason',
    'maintainer_email': 'rnason@cloudmage.io',
    'url': 'https://github.com/CloudMages/PyPkgs-GitUtils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
