# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmHistoricalAdherenceResultWrapper(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmHistoricalAdherenceResultWrapper - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entity_id': 'str',
            'data': 'list[HistoricalAdherenceQueryResult]',
            'lookup_id_to_secondary_presence_id': 'dict(str, str)'
        }

        self.attribute_map = {
            'entity_id': 'entityId',
            'data': 'data',
            'lookup_id_to_secondary_presence_id': 'lookupIdToSecondaryPresenceId'
        }

        self._entity_id = None
        self._data = None
        self._lookup_id_to_secondary_presence_id = None

    @property
    def entity_id(self):
        """
        Gets the entity_id of this WfmHistoricalAdherenceResultWrapper.
        The operation ID of the historical adherence query

        :return: The entity_id of this WfmHistoricalAdherenceResultWrapper.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """
        Sets the entity_id of this WfmHistoricalAdherenceResultWrapper.
        The operation ID of the historical adherence query

        :param entity_id: The entity_id of this WfmHistoricalAdherenceResultWrapper.
        :type: str
        """
        
        self._entity_id = entity_id

    @property
    def data(self):
        """
        Gets the data of this WfmHistoricalAdherenceResultWrapper.
        The list of historical adherence query results

        :return: The data of this WfmHistoricalAdherenceResultWrapper.
        :rtype: list[HistoricalAdherenceQueryResult]
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this WfmHistoricalAdherenceResultWrapper.
        The list of historical adherence query results

        :param data: The data of this WfmHistoricalAdherenceResultWrapper.
        :type: list[HistoricalAdherenceQueryResult]
        """
        
        self._data = data

    @property
    def lookup_id_to_secondary_presence_id(self):
        """
        Gets the lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceResultWrapper.
        Map of secondary presence lookup ID to corresponding secondary presence ID

        :return: The lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceResultWrapper.
        :rtype: dict(str, str)
        """
        return self._lookup_id_to_secondary_presence_id

    @lookup_id_to_secondary_presence_id.setter
    def lookup_id_to_secondary_presence_id(self, lookup_id_to_secondary_presence_id):
        """
        Sets the lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceResultWrapper.
        Map of secondary presence lookup ID to corresponding secondary presence ID

        :param lookup_id_to_secondary_presence_id: The lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceResultWrapper.
        :type: dict(str, str)
        """
        
        self._lookup_id_to_secondary_presence_id = lookup_id_to_secondary_presence_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

