# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import proto  # type: ignore


from google.cloud.websecurityscanner_v1alpha.types import finding_addon


__protobuf__ = proto.module(
    package="google.cloud.websecurityscanner.v1alpha", manifest={"Finding",},
)


class Finding(proto.Message):
    r"""A Finding resource represents a vulnerability instance
    identified during a ScanRun.

    Attributes:
        name (str):
            The resource name of the Finding. The name
            follows the format of
            'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
            The finding IDs are generated by the system.
        finding_type (~.finding.Finding.FindingType):
            The type of the Finding.
        http_method (str):
            The http method of the request that triggered
            the vulnerability, in uppercase.
        fuzzed_url (str):
            The URL produced by the server-side fuzzer
            and used in the request that triggered the
            vulnerability.
        body (str):
            The body of the request that triggered the
            vulnerability.
        description (str):
            The description of the vulnerability.
        reproduction_url (str):
            The URL containing human-readable payload
            that user can leverage to reproduce the
            vulnerability.
        frame_url (str):
            If the vulnerability was originated from
            nested IFrame, the immediate parent IFrame is
            reported.
        final_url (str):
            The URL where the browser lands when the
            vulnerability is detected.
        tracking_id (str):
            The tracking ID uniquely identifies a
            vulnerability instance across multiple ScanRuns.
        outdated_library (~.finding_addon.OutdatedLibrary):
            An addon containing information about
            outdated libraries.
        violating_resource (~.finding_addon.ViolatingResource):
            An addon containing detailed information
            regarding any resource causing the vulnerability
            such as JavaScript sources, image, audio files,
            etc.
        vulnerable_headers (~.finding_addon.VulnerableHeaders):
            An addon containing information about
            vulnerable or missing HTTP headers.
        vulnerable_parameters (~.finding_addon.VulnerableParameters):
            An addon containing information about request
            parameters which were found to be vulnerable.
        xss (~.finding_addon.Xss):
            An addon containing information reported for
            an XSS, if any.
    """

    class FindingType(proto.Enum):
        r"""Types of Findings."""
        FINDING_TYPE_UNSPECIFIED = 0
        MIXED_CONTENT = 1
        OUTDATED_LIBRARY = 2
        ROSETTA_FLASH = 5
        XSS_CALLBACK = 3
        XSS_ERROR = 4
        CLEAR_TEXT_PASSWORD = 6
        INVALID_CONTENT_TYPE = 7
        XSS_ANGULAR_CALLBACK = 8
        INVALID_HEADER = 9
        MISSPELLED_SECURITY_HEADER_NAME = 10
        MISMATCHING_SECURITY_HEADER_VALUES = 11

    name = proto.Field(proto.STRING, number=1)

    finding_type = proto.Field(proto.ENUM, number=2, enum=FindingType,)

    http_method = proto.Field(proto.STRING, number=3)

    fuzzed_url = proto.Field(proto.STRING, number=4)

    body = proto.Field(proto.STRING, number=5)

    description = proto.Field(proto.STRING, number=6)

    reproduction_url = proto.Field(proto.STRING, number=7)

    frame_url = proto.Field(proto.STRING, number=8)

    final_url = proto.Field(proto.STRING, number=9)

    tracking_id = proto.Field(proto.STRING, number=10)

    outdated_library = proto.Field(
        proto.MESSAGE, number=11, message=finding_addon.OutdatedLibrary,
    )

    violating_resource = proto.Field(
        proto.MESSAGE, number=12, message=finding_addon.ViolatingResource,
    )

    vulnerable_headers = proto.Field(
        proto.MESSAGE, number=15, message=finding_addon.VulnerableHeaders,
    )

    vulnerable_parameters = proto.Field(
        proto.MESSAGE, number=13, message=finding_addon.VulnerableParameters,
    )

    xss = proto.Field(proto.MESSAGE, number=14, message=finding_addon.Xss,)


__all__ = tuple(sorted(__protobuf__.manifest))
