"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstraplessSynthesizer = void 0;
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
        });
    }
    addFileAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesizeStackArtifacts(session) {
        _shared_1.assertBound(this.stack);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        _shared_1.addStackArtifactToAssembly(session, this.stack, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
            requiresBootstrapStackVersion: 1,
        }, []);
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
//# sourceMappingURL=data:application/json;base64,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