import * as core from "../../core";
/**
 * Construction properties of {@link CfnInclude}.
 */
export interface CfnIncludeProps {
    /**
     * Path to the template file.
     *
     * Both JSON and YAML template formats are supported.
     */
    readonly templateFile: string;
}
/**
 * Construct to import an existing CloudFormation template file into a CDK application.
 * All resources defined in the template file can be retrieved by calling the {@link getResource} method.
 * Any modifications made on the returned resource objects will be reflected in the resulting CDK template.
 */
export declare class CfnInclude extends core.CfnElement {
    private readonly conditions;
    private readonly resources;
    private readonly parameters;
    private readonly outputs;
    private readonly template;
    private readonly preserveLogicalIds;
    constructor(scope: core.Construct, id: string, props: CfnIncludeProps);
    /**
     * Returns the low-level CfnResource from the template with the given logical ID.
     * Any modifications performed on that resource will be reflected in the resulting CDK template.
     *
     * The returned object will be of the proper underlying class;
     * you can always cast it to the correct type in your code:
     *
     *     // assume the template contains an AWS::S3::Bucket with logical ID 'Bucket'
     *     const cfnBucket = cfnTemplate.getResource('Bucket') as s3.CfnBucket;
     *     // cfnBucket is of type s3.CfnBucket
     *
     * If the template does not contain a resource with the given logical ID,
     * an exception will be thrown.
     *
     * @param logicalId the logical ID of the resource in the CloudFormation template file
     */
    getResource(logicalId: string): core.CfnResource;
    /**
     * Returns the CfnCondition object from the 'Conditions'
     * section of the CloudFormation template with the given name.
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     *
     * If a Condition with the given name is not present in the template,
     * throws an exception.
     *
     * @param conditionName the name of the Condition in the CloudFormation template file
     */
    getCondition(conditionName: string): core.CfnCondition;
    /**
     * Returns the CfnParameter object from the 'Parameters'
     * section of the included template
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     *
     * If a Parameter with the given name is not present in the template,
     * throws an exception.
     *
     * @param parameterName the name of the parameter to retrieve
     */
    getParameter(parameterName: string): core.CfnParameter;
    /**
     * Returns the CfnOutput object from the 'Outputs'
     * section of the included template
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     *
     * If an Output with the given name is not present in the template,
     * throws an exception.
     *
     * @param logicalId the name of the output to retrieve
     */
    getOutput(logicalId: string): core.CfnOutput;
    private createParameter;
    private createOutput;
    private createCondition;
    private getOrCreateResource;
}
