"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResourceDataSync = exports.CfnPatchBaseline = exports.CfnParameter = exports.CfnMaintenanceWindowTask = exports.CfnMaintenanceWindowTarget = exports.CfnMaintenanceWindow = exports.CfnDocument = exports.CfnAssociation = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-07-09T12:47:49.001Z","fingerprint":"lkHtvUZ5eCGIdP9Mugen36v/h1iWE85NieTiQVUg8fw="}
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnAssociationProps`
 *
 * @param properties - the TypeScript properties of a `CfnAssociationProps`
 *
 * @returns the result of the validation.
 */
function CfnAssociationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('associationName', cdk.validateString)(properties.associationName));
    errors.collect(cdk.propertyValidator('automationTargetParameterName', cdk.validateString)(properties.automationTargetParameterName));
    errors.collect(cdk.propertyValidator('complianceSeverity', cdk.validateString)(properties.complianceSeverity));
    errors.collect(cdk.propertyValidator('documentVersion', cdk.validateString)(properties.documentVersion));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.validateString)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxErrors', cdk.validateString)(properties.maxErrors));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('outputLocation', CfnAssociation_InstanceAssociationOutputLocationPropertyValidator)(properties.outputLocation));
    errors.collect(cdk.propertyValidator('parameters', cdk.hashValidator(cdk.validateString))(properties.parameters));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('syncCompliance', cdk.validateString)(properties.syncCompliance));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnAssociation_TargetPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('waitForSuccessTimeoutSeconds', cdk.validateNumber)(properties.waitForSuccessTimeoutSeconds));
    return errors.wrap('supplied properties not correct for "CfnAssociationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association` resource
 *
 * @param properties - the TypeScript properties of a `CfnAssociationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association` resource.
 */
// @ts-ignore TS6133
function cfnAssociationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociationPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        AssociationName: cdk.stringToCloudFormation(properties.associationName),
        AutomationTargetParameterName: cdk.stringToCloudFormation(properties.automationTargetParameterName),
        ComplianceSeverity: cdk.stringToCloudFormation(properties.complianceSeverity),
        DocumentVersion: cdk.stringToCloudFormation(properties.documentVersion),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        MaxConcurrency: cdk.stringToCloudFormation(properties.maxConcurrency),
        MaxErrors: cdk.stringToCloudFormation(properties.maxErrors),
        OutputLocation: cfnAssociationInstanceAssociationOutputLocationPropertyToCloudFormation(properties.outputLocation),
        Parameters: cdk.hashMapper(cdk.stringToCloudFormation)(properties.parameters),
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
        SyncCompliance: cdk.stringToCloudFormation(properties.syncCompliance),
        Targets: cdk.listMapper(cfnAssociationTargetPropertyToCloudFormation)(properties.targets),
        WaitForSuccessTimeoutSeconds: cdk.numberToCloudFormation(properties.waitForSuccessTimeoutSeconds),
    };
}
// @ts-ignore TS6133
function CfnAssociationPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        associationName: properties.AssociationName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AssociationName),
        automationTargetParameterName: properties.AutomationTargetParameterName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AutomationTargetParameterName),
        complianceSeverity: properties.ComplianceSeverity == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ComplianceSeverity),
        documentVersion: properties.DocumentVersion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DocumentVersion),
        instanceId: properties.InstanceId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.InstanceId),
        maxConcurrency: properties.MaxConcurrency == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MaxConcurrency),
        maxErrors: properties.MaxErrors == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MaxErrors),
        outputLocation: properties.OutputLocation == null ? undefined : CfnAssociationInstanceAssociationOutputLocationPropertyFromCloudFormation(properties.OutputLocation),
        parameters: cfn_parse.FromCloudFormation.getMap(properties.Parameters, (prop1) => cfn_parse.FromCloudFormation.getString(prop1)),
        scheduleExpression: properties.ScheduleExpression == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression),
        syncCompliance: properties.SyncCompliance == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SyncCompliance),
        targets: cfn_parse.FromCloudFormation.getArray(properties.Targets, (prop1) => CfnAssociationTargetPropertyFromCloudFormation(prop1)),
        waitForSuccessTimeoutSeconds: properties.WaitForSuccessTimeoutSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.WaitForSuccessTimeoutSeconds),
    };
}
/**
 * A CloudFormation `AWS::SSM::Association`
 *
 * @cloudformationResource AWS::SSM::Association
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
class CfnAssociation extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::Association`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAssociation.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        this.attrAssociationId = cdk.Token.asString(this.getAtt('AssociationId'));
        this.name = props.name;
        this.associationName = props.associationName;
        this.automationTargetParameterName = props.automationTargetParameterName;
        this.complianceSeverity = props.complianceSeverity;
        this.documentVersion = props.documentVersion;
        this.instanceId = props.instanceId;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.outputLocation = props.outputLocation;
        this.parameters = props.parameters;
        this.scheduleExpression = props.scheduleExpression;
        this.syncCompliance = props.syncCompliance;
        this.targets = props.targets;
        this.waitForSuccessTimeoutSeconds = props.waitForSuccessTimeoutSeconds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnAssociationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAssociation(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAssociation.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            associationName: this.associationName,
            automationTargetParameterName: this.automationTargetParameterName,
            complianceSeverity: this.complianceSeverity,
            documentVersion: this.documentVersion,
            instanceId: this.instanceId,
            maxConcurrency: this.maxConcurrency,
            maxErrors: this.maxErrors,
            outputLocation: this.outputLocation,
            parameters: this.parameters,
            scheduleExpression: this.scheduleExpression,
            syncCompliance: this.syncCompliance,
            targets: this.targets,
            waitForSuccessTimeoutSeconds: this.waitForSuccessTimeoutSeconds,
        };
    }
    renderProperties(props) {
        return cfnAssociationPropsToCloudFormation(props);
    }
}
exports.CfnAssociation = CfnAssociation;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAssociation.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Association";
/**
 * Determine whether the given properties match those of a `InstanceAssociationOutputLocationProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceAssociationOutputLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_InstanceAssociationOutputLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('s3Location', CfnAssociation_S3OutputLocationPropertyValidator)(properties.s3Location));
    return errors.wrap('supplied properties not correct for "InstanceAssociationOutputLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.InstanceAssociationOutputLocation` resource
 *
 * @param properties - the TypeScript properties of a `InstanceAssociationOutputLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.InstanceAssociationOutputLocation` resource.
 */
// @ts-ignore TS6133
function cfnAssociationInstanceAssociationOutputLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_InstanceAssociationOutputLocationPropertyValidator(properties).assertSuccess();
    return {
        S3Location: cfnAssociationS3OutputLocationPropertyToCloudFormation(properties.s3Location),
    };
}
// @ts-ignore TS6133
function CfnAssociationInstanceAssociationOutputLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        s3Location: properties.S3Location == null ? undefined : CfnAssociationS3OutputLocationPropertyFromCloudFormation(properties.S3Location),
    };
}
/**
 * Determine whether the given properties match those of a `S3OutputLocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_S3OutputLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('outputS3BucketName', cdk.validateString)(properties.outputS3BucketName));
    errors.collect(cdk.propertyValidator('outputS3KeyPrefix', cdk.validateString)(properties.outputS3KeyPrefix));
    errors.collect(cdk.propertyValidator('outputS3Region', cdk.validateString)(properties.outputS3Region));
    return errors.wrap('supplied properties not correct for "S3OutputLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.S3OutputLocation` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.S3OutputLocation` resource.
 */
// @ts-ignore TS6133
function cfnAssociationS3OutputLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_S3OutputLocationPropertyValidator(properties).assertSuccess();
    return {
        OutputS3BucketName: cdk.stringToCloudFormation(properties.outputS3BucketName),
        OutputS3KeyPrefix: cdk.stringToCloudFormation(properties.outputS3KeyPrefix),
        OutputS3Region: cdk.stringToCloudFormation(properties.outputS3Region),
    };
}
// @ts-ignore TS6133
function CfnAssociationS3OutputLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        outputS3BucketName: properties.OutputS3BucketName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OutputS3BucketName),
        outputS3KeyPrefix: properties.OutputS3KeyPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OutputS3KeyPrefix),
        outputS3Region: properties.OutputS3Region == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OutputS3Region),
    };
}
/**
 * Determine whether the given properties match those of a `TargetProperty`
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_TargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.Target` resource
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.Target` resource.
 */
// @ts-ignore TS6133
function cfnAssociationTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_TargetPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAssociationTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: cfn_parse.FromCloudFormation.getString(properties.Key),
        values: cfn_parse.FromCloudFormation.getStringArray(properties.Values),
    };
}
/**
 * Determine whether the given properties match those of a `CfnDocumentProps`
 *
 * @param properties - the TypeScript properties of a `CfnDocumentProps`
 *
 * @returns the result of the validation.
 */
function CfnDocumentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('content', cdk.requiredValidator)(properties.content));
    errors.collect(cdk.propertyValidator('content', cdk.validateObject)(properties.content));
    errors.collect(cdk.propertyValidator('documentType', cdk.validateString)(properties.documentType));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDocumentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Document` resource
 *
 * @param properties - the TypeScript properties of a `CfnDocumentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Document` resource.
 */
// @ts-ignore TS6133
function cfnDocumentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDocumentPropsValidator(properties).assertSuccess();
    return {
        Content: cdk.objectToCloudFormation(properties.content),
        DocumentType: cdk.stringToCloudFormation(properties.documentType),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDocumentPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        content: cfn_parse.FromCloudFormation.getAny(properties.Content),
        documentType: properties.DocumentType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DocumentType),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        tags: cfn_parse.FromCloudFormation.getArray(properties.Tags, (prop1) => cfn_parse.FromCloudFormation.getCfnTag(prop1)),
    };
}
/**
 * A CloudFormation `AWS::SSM::Document`
 *
 * @cloudformationResource AWS::SSM::Document
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
class CfnDocument extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::Document`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDocument.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'content', this);
        this.content = props.content;
        this.documentType = props.documentType;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::Document", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnDocumentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDocument(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDocument.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            content: this.content,
            documentType: this.documentType,
            name: this.name,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDocumentPropsToCloudFormation(props);
    }
}
exports.CfnDocument = CfnDocument;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDocument.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Document";
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowUnassociatedTargets', cdk.requiredValidator)(properties.allowUnassociatedTargets));
    errors.collect(cdk.propertyValidator('allowUnassociatedTargets', cdk.validateBoolean)(properties.allowUnassociatedTargets));
    errors.collect(cdk.propertyValidator('cutoff', cdk.requiredValidator)(properties.cutoff));
    errors.collect(cdk.propertyValidator('cutoff', cdk.validateNumber)(properties.cutoff));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('duration', cdk.requiredValidator)(properties.duration));
    errors.collect(cdk.propertyValidator('duration', cdk.validateNumber)(properties.duration));
    errors.collect(cdk.propertyValidator('endDate', cdk.validateString)(properties.endDate));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('schedule', cdk.requiredValidator)(properties.schedule));
    errors.collect(cdk.propertyValidator('schedule', cdk.validateString)(properties.schedule));
    errors.collect(cdk.propertyValidator('scheduleOffset', cdk.validateNumber)(properties.scheduleOffset));
    errors.collect(cdk.propertyValidator('scheduleTimezone', cdk.validateString)(properties.scheduleTimezone));
    errors.collect(cdk.propertyValidator('startDate', cdk.validateString)(properties.startDate));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindow` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindow` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowPropsValidator(properties).assertSuccess();
    return {
        AllowUnassociatedTargets: cdk.booleanToCloudFormation(properties.allowUnassociatedTargets),
        Cutoff: cdk.numberToCloudFormation(properties.cutoff),
        Duration: cdk.numberToCloudFormation(properties.duration),
        Name: cdk.stringToCloudFormation(properties.name),
        Schedule: cdk.stringToCloudFormation(properties.schedule),
        Description: cdk.stringToCloudFormation(properties.description),
        EndDate: cdk.stringToCloudFormation(properties.endDate),
        ScheduleOffset: cdk.numberToCloudFormation(properties.scheduleOffset),
        ScheduleTimezone: cdk.stringToCloudFormation(properties.scheduleTimezone),
        StartDate: cdk.stringToCloudFormation(properties.startDate),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        allowUnassociatedTargets: cfn_parse.FromCloudFormation.getBoolean(properties.AllowUnassociatedTargets),
        cutoff: cfn_parse.FromCloudFormation.getNumber(properties.Cutoff),
        duration: cfn_parse.FromCloudFormation.getNumber(properties.Duration),
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        schedule: cfn_parse.FromCloudFormation.getString(properties.Schedule),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        endDate: properties.EndDate == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EndDate),
        scheduleOffset: properties.ScheduleOffset == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.ScheduleOffset),
        scheduleTimezone: properties.ScheduleTimezone == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ScheduleTimezone),
        startDate: properties.StartDate == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.StartDate),
        tags: cfn_parse.FromCloudFormation.getArray(properties.Tags, (prop1) => cfn_parse.FromCloudFormation.getCfnTag(prop1)),
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindow`
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindow
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 */
class CfnMaintenanceWindow extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::MaintenanceWindow`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'allowUnassociatedTargets', this);
        cdk.requireProperty(props, 'cutoff', this);
        cdk.requireProperty(props, 'duration', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'schedule', this);
        this.allowUnassociatedTargets = props.allowUnassociatedTargets;
        this.cutoff = props.cutoff;
        this.duration = props.duration;
        this.name = props.name;
        this.schedule = props.schedule;
        this.description = props.description;
        this.endDate = props.endDate;
        this.scheduleOffset = props.scheduleOffset;
        this.scheduleTimezone = props.scheduleTimezone;
        this.startDate = props.startDate;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::MaintenanceWindow", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnMaintenanceWindowPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindow(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allowUnassociatedTargets: this.allowUnassociatedTargets,
            cutoff: this.cutoff,
            duration: this.duration,
            name: this.name,
            schedule: this.schedule,
            description: this.description,
            endDate: this.endDate,
            scheduleOffset: this.scheduleOffset,
            scheduleTimezone: this.scheduleTimezone,
            startDate: this.startDate,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowPropsToCloudFormation(props);
    }
}
exports.CfnMaintenanceWindow = CfnMaintenanceWindow;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindow";
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowTargetProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTargetProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTargetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('ownerInformation', cdk.validateString)(properties.ownerInformation));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('targets', cdk.requiredValidator)(properties.targets));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnMaintenanceWindowTarget_TargetsPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('windowId', cdk.requiredValidator)(properties.windowId));
    errors.collect(cdk.propertyValidator('windowId', cdk.validateString)(properties.windowId));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowTargetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTargetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTargetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTargetPropsValidator(properties).assertSuccess();
    return {
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        Targets: cdk.listMapper(cfnMaintenanceWindowTargetTargetsPropertyToCloudFormation)(properties.targets),
        WindowId: cdk.stringToCloudFormation(properties.windowId),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        OwnerInformation: cdk.stringToCloudFormation(properties.ownerInformation),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTargetPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        resourceType: cfn_parse.FromCloudFormation.getString(properties.ResourceType),
        targets: cfn_parse.FromCloudFormation.getArray(properties.Targets, (prop1) => CfnMaintenanceWindowTargetTargetsPropertyFromCloudFormation(prop1)),
        windowId: cfn_parse.FromCloudFormation.getString(properties.WindowId),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        ownerInformation: properties.OwnerInformation == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OwnerInformation),
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 */
class CfnMaintenanceWindowTarget extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTarget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'targets', this);
        cdk.requireProperty(props, 'windowId', this);
        this.resourceType = props.resourceType;
        this.targets = props.targets;
        this.windowId = props.windowId;
        this.description = props.description;
        this.name = props.name;
        this.ownerInformation = props.ownerInformation;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnMaintenanceWindowTargetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindowTarget(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            resourceType: this.resourceType,
            targets: this.targets,
            windowId: this.windowId,
            description: this.description,
            name: this.name,
            ownerInformation: this.ownerInformation,
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowTargetPropsToCloudFormation(props);
    }
}
exports.CfnMaintenanceWindowTarget = CfnMaintenanceWindowTarget;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTarget";
/**
 * Determine whether the given properties match those of a `TargetsProperty`
 *
 * @param properties - the TypeScript properties of a `TargetsProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTarget_TargetsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget.Targets` resource
 *
 * @param properties - the TypeScript properties of a `TargetsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget.Targets` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTargetTargetsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTarget_TargetsPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTargetTargetsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: cfn_parse.FromCloudFormation.getString(properties.Key),
        values: cfn_parse.FromCloudFormation.getStringArray(properties.Values),
    };
}
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('loggingInfo', CfnMaintenanceWindowTask_LoggingInfoPropertyValidator)(properties.loggingInfo));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.requiredValidator)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.validateString)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxErrors', cdk.requiredValidator)(properties.maxErrors));
    errors.collect(cdk.propertyValidator('maxErrors', cdk.validateString)(properties.maxErrors));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('targets', cdk.requiredValidator)(properties.targets));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnMaintenanceWindowTask_TargetPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('taskArn', cdk.requiredValidator)(properties.taskArn));
    errors.collect(cdk.propertyValidator('taskArn', cdk.validateString)(properties.taskArn));
    errors.collect(cdk.propertyValidator('taskInvocationParameters', CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator)(properties.taskInvocationParameters));
    errors.collect(cdk.propertyValidator('taskParameters', cdk.validateObject)(properties.taskParameters));
    errors.collect(cdk.propertyValidator('taskType', cdk.requiredValidator)(properties.taskType));
    errors.collect(cdk.propertyValidator('taskType', cdk.validateString)(properties.taskType));
    errors.collect(cdk.propertyValidator('windowId', cdk.requiredValidator)(properties.windowId));
    errors.collect(cdk.propertyValidator('windowId', cdk.validateString)(properties.windowId));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTaskPropsValidator(properties).assertSuccess();
    return {
        MaxConcurrency: cdk.stringToCloudFormation(properties.maxConcurrency),
        MaxErrors: cdk.stringToCloudFormation(properties.maxErrors),
        Priority: cdk.numberToCloudFormation(properties.priority),
        Targets: cdk.listMapper(cfnMaintenanceWindowTaskTargetPropertyToCloudFormation)(properties.targets),
        TaskArn: cdk.stringToCloudFormation(properties.taskArn),
        TaskType: cdk.stringToCloudFormation(properties.taskType),
        WindowId: cdk.stringToCloudFormation(properties.windowId),
        Description: cdk.stringToCloudFormation(properties.description),
        LoggingInfo: cfnMaintenanceWindowTaskLoggingInfoPropertyToCloudFormation(properties.loggingInfo),
        Name: cdk.stringToCloudFormation(properties.name),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        TaskInvocationParameters: cfnMaintenanceWindowTaskTaskInvocationParametersPropertyToCloudFormation(properties.taskInvocationParameters),
        TaskParameters: cdk.objectToCloudFormation(properties.taskParameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        maxConcurrency: cfn_parse.FromCloudFormation.getString(properties.MaxConcurrency),
        maxErrors: cfn_parse.FromCloudFormation.getString(properties.MaxErrors),
        priority: cfn_parse.FromCloudFormation.getNumber(properties.Priority),
        targets: cfn_parse.FromCloudFormation.getArray(properties.Targets, (prop1) => CfnMaintenanceWindowTaskTargetPropertyFromCloudFormation(prop1)),
        taskArn: cfn_parse.FromCloudFormation.getString(properties.TaskArn),
        taskType: cfn_parse.FromCloudFormation.getString(properties.TaskType),
        windowId: cfn_parse.FromCloudFormation.getString(properties.WindowId),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        loggingInfo: properties.LoggingInfo == null ? undefined : CfnMaintenanceWindowTaskLoggingInfoPropertyFromCloudFormation(properties.LoggingInfo),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        serviceRoleArn: properties.ServiceRoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn),
        taskInvocationParameters: properties.TaskInvocationParameters == null ? undefined : CfnMaintenanceWindowTaskTaskInvocationParametersPropertyFromCloudFormation(properties.TaskInvocationParameters),
        taskParameters: properties.TaskParameters == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.TaskParameters),
    };
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
class CfnMaintenanceWindowTask extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'maxConcurrency', this);
        cdk.requireProperty(props, 'maxErrors', this);
        cdk.requireProperty(props, 'priority', this);
        cdk.requireProperty(props, 'targets', this);
        cdk.requireProperty(props, 'taskArn', this);
        cdk.requireProperty(props, 'taskType', this);
        cdk.requireProperty(props, 'windowId', this);
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.priority = props.priority;
        this.targets = props.targets;
        this.taskArn = props.taskArn;
        this.taskType = props.taskType;
        this.windowId = props.windowId;
        this.description = props.description;
        this.loggingInfo = props.loggingInfo;
        this.name = props.name;
        this.serviceRoleArn = props.serviceRoleArn;
        this.taskInvocationParameters = props.taskInvocationParameters;
        this.taskParameters = props.taskParameters;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnMaintenanceWindowTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindowTask(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            maxConcurrency: this.maxConcurrency,
            maxErrors: this.maxErrors,
            priority: this.priority,
            targets: this.targets,
            taskArn: this.taskArn,
            taskType: this.taskType,
            windowId: this.windowId,
            description: this.description,
            loggingInfo: this.loggingInfo,
            name: this.name,
            serviceRoleArn: this.serviceRoleArn,
            taskInvocationParameters: this.taskInvocationParameters,
            taskParameters: this.taskParameters,
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowTaskPropsToCloudFormation(props);
    }
}
exports.CfnMaintenanceWindowTask = CfnMaintenanceWindowTask;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTask";
/**
 * Determine whether the given properties match those of a `LoggingInfoProperty`
 *
 * @param properties - the TypeScript properties of a `LoggingInfoProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_LoggingInfoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('region', cdk.requiredValidator)(properties.region));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.requiredValidator)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.validateString)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.validateString)(properties.s3Prefix));
    return errors.wrap('supplied properties not correct for "LoggingInfoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.LoggingInfo` resource
 *
 * @param properties - the TypeScript properties of a `LoggingInfoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.LoggingInfo` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskLoggingInfoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_LoggingInfoPropertyValidator(properties).assertSuccess();
    return {
        Region: cdk.stringToCloudFormation(properties.region),
        S3Bucket: cdk.stringToCloudFormation(properties.s3Bucket),
        S3Prefix: cdk.stringToCloudFormation(properties.s3Prefix),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskLoggingInfoPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        region: cfn_parse.FromCloudFormation.getString(properties.Region),
        s3Bucket: cfn_parse.FromCloudFormation.getString(properties.S3Bucket),
        s3Prefix: properties.S3Prefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.S3Prefix),
    };
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('documentVersion', cdk.validateString)(properties.documentVersion));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowAutomationParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowAutomationParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowAutomationParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator(properties).assertSuccess();
    return {
        DocumentVersion: cdk.stringToCloudFormation(properties.documentVersion),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        documentVersion: properties.DocumentVersion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DocumentVersion),
        parameters: properties.Parameters == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.Parameters),
    };
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('clientContext', cdk.validateString)(properties.clientContext));
    errors.collect(cdk.propertyValidator('payload', cdk.validateString)(properties.payload));
    errors.collect(cdk.propertyValidator('qualifier', cdk.validateString)(properties.qualifier));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowLambdaParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowLambdaParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowLambdaParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator(properties).assertSuccess();
    return {
        ClientContext: cdk.stringToCloudFormation(properties.clientContext),
        Payload: cdk.stringToCloudFormation(properties.payload),
        Qualifier: cdk.stringToCloudFormation(properties.qualifier),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        clientContext: properties.ClientContext == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ClientContext),
        payload: properties.Payload == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Payload),
        qualifier: properties.Qualifier == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Qualifier),
    };
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('documentHash', cdk.validateString)(properties.documentHash));
    errors.collect(cdk.propertyValidator('documentHashType', cdk.validateString)(properties.documentHashType));
    errors.collect(cdk.propertyValidator('notificationConfig', CfnMaintenanceWindowTask_NotificationConfigPropertyValidator)(properties.notificationConfig));
    errors.collect(cdk.propertyValidator('outputS3BucketName', cdk.validateString)(properties.outputS3BucketName));
    errors.collect(cdk.propertyValidator('outputS3KeyPrefix', cdk.validateString)(properties.outputS3KeyPrefix));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('timeoutSeconds', cdk.validateNumber)(properties.timeoutSeconds));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowRunCommandParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowRunCommandParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowRunCommandParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator(properties).assertSuccess();
    return {
        Comment: cdk.stringToCloudFormation(properties.comment),
        DocumentHash: cdk.stringToCloudFormation(properties.documentHash),
        DocumentHashType: cdk.stringToCloudFormation(properties.documentHashType),
        NotificationConfig: cfnMaintenanceWindowTaskNotificationConfigPropertyToCloudFormation(properties.notificationConfig),
        OutputS3BucketName: cdk.stringToCloudFormation(properties.outputS3BucketName),
        OutputS3KeyPrefix: cdk.stringToCloudFormation(properties.outputS3KeyPrefix),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        TimeoutSeconds: cdk.numberToCloudFormation(properties.timeoutSeconds),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        comment: properties.Comment == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Comment),
        documentHash: properties.DocumentHash == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DocumentHash),
        documentHashType: properties.DocumentHashType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DocumentHashType),
        notificationConfig: properties.NotificationConfig == null ? undefined : CfnMaintenanceWindowTaskNotificationConfigPropertyFromCloudFormation(properties.NotificationConfig),
        outputS3BucketName: properties.OutputS3BucketName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OutputS3BucketName),
        outputS3KeyPrefix: properties.OutputS3KeyPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OutputS3KeyPrefix),
        parameters: properties.Parameters == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.Parameters),
        serviceRoleArn: properties.ServiceRoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn),
        timeoutSeconds: properties.TimeoutSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.TimeoutSeconds),
    };
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('input', cdk.validateString)(properties.input));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowStepFunctionsParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowStepFunctionsParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowStepFunctionsParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator(properties).assertSuccess();
    return {
        Input: cdk.stringToCloudFormation(properties.input),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        input: properties.Input == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Input),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
    };
}
/**
 * Determine whether the given properties match those of a `NotificationConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_NotificationConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('notificationArn', cdk.requiredValidator)(properties.notificationArn));
    errors.collect(cdk.propertyValidator('notificationArn', cdk.validateString)(properties.notificationArn));
    errors.collect(cdk.propertyValidator('notificationEvents', cdk.listValidator(cdk.validateString))(properties.notificationEvents));
    errors.collect(cdk.propertyValidator('notificationType', cdk.validateString)(properties.notificationType));
    return errors.wrap('supplied properties not correct for "NotificationConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.NotificationConfig` resource
 *
 * @param properties - the TypeScript properties of a `NotificationConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.NotificationConfig` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskNotificationConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_NotificationConfigPropertyValidator(properties).assertSuccess();
    return {
        NotificationArn: cdk.stringToCloudFormation(properties.notificationArn),
        NotificationEvents: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationEvents),
        NotificationType: cdk.stringToCloudFormation(properties.notificationType),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskNotificationConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        notificationArn: cfn_parse.FromCloudFormation.getString(properties.NotificationArn),
        notificationEvents: cfn_parse.FromCloudFormation.getStringArray(properties.NotificationEvents),
        notificationType: properties.NotificationType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.NotificationType),
    };
}
/**
 * Determine whether the given properties match those of a `TargetProperty`
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_TargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.Target` resource
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.Target` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_TargetPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: cfn_parse.FromCloudFormation.getString(properties.Key),
        values: cfn_parse.FromCloudFormation.getStringArray(properties.Values),
    };
}
/**
 * Determine whether the given properties match those of a `TaskInvocationParametersProperty`
 *
 * @param properties - the TypeScript properties of a `TaskInvocationParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('maintenanceWindowAutomationParameters', CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator)(properties.maintenanceWindowAutomationParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowLambdaParameters', CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator)(properties.maintenanceWindowLambdaParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowRunCommandParameters', CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator)(properties.maintenanceWindowRunCommandParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowStepFunctionsParameters', CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator)(properties.maintenanceWindowStepFunctionsParameters));
    return errors.wrap('supplied properties not correct for "TaskInvocationParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters` resource
 *
 * @param properties - the TypeScript properties of a `TaskInvocationParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskTaskInvocationParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator(properties).assertSuccess();
    return {
        MaintenanceWindowAutomationParameters: cfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyToCloudFormation(properties.maintenanceWindowAutomationParameters),
        MaintenanceWindowLambdaParameters: cfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyToCloudFormation(properties.maintenanceWindowLambdaParameters),
        MaintenanceWindowRunCommandParameters: cfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyToCloudFormation(properties.maintenanceWindowRunCommandParameters),
        MaintenanceWindowStepFunctionsParameters: cfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyToCloudFormation(properties.maintenanceWindowStepFunctionsParameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskTaskInvocationParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        maintenanceWindowAutomationParameters: properties.MaintenanceWindowAutomationParameters == null ? undefined : CfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyFromCloudFormation(properties.MaintenanceWindowAutomationParameters),
        maintenanceWindowLambdaParameters: properties.MaintenanceWindowLambdaParameters == null ? undefined : CfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyFromCloudFormation(properties.MaintenanceWindowLambdaParameters),
        maintenanceWindowRunCommandParameters: properties.MaintenanceWindowRunCommandParameters == null ? undefined : CfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyFromCloudFormation(properties.MaintenanceWindowRunCommandParameters),
        maintenanceWindowStepFunctionsParameters: properties.MaintenanceWindowStepFunctionsParameters == null ? undefined : CfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyFromCloudFormation(properties.MaintenanceWindowStepFunctionsParameters),
    };
}
/**
 * Determine whether the given properties match those of a `CfnParameterProps`
 *
 * @param properties - the TypeScript properties of a `CfnParameterProps`
 *
 * @returns the result of the validation.
 */
function CfnParameterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowedPattern', cdk.validateString)(properties.allowedPattern));
    errors.collect(cdk.propertyValidator('dataType', cdk.validateString)(properties.dataType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('policies', cdk.validateString)(properties.policies));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('tier', cdk.validateString)(properties.tier));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "CfnParameterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Parameter` resource
 *
 * @param properties - the TypeScript properties of a `CfnParameterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Parameter` resource.
 */
// @ts-ignore TS6133
function cfnParameterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnParameterPropsValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cdk.stringToCloudFormation(properties.value),
        AllowedPattern: cdk.stringToCloudFormation(properties.allowedPattern),
        DataType: cdk.stringToCloudFormation(properties.dataType),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Policies: cdk.stringToCloudFormation(properties.policies),
        Tags: cdk.objectToCloudFormation(properties.tags),
        Tier: cdk.stringToCloudFormation(properties.tier),
    };
}
// @ts-ignore TS6133
function CfnParameterPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        type: cfn_parse.FromCloudFormation.getString(properties.Type),
        value: cfn_parse.FromCloudFormation.getString(properties.Value),
        allowedPattern: properties.AllowedPattern == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AllowedPattern),
        dataType: properties.DataType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DataType),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        policies: properties.Policies == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Policies),
        tags: properties.Tags == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.Tags),
        tier: properties.Tier == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Tier),
    };
}
/**
 * A CloudFormation `AWS::SSM::Parameter`
 *
 * @cloudformationResource AWS::SSM::Parameter
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 */
class CfnParameter extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::Parameter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnParameter.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'type', this);
        cdk.requireProperty(props, 'value', this);
        this.attrType = cdk.Token.asString(this.getAtt('Type'));
        this.attrValue = cdk.Token.asString(this.getAtt('Value'));
        this.type = props.type;
        this.value = props.value;
        this.allowedPattern = props.allowedPattern;
        this.dataType = props.dataType;
        this.description = props.description;
        this.name = props.name;
        this.policies = props.policies;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::SSM::Parameter", props.tags, { tagPropertyName: 'tags' });
        this.tier = props.tier;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnParameterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnParameter(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnParameter.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            type: this.type,
            value: this.value,
            allowedPattern: this.allowedPattern,
            dataType: this.dataType,
            description: this.description,
            name: this.name,
            policies: this.policies,
            tags: this.tags.renderTags(),
            tier: this.tier,
        };
    }
    renderProperties(props) {
        return cfnParameterPropsToCloudFormation(props);
    }
}
exports.CfnParameter = CfnParameter;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnParameter.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Parameter";
/**
 * Determine whether the given properties match those of a `CfnPatchBaselineProps`
 *
 * @param properties - the TypeScript properties of a `CfnPatchBaselineProps`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaselinePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('approvalRules', CfnPatchBaseline_RuleGroupPropertyValidator)(properties.approvalRules));
    errors.collect(cdk.propertyValidator('approvedPatches', cdk.listValidator(cdk.validateString))(properties.approvedPatches));
    errors.collect(cdk.propertyValidator('approvedPatchesComplianceLevel', cdk.validateString)(properties.approvedPatchesComplianceLevel));
    errors.collect(cdk.propertyValidator('approvedPatchesEnableNonSecurity', cdk.validateBoolean)(properties.approvedPatchesEnableNonSecurity));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('globalFilters', CfnPatchBaseline_PatchFilterGroupPropertyValidator)(properties.globalFilters));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('operatingSystem', cdk.validateString)(properties.operatingSystem));
    errors.collect(cdk.propertyValidator('patchGroups', cdk.listValidator(cdk.validateString))(properties.patchGroups));
    errors.collect(cdk.propertyValidator('rejectedPatches', cdk.listValidator(cdk.validateString))(properties.rejectedPatches));
    errors.collect(cdk.propertyValidator('rejectedPatchesAction', cdk.validateString)(properties.rejectedPatchesAction));
    errors.collect(cdk.propertyValidator('sources', cdk.listValidator(CfnPatchBaseline_PatchSourcePropertyValidator))(properties.sources));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPatchBaselineProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline` resource
 *
 * @param properties - the TypeScript properties of a `CfnPatchBaselineProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaselinePropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ApprovalRules: cfnPatchBaselineRuleGroupPropertyToCloudFormation(properties.approvalRules),
        ApprovedPatches: cdk.listMapper(cdk.stringToCloudFormation)(properties.approvedPatches),
        ApprovedPatchesComplianceLevel: cdk.stringToCloudFormation(properties.approvedPatchesComplianceLevel),
        ApprovedPatchesEnableNonSecurity: cdk.booleanToCloudFormation(properties.approvedPatchesEnableNonSecurity),
        Description: cdk.stringToCloudFormation(properties.description),
        GlobalFilters: cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties.globalFilters),
        OperatingSystem: cdk.stringToCloudFormation(properties.operatingSystem),
        PatchGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.patchGroups),
        RejectedPatches: cdk.listMapper(cdk.stringToCloudFormation)(properties.rejectedPatches),
        RejectedPatchesAction: cdk.stringToCloudFormation(properties.rejectedPatchesAction),
        Sources: cdk.listMapper(cfnPatchBaselinePatchSourcePropertyToCloudFormation)(properties.sources),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        approvalRules: properties.ApprovalRules == null ? undefined : CfnPatchBaselineRuleGroupPropertyFromCloudFormation(properties.ApprovalRules),
        approvedPatches: cfn_parse.FromCloudFormation.getStringArray(properties.ApprovedPatches),
        approvedPatchesComplianceLevel: properties.ApprovedPatchesComplianceLevel == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ApprovedPatchesComplianceLevel),
        approvedPatchesEnableNonSecurity: properties.ApprovedPatchesEnableNonSecurity == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.ApprovedPatchesEnableNonSecurity),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        globalFilters: properties.GlobalFilters == null ? undefined : CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties.GlobalFilters),
        operatingSystem: properties.OperatingSystem == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.OperatingSystem),
        patchGroups: cfn_parse.FromCloudFormation.getStringArray(properties.PatchGroups),
        rejectedPatches: cfn_parse.FromCloudFormation.getStringArray(properties.RejectedPatches),
        rejectedPatchesAction: properties.RejectedPatchesAction == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RejectedPatchesAction),
        sources: cfn_parse.FromCloudFormation.getArray(properties.Sources, (prop1) => CfnPatchBaselinePatchSourcePropertyFromCloudFormation(prop1)),
        tags: cfn_parse.FromCloudFormation.getArray(properties.Tags, (prop1) => cfn_parse.FromCloudFormation.getCfnTag(prop1)),
    };
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`
 *
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
class CfnPatchBaseline extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::PatchBaseline`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        this.name = props.name;
        this.approvalRules = props.approvalRules;
        this.approvedPatches = props.approvedPatches;
        this.approvedPatchesComplianceLevel = props.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = props.approvedPatchesEnableNonSecurity;
        this.description = props.description;
        this.globalFilters = props.globalFilters;
        this.operatingSystem = props.operatingSystem;
        this.patchGroups = props.patchGroups;
        this.rejectedPatches = props.rejectedPatches;
        this.rejectedPatchesAction = props.rejectedPatchesAction;
        this.sources = props.sources;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::PatchBaseline", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnPatchBaselinePropsFromCloudFormation(resourceProperties);
        const ret = new CfnPatchBaseline(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            approvalRules: this.approvalRules,
            approvedPatches: this.approvedPatches,
            approvedPatchesComplianceLevel: this.approvedPatchesComplianceLevel,
            approvedPatchesEnableNonSecurity: this.approvedPatchesEnableNonSecurity,
            description: this.description,
            globalFilters: this.globalFilters,
            operatingSystem: this.operatingSystem,
            patchGroups: this.patchGroups,
            rejectedPatches: this.rejectedPatches,
            rejectedPatchesAction: this.rejectedPatchesAction,
            sources: this.sources,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPatchBaselinePropsToCloudFormation(props);
    }
}
exports.CfnPatchBaseline = CfnPatchBaseline;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::PatchBaseline";
/**
 * Determine whether the given properties match those of a `PatchFilterProperty`
 *
 * @param properties - the TypeScript properties of a `PatchFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "PatchFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilter` resource
 *
 * @param properties - the TypeScript properties of a `PatchFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilter` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchFilterPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        key: properties.Key == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Key),
        values: cfn_parse.FromCloudFormation.getStringArray(properties.Values),
    };
}
/**
 * Determine whether the given properties match those of a `PatchFilterGroupProperty`
 *
 * @param properties - the TypeScript properties of a `PatchFilterGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchFilterGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('patchFilters', cdk.listValidator(CfnPatchBaseline_PatchFilterPropertyValidator))(properties.patchFilters));
    return errors.wrap('supplied properties not correct for "PatchFilterGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilterGroup` resource
 *
 * @param properties - the TypeScript properties of a `PatchFilterGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilterGroup` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchFilterGroupPropertyValidator(properties).assertSuccess();
    return {
        PatchFilters: cdk.listMapper(cfnPatchBaselinePatchFilterPropertyToCloudFormation)(properties.patchFilters),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        patchFilters: cfn_parse.FromCloudFormation.getArray(properties.PatchFilters, (prop1) => CfnPatchBaselinePatchFilterPropertyFromCloudFormation(prop1)),
    };
}
/**
 * Determine whether the given properties match those of a `PatchSourceProperty`
 *
 * @param properties - the TypeScript properties of a `PatchSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('configuration', cdk.validateString)(properties.configuration));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('products', cdk.listValidator(cdk.validateString))(properties.products));
    return errors.wrap('supplied properties not correct for "PatchSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchSource` resource
 *
 * @param properties - the TypeScript properties of a `PatchSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchSource` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchSourcePropertyValidator(properties).assertSuccess();
    return {
        Configuration: cdk.stringToCloudFormation(properties.configuration),
        Name: cdk.stringToCloudFormation(properties.name),
        Products: cdk.listMapper(cdk.stringToCloudFormation)(properties.products),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        configuration: properties.Configuration == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Configuration),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        products: cfn_parse.FromCloudFormation.getStringArray(properties.Products),
    };
}
/**
 * Determine whether the given properties match those of a `RuleProperty`
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_RulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('approveAfterDays', cdk.validateNumber)(properties.approveAfterDays));
    errors.collect(cdk.propertyValidator('approveUntilDate', cdk.validateString)(properties.approveUntilDate));
    errors.collect(cdk.propertyValidator('complianceLevel', cdk.validateString)(properties.complianceLevel));
    errors.collect(cdk.propertyValidator('enableNonSecurity', cdk.validateBoolean)(properties.enableNonSecurity));
    errors.collect(cdk.propertyValidator('patchFilterGroup', CfnPatchBaseline_PatchFilterGroupPropertyValidator)(properties.patchFilterGroup));
    return errors.wrap('supplied properties not correct for "RuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.Rule` resource
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.Rule` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselineRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_RulePropertyValidator(properties).assertSuccess();
    return {
        ApproveAfterDays: cdk.numberToCloudFormation(properties.approveAfterDays),
        ApproveUntilDate: cdk.stringToCloudFormation(properties.approveUntilDate),
        ComplianceLevel: cdk.stringToCloudFormation(properties.complianceLevel),
        EnableNonSecurity: cdk.booleanToCloudFormation(properties.enableNonSecurity),
        PatchFilterGroup: cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties.patchFilterGroup),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselineRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        approveAfterDays: properties.ApproveAfterDays == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.ApproveAfterDays),
        approveUntilDate: properties.ApproveUntilDate == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ApproveUntilDate),
        complianceLevel: properties.ComplianceLevel == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ComplianceLevel),
        enableNonSecurity: properties.EnableNonSecurity == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.EnableNonSecurity),
        patchFilterGroup: properties.PatchFilterGroup == null ? undefined : CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties.PatchFilterGroup),
    };
}
/**
 * Determine whether the given properties match those of a `RuleGroupProperty`
 *
 * @param properties - the TypeScript properties of a `RuleGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_RuleGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('patchRules', cdk.listValidator(CfnPatchBaseline_RulePropertyValidator))(properties.patchRules));
    return errors.wrap('supplied properties not correct for "RuleGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.RuleGroup` resource
 *
 * @param properties - the TypeScript properties of a `RuleGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.RuleGroup` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselineRuleGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_RuleGroupPropertyValidator(properties).assertSuccess();
    return {
        PatchRules: cdk.listMapper(cfnPatchBaselineRulePropertyToCloudFormation)(properties.patchRules),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselineRuleGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        patchRules: cfn_parse.FromCloudFormation.getArray(properties.PatchRules, (prop1) => CfnPatchBaselineRulePropertyFromCloudFormation(prop1)),
    };
}
/**
 * Determine whether the given properties match those of a `CfnResourceDataSyncProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourceDataSyncProps`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSyncPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketPrefix', cdk.validateString)(properties.bucketPrefix));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.validateString)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('kmsKeyArn', cdk.validateString)(properties.kmsKeyArn));
    errors.collect(cdk.propertyValidator('s3Destination', CfnResourceDataSync_S3DestinationPropertyValidator)(properties.s3Destination));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.validateString)(properties.syncFormat));
    errors.collect(cdk.propertyValidator('syncName', cdk.requiredValidator)(properties.syncName));
    errors.collect(cdk.propertyValidator('syncName', cdk.validateString)(properties.syncName));
    errors.collect(cdk.propertyValidator('syncSource', CfnResourceDataSync_SyncSourcePropertyValidator)(properties.syncSource));
    errors.collect(cdk.propertyValidator('syncType', cdk.validateString)(properties.syncType));
    return errors.wrap('supplied properties not correct for "CfnResourceDataSyncProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourceDataSyncProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSyncPropsValidator(properties).assertSuccess();
    return {
        SyncName: cdk.stringToCloudFormation(properties.syncName),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        BucketPrefix: cdk.stringToCloudFormation(properties.bucketPrefix),
        BucketRegion: cdk.stringToCloudFormation(properties.bucketRegion),
        KMSKeyArn: cdk.stringToCloudFormation(properties.kmsKeyArn),
        S3Destination: cfnResourceDataSyncS3DestinationPropertyToCloudFormation(properties.s3Destination),
        SyncFormat: cdk.stringToCloudFormation(properties.syncFormat),
        SyncSource: cfnResourceDataSyncSyncSourcePropertyToCloudFormation(properties.syncSource),
        SyncType: cdk.stringToCloudFormation(properties.syncType),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        syncName: cfn_parse.FromCloudFormation.getString(properties.SyncName),
        bucketName: properties.BucketName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.BucketName),
        bucketPrefix: properties.BucketPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.BucketPrefix),
        bucketRegion: properties.BucketRegion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.BucketRegion),
        kmsKeyArn: properties.KMSKeyArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.KMSKeyArn),
        s3Destination: properties.S3Destination == null ? undefined : CfnResourceDataSyncS3DestinationPropertyFromCloudFormation(properties.S3Destination),
        syncFormat: properties.SyncFormat == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SyncFormat),
        syncSource: properties.SyncSource == null ? undefined : CfnResourceDataSyncSyncSourcePropertyFromCloudFormation(properties.SyncSource),
        syncType: properties.SyncType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SyncType),
    };
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`
 *
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
class CfnResourceDataSync extends cdk.CfnResource {
    /**
     * Create a new `AWS::SSM::ResourceDataSync`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'syncName', this);
        this.syncName = props.syncName;
        this.bucketName = props.bucketName;
        this.bucketPrefix = props.bucketPrefix;
        this.bucketRegion = props.bucketRegion;
        this.kmsKeyArn = props.kmsKeyArn;
        this.s3Destination = props.s3Destination;
        this.syncFormat = props.syncFormat;
        this.syncSource = props.syncSource;
        this.syncType = props.syncType;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnResourceDataSyncPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourceDataSync(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            syncName: this.syncName,
            bucketName: this.bucketName,
            bucketPrefix: this.bucketPrefix,
            bucketRegion: this.bucketRegion,
            kmsKeyArn: this.kmsKeyArn,
            s3Destination: this.s3Destination,
            syncFormat: this.syncFormat,
            syncSource: this.syncSource,
            syncType: this.syncType,
        };
    }
    renderProperties(props) {
        return cfnResourceDataSyncPropsToCloudFormation(props);
    }
}
exports.CfnResourceDataSync = CfnResourceDataSync;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::ResourceDataSync";
/**
 * Determine whether the given properties match those of a `AwsOrganizationsSourceProperty`
 *
 * @param properties - the TypeScript properties of a `AwsOrganizationsSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('organizationSourceType', cdk.requiredValidator)(properties.organizationSourceType));
    errors.collect(cdk.propertyValidator('organizationSourceType', cdk.validateString)(properties.organizationSourceType));
    errors.collect(cdk.propertyValidator('organizationalUnits', cdk.listValidator(cdk.validateString))(properties.organizationalUnits));
    return errors.wrap('supplied properties not correct for "AwsOrganizationsSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.AwsOrganizationsSource` resource
 *
 * @param properties - the TypeScript properties of a `AwsOrganizationsSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.AwsOrganizationsSource` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncAwsOrganizationsSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator(properties).assertSuccess();
    return {
        OrganizationSourceType: cdk.stringToCloudFormation(properties.organizationSourceType),
        OrganizationalUnits: cdk.listMapper(cdk.stringToCloudFormation)(properties.organizationalUnits),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncAwsOrganizationsSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        organizationSourceType: cfn_parse.FromCloudFormation.getString(properties.OrganizationSourceType),
        organizationalUnits: cfn_parse.FromCloudFormation.getStringArray(properties.OrganizationalUnits),
    };
}
/**
 * Determine whether the given properties match those of a `S3DestinationProperty`
 *
 * @param properties - the TypeScript properties of a `S3DestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_S3DestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucketName', cdk.requiredValidator)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketPrefix', cdk.validateString)(properties.bucketPrefix));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.requiredValidator)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.validateString)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('kmsKeyArn', cdk.validateString)(properties.kmsKeyArn));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.requiredValidator)(properties.syncFormat));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.validateString)(properties.syncFormat));
    return errors.wrap('supplied properties not correct for "S3DestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.S3Destination` resource
 *
 * @param properties - the TypeScript properties of a `S3DestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.S3Destination` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncS3DestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_S3DestinationPropertyValidator(properties).assertSuccess();
    return {
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        BucketPrefix: cdk.stringToCloudFormation(properties.bucketPrefix),
        BucketRegion: cdk.stringToCloudFormation(properties.bucketRegion),
        KMSKeyArn: cdk.stringToCloudFormation(properties.kmsKeyArn),
        SyncFormat: cdk.stringToCloudFormation(properties.syncFormat),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncS3DestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucketName: cfn_parse.FromCloudFormation.getString(properties.BucketName),
        bucketPrefix: properties.BucketPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.BucketPrefix),
        bucketRegion: cfn_parse.FromCloudFormation.getString(properties.BucketRegion),
        kmsKeyArn: properties.KMSKeyArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.KMSKeyArn),
        syncFormat: cfn_parse.FromCloudFormation.getString(properties.SyncFormat),
    };
}
/**
 * Determine whether the given properties match those of a `SyncSourceProperty`
 *
 * @param properties - the TypeScript properties of a `SyncSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_SyncSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('awsOrganizationsSource', CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator)(properties.awsOrganizationsSource));
    errors.collect(cdk.propertyValidator('includeFutureRegions', cdk.validateBoolean)(properties.includeFutureRegions));
    errors.collect(cdk.propertyValidator('sourceRegions', cdk.requiredValidator)(properties.sourceRegions));
    errors.collect(cdk.propertyValidator('sourceRegions', cdk.listValidator(cdk.validateString))(properties.sourceRegions));
    errors.collect(cdk.propertyValidator('sourceType', cdk.requiredValidator)(properties.sourceType));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    return errors.wrap('supplied properties not correct for "SyncSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.SyncSource` resource
 *
 * @param properties - the TypeScript properties of a `SyncSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.SyncSource` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncSyncSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_SyncSourcePropertyValidator(properties).assertSuccess();
    return {
        AwsOrganizationsSource: cfnResourceDataSyncAwsOrganizationsSourcePropertyToCloudFormation(properties.awsOrganizationsSource),
        IncludeFutureRegions: cdk.booleanToCloudFormation(properties.includeFutureRegions),
        SourceRegions: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceRegions),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncSyncSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        awsOrganizationsSource: properties.AwsOrganizationsSource == null ? undefined : CfnResourceDataSyncAwsOrganizationsSourcePropertyFromCloudFormation(properties.AwsOrganizationsSource),
        includeFutureRegions: properties.IncludeFutureRegions == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.IncludeFutureRegions),
        sourceRegions: cfn_parse.FromCloudFormation.getStringArray(properties.SourceRegions),
        sourceType: cfn_parse.FromCloudFormation.getString(properties.SourceType),
    };
}
//# sourceMappingURL=data:application/json;base64,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