"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiMapping = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Create a new API mapping for API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class HttpApiMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const apiMappingProps = {
            apiId: props.api.httpApiId,
            domainName: props.domainName.domainName,
            stage: (_b = (_a = props.stage) === null || _a === void 0 ? void 0 : _a.stageName) !== null && _b !== void 0 ? _b : '$default',
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        this.apiMappingId = resource.ref;
    }
    /**
     * import from API ID
     */
    static fromHttpApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpApiMapping = HttpApiMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLW1hcHBpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhcGktbWFwcGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBb0QsQ0FBQyxnREFBZ0Q7QUFDckcsc0VBQThFO0FBcUM5RTs7O0dBR0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxlQUFRO0lBY3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7O1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxlQUFlLEdBQXVCO1lBQ3hDLEtBQUssRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDLFNBQVM7WUFDMUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsVUFBVTtZQUN2QyxLQUFLLGNBQUUsS0FBSyxDQUFDLEtBQUssMENBQUUsU0FBUyxtQ0FBSSxVQUFVO1lBQzNDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNyQyxDQUFDO1FBQ0YsTUFBTSxRQUFRLEdBQUcsSUFBSSxzQ0FBYSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLFlBQVksR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO0lBQ3JDLENBQUM7SUF2QkQ7O09BRUc7SUFDSSxNQUFNLENBQUMsNEJBQTRCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDcEcsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ29CLGlCQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUN0RCxDQUFDO1NBQUE7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNqQyxDQUFDO0NBZ0JKO0FBekJELHdDQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IENmbkFwaU1hcHBpbmcsIENmbkFwaU1hcHBpbmdQcm9wcyB9IGZyb20gJy4uL2FwaWdhdGV3YXl2Mi5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSUFwaU1hcHBpbmcsIElEb21haW5OYW1lIH0gZnJvbSAnLi4vY29tbW9uJztcbmltcG9ydCB7IElIdHRwQXBpIH0gZnJvbSAnLi4vaHR0cC9hcGknO1xuaW1wb3J0IHsgSUh0dHBTdGFnZSB9IGZyb20gJy4vc3RhZ2UnO1xuLyoqXG4gKiBQcm9wZXJ0aWVzIHVzZWQgdG8gY3JlYXRlIHRoZSBIdHRwQXBpTWFwcGluZyByZXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBBcGlNYXBwaW5nUHJvcHMge1xuICAgIC8qKlxuICAgICAqIEFwaSBtYXBwaW5nIGtleS4gVGhlIHBhdGggd2hlcmUgdGhpcyBzdGFnZSBzaG91bGQgYmUgbWFwcGVkIHRvIG9uIHRoZSBkb21haW5cbiAgICAgKiBAZGVmYXVsdCAnLydcbiAgICAgKi9cbiAgICByZWFkb25seSBhcGlNYXBwaW5nS2V5Pzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBIdHRwQXBpIHRvIHdoaWNoIHRoaXMgbWFwcGluZyBpcyBhcHBsaWVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXBpOiBJSHR0cEFwaTtcbiAgICAvKipcbiAgICAgKiBjdXN0b20gZG9tYWluIG5hbWUgb2YgdGhlIG1hcHBpbmcgdGFyZ2V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgZG9tYWluTmFtZTogSURvbWFpbk5hbWU7XG4gICAgLyoqXG4gICAgICogc3RhZ2UgZm9yIHRoZSBIdHRwQXBpTWFwcGluZyByZXNvdXJjZVxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSB0aGUgJGRlZmF1bHQgc3RhZ2VcbiAgICAgKi9cbiAgICByZWFkb25seSBzdGFnZT86IElIdHRwU3RhZ2U7XG59XG4vKipcbiAqIFRoZSBhdHRyaWJ1dGVzIHVzZWQgdG8gaW1wb3J0IGV4aXN0aW5nIEh0dHBBcGlNYXBwaW5nXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cEFwaU1hcHBpbmdBdHRyaWJ1dGVzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQVBJIG1hcHBpbmcgSURcbiAgICAgKi9cbiAgICByZWFkb25seSBhcGlNYXBwaW5nSWQ6IHN0cmluZztcbn1cbi8qKlxuICogQ3JlYXRlIGEgbmV3IEFQSSBtYXBwaW5nIGZvciBBUEkgR2F0ZXdheSBIVFRQIEFQSSBlbmRwb2ludC5cbiAqIEByZXNvdXJjZSBBV1M6OkFwaUdhdGV3YXlWMjo6QXBpTWFwcGluZ1xuICovXG5leHBvcnQgY2xhc3MgSHR0cEFwaU1hcHBpbmcgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElBcGlNYXBwaW5nIHtcbiAgICAvKipcbiAgICAgKiBpbXBvcnQgZnJvbSBBUEkgSURcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIGZyb21IdHRwQXBpTWFwcGluZ0F0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IEh0dHBBcGlNYXBwaW5nQXR0cmlidXRlcyk6IElBcGlNYXBwaW5nIHtcbiAgICAgICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJQXBpTWFwcGluZyB7XG4gICAgICAgICAgICBwdWJsaWMgcmVhZG9ubHkgYXBpTWFwcGluZ0lkID0gYXR0cnMuYXBpTWFwcGluZ0lkO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIElEIG9mIHRoZSBBUEkgTWFwcGluZ1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhcGlNYXBwaW5nSWQ6IHN0cmluZztcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSHR0cEFwaU1hcHBpbmdQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBjb25zdCBhcGlNYXBwaW5nUHJvcHM6IENmbkFwaU1hcHBpbmdQcm9wcyA9IHtcbiAgICAgICAgICAgIGFwaUlkOiBwcm9wcy5hcGkuaHR0cEFwaUlkLFxuICAgICAgICAgICAgZG9tYWluTmFtZTogcHJvcHMuZG9tYWluTmFtZS5kb21haW5OYW1lLFxuICAgICAgICAgICAgc3RhZ2U6IHByb3BzLnN0YWdlPy5zdGFnZU5hbWUgPz8gJyRkZWZhdWx0JyxcbiAgICAgICAgICAgIGFwaU1hcHBpbmdLZXk6IHByb3BzLmFwaU1hcHBpbmdLZXksXG4gICAgICAgIH07XG4gICAgICAgIGNvbnN0IHJlc291cmNlID0gbmV3IENmbkFwaU1hcHBpbmcodGhpcywgJ1Jlc291cmNlJywgYXBpTWFwcGluZ1Byb3BzKTtcbiAgICAgICAgdGhpcy5hcGlNYXBwaW5nSWQgPSByZXNvdXJjZS5yZWY7XG4gICAgfVxufVxuIl19