[![doc](https://img.shields.io/badge/-Documentation-blue)](https://advestis.github.io/adnmtf)
[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

#### Status
[![pytests](https://github.com/Advestis/adnmtf/actions/workflows/pull-request.yml/badge.svg)](https://github.com/Advestis/adnmtf/actions/workflows/pull-request.yml)
[![push-pypi](https://github.com/Advestis/adnmtf/actions/workflows/push-pypi.yml/badge.svg)](https://github.com/Advestis/adnmtf/actions/workflows/push-pypi.yml)
[![push-doc](https://github.com/Advestis/adnmtf/actions/workflows/push-doc.yml/badge.svg)](https://github.com/Advestis/adnmtf/actions/workflows/push-doc.yml)

![maintained](https://img.shields.io/badge/Maintained%3F-yes-green.svg)
![issues](https://img.shields.io/github/issues/Advestis/adnmtf.svg)
![pr](https://img.shields.io/github/issues-pr/Advestis/adnmtf.svg)


#### Compatibilities
![ubuntu](https://img.shields.io/badge/Ubuntu-supported--tested-success)
![windows](https://img.shields.io/badge/Windows-supported--tested-success)
![unix](https://img.shields.io/badge/Other%20Unix-supported--untested-yellow)

![python](https://img.shields.io/pypi/pyversions/adnmtf)


##### Contact
[![linkedin](https://img.shields.io/badge/LinkedIn-Advestis-blue)](https://www.linkedin.com/company/advestis/)
[![linkedin2](https://img.shields.io/badge/LinkedIn-PFogel-blue)](https://www.linkedin.com/in/fogelpaul/)
[![website](https://img.shields.io/badge/website-Advestis.com-blue)](https://www.advestis.com/)
[![mail](https://img.shields.io/badge/mail-maintainers-blue)](mailto:pfogel@advestis.com)

# NMTF

Non-Negative Matrix and Tensor Factorizations

Developped in collaboration with [Advestis](https://advestis.com/) ([Github](https://github.com/Advestis))

## NMF Example

```python
from nmtf import NMF
import numpy as np

w = np.array([[1, 2],
              [3, 4],
              [5, 6],
              [7, 8],
              [9, 10],
              [11, 12]])

h = np.array([[0.1, 0.2, 0.3, 0.4, 0.5, 0.6],
              [0.9, 0.8, 0.7, 0.6, 0.5, 0.4]])
m0 = w.dot(h)
my_nmfmodel = NMF(n_components=2)
estimator_ = my_nmfmodel.fit_transform(m0)
estimator_ = my_nmfmodel.predict(estimator_)
```

In this example, the matrix to be factorized is generated by the dot product of:

| W  |    |
|----|----|
| 1  | 2  |
| 3  | 4  |
| 5  | 6  |
| 7  | 8  |
| 9  | 10 |
| 11 | 12 |
and

| H   |     |     |     |     |     |
|-----|-----|-----|-----|-----|-----|
| 0.1 | 0.2 | 0.3 | 0.4 | 0.5 | 0.6 |
| 0.9 | 0.8 | 0.7 | 0.6 | 0.4 | 0.4 |

- *NMF* instantiates a NMF class with 2 components.
- *fit_transform* calls the functions below in the given order:
  - *nmtf_base* module: *non_negative_factorization*, *nmf_init*, *r_ntf_solve*
  - *nmtf_core* module: *ntf_solve*, *ntf_solve_simple*, *ntf_update*
- *predict* derives from *fit_transform* outputs ordered sample and
feature indexes for future use in ordered heatmaps. 
*predict* calls *nmf_predict* and *build_clusters* in the *nmtf_base* module

## NTF Example

```python
from nmtf import NTF
import pandas as pd

DATA_PATH = ...

df = pd.read_csv(DATA_PATH)
m0 = df.values
n_blocks = 5
my_ntfmodel = NTF(n_components=5)
estimator_ = my_ntfmodel.fit_transform(m0, n_blocks)
estimator_ = my_ntfmodel.predict(estimator_)


```

In this example, the tensor to be factorized is read in file *data_ntf.csv*. 
The tensor has 5 layers in the 3rd dimension and is formatted as a table
with 5 blocks concatenated horizontally.

- *NTF* instantiates a NTF class with 5 components.
- *fit_transform* calls the functions below in the given order:
  - *nmtf_base* module: *non_negative_tensor_factorization*, *ntf_init*, *r_ntf_solve*
  - *nmtf_core* module: *ntf_solve*, *ntf_solve_simple*, *ntf_update*
- *predict* derives from *fit_transform* outputs ordered sample and
feature indexes for future use in ordered heatmaps. 
*predict* calls *nmf_predict* and *build_clusters* in the *nmtf_base* module

## Articles

### Peer-reviewed articles

* [(researchgate) A Tale of Two Matrix Factorizations](https://www.researchgate.net/publication/263216872_A_Tale_of_Two_Matrix_Factorizations)
* [(researchgate) Fast Local Algorithms for Large Scale Nonnegative Matrix and Tensor Factorizations](https://www.researchgate.net/publication/220241471_Fast_Local_Algorithms_for_Large_Scale_Nonnegative_Matrix_and_Tensor_Factorizations)
* [(nature) Learning the parts of objects by non-negative matrix factorization](https://www.nature.com/articles/44565)

### Blog articles

* [(Medium) Using Non-negative matrix factorization to classify companies](https://medium.com/@chtill.g/using-nmf-to-classify-companies-a77e176f276f)

* [(offconvex) Tensor Methods in Machine Learning](https://www.offconvex.org/2015/12/17/tensor-decompositions/?source=post_page---------------------------)
