# -*- coding: utf-8 -*-

# Copyright (c) 2021, Brandon Nielsen
# All rights reserved.
#
# This software may be modified and distributed under the terms
# of the BSD license.  See the LICENSE file for details.

from decimal import Decimal

# Base values
DAYS_PER_WEEK = Decimal(7)
HOURS_PER_DAY = Decimal(24)
MINUTES_PER_HOUR = Decimal(60)
SECONDS_PER_MINUTE = Decimal(60)
MILLISECONDS_PER_SECOND = Decimal(1000)
MICROSECONDS_PER_MILLISECOND = Decimal(1000)
NANOSECONDS_PER_MICROSECOND = Decimal(1000)
PICOSECONDS_PER_NANOSECOND = Decimal(1000)
ATTOSECONDS_PER_NANOSECOND = Decimal(1000000000)
YOCTOSECONDS_PER_NANOSECOND = Decimal(1000000000000000)

# Derived values
NANOSECONDS_PER_MILLISECOND = MICROSECONDS_PER_MILLISECOND * NANOSECONDS_PER_MICROSECOND

MICROSECONDS_PER_SECOND = MILLISECONDS_PER_SECOND * MICROSECONDS_PER_MILLISECOND
NANOSECONDS_PER_SECOND = MICROSECONDS_PER_SECOND * NANOSECONDS_PER_MICROSECOND

MILLISECONDS_PER_MINUTE = MILLISECONDS_PER_SECOND * SECONDS_PER_MINUTE
MICROSECONDS_PER_MINUTE = MICROSECONDS_PER_SECOND * SECONDS_PER_MINUTE
NANOSECONDS_PER_MINUTE = NANOSECONDS_PER_SECOND * SECONDS_PER_MINUTE

SECONDS_PER_HOUR = SECONDS_PER_MINUTE * MINUTES_PER_HOUR
MILLISECONDS_PER_HOUR = MILLISECONDS_PER_SECOND * SECONDS_PER_HOUR
MICROSECONDS_PER_HOUR = MICROSECONDS_PER_SECOND * SECONDS_PER_HOUR
NANOSECONDS_PER_HOUR = NANOSECONDS_PER_SECOND * SECONDS_PER_HOUR

MINUTES_PER_DAY = MINUTES_PER_HOUR * HOURS_PER_DAY
SECONDS_PER_DAY = SECONDS_PER_MINUTE * MINUTES_PER_DAY
MILLISECONDS_PER_DAY = MILLISECONDS_PER_SECOND * SECONDS_PER_DAY
MICROSECONDS_PER_DAY = MICROSECONDS_PER_MILLISECOND * MILLISECONDS_PER_DAY
NANOSECONDS_PER_DAY = NANOSECONDS_PER_MICROSECOND * MICROSECONDS_PER_DAY

HOURS_PER_WEEK = HOURS_PER_DAY * DAYS_PER_WEEK
MINUTES_PER_WEEK = MINUTES_PER_DAY * DAYS_PER_WEEK
SECONDS_PER_WEEK = SECONDS_PER_DAY * DAYS_PER_WEEK
MILLISECONDS_PER_WEEK = MILLISECONDS_PER_DAY * DAYS_PER_WEEK
MICROSECONDS_PER_WEEK = MICROSECONDS_PER_DAY * DAYS_PER_WEEK
NANOSECONDS_PER_WEEK = NANOSECONDS_PER_DAY * DAYS_PER_WEEK
