"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventRuleTargets = exports.EventRuleTargetsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "EventRuleTargetsProperty", { enumerable: true, get: function () { return cms_generated_1.RosEventRuleTargets; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::EventRuleTargets`
 */
class EventRuleTargets extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CMS::EventRuleTargets`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEventRuleTargets = new cms_generated_1.RosEventRuleTargets(this, id, {
            contactParameters: props.contactParameters,
            slsParameters: props.slsParameters,
            webhookParameters: props.webhookParameters,
            fcParameters: props.fcParameters,
            ruleName: props.ruleName,
            mnsParameters: props.mnsParameters,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEventRuleTargets;
    }
}
exports.EventRuleTargets = EventRuleTargets;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRydWxldGFyZ2V0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImV2ZW50cnVsZXRhcmdldHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFzRDtBQUV0Qix5R0FGdkIsbUNBQW1CLE9BRTRCO0FBc0N4RDs7R0FFRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFFOUM7OztPQUdHO0lBRUg7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE0QixFQUFFLG1DQUEyQyxJQUFJO1FBQ3ZILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxtQkFBbUIsR0FBRyxJQUFJLG1DQUFtQixDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDM0QsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNyQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLG1CQUFtQixDQUFDO0lBQ3hDLENBQUM7Q0FDSjtBQTNCRCw0Q0EyQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NFdmVudFJ1bGVUYXJnZXRzIH0gZnJvbSAnLi9jbXMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zRXZlbnRSdWxlVGFyZ2V0cyBhcyBFdmVudFJ1bGVUYXJnZXRzUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkNNUzo6RXZlbnRSdWxlVGFyZ2V0c2BcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFdmVudFJ1bGVUYXJnZXRzUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcnVsZU5hbWU6IFRoZSBuYW1lIG9mIHRoZSBhbGVydCBydWxlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJ1bGVOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb250YWN0UGFyYW1ldGVyczogQ09OVEFDVCBjb25maWd1cmF0aW9uLkEgbWF4aW11bSBvZiA1IHBhcmFtZXRlcnNcbiAgICAgKi9cbiAgICByZWFkb25seSBjb250YWN0UGFyYW1ldGVycz86IEFycmF5PFJvc0V2ZW50UnVsZVRhcmdldHMuQ29udGFjdFBhcmFtZXRlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBmY1BhcmFtZXRlcnM6IEZDIGNvbmZpZ3VyYXRpb24uQSBtYXhpbXVtIG9mIDUgcGFyYW1ldGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBmY1BhcmFtZXRlcnM/OiBBcnJheTxSb3NFdmVudFJ1bGVUYXJnZXRzLkZjUGFyYW1ldGVyc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG1uc1BhcmFtZXRlcnM6IE1OUyBjb25maWd1cmF0aW9uLkEgbWF4aW11bSBvZiA1IHBhcmFtZXRlcnNcbiAgICAgKi9cbiAgICByZWFkb25seSBtbnNQYXJhbWV0ZXJzPzogQXJyYXk8Um9zRXZlbnRSdWxlVGFyZ2V0cy5NbnNQYXJhbWV0ZXJzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2xzUGFyYW1ldGVyczogU0xTIGNvbmZpZ3VyYXRpb24uQSBtYXhpbXVtIG9mIDUgcGFyYW1ldGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBzbHNQYXJhbWV0ZXJzPzogQXJyYXk8Um9zRXZlbnRSdWxlVGFyZ2V0cy5TbHNQYXJhbWV0ZXJzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgd2ViaG9va1BhcmFtZXRlcnM6IFdFQkhPT0sgY29uZmlndXJhdGlvbi5BIG1heGltdW0gb2YgNSBwYXJhbWV0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHdlYmhvb2tQYXJhbWV0ZXJzPzogQXJyYXk8Um9zRXZlbnRSdWxlVGFyZ2V0cy5XZWJob29rUGFyYW1ldGVyc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6Q01TOjpFdmVudFJ1bGVUYXJnZXRzYFxuICovXG5leHBvcnQgY2xhc3MgRXZlbnRSdWxlVGFyZ2V0cyBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6Q01TOjpFdmVudFJ1bGVUYXJnZXRzYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFdmVudFJ1bGVUYXJnZXRzUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zRXZlbnRSdWxlVGFyZ2V0cyA9IG5ldyBSb3NFdmVudFJ1bGVUYXJnZXRzKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgY29udGFjdFBhcmFtZXRlcnM6IHByb3BzLmNvbnRhY3RQYXJhbWV0ZXJzLFxuICAgICAgICAgICAgc2xzUGFyYW1ldGVyczogcHJvcHMuc2xzUGFyYW1ldGVycyxcbiAgICAgICAgICAgIHdlYmhvb2tQYXJhbWV0ZXJzOiBwcm9wcy53ZWJob29rUGFyYW1ldGVycyxcbiAgICAgICAgICAgIGZjUGFyYW1ldGVyczogcHJvcHMuZmNQYXJhbWV0ZXJzLFxuICAgICAgICAgICAgcnVsZU5hbWU6IHByb3BzLnJ1bGVOYW1lLFxuICAgICAgICAgICAgbW5zUGFyYW1ldGVyczogcHJvcHMubW5zUGFyYW1ldGVycyxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NFdmVudFJ1bGVUYXJnZXRzO1xuICAgIH1cbn1cbiJdfQ==