# Epic common &mdash; Useful Common Utilities
[![Epic-common CI](https://github.com/Cybereason/epic-common/actions/workflows/ci.yml/badge.svg)](https://github.com/Cybereason/epic-common/actions/workflows/ci.yml)

## What is it?
The **epic-common** Python library provides many general useful utilities.
These are various functions and classes which are useful and helpful in almost any project and context.
Some save programming time on common tasks, some prevent falling into common pitfalls and some provide 
functionality that, after getting used to it, you just can't live without.

## Modules
- **assertion:** Utilities for assertion of parameter types.
- **flow:** Utilities for flow control.
- **general:** Many general useful utilities.
- **importguard:** Provide an installation hint upon import failure.
- **inspection:** Utilities relating to live object inspection.
- **io:** Pickling, reading and writing files, loading and dumping JSON files, etc.
- **iteration:** Utilities relating to iteration over iterables.
- **nesteddict:** Helpers for easily dealing with nested dictionaries.
- **pathgeneralizer:** An abstraction providing a common interface to accessing local and remote resources.
- **time:** Helpers for timing, setting a timeout and converting timestamps.
- **queue:** Provides a convenient iterable queue.
