# pied-piper-sdwan-sdk
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.41
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/oshafran/pied-piper-openapi-client-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/oshafran/pied-piper-openapi-client-python.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.api import authentication_api
# Defining the host is optional and defaults to https://44.196.44.132
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://44.196.44.132"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = authentication_api.AuthenticationApi(api_client)

    try:
        # Token
        api_response = api_instance.dataservice_client_token_get()
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling AuthenticationApi->dataservice_client_token_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://44.196.44.132*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**dataservice_client_token_get**](docs/AuthenticationApi.md#dataservice_client_token_get) | **GET** /dataservice/client/token | Token
*AuthenticationApi* | [**j_security_check_post**](docs/AuthenticationApi.md#j_security_check_post) | **POST** /j_security_check | Authentication
*BusinessApi* | [**dataservice_system_device_vedges_get**](docs/BusinessApi.md#dataservice_system_device_vedges_get) | **GET** /dataservice/system/device/vedges | Get Device VEdges
*BusinessApi* | [**dataservice_template_policy_list_site_delete**](docs/BusinessApi.md#dataservice_template_policy_list_site_delete) | **DELETE** /dataservice/template/policy/list/site/ | Delete VPN Template List
*BusinessApi* | [**dataservice_template_policy_list_site_get**](docs/BusinessApi.md#dataservice_template_policy_list_site_get) | **GET** /dataservice/template/policy/list/site | Get Prefix Template List
*BusinessApi* | [**dataservice_template_policy_list_site_id_delete**](docs/BusinessApi.md#dataservice_template_policy_list_site_id_delete) | **DELETE** /dataservice/template/policy/list/site/{id} | Delete Site Template List
*BusinessApi* | [**dataservice_template_policy_list_site_post**](docs/BusinessApi.md#dataservice_template_policy_list_site_post) | **POST** /dataservice/template/policy/list/site | Create Site Template List
*BusinessApi* | [**dataservice_template_policy_list_vpn_post**](docs/BusinessApi.md#dataservice_template_policy_list_vpn_post) | **POST** /dataservice/template/policy/list/vpn | Create VPN Template List
*SDWANDevicePolicyApi* | [**dataservice_template_policy_list_get**](docs/SDWANDevicePolicyApi.md#dataservice_template_policy_list_get) | **GET** /dataservice/template/policy/list | Policy List
*SDWANDevicePolicyApi* | [**dataservice_template_policy_vedge_devices_get**](docs/SDWANDevicePolicyApi.md#dataservice_template_policy_vedge_devices_get) | **GET** /dataservice/template/policy/vedge/devices | vEdge Template Policy
*SDWANDeviceTemplateApi* | [**dataservice_template_feature_get**](docs/SDWANDeviceTemplateApi.md#dataservice_template_feature_get) | **GET** /dataservice/template/feature | Template Feature
*SDWANDeviceTemplateApi* | [**dataservice_template_feature_types_get**](docs/SDWANDeviceTemplateApi.md#dataservice_template_feature_types_get) | **GET** /dataservice/template/feature/types | Template Feature Type
*SDWANFabricDevicesApi* | [**dataservice_device_counters_get**](docs/SDWANFabricDevicesApi.md#dataservice_device_counters_get) | **GET** /dataservice/device/counters | Device Counters
*SDWANFabricDevicesApi* | [**dataservice_device_get**](docs/SDWANFabricDevicesApi.md#dataservice_device_get) | **GET** /dataservice/device | Fabric Devices
*SDWANFabricDevicesApi* | [**dataservice_device_monitor_get**](docs/SDWANFabricDevicesApi.md#dataservice_device_monitor_get) | **GET** /dataservice/device/monitor | Devices Status
*SDWANFabricDevicesApi* | [**dataservice_statistics_interface_get**](docs/SDWANFabricDevicesApi.md#dataservice_statistics_interface_get) | **GET** /dataservice/statistics/interface | Interface statistics


## Documentation For Models



## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: JSESSIONID
- **Location**: 


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.api.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```

