# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GroupInsightsConfiguration',
    'SamplingRule',
    'SamplingRuleRecord',
    'SamplingRuleUpdate',
]

@pulumi.output_type
class GroupInsightsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insightsEnabled":
            suggest = "insights_enabled"
        elif key == "notificationsEnabled":
            suggest = "notifications_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupInsightsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupInsightsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupInsightsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insights_enabled: Optional[bool] = None,
                 notifications_enabled: Optional[bool] = None):
        """
        :param bool insights_enabled: Set the InsightsEnabled value to true to enable insights or false to disable insights.
        :param bool notifications_enabled: Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on a group with InsightsEnabled set to true.
        """
        if insights_enabled is not None:
            pulumi.set(__self__, "insights_enabled", insights_enabled)
        if notifications_enabled is not None:
            pulumi.set(__self__, "notifications_enabled", notifications_enabled)

    @property
    @pulumi.getter(name="insightsEnabled")
    def insights_enabled(self) -> Optional[bool]:
        """
        Set the InsightsEnabled value to true to enable insights or false to disable insights.
        """
        return pulumi.get(self, "insights_enabled")

    @property
    @pulumi.getter(name="notificationsEnabled")
    def notifications_enabled(self) -> Optional[bool]:
        """
        Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on a group with InsightsEnabled set to true.
        """
        return pulumi.get(self, "notifications_enabled")


@pulumi.output_type
class SamplingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedRate":
            suggest = "fixed_rate"
        elif key == "hTTPMethod":
            suggest = "h_ttp_method"
        elif key == "reservoirSize":
            suggest = "reservoir_size"
        elif key == "resourceARN":
            suggest = "resource_arn"
        elif key == "ruleARN":
            suggest = "rule_arn"
        elif key == "ruleName":
            suggest = "rule_name"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "uRLPath":
            suggest = "u_rl_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamplingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamplingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamplingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Optional[Any] = None,
                 fixed_rate: Optional[float] = None,
                 h_ttp_method: Optional[str] = None,
                 host: Optional[str] = None,
                 priority: Optional[int] = None,
                 reservoir_size: Optional[int] = None,
                 resource_arn: Optional[str] = None,
                 rule_arn: Optional[str] = None,
                 rule_name: Optional[str] = None,
                 service_name: Optional[str] = None,
                 service_type: Optional[str] = None,
                 u_rl_path: Optional[str] = None,
                 version: Optional[int] = None):
        """
        :param Any attributes: Matches attributes derived from the request.
        :param float fixed_rate: The percentage of matching requests to instrument, after the reservoir is exhausted.
        :param str h_ttp_method: Matches the HTTP method from a request URL.
        :param str host: Matches the hostname from a request URL.
        :param int priority: The priority of the sampling rule.
        :param int reservoir_size: A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        :param str resource_arn: Matches the ARN of the AWS resource on which the service runs.
        :param str service_name: Matches the name that the service uses to identify itself in segments.
        :param str service_type: Matches the origin that the service uses to identify its type in segments.
        :param str u_rl_path: Matches the path from a request URL.
        :param int version: The version of the sampling rule format (1)
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if fixed_rate is not None:
            pulumi.set(__self__, "fixed_rate", fixed_rate)
        if h_ttp_method is not None:
            pulumi.set(__self__, "h_ttp_method", h_ttp_method)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if reservoir_size is not None:
            pulumi.set(__self__, "reservoir_size", reservoir_size)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if rule_arn is not None:
            pulumi.set(__self__, "rule_arn", rule_arn)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if u_rl_path is not None:
            pulumi.set(__self__, "u_rl_path", u_rl_path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Any]:
        """
        Matches attributes derived from the request.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="fixedRate")
    def fixed_rate(self) -> Optional[float]:
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        return pulumi.get(self, "fixed_rate")

    @property
    @pulumi.getter(name="hTTPMethod")
    def h_ttp_method(self) -> Optional[str]:
        """
        Matches the HTTP method from a request URL.
        """
        return pulumi.get(self, "h_ttp_method")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Matches the hostname from a request URL.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the sampling rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="reservoirSize")
    def reservoir_size(self) -> Optional[int]:
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        return pulumi.get(self, "reservoir_size")

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> Optional[str]:
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="ruleARN")
    def rule_arn(self) -> Optional[str]:
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[str]:
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        Matches the name that the service uses to identify itself in segments.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[str]:
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="uRLPath")
    def u_rl_path(self) -> Optional[str]:
        """
        Matches the path from a request URL.
        """
        return pulumi.get(self, "u_rl_path")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        """
        The version of the sampling rule format (1)
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SamplingRuleRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "modifiedAt":
            suggest = "modified_at"
        elif key == "samplingRule":
            suggest = "sampling_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamplingRuleRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamplingRuleRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamplingRuleRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 modified_at: Optional[str] = None,
                 sampling_rule: Optional['outputs.SamplingRule'] = None):
        """
        :param str created_at: When the rule was created, in Unix time seconds.
        :param str modified_at: When the rule was modified, in Unix time seconds.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if sampling_rule is not None:
            pulumi.set(__self__, "sampling_rule", sampling_rule)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        When the rule was created, in Unix time seconds.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[str]:
        """
        When the rule was modified, in Unix time seconds.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="samplingRule")
    def sampling_rule(self) -> Optional['outputs.SamplingRule']:
        return pulumi.get(self, "sampling_rule")


@pulumi.output_type
class SamplingRuleUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedRate":
            suggest = "fixed_rate"
        elif key == "hTTPMethod":
            suggest = "h_ttp_method"
        elif key == "reservoirSize":
            suggest = "reservoir_size"
        elif key == "resourceARN":
            suggest = "resource_arn"
        elif key == "ruleARN":
            suggest = "rule_arn"
        elif key == "ruleName":
            suggest = "rule_name"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "serviceType":
            suggest = "service_type"
        elif key == "uRLPath":
            suggest = "u_rl_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamplingRuleUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamplingRuleUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamplingRuleUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: Optional[Any] = None,
                 fixed_rate: Optional[float] = None,
                 h_ttp_method: Optional[str] = None,
                 host: Optional[str] = None,
                 priority: Optional[int] = None,
                 reservoir_size: Optional[int] = None,
                 resource_arn: Optional[str] = None,
                 rule_arn: Optional[str] = None,
                 rule_name: Optional[str] = None,
                 service_name: Optional[str] = None,
                 service_type: Optional[str] = None,
                 u_rl_path: Optional[str] = None):
        """
        :param Any attributes: Matches attributes derived from the request.
        :param float fixed_rate: The percentage of matching requests to instrument, after the reservoir is exhausted.
        :param str h_ttp_method: Matches the HTTP method from a request URL.
        :param str host: Matches the hostname from a request URL.
        :param int priority: The priority of the sampling rule.
        :param int reservoir_size: A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        :param str resource_arn: Matches the ARN of the AWS resource on which the service runs.
        :param str service_name: Matches the name that the service uses to identify itself in segments.
        :param str service_type: Matches the origin that the service uses to identify its type in segments.
        :param str u_rl_path: Matches the path from a request URL.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if fixed_rate is not None:
            pulumi.set(__self__, "fixed_rate", fixed_rate)
        if h_ttp_method is not None:
            pulumi.set(__self__, "h_ttp_method", h_ttp_method)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if reservoir_size is not None:
            pulumi.set(__self__, "reservoir_size", reservoir_size)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if rule_arn is not None:
            pulumi.set(__self__, "rule_arn", rule_arn)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if u_rl_path is not None:
            pulumi.set(__self__, "u_rl_path", u_rl_path)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Any]:
        """
        Matches attributes derived from the request.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="fixedRate")
    def fixed_rate(self) -> Optional[float]:
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        return pulumi.get(self, "fixed_rate")

    @property
    @pulumi.getter(name="hTTPMethod")
    def h_ttp_method(self) -> Optional[str]:
        """
        Matches the HTTP method from a request URL.
        """
        return pulumi.get(self, "h_ttp_method")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Matches the hostname from a request URL.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the sampling rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="reservoirSize")
    def reservoir_size(self) -> Optional[int]:
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        return pulumi.get(self, "reservoir_size")

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> Optional[str]:
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="ruleARN")
    def rule_arn(self) -> Optional[str]:
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[str]:
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        Matches the name that the service uses to identify itself in segments.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[str]:
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="uRLPath")
    def u_rl_path(self) -> Optional[str]:
        """
        Matches the path from a request URL.
        """
        return pulumi.get(self, "u_rl_path")


