from typing import Any, Callable, List, Optional, Sequence, Set, Tuple, Union

from django.db.backends.base.base import BaseDatabaseWrapper
from django.db.migrations.migration import Migration

from .loader import MigrationLoader
from .recorder import MigrationRecorder
from .state import ProjectState

class MigrationExecutor:
    connection: BaseDatabaseWrapper = ...
    loader: MigrationLoader = ...
    recorder: MigrationRecorder = ...
    progress_callback: Callable = ...
    def __init__(
        self,
        connection: Optional[BaseDatabaseWrapper],
        progress_callback: Optional[Callable] = ...,
    ) -> None: ...
    def migration_plan(
        self, targets: Union[Sequence[Tuple[str, Optional[str]]], Set[Tuple[str, str]]], clean_start: bool = ...
    ) -> List[Tuple[Migration, bool]]: ...
    def migrate(
        self,
        targets: Optional[Sequence[Tuple[str, Optional[str]]]],
        plan: Optional[Sequence[Tuple[Migration, bool]]] = ...,
        state: Optional[ProjectState] = ...,
        fake: bool = ...,
        fake_initial: bool = ...,
    ) -> ProjectState: ...
    def collect_sql(self, plan: Sequence[Tuple[Migration, bool]]) -> List[str]: ...
    def apply_migration(
        self, state: ProjectState, migration: Migration, fake: bool = ..., fake_initial: bool = ...
    ) -> ProjectState: ...
    def unapply_migration(self, state: ProjectState, migration: Migration, fake: bool = ...) -> ProjectState: ...
    def check_replacements(self) -> None: ...
    def detect_soft_applied(
        self, project_state: Optional[ProjectState], migration: Migration
    ) -> Tuple[bool, ProjectState]: ...
