# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import os
import sys
import unittest

import mparticle
from mparticle.rest import ApiException
from mparticle.models.batch import Batch


class TestBatch(unittest.TestCase):
    """ Batch unit test stubs """

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testBatch(self):
        """
        Test Batch
        """
        model = mparticle.models.batch.Batch()

    def testBatchMPID(self):
        """
        Test Batch MPID
        """
        model = mparticle.models.batch.Batch()

        identity_dict = model.to_dict()
        for key in identity_dict:
            self.assertEqual(None, identity_dict[key])

        model.mpid = 600868121729048600
        identity_dict = model.to_dict()
        self.assertEqual(600868121729048600, identity_dict["mpid"])

    def testBatchDAS(self):
        """
        Test Batch DAS
        """
        model = mparticle.models.batch.Batch()

        identity_dict = model.to_dict()
        for key in identity_dict:
            self.assertEqual(None, identity_dict[key])

        model.mp_deviceid = "59780f39-d7a0-4ebe-9950-280f937c29e2"
        identity_dict = model.to_dict()
        self.assertEqual("59780f39-d7a0-4ebe-9950-280f937c29e2", identity_dict["mp_deviceid"])
    
    def testBatchWithoutContext(self):
        model = mparticle.models.batch.Batch()
        batch_dict = model.to_dict()
        self.assertIsNone(batch_dict["context"])

    def testBatchWithContext(self):
        data_plan = mparticle.models.data_plan_context.DataPlanContext("foo", 5)
        context = mparticle.models.batch_context.BatchContext(data_plan)
        model = mparticle.models.batch.Batch(context=context)
        batch_dict = model.to_dict()
        self.assertIsNotNone(batch_dict["context"])
        self.assertIsNotNone(batch_dict["context"]["data_plan"])
        self.assertEqual("foo", batch_dict["context"]["data_plan"]["plan_id"])
        self.assertEqual(5, batch_dict["context"]["data_plan"]["plan_version"])

if __name__ == '__main__':
    unittest.main()
