# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PushMessageEvent(object):

    def __init__(self, timestamp_unixtime_ms=None, event_id=None, source_message_id=None, session_id=None, session_uuid=None, custom_attributes=None, location=None, device_current_state=None, push_message_token=None, push_message_type=None, message=None, network=None, push_notification_payload=None, application_state=None, action_identifier=None):
        """
        PushMessageEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp_unixtime_ms': 'int',
            'event_id': 'int',
            'source_message_id': 'str',
            'session_id': 'int',
            'session_uuid': 'str',
            'custom_attributes': 'dict(str, str)',
            'location': 'GeoLocation',
            'device_current_state': 'DeviceCurrentState',
            'push_message_token': 'str',
            'push_message_type': 'str',
            'message': 'str',
            'network': 'str',
            'push_notification_payload': 'str',
            'application_state': 'str',
            'action_identifier': 'str'
        }

        self.attribute_map = {
            'timestamp_unixtime_ms': 'timestamp_unixtime_ms',
            'event_id': 'event_id',
            'source_message_id': 'source_message_id',
            'session_id': 'session_id',
            'session_uuid': 'session_uuid',
            'custom_attributes': 'custom_attributes',
            'location': 'location',
            'device_current_state': 'device_current_state',
            'push_message_token': 'push_message_token',
            'push_message_type': 'push_message_type',
            'message': 'message',
            'network': 'network',
            'push_notification_payload': 'push_notification_payload',
            'application_state': 'application_state',
            'action_identifier': 'action_identifier'
        }

        self._timestamp_unixtime_ms = timestamp_unixtime_ms
        self._event_id = event_id
        self._source_message_id = source_message_id
        self._session_id = session_id
        self._session_uuid = session_uuid
        self._custom_attributes = custom_attributes
        self._location = location
        self._device_current_state = device_current_state
        self._push_message_token = push_message_token
        self._push_message_type = push_message_type
        self._message = message
        self._network = network
        self._push_notification_payload = push_notification_payload
        self._application_state = application_state
        self._action_identifier = action_identifier

    @property
    def timestamp_unixtime_ms(self):
        """
        Gets the timestamp_unixtime_ms of this PushMessageEvent.


        :return: The timestamp_unixtime_ms of this PushMessageEvent.
        :rtype: int
        """
        return self._timestamp_unixtime_ms

    @timestamp_unixtime_ms.setter
    def timestamp_unixtime_ms(self, timestamp_unixtime_ms):
        """
        Sets the timestamp_unixtime_ms of this PushMessageEvent.


        :param timestamp_unixtime_ms: The timestamp_unixtime_ms of this PushMessageEvent.
        :type: int
        """

        self._timestamp_unixtime_ms = timestamp_unixtime_ms

    @property
    def event_id(self):
        """
        Gets the event_id of this PushMessageEvent.


        :return: The event_id of this PushMessageEvent.
        :rtype: int
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this PushMessageEvent.


        :param event_id: The event_id of this PushMessageEvent.
        :type: int
        """

        self._event_id = event_id

    @property
    def source_message_id(self):
        """
        Gets the source_message_id of this PushMessageEvent.


        :return: The source_message_id of this PushMessageEvent.
        :rtype: str
        """
        return self._source_message_id

    @source_message_id.setter
    def source_message_id(self, source_message_id):
        """
        Sets the source_message_id of this PushMessageEvent.


        :param source_message_id: The source_message_id of this PushMessageEvent.
        :type: str
        """

        self._source_message_id = source_message_id

    @property
    def session_id(self):
        """
        Gets the session_id of this PushMessageEvent.


        :return: The session_id of this PushMessageEvent.
        :rtype: int
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this PushMessageEvent.


        :param session_id: The session_id of this PushMessageEvent.
        :type: int
        """

        self._session_id = session_id

    @property
    def session_uuid(self):
        """
        Gets the session_uuid of this PushMessageEvent.


        :return: The session_uuid of this PushMessageEvent.
        :rtype: str
        """
        return self._session_uuid

    @session_uuid.setter
    def session_uuid(self, session_uuid):
        """
        Sets the session_uuid of this PushMessageEvent.


        :param session_uuid: The session_uuid of this PushMessageEvent.
        :type: str
        """

        self._session_uuid = session_uuid

    @property
    def custom_attributes(self):
        """
        Gets the custom_attributes of this PushMessageEvent.


        :return: The custom_attributes of this PushMessageEvent.
        :rtype: dict(str, str)
        """
        return self._custom_attributes

    @custom_attributes.setter
    def custom_attributes(self, custom_attributes):
        """
        Sets the custom_attributes of this PushMessageEvent.


        :param custom_attributes: The custom_attributes of this PushMessageEvent.
        :type: dict(str, str)
        """

        self._custom_attributes = custom_attributes

    @property
    def location(self):
        """
        Gets the location of this PushMessageEvent.


        :return: The location of this PushMessageEvent.
        :rtype: GeoLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this PushMessageEvent.


        :param location: The location of this PushMessageEvent.
        :type: GeoLocation
        """

        self._location = location

    @property
    def device_current_state(self):
        """
        Gets the device_current_state of this PushMessageEvent.


        :return: The device_current_state of this PushMessageEvent.
        :rtype: DeviceCurrentState
        """
        return self._device_current_state

    @device_current_state.setter
    def device_current_state(self, device_current_state):
        """
        Sets the device_current_state of this PushMessageEvent.


        :param device_current_state: The device_current_state of this PushMessageEvent.
        :type: DeviceCurrentState
        """

        self._device_current_state = device_current_state

    @property
    def push_message_token(self):
        """
        Gets the push_message_token of this PushMessageEvent.


        :return: The push_message_token of this PushMessageEvent.
        :rtype: str
        """
        return self._push_message_token

    @push_message_token.setter
    def push_message_token(self, push_message_token):
        """
        Sets the push_message_token of this PushMessageEvent.


        :param push_message_token: The push_message_token of this PushMessageEvent.
        :type: str
        """

        self._push_message_token = push_message_token

    @property
    def push_message_type(self):
        """
        Gets the push_message_type of this PushMessageEvent.


        :return: The push_message_type of this PushMessageEvent.
        :rtype: str
        """
        return self._push_message_type

    @push_message_type.setter
    def push_message_type(self, push_message_type):
        """
        Sets the push_message_type of this PushMessageEvent.


        :param push_message_type: The push_message_type of this PushMessageEvent.
        :type: str
        """
        allowed_values = ["unknown", "sent", "received", "action"]
        if push_message_type not in allowed_values:
            raise ValueError(
                "Invalid value for `push_message_type` ({0}), must be one of {1}"
                .format(push_message_type, allowed_values)
            )

        self._push_message_type = push_message_type

    @property
    def message(self):
        """
        Gets the message of this PushMessageEvent.


        :return: The message of this PushMessageEvent.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this PushMessageEvent.


        :param message: The message of this PushMessageEvent.
        :type: str
        """

        self._message = message

    @property
    def network(self):
        """
        Gets the network of this PushMessageEvent.


        :return: The network of this PushMessageEvent.
        :rtype: str
        """
        return self._network

    @network.setter
    def network(self, network):
        """
        Sets the network of this PushMessageEvent.


        :param network: The network of this PushMessageEvent.
        :type: str
        """

        self._network = network

    @property
    def push_notification_payload(self):
        """
        Gets the push_notification_payload of this PushMessageEvent.


        :return: The push_notification_payload of this PushMessageEvent.
        :rtype: str
        """
        return self._push_notification_payload

    @push_notification_payload.setter
    def push_notification_payload(self, push_notification_payload):
        """
        Sets the push_notification_payload of this PushMessageEvent.


        :param push_notification_payload: The push_notification_payload of this PushMessageEvent.
        :type: str
        """

        self._push_notification_payload = push_notification_payload

    @property
    def application_state(self):
        """
        Gets the application_state of this PushMessageEvent.


        :return: The application_state of this PushMessageEvent.
        :rtype: str
        """
        return self._application_state

    @application_state.setter
    def application_state(self, application_state):
        """
        Sets the application_state of this PushMessageEvent.


        :param application_state: The application_state of this PushMessageEvent.
        :type: str
        """
        allowed_values = ["unknown", "not_running", "background", "foreground"]
        if application_state not in allowed_values:
            raise ValueError(
                "Invalid value for `application_state` ({0}), must be one of {1}"
                .format(application_state, allowed_values)
            )

        self._application_state = application_state

    @property
    def action_identifier(self):
        """
        Gets the action_identifier of this PushMessageEvent.


        :return: The action_identifier of this PushMessageEvent.
        :rtype: str
        """
        return self._action_identifier

    @action_identifier.setter
    def action_identifier(self, action_identifier):
        """
        Sets the action_identifier of this PushMessageEvent.


        :param action_identifier: The action_identifier of this PushMessageEvent.
        :type: str
        """

        self._action_identifier = action_identifier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
