# [Django Admin Argon](https://github.com/app-generator/django-admin-argon-dashboard)

Modern template for **Django Admin Interface** coded on top of **Argon Dashboard**, an open-source `Boostrap 5` design from `Creative-Tim`.

> Actively supported by [AppSeed](https://appseed.us/) via `Email` and `Discord`.

<br>

**Links & Resources**

- UI Kit: [Argon Dashboard BS5](https://www.creative-tim.com/product/argon-dashboard?AFFILIATE=128200) `v2.0.4` by Creative-Tim
- [Django Argon Dashboard](https://django-argon-dashboard.appseed-srv1.com/) - LIVE Demo
- [Django Argon Dashboard](https://github.com/app-generator/django-admin-argon-dashboard_p) - `playground project` 

<br />

![Argon Dashboard - Starter generated by AppSeed.](https://user-images.githubusercontent.com/51070104/183684596-4b29a886-f13d-4da5-98d3-12b5b90df47f.png)

<br />

## `Video Presentation`

> This material provides `more information` about this library and the `playground project`. 

[![Django Theme Material Kit - Video Presentation.](https://user-images.githubusercontent.com/51070104/203936766-d77198c1-90e6-4fd3-83ba-3f74b9dc6fe9.png)](https://www.youtube.com/watch?v=UFAXMAahb3U)

<br />

## Why `Django Argon Design`

- Modern `Bootstrap 5` Design
- `Responsive Interface`
- `Minimal Template` overriding
- `Easy integration`

<br />

## How to use it

<br />

> **Install the package** via `PIP` 

```bash
$ pip install django-admin-argon-dashboard
// OR
$ pip install git+https://github.com/app-generator/django-admin-argon-dashboard.git
```

<br />

> Add `admin_argon` application to the `INSTALLED_APPS` setting of your Django project `settings.py` file (note it should be before `django.contrib.admin`):

```python
    INSTALLED_APPS = (
        ...
        'admin_argon.apps.AdminArgonConfig',
        'django.contrib.admin',
    )
```

<br />

> Add `admin_argon` urls in your Django Project `urls.py` file.

```python
    from django.urls import path, include

    urlpatterns = [
        ...
        path('', include('admin_argon.urls')),
    ]
```

Here are the available `links`: 

```python

    path('', views.index, name='index'),
    path('billing/', views.billing, name='billing'),
    path('profile/', views.profile, name='profile'),
    path('tables/',  views.tables,  name='tables' ),
    path('rtl/',     views.rtl,     name='rtl'    ),
    path('vr/',      views.vr,      name='vr'     ),
    
```

<br />

> **Collect static** if you are in `production environment`:

```bash
$ python manage.py collectstatic
```

<br />

> **Start the app**

```bash
$ # Set up the database
$ python manage.py makemigrations
$ python manage.py migrate
$
$ # Create the superuser
$ python manage.py createsuperuser
$
$ # Start the application (development mode)
$ python manage.py runserver # default port 8000
```

Access the `admin` section in the browser: `http://127.0.0.1:8000/`

<br />

## How to use it for common users

> `Create view functions` for a particular pages and render the html template.

```python
    def dashboard(request):
        return render(request, 'pages/dashboard.html')
```

<br />

> Create `urls.py` file and map the function to the `urls.py` file.

```python
    path('dashboard/', views.dashboard, name="dashboard")
```

<br />

>  Available pages 

- `dashboard.html`
- `billing.html`
- `profile.html`
- `rtl.html`
- `tables.html`
- `virtual-reality.html`

<br />

## Screenshots

Start your development with a Freebie Dashboard for [Bootstrap 5](https://www.admin-dashboards.com/bootstrap-5-templates/). Argon is a completly new product built on our newest re-built from scratch framework structure that is meant to make our products more intuitive and much easier to customize. 
Argon Dashboard is built with over 70 individual components, giving you the freedom of choosing and combining. This Dashboard is coming with pre-built examples, so the development process is seamless, switching from our pages to the real website is very easy to be done.

<br /> 

> **[Django Admin Argon](https://github.com/app-generator/django-admin-argon-dashboard)**: `Edit users`

![django-admin-argon-users-min](https://user-images.githubusercontent.com/51070104/201162283-90fb0637-687e-4926-ab12-bf409491dac6.jpg)

<br />

> **[Django Admin Argon](https://github.com/app-generator/django-admin-argon-dashboard)**: `Dashboard` page

![django-admin-argon-dashboard-min](https://user-images.githubusercontent.com/51070104/201162509-80df6786-e595-4fca-a570-45f6a4438c24.jpg) 

<br />

---
**[Django Admin Argon](https://github.com/app-generator/django-admin-argon-dashboard)** - Modern Admin Interface provided by **[AppSeed](https://appseed.us/)**
