# Generated by Django 2.2.11 on 2022-03-09 20:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('apis_vocabularies', '0002_texttype_lang'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('apis_metainfo', '0006_remove_text_lang'),
        ('apis_entities', '0004_auto_20200722_1231'),
    ]

    operations = [
        migrations.CreateModel(
            name='DataSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('server_directory', models.CharField(max_length=255)),
                ('page_count', models.IntegerField(blank=True, null=True)),
                ('citation', models.TextField(blank=True, max_length=600, null=True)),
                ('year', models.CharField(max_length=10)),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DataSourcePage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page_index', models.IntegerField()),
                ('page_token', models.CharField(blank=True, max_length=20, null=True)),
                ('DataSource', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.DataSource')),
            ],
        ),
        migrations.CreateModel(
            name='GenericCollectionEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='ImportProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, help_text='Describe your project here.', max_length=2000, null=True)),
                ('DataSources', models.ManyToManyField(blank=True, help_text='Consider adding existing Datasources uploaded by you to this Project. Or upload/add additional Datasources later.', to='apis_import_project.DataSource')),
                ('Editors', models.ManyToManyField(blank=True, help_text='Add users that should be able to edit this project.', related_name='Editors', to=settings.AUTH_USER_MODEL)),
                ('collection', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_metainfo.Collection')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='owner', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PageCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_in', models.ManyToManyField(related_name='created', to='apis_import_project.GenericCollectionEntry')),
                ('edited_in', models.ManyToManyField(related_name='edited', to='apis_import_project.GenericCollectionEntry')),
            ],
        ),
        migrations.CreateModel(
            name='ProjectState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_datasource', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_import_project.DataSource')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.ImportProject')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProjectCollectionEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('json', models.TextField(blank=True)),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='last_json', to='apis_import_project.GenericCollectionEntry')),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.ImportProject')),
            ],
        ),
        migrations.CreateModel(
            name='PageData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('collection', models.OneToOneField(auto_created=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_import_project.PageCollection')),
                ('function', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_vocabularies.PersonInstitutionRelation')),
                ('institution', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_entities.Institution')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.DataSourcePage')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.ImportProject')),
            ],
        ),
        migrations.CreateModel(
            name='DataSourceProjectState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('datasource', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.DataSource')),
                ('last_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_import_project.DataSourcePage')),
                ('project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_import_project.ImportProject')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
