from pathlib import Path
from setuptools import setup, find_packages

this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

setup(
    name='arb_logger',
    author='arb',
    author_email='arb.trops@gmail.com',
    description="A custom logger with Redis integration",
    url="https://github.com/Acid3croco/arb-trops-services",
    long_description=long_description,
    long_description_content_type='text/markdown',
    version='2.0.1',
    packages=find_packages(),
    install_requires=['coloredlogs', 'redis', 'pync'],
    entry_points={
        'console_scripts': [
            'arb_alerts = arb_logger.redis_log_client:main',
        ]
    },
)
