# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetDeviceResult:
    """
    A collection of values returned by getDevice.
    """
    def __init__(__self__, access_private_ipv4=None, access_public_ipv4=None, access_public_ipv6=None, always_pxe=None, billing_cycle=None, description=None, device_id=None, facility=None, hardware_reservation_id=None, hostname=None, id=None, ipxe_script_url=None, network_type=None, networks=None, operating_system=None, plan=None, ports=None, project_id=None, root_password=None, ssh_key_ids=None, state=None, storage=None, tags=None):
        if access_private_ipv4 and not isinstance(access_private_ipv4, str):
            raise TypeError("Expected argument 'access_private_ipv4' to be a str")
        __self__.access_private_ipv4 = access_private_ipv4
        """
        The ipv4 private IP assigned to the device
        """
        if access_public_ipv4 and not isinstance(access_public_ipv4, str):
            raise TypeError("Expected argument 'access_public_ipv4' to be a str")
        __self__.access_public_ipv4 = access_public_ipv4
        """
        The ipv4 management IP assigned to the device
        """
        if access_public_ipv6 and not isinstance(access_public_ipv6, str):
            raise TypeError("Expected argument 'access_public_ipv6' to be a str")
        __self__.access_public_ipv6 = access_public_ipv6
        """
        The ipv6 management IP assigned to the device
        """
        if always_pxe and not isinstance(always_pxe, bool):
            raise TypeError("Expected argument 'always_pxe' to be a bool")
        __self__.always_pxe = always_pxe
        if billing_cycle and not isinstance(billing_cycle, str):
            raise TypeError("Expected argument 'billing_cycle' to be a str")
        __self__.billing_cycle = billing_cycle
        """
        The billing cycle of the device (monthly or hourly)
        """
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        __self__.description = description
        """
        Description string for the device
        """
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        __self__.device_id = device_id
        if facility and not isinstance(facility, str):
            raise TypeError("Expected argument 'facility' to be a str")
        __self__.facility = facility
        """
        The facility where the device is deployed.
        """
        if hardware_reservation_id and not isinstance(hardware_reservation_id, str):
            raise TypeError("Expected argument 'hardware_reservation_id' to be a str")
        __self__.hardware_reservation_id = hardware_reservation_id
        """
        The id of hardware reservation which this device occupies
        """
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        __self__.hostname = hostname
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if ipxe_script_url and not isinstance(ipxe_script_url, str):
            raise TypeError("Expected argument 'ipxe_script_url' to be a str")
        __self__.ipxe_script_url = ipxe_script_url
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        __self__.network_type = network_type
        """
        L2 network type of the device, one of "layer3", "layer2-bonded", "layer2-individual", "hybrid"
        """
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        __self__.networks = networks
        """
        The device's private and public IP (v4 and v6) network details. When a device is run without any special network configuration, it will have 3 networks: 
        * Public IPv4 at `packet_device.name.network.0`
        * IPv6 at `packet_device.name.network.1`
        * Private IPv4 at `packet_device.name.network.2`
        Elastic addresses then stack by type - an assigned public IPv4 will go after the management public IPv4 (to index 1), and will then shift the indices of the IPv6 and private IPv4. Assigned private IPv4 will go after the management private IPv4 (to the end of the network list).
        The fields of the network attributes are:
        """
        if operating_system and not isinstance(operating_system, str):
            raise TypeError("Expected argument 'operating_system' to be a str")
        __self__.operating_system = operating_system
        """
        The operating system running on the device
        """
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        __self__.plan = plan
        """
        The hardware config of the device
        """
        if ports and not isinstance(ports, list):
            raise TypeError("Expected argument 'ports' to be a list")
        __self__.ports = ports
        """
        Ports assigned to the device
        """
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        __self__.project_id = project_id
        if root_password and not isinstance(root_password, str):
            raise TypeError("Expected argument 'root_password' to be a str")
        __self__.root_password = root_password
        """
        Root password to the server (if still available)
        """
        if ssh_key_ids and not isinstance(ssh_key_ids, list):
            raise TypeError("Expected argument 'ssh_key_ids' to be a list")
        __self__.ssh_key_ids = ssh_key_ids
        """
        List of IDs of SSH keys deployed in the device, can be both user or project SSH keys
        """
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        __self__.state = state
        """
        The state of the device
        """
        if storage and not isinstance(storage, str):
            raise TypeError("Expected argument 'storage' to be a str")
        __self__.storage = storage
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        __self__.tags = tags
        """
        Tags attached to the device
        """
class AwaitableGetDeviceResult(GetDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeviceResult(
            access_private_ipv4=self.access_private_ipv4,
            access_public_ipv4=self.access_public_ipv4,
            access_public_ipv6=self.access_public_ipv6,
            always_pxe=self.always_pxe,
            billing_cycle=self.billing_cycle,
            description=self.description,
            device_id=self.device_id,
            facility=self.facility,
            hardware_reservation_id=self.hardware_reservation_id,
            hostname=self.hostname,
            id=self.id,
            ipxe_script_url=self.ipxe_script_url,
            network_type=self.network_type,
            networks=self.networks,
            operating_system=self.operating_system,
            plan=self.plan,
            ports=self.ports,
            project_id=self.project_id,
            root_password=self.root_password,
            ssh_key_ids=self.ssh_key_ids,
            state=self.state,
            storage=self.storage,
            tags=self.tags)

def get_device(device_id=None,hostname=None,project_id=None,opts=None):
    """
    Provides a Packet device datasource.

    > **Note:** All arguments including the `root_password` and `user_data` will be stored in
     the raw state as plain-text.
    [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).


    :param str device_id: Device ID
    :param str hostname: The device name
    :param str project_id: The id of the project in which the devices exists
    """
    __args__ = dict()


    __args__['deviceId'] = device_id
    __args__['hostname'] = hostname
    __args__['projectId'] = project_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('packet:index/getDevice:getDevice', __args__, opts=opts).value

    return AwaitableGetDeviceResult(
        access_private_ipv4=__ret__.get('accessPrivateIpv4'),
        access_public_ipv4=__ret__.get('accessPublicIpv4'),
        access_public_ipv6=__ret__.get('accessPublicIpv6'),
        always_pxe=__ret__.get('alwaysPxe'),
        billing_cycle=__ret__.get('billingCycle'),
        description=__ret__.get('description'),
        device_id=__ret__.get('deviceId'),
        facility=__ret__.get('facility'),
        hardware_reservation_id=__ret__.get('hardwareReservationId'),
        hostname=__ret__.get('hostname'),
        id=__ret__.get('id'),
        ipxe_script_url=__ret__.get('ipxeScriptUrl'),
        network_type=__ret__.get('networkType'),
        networks=__ret__.get('networks'),
        operating_system=__ret__.get('operatingSystem'),
        plan=__ret__.get('plan'),
        ports=__ret__.get('ports'),
        project_id=__ret__.get('projectId'),
        root_password=__ret__.get('rootPassword'),
        ssh_key_ids=__ret__.get('sshKeyIds'),
        state=__ret__.get('state'),
        storage=__ret__.get('storage'),
        tags=__ret__.get('tags'))
