"""
Test number normaliser
"""
from techiaith.tts.testun.number_norm import find_numbers

tests = [
    ["0", "dim"],
    ["1", "un"],
    ["2", "dau"],
    ["2 gath", "dwy gath"],
    ["3", "tri"],
    ["4", "pedwar"],
    ["5", "pump"],
    ["6", "chwech"],
    ["7", "saith"],
    ["8", "wyth"],
    ["9", "naw"],
    ["10", "deg"],
    ["11", "un deg un"],
    ["12", "un deg dau"],
    ["13", "un deg tri"],
    ["14", "un deg pedwar"],
    ["15", "un deg pump"],
    ["16", "un deg chwech"],
    ["17", "un deg saith"],
    ["18", "un deg wyth"],
    ["19", "un deg naw"],
    ["20", "ugain"],
    ["30", "tri deg"],
    ["40", "pedwar deg"],
    ["50", "pum deg"],
    ["60", "chwe deg"],
    ["70", "saith deg"],
    ["80", "wyth deg"],
    ["90", "naw deg"],
    ["93", "naw deg tri"],
    ["100", "cant"],
    ["110", "cant un deg"],
    ["120", "cant dau ddeg"],
    ["500", "pum cant"],
    ["1000", "mil"],
    ["10000", "deg mil"],
    ["21", "dau ddeg un"],
    ["32", "tri deg dau"],
    ["43", "pedwar deg tri"],
    ["54", "pum deg pedwar"],
    ["65", "chwe deg pump"],
    ["76", "saith deg chwech"],
    ["87", "wyth deg saith"],
    ["98", "naw deg wyth"],
    ["99", "naw deg naw"],
    ["111", "cant un deg un"],
    ["112", "cant un deg dau"],
    ["123", "cant dau ddeg tri"],
    ["504", "pum can pedwar"],
    ["1050", "mil pum deg"],
    ["16789", "un deg chwe mil saith cant wyth deg naw"],
    ["11110", "deg mil cant un deg"],
    ["273693", "dau gant saith deg tri mil chwe chant naw deg tri"],
    ["73693", "saith deg tri mil chwe chant naw deg tri"],
    ["10020360", "deg miliwn dau ddeg mil tri chant chwe deg"],
    ["07984663484", "dim saith naw wyth pedwar chwech chwech tri phedwar wyth pedwar"],
    ["079846634840", "dim saith naw wyth pedwar chwech chwech tri phedwar wyth pedwar dim"],
    [
        "+4479846634840",
        "plws pedwar pedwar saith naw wyth pedwar chwech chwech tri phedwar wyth pedwar dim",
    ],
    ["01248 345321", "dim un dau bedwar wyth tri phedwar pump tri dau un"],
    [
        "123,456,789",
        "cant dau ddeg tair miliwn pedwar cant pum deg chwe mil saith cant wyth deg naw",
    ],
    ["4.99", "pedwar pwynt naw deg naw"],
    ["499,000.34", "pedwar cant naw deg naw mil pwynt tri deg pedwar"],
    ["£4.99", "pedair punt naw deg naw ceiniog"],
    ["£200", "dau can punt"],
    ["mae gen i £200", "mae gen i ddau can punt"],
    ["mae yna 2 gath", "mae yna dwy gath"],
    ["£1", "un bunt"],
    ["£2", "dwy bunt"],
    ["£3", "tair punt"],
    ["£4", "pedair punt"],
    ["£5", "pum punt"],
    ["£6", "chwe phunt"],
    ["£7", "saith bunt"],
    ["£8", "wyth bunt"],
    ["£9", "naw punt"],
    ["£10", "deg punt"],
    ["£1050.25", "mil pum deg punt dwy ddeg pum ceiniog"],
    ["£20m", "ugain miliwn punt"],
    ["£2.3m", "dau bwynt tair miliwn punt"],
    ["£99", "naw deg naw punt"],
]


def test_wordify():
    for test in tests:
        words = find_numbers(test[0])
        assert test[1] == words
