#!/usr/bin/env python3
# Generated by "pythonizer -aM CGI/Carp.pm" v1.027 run by SNOOPYJC on Wed Feb 22 18:03:16 2023
__author__ = """Joe Cool"""
__email__ = "snoopyjc@gmail.com"
__version__ = "1.027"
import builtins, os, perllib, re, sys
import time as tm_py

_bn = lambda s: "" if s is None else s
_str = lambda s: "" if s is None else str(s)
import Exporter as _Exporter

builtins.__PACKAGE__ = "CGI.Carp"
Exporter.import_("Exporter")
perllib.init_package("main")
perllib.init_package("CGI.Carp")
perllib.init_package("CORE.GLOBAL")

# Cut and paste from CGI.pm so that we don't have the overhead of
# always loading the entire CGI module.


def to_filehandle(*_args):
    _args = list(_args)

    caller = 0
    package = None
    tmp = None
    thingy = _args.pop(0) if _args else None
    if not thingy:
        return None

    if perllib.isa(thingy, "GLOB"):
        return thingy

    if perllib.isa(thingy, "FileHandle"):
        return thingy

    if not perllib.ref_scalar(thingy):
        caller = 1
        while package := perllib.caller_s((caller := caller + 1) - 1):
            [tmp] = perllib.list_of_n(
                thingy
                if (re.search(r"[\':]", _str(thingy)))
                else f"{_bn(package)}::{_bn(thingy)}",
                1,
            )
            if perllib.fileno(tmp) is not None:
                return tmp

    return None


CGI.Carp.to_filehandle = to_filehandle

# headers


def fatalsToBrowser(*_args):
    _args = list(_args)

    bytes_written = None
    r = None
    msg = _args.pop(0) if _args else None

    if perllib.ref_scalar(msg):
        msg = f"{_bn(msg)}"

    msg = re.sub(re.compile(r"&"), r"&amp;", _str(msg), count=0)
    msg = re.sub(re.compile(r">"), r"&gt;", _str(msg), count=0)
    msg = re.sub(re.compile(r"<"), r"&lt;", _str(msg), count=0)
    msg = re.sub(re.compile(r'"'), r"&quot;", _str(msg), count=0)

    [wm] = perllib.list_of_n(
        f"""the webmaster (<a href="mailto:{os.environ.get('SERVER_ADMIN','')}">{os.environ.get('SERVER_ADMIN','')}</a>)"""
        if os.environ.get("SERVER_ADMIN")
        else "this site's webmaster",
        1,
    )
    [outer_message] = perllib.list_of_n(
        f"""For help, please send mail to {_bn(wm)}, giving this error message 
and the time and date of the error.
""",
        1,
    )
    mod_perl = "MOD_PERL" in os.environ

    if CGI.Carp.CUSTOM_MSG_v:
        if perllib.ref_scalar(CGI.Carp.CUSTOM_MSG_v) == "CODE":
            if not mod_perl:
                perllib.perl_print("Content-type: text/html\n", file=sys.stdout)

            try:
                perllib.EXCEPTIONS_BEING_CAUGHT = 1

                perllib.get_subref(CGI.Carp.CUSTOM_MSG_v)(msg)  # nicer to perl 5.003 users
                perllib.EVAL_ERROR = ""
                perllib.EXCEPTIONS_BEING_CAUGHT = ""
            except Exception as _e:
                perllib.EVAL_ERROR = perllib.exc(_e)
                perllib.EXCEPTIONS_BEING_CAUGHT = ""

            if perllib.EVAL_ERROR:
                perllib.perl_print(
                    f"error while executing the error handler: {perllib.EVAL_ERROR}",
                    end="",
                    file=sys.stderr,
                )

            return
        else:
            outer_message = CGI.Carp.CUSTOM_MSG_v

    mess = f"""<h1>Software error:</h1>
<pre>{_bn(msg)}</pre>
<p>
{_bn(outer_message)}
</p>
"""

    if mod_perl:
        r = None
        if (
            os.environ.get("MOD_PERL_API_VERSION")
            and perllib.num(os.environ.get("MOD_PERL_API_VERSION")) == 2
        ):
            mod_perl = 2
            import Apache2.RequestRec as _Apache2_RequestRec
            import Apache2.RequestIO as _Apache2_RequestIO
            import Apache2.RequestUtil as _Apache2_RequestUtil
            import APR.Pool as _APR_Pool
            import ModPerl.Util as _ModPerl_Util
            import Apache2.Response as _Apache2_Response

            r = Apache2.RequestUtil.request(Apache2.RequestUtil)
        else:
            r = Apache.request(Apache)
        # If bytes have already been sent, then
        # we print the message out directly.
        # Otherwise we make a custom error
        # handler to produce the doc for us.

        if r.bytes_sent():
            r.print_(mess)
            ModPerl.Util.exit(0) if mod_perl == 2 else r.exit()
        else:
            # MSIE won't display a custom 500 response unless it is >512 bytes!
            if os.environ.get("HTTP_USER_AGENT") is not None and (
                re.search(r"MSIE", _str(os.environ.get("HTTP_USER_AGENT")))
            ):
                mess = "<!-- " + (_str(" " * 513)) + f" -->\n{mess}"

            r.custom_response(500, mess)
    else:
        _eval_result584 = None
        try:
            perllib.EXCEPTIONS_BEING_CAUGHT = 1
            _eval_result584 = perllib.tell(sys.stdout)
            perllib.EVAL_ERROR = ""
            perllib.EXCEPTIONS_BEING_CAUGHT = ""
        except Exception as _e:
            perllib.EVAL_ERROR = perllib.exc(_e)
            perllib.EXCEPTIONS_BEING_CAUGHT = ""

        bytes_written = _eval_result584
        if bytes_written is not None and perllib.num(bytes_written) > 0:
            perllib.perl_print(mess, end="", file=sys.stdout)
        else:
            perllib.perl_print("Status: 500", file=sys.stdout)
            perllib.perl_print("Content-type: text/html\n", file=sys.stdout)
            # MSIE won't display a custom 500 response unless it is >512 bytes!
            if os.environ.get("HTTP_USER_AGENT") is not None and (
                re.search(r"MSIE", _str(os.environ.get("HTTP_USER_AGENT")))
            ):
                mess = "<!-- " + (_str(" " * 513)) + f" -->\n{mess}"

            perllib.perl_print(mess, end="", file=sys.stdout)

    return CGI.Carp.warningsToBrowser(1)  # emit warnings before dying


CGI.Carp.fatalsToBrowser = fatalsToBrowser


def set_die_handler(*_args):
    _args = list(_args)

    [handler] = perllib.list_of_n((_args.pop(0) if _args else None), 1)

    # setting SIG{__DIE__} here is necessary to catch runtime
    # errors which are not called by literally saying "die",
    # such as the line "undef->explode();". however, doing this
    # will interfere with fatalsToBrowser, which also sets
    # SIG{__DIE__} in the import() function above (or the
    # import() function above may interfere with this). for
    # this reason, you should choose to either set the die
    # handler here, or use fatalsToBrowser, not both.
    main.SIG_h["__DIE__"] = handler

    CGI.Carp.DIE_HANDLER_v = handler

    return CGI.Carp.DIE_HANDLER_v


CGI.Carp.set_die_handler = set_die_handler


def set_message(*_args):
    _args = list(_args)
    CGI.Carp.CUSTOM_MSG_v = _args.pop(0) if _args else None
    return CGI.Carp.CUSTOM_MSG_v


CGI.Carp.set_message = set_message

# The mod_perl package Apache::Registry loads CGI programs by calling
# eval.  These evals don't count when looking at the stack backtrace.


def _longmess_(*_args):
    message = perllib.longmess()
    if "MOD_PERL" in os.environ:

        def _f425(_m_):
            global _m
            _m = _m_
            return _m.expand(r"")

        message = re.sub(
            re.compile(r"eval[^\n]+(ModPerl|Apache)/(?:Registry|Dispatch)\w*\.pm.*", re.S),
            _f425,
            message,
            count=1,
        )

    return message


CGI.Carp._longmess_ = _longmess_


def ineval(*_args):
    return (0 if "MOD_PERL" in os.environ else perllib.EXCEPTIONS_BEING_CAUGHT) or (
        re.search(re.compile(r"eval [\{\']", re.M), CGI.Carp._longmess_())
    )


CGI.Carp.ineval = ineval


def _warn_(*_args):
    _args = list(_args)
    msg = _args.pop(0) if _args else None
    if CGI.Carp.EMIT_WARNINGS_v:
        # We need to mangle the message a bit to make it a valid HTML
        # comment.  This is done by substituting similar-looking ISO
        # 8859-1 characters for <, > and -.  This is a hack.
        msg = _str(msg).translate(str.maketrans("<>-", "\xab\xbb\xad"))
        msg = msg.rstrip("\n")
        return perllib.perl_print(f"<!-- warning: {_bn(msg)} -->", file=sys.stdout)
    else:
        return CGI.Carp.WARNINGS_a.append(msg)


CGI.Carp._warn_ = _warn_


def warningsToBrowser(*_args):
    _args = list(_args)
    CGI.Carp.EMIT_WARNINGS_v = (_args.pop(0) if _args else None) if _args else 1
    while CGI.Carp.EMIT_WARNINGS_v and CGI.Carp.WARNINGS_a:
        CGI.Carp._warn_(CGI.Carp.WARNINGS_a.pop(0) if CGI.Carp.WARNINGS_a else None)


CGI.Carp.warningsToBrowser = warningsToBrowser


def set_progname(*_args):
    _args = list(_args)
    CGI.Carp.PROGNAME_v = _args.pop(0) if _args else None
    return CGI.Carp.PROGNAME_v


CGI.Carp.set_progname = set_progname


def stamp(*_args):
    frame = 0
    id_v = ""
    pack = None
    file = None
    dev = ""
    dirs = ""
    if CGI.Carp.PROGNAME_v is not None:
        id_v = CGI.Carp.PROGNAME_v
    else:
        _do_376 = True
        while _do_376:
            id_v = file
            [pack, file] = perllib.list_of_n(perllib.caller((frame := frame + 1) - 1), 2)
            _do_376 = not (not file)

    if not CGI.Carp.FULL_PATH_v:
        [dev, dirs, id_v] = perllib.list_of_n(perllib.splitpath(_str(id_v)), 3)

    if CGI.Carp.NO_TIMESTAMP_v:
        return f"{_bn(id_v)}: "

    time = tm_py.ctime()
    return f"[{time}] {_bn(id_v)}: "


CGI.Carp.stamp = stamp


def id_(*_args):
    _args = list(_args)
    level = _args.pop(0) if _args else None
    [pack, file, line, sub] = perllib.list_of_n(perllib.caller(perllib.int_(level)), 4)
    [dev, dirs, id_v] = perllib.list_of_n(perllib.splitpath(_str(file)), 3)
    return perllib.Array([file, line, id_v])


CGI.Carp.id_ = id_


def realdie(*_args):
    return perllib.die(*_args)


CGI.Carp.realdie = realdie

# We have to be ready to accept a filehandle as a reference
# or a string.


def carpout(*_args):
    [in_] = perllib.list_of_n(_args, 1)
    [no] = perllib.list_of_n(perllib.fileno(CGI.Carp.to_filehandle(in_)), 1)
    if no is None:
        CGI.Carp.realdie(f"Invalid filehandle {_bn(in_)}\n")

    CGI.Carp.SAVEERR = perllib.dup(sys.stderr, "w", checked=False)
    sys.stderr = perllib.dup(f"{_bn(no)}", "w", checked=False)
    return not sys.stderr.closed or (
        perllib.perl_print(
            f"Unable to redirect >&{_bn(no)}: {perllib.OS_ERROR}\n", end="", file=CGI.Carp.SAVEERR
        )
        and sys.exit(1)
    )


CGI.Carp.carpout = carpout


def die(*_args):
    # if no argument is passed, propagate $@ like
    # the real die
    [arg, *rest] = perllib.list_of_at_least_n(
        _args
        if _args
        else f"{perllib.EVAL_ERROR}\t...propagated"
        if perllib.EVAL_ERROR
        else "Died",
        1,
    )
    rest = perllib.Array(rest)

    if CGI.Carp.DIE_HANDLER_v:
        perllib.get_subref(CGI.Carp.DIE_HANDLER_v)(arg, *rest)

    # the "$arg" is done on purpose!
    # if called as die( $object, 'string' ),
    # all is stringified, just like with
    # the real 'die'

    if rest:
        arg = "".join(map(_str, (f"{_bn(arg)}", *rest)))

    # SNOOPYJC [file, line, id_v] = perllib.list_of_n(CGI.Carp.id_(1), 3)
    [file, line, id_v] = perllib.list_of_n(CGI.Carp.id_(2), 3)  # SNOOPYJC: Don't report the error in perllib

    if not (perllib.ref_scalar(arg) or (re.search(r"\n$", _str(arg)))):
        arg = _str(arg) + f" at {_bn(file)} line {_bn(line)}.\n"

    if CGI.Carp.ineval():
        CGI.Carp.realdie(arg)

    if CGI.Carp.WRAP_v and CGI.Carp.TO_BROWSER_v:
        CGI.Carp.fatalsToBrowser(arg)

    if (re.search(r"\n$", _str(arg))) or not "MOD_PERL" in os.environ:

        def _f456(_m_):
            global _m
            _m = _m_
            return CGI.Carp.stamp()

        arg = re.sub(re.compile(r"^(?=.|\n)", re.M), _f456, _str(arg), count=0)

    if not ((re.search(r"\n$", _str(arg)))):
        arg = _str(arg) + "\n"

    return CGI.Carp.realdie(arg)


CGI.Carp.die = die


def croak(*_args):
    return CGI.Carp.die(perllib.shortmess(*_args, skip=1))  # SNOOPYJC


CGI.Carp.croak = croak


def confess(*_args):
    return CGI.Carp.die(perllib.longmess(*_args, skip=1))   # SNOOPYJC


CGI.Carp.confess = confess

# These are the originals


def realwarn(*_args):
    return perllib.warn(*_args)


CGI.Carp.realwarn = realwarn


def warn(*_args):
    _args = list(_args)
    message = _args.pop(0) if _args else None
    [file, line, id_v] = perllib.list_of_n(CGI.Carp.id_(1), 3)
    if not ((re.search(r"\n$", _str(message)))):
        message = _str(message) + f" at {_bn(file)} line {_bn(line)}.\n"

    if CGI.Carp.WARN_v:
        CGI.Carp._warn_(message)

    stamp_v = stamp()
    message = re.sub(re.compile(r"^(?=.|\n)", re.M), rf"{stamp_v}", _str(message), count=0)
    return CGI.Carp.realwarn(message)


CGI.Carp.warn = warn


def cluck(*_args):
    return CGI.Carp.warn(perllib.longmess(*_args, skip=1))  # SNOOPYJC


CGI.Carp.cluck = cluck


def carp(*_args):
    return CGI.Carp.warn(perllib.shortmess(*_args, skip=1)) # SNOOPYJC


CGI.Carp.carp = carp

# fancy import routine detects and handles 'errorWrap' specially.


def import_(*_args):
    _args = list(_args)
    global _d

    n = None
    pkg = _args.pop(0) if _args else None
    routines = perllib.Hash()
    name = perllib.Array()
    if name := list(filter(lambda _d: re.search(r"^name=", _d), _args)):
        [n] = perllib.list_of_n((perllib.split(r"=", _str(name[0])))[1], 1)
        CGI.Carp.set_progname(n)
        _args = perllib.Array(list(filter(lambda _d: not re.search(r"^name=", _str(_d)), _args)))

    list(
        filter(
            lambda _d: (perllib.add_element(routines, _d, 1) - 1),
            perllib.flatten([_args, CGI.Carp.EXPORT_a]),
        )
    )
    if routines.get("fatalsToBrowser") or routines.get("wrap"):
        CGI.Carp.WRAP_v = perllib.num(CGI.Carp.WRAP_v) + 1

    if routines.get("warningsToBrowser"):
        CGI.Carp.WARN_v = perllib.num(CGI.Carp.WARN_v) + 1

    [oldlevel] = perllib.list_of_n(Exporter.ExportLevel_v, 1)
    Exporter.ExportLevel_v = 1
    Exporter.import_(pkg, *routines.keys())
    Exporter.ExportLevel_v = oldlevel
    if routines.get("fatalsToBrowser"):
        main.SIG_h["__DIE__"] = CGI.Carp.die

    if routines.get("noTimestamp"):
        CGI.Carp.NO_TIMESTAMP_v = 1
        return CGI.Carp.NO_TIMESTAMP_v


CGI.Carp.import_ = import_
# use Carp;


def __BEGIN__316():

    pass  # SKIPPED:   require Carp;
    CORE.GLOBAL.die = CGI.Carp.die
    die = CGI.Carp.die


CGI.Carp.__BEGIN__316 = __BEGIN__316

# SKIPPED: use File::Spec;

CGI.Carp.CUSTOM_MSG_v = perllib.init_global("CGI.Carp", "CUSTOM_MSG_v", "")
CGI.Carp.DIE_HANDLER_v = perllib.init_global("CGI.Carp", "DIE_HANDLER_v", "")
CGI.Carp.EMIT_WARNINGS_v = perllib.init_global("CGI.Carp", "EMIT_WARNINGS_v", "")
CGI.Carp.EXPORT_a = perllib.init_global("CGI.Carp", "EXPORT_a", perllib.Array())
CGI.Carp.FULL_PATH_v = perllib.init_global("CGI.Carp", "FULL_PATH_v", "")
CGI.Carp.NO_TIMESTAMP_v = perllib.init_global("CGI.Carp", "NO_TIMESTAMP_v", None)
CGI.Carp.PROGNAME_v = perllib.init_global("CGI.Carp", "PROGNAME_v", None)
CGI.Carp.TO_BROWSER_v = perllib.init_global("CGI.Carp", "TO_BROWSER_v", 0)
CGI.Carp.WARNINGS_a = perllib.init_global("CGI.Carp", "WARNINGS_a", perllib.Array())
CGI.Carp.WARN_v = perllib.init_global("CGI.Carp", "WARN_v", None)
CGI.Carp.WRAP_v = perllib.init_global("CGI.Carp", "WRAP_v", None)
_d = ""
main.SIG_h = perllib.init_global("main", "SIG_h", perllib.Hash())

__BEGIN__316()
builtins.__PACKAGE__ = "CGI.Carp"

#appease_cpants_kwalitee = """
#use strict;
#use warnings;
#"""

"""
=head1 NAME

B<CGI::Carp> - CGI routines for writing to the HTTPD (or other) error log

=head1 SYNOPSIS

    use CGI::Carp;

    croak "We're outta here!";
    confess "It was my fault: $!";
    carp "It was your fault!";   
    warn "I'm confused";
    die  "I'm dying.\n";

    use CGI::Carp qw(cluck);
    cluck "I wouldn't do that if I were you";

    use CGI::Carp qw(fatalsToBrowser);
    die "Fatal error messages are now sent to browser";

=head1 DESCRIPTION

CGI scripts have a nasty habit of leaving warning messages in the error
logs that are neither time stamped nor fully identified.  Tracking down
the script that caused the error is a pain.  This fixes that.  Replace
the usual

    use Carp;

with

    use CGI::Carp

The standard warn(), die (), croak(), confess() and carp() calls will
be replaced with functions that write time-stamped messages to the
HTTP server error log.

For example:

   [Fri Nov 17 21:40:43 1995] test.pl: I'm confused at test.pl line 3.
   [Fri Nov 17 21:40:43 1995] test.pl: Got an error message: Permission denied.
   [Fri Nov 17 21:40:43 1995] test.pl: I'm dying.

=head1 REDIRECTING ERROR MESSAGES

By default, error messages are sent to STDERR.  Most HTTPD servers
direct STDERR to the server's error log.  Some applications may wish
to keep private error logs, distinct from the server's error log, or
they may wish to direct error messages to STDOUT so that the browser
will receive them.

The C<carpout()> function is provided for this purpose.  Since
carpout() is not exported by default, you must import it explicitly by
saying

   use CGI::Carp qw(carpout);

The carpout() function requires one argument, a reference to an open
filehandle for writing errors.  It should be called in a C<BEGIN>
block at the top of the CGI application so that compiler errors will
be caught.  Example:

   BEGIN {
     use CGI::Carp qw(carpout);
     open(LOG, ">>/usr/local/cgi-logs/mycgi-log") or
       die("Unable to open mycgi-log: $!\n");
     carpout(LOG);
   }

carpout() does not handle file locking on the log for you at this
point.  Also, note that carpout() does not work with in-memory file
handles, although a patch would be welcome to address that.

The real STDERR is not closed -- it is moved to CGI::Carp::SAVEERR.
Some servers, when dealing with CGI scripts, close their connection to
the browser when the script closes STDOUT and STDERR.
CGI::Carp::SAVEERR is there to prevent this from happening
prematurely.

You can pass filehandles to carpout() in a variety of ways.  The "correct"
way according to Tom Christiansen is to pass a reference to a filehandle
GLOB:

    carpout(\*LOG);

This looks weird to mere mortals however, so the following syntaxes are
accepted as well:

    carpout(LOG);
    carpout(main::LOG);
    carpout(main'LOG);
    carpout(\LOG);
    carpout(\'main::LOG');

    ... and so on

FileHandle and other objects work as well.

Use of carpout() is not great for performance, so it is recommended
for debugging purposes or for moderate-use applications.  A future
version of this module may delay redirecting STDERR until one of the
CGI::Carp methods is called to prevent the performance hit.

=head1 MAKING PERL ERRORS APPEAR IN THE BROWSER WINDOW

If you want to send fatal (die, confess) errors to the browser, import
the special "fatalsToBrowser" subroutine:

    use CGI::Carp qw(fatalsToBrowser);
    die "Bad error here";

Fatal errors will now be echoed to the browser as well as to the log.
CGI::Carp arranges to send a minimal HTTP header to the browser so
that even errors that occur in the early compile phase will be seen.
Nonfatal errors will still be directed to the log file only (unless
redirected with carpout).

Note that fatalsToBrowser may B<not> work well with mod_perl version 2.0
and higher.

=head2 Changing the default message

By default, the software error message is followed by a note to
contact the Webmaster by e-mail with the time and date of the error.
If this message is not to your liking, you can change it using the
set_message() routine.  This is not imported by default; you should
import it on the use() line:

    use CGI::Carp qw(fatalsToBrowser set_message);
    set_message("It's not a bug, it's a feature!");

You may also pass in a code reference in order to create a custom
error message.  At run time, your code will be called with the text
of the error message that caused the script to die.  Example:

    use CGI::Carp qw(fatalsToBrowser set_message);
    BEGIN {
       sub handle_errors {
          my $msg = shift;
          print "<h1>Oh gosh</h1>";
          print "<p>Got an error: $msg</p>";
      }
      set_message(\&handle_errors);
    }

In order to correctly intercept compile-time errors, you should call
set_message() from within a BEGIN{} block.

=head1 DOING MORE THAN PRINTING A MESSAGE IN THE EVENT OF PERL ERRORS

If fatalsToBrowser in conjunction with set_message does not provide 
you with all of the functionality you need, you can go one step 
further by specifying a function to be executed any time a script
calls "die", has a syntax error, or dies unexpectedly at runtime
with a line like "undef->explode();". 

    use CGI::Carp qw(set_die_handler);
    BEGIN {
       sub handle_errors {
          my $msg = shift;
          print "content-type: text/html\n\n";
          print "<h1>Oh gosh</h1>";
          print "<p>Got an error: $msg</p>";

          #proceed to send an email to a system administrator,
          #write a detailed message to the browser and/or a log,
          #etc....
      }
      set_die_handler(\&handle_errors);
    }

Notice that if you use set_die_handler(), you must handle sending
HTML headers to the browser yourself if you are printing a message.

If you use set_die_handler(), you will most likely interfere with 
the behavior of fatalsToBrowser, so you must use this or that, not 
both. 

Using set_die_handler() sets SIG{__DIE__} (as does fatalsToBrowser),
and there is only one SIG{__DIE__}. This means that if you are 
attempting to set SIG{__DIE__} yourself, you may interfere with 
this module's functionality, or this module may interfere with 
your module's functionality.

=head1 SUPPRESSING PERL ERRORS APPEARING IN THE BROWSER WINDOW

A problem sometimes encountered when using fatalsToBrowser is
when a C<die()> is done inside an C<eval> body or expression.
Even though the
fatalsToBrower support takes precautions to avoid this,
you still may get the error message printed to STDOUT.
This may have some undesirable effects when the purpose of doing the
eval is to determine which of several algorithms is to be used.

By setting C<$CGI::Carp::TO_BROWSER> to 0 you can suppress printing
the C<die> messages but without all of the complexity of using
C<set_die_handler>.  You can localize this effect to inside C<eval>
bodies if this is desirable: For example:

 eval {
   local $CGI::Carp::TO_BROWSER = 0;
   die "Fatal error messages not sent browser"
 }
 # $@ will contain error message


=head1 MAKING WARNINGS APPEAR AS HTML COMMENTS

It is also possible to make non-fatal errors appear as HTML comments
embedded in the output of your program.  To enable this feature,
export the new "warningsToBrowser" subroutine.  Since sending warnings
to the browser before the HTTP headers have been sent would cause an
error, any warnings are stored in an internal buffer until you call
the warningsToBrowser() subroutine with a true argument:

    use CGI::Carp qw(fatalsToBrowser warningsToBrowser);
    use CGI qw(:standard);
    print header();
    warningsToBrowser(1);

You may also give a false argument to warningsToBrowser() to prevent
warnings from being sent to the browser while you are printing some
content where HTML comments are not allowed:

    warningsToBrowser(0);    # disable warnings
    print "<script type=\"text/javascript\"><!--\n";
    print_some_javascript_code();
    print "//--></script>\n";
    warningsToBrowser(1);    # re-enable warnings

Note: In this respect warningsToBrowser() differs fundamentally from
fatalsToBrowser(), which you should never call yourself!

=head1 OVERRIDING THE NAME OF THE PROGRAM

CGI::Carp includes the name of the program that generated the error or
warning in the messages written to the log and the browser window.
Sometimes, Perl can get confused about what the actual name of the
executed program was.  In these cases, you can override the program
name that CGI::Carp will use for all messages.

The quick way to do that is to tell CGI::Carp the name of the program
in its use statement.  You can do that by adding
"name=cgi_carp_log_name" to your "use" statement.  For example:

    use CGI::Carp qw(name=cgi_carp_log_name);

.  If you want to change the program name partway through the program,
you can use the C<set_progname()> function instead.  It is not
exported by default, you must import it explicitly by saying

    use CGI::Carp qw(set_progname);

Once you've done that, you can change the logged name of the program
at any time by calling

    set_progname(new_program_name);

You can set the program back to the default by calling

    set_progname(undef);

Note that this override doesn't happen until after the program has
compiled, so any compile-time errors will still show up with the
non-overridden program name

=head1 TURNING OFF TIMESTAMPS IN MESSAGES

If your web server automatically adds a timestamp to each log line,
you may not need CGI::Carp to add its own. You can disable timestamping
by importing "noTimestamp":

    use CGI::Carp qw(noTimestamp);

Alternatively you can set C<$CGI::Carp::NO_TIMESTAMP> to 1.

Note that the name of the program is still automatically included in
the message.

=head1 GETTING THE FULL PATH OF THE SCRIPT IN MESSAGES

Set C<$CGI::Carp::FULL_PATH> to 1.

=head1 AUTHOR INFORMATION

The CGI.pm distribution is copyright 1995-2007, Lincoln D. Stein. It is
distributed under the Artistic License 2.0. It is currently
maintained by Lee Johnson with help from many contributors.

Address bug reports and comments to: https://github.com/leejo/CGI.pm/issues

The original bug tracker can be found at: https://rt.cpan.org/Public/Dist/Display.html?Queue=CGI.pm

When sending bug reports, please provide the version of CGI.pm, the version of
Perl, the name and version of your Web server, and the name and version of the
operating system you are using.  If the problem is even remotely browser
dependent, please provide information about the affected browsers as well.

=head1 SEE ALSO

L<Carp>, L<CGI::Base>, L<CGI::BasePlus>, L<CGI::Request>,
L<CGI::MiniSvr>, L<CGI::Form>, L<CGI::Response>.

=cut
"""
# SKIPPED: require 5.000;
CGI.Carp.ISA_a = "Exporter".split()
CGI.Carp.EXPORT_a = "confess croak carp".split()
CGI.Carp.EXPORT_OK_a = "carpout fatalsToBrowser warningsToBrowser wrap noTimestamp set_message set_die_handler set_progname cluck ^name= die".split()

main.SIG_h["__WARN__"] = CGI.Carp.warn

CGI.Carp.VERSION_v = "4.54"
CGI.Carp.CUSTOM_MSG_v = None
CGI.Carp.DIE_HANDLER_v = None
CGI.Carp.TO_BROWSER_v = 1
CGI.Carp.NO_TIMESTAMP_v = 0
CGI.Carp.FULL_PATH_v = 0
