# My App Name Configuration

This document describes the configuration for My App Name. Each section will 
document a particular configuration value and its description. First, 
though, we start with the possible sources. 

This documentation was auto-generated by [yapconf.](https://github.com/loganasherjones/yapconf)


## Sources

My App Name configuration can be loaded from the below sources:


#### Source 1 Label

Source 1 Label is of type [etcd](https://yapconf.readthedocs.io/en/stable/sources.html#etcd).


The etcd source means that My App Name will load configuration values from the 
`/` in etcd.


#### Source 2 Label

Source 2 Label is of type [dict](https://yapconf.readthedocs.io/en/stable/sources.html#dict).


The dict source means that My App Name will load configuration values from an 
in-memory dictionary that cannot be modified externally. Usually, it is used as 
a list of sensible defaults.


#### Source 3 Label

Source 3 Label is of type [environment](https://yapconf.readthedocs.io/en/stable/sources.html#environment).


This environment source means that My App Name will load configuration values 
by using their `env_name` that is documented below.


#### Source 4 Label

Source 4 Label is of type [json](https://yapconf.readthedocs.io/en/stable/sources.html#json).


This json source means that My App Name will load configuration values from an 
in-memory string and cannot be modified. Usually it is used as a list of 
sensible defaults.


#### Source 5 Label

Source 5 Label is of type [json](https://yapconf.readthedocs.io/en/stable/sources.html#json).


This json source means that My App Name will load configuration values from 
`/path/to/file.json`. You may edit this file with [valid JSON](https://www.json.org/).


#### Source 6 Label

Source 6 Label is of type [kubernetes](https://yapconf.readthedocs.io/en/stable/sources.html#kubernetes).

The kubernetes source indicates that the configuration 
may be loaded from a kubernetes [ConfigMap](https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/). 
Specifically, My App Name will load the configuration from the ConfigMap named 
`config_map_name` in the namespace `config_map_namespace`

Additionally, Source 6 Label specified that `key_name` exists in the 
`config_map_name` ConfigMap. `key_name` will be loaded as `json`. 
You may modify this entry with [valid JSON](https://www.json.org/).


#### Source 7 Label

Source 7 Label is of type [yaml](https://yapconf.readthedocs.io/en/stable/sources.html#yaml).


The yaml source means that My App Name will load configuration values from 
`/path/to/file.yaml`. You may edit this file with [valid YAML](http://yaml.org/)

## Configuration

This section outlines the various configuration items My App Name supports.

| Name                                  | Type | Default                    | Description                          |
| ------------------------------------- | ---- | -------------------------- | ------------------------------------ |
| [database.host](#database.host)       | str  | localhost                  | Description of database.host here    |
| [database.name](#database.name)       | str  | myapp                      | Description of database.name here    |
| [database.port](#database.port)       | int  | 3306                       | Description of database.port here    |
| [database.verbose](#database.verbose) | bool | False                      | Description of database.verbose here |
| [emoji](#emoji)                       | str  | 🐍                          | Description of emoji here            |
| [file](#file)                         | str  | /default/path/to/file.yaml | Description of file here             |
| [ssl.private_key](#ssl.private_key)   | str  | /etc/certs/private.key     | Description of ssl.private_key here  |
| [ssl.public_key](#ssl.public_key)     | str  | /etc/certs/public.crt      | Description of ssl.public_key here   |
| [web_port](#web_port)                 | int  | 3000                       | Description of web_port here         |

### database.host

Description of database.host here

| Attribute     | Value                  |
| ------------- | ---------------------- |
| **item_type** | `str`                  |
| **default**   | `localhost`            |
| **env_name**  | `MY_APP_DATABASE_HOST` |
| **required**  | `True`                 |
| **cli_name**  | `--database-host`      |
| **fallback**  | `None`                 |
| **choices**   | `None`                 |

You can set database.host from the environment by setting the environment variable `MY_APP_DATABASE_HOST`

You can set `database.host` from the command-line by specifying `--database-host` at My App Name's entrypoint.

If `database.host` is not set in any of the sources listed, it will fallback to the default value `localhost`

Long description goes here.

### database.name

Description of database.name here

| Attribute     | Value                  |
| ------------- | ---------------------- |
| **item_type** | `str`                  |
| **default**   | `myapp`                |
| **env_name**  | `MY_APP_DATABASE_NAME` |
| **required**  | `True`                 |
| **cli_name**  | `--database-name`      |
| **fallback**  | `None`                 |
| **choices**   | `None`                 |

You can set database.name from the environment by setting the environment variable `MY_APP_DATABASE_NAME`

You can set `database.name` from the command-line by specifying `--database-name` at My App Name's entrypoint.

If `database.name` is not set in any of the sources listed, it will fallback to the default value `myapp`

Long description goes here.

### database.port

Description of database.port here

| Attribute     | Value                  |
| ------------- | ---------------------- |
| **item_type** | `int`                  |
| **default**   | `3306`                 |
| **env_name**  | `MY_APP_DATABASE_PORT` |
| **required**  | `True`                 |
| **cli_name**  | `--database-port`      |
| **fallback**  | `None`                 |
| **choices**   | `None`                 |

You can set database.port from the environment by setting the environment variable `MY_APP_DATABASE_PORT`

You can set `database.port` from the command-line by specifying `--database-port` at My App Name's entrypoint.

If `database.port` is not set in any of the sources listed, it will fallback to the default value `3306`

Long description goes here.

### database.verbose

Description of database.verbose here

| Attribute     | Value                     |
| ------------- | ------------------------- |
| **item_type** | `bool`                    |
| **default**   | `False`                   |
| **env_name**  | `MY_APP_DATABASE_VERBOSE` |
| **required**  | `True`                    |
| **cli_name**  | `--database-verbose`      |
| **fallback**  | `None`                    |
| **choices**   | `None`                    |

You can set database.verbose from the environment by setting the environment variable `MY_APP_DATABASE_VERBOSE`

You can set `database.verbose` from the command-line by specifying `--database-verbose` at My App Name's entrypoint.

Long description goes here.

### emoji

Description of emoji here

| Attribute     | Value          |
| ------------- | -------------- |
| **item_type** | `str`          |
| **default**   | `🐍`            |
| **env_name**  | `MY_APP_EMOJI` |
| **required**  | `True`         |
| **cli_name**  | `--emoji`      |
| **fallback**  | `None`         |
| **choices**   | `None`         |

You can set emoji from the environment by setting the environment variable `MY_APP_EMOJI`

You can set `emoji` from the command-line by specifying `--emoji` at My App Name's entrypoint.

If `emoji` is not set in any of the sources listed, it will fallback to the default value `🐍`

Long description goes here.

### file

Description of file here

| Attribute     | Value                        |
| ------------- | ---------------------------- |
| **item_type** | `str`                        |
| **default**   | `/default/path/to/file.yaml` |
| **env_name**  | `MY_APP_MY_APP_CONFIG_FILE`  |
| **required**  | `True`                       |
| **cli_name**  | `--file/-f`                  |
| **fallback**  | `None`                       |
| **choices**   | `None`                       |

You can set file from the environment by setting the environment variable `MY_APP_MY_APP_CONFIG_FILE`

You can set `file` from the command-line by specifying `--file/-f` at My App Name's entrypoint.

If `file` is not set in any of the sources listed, it will fallback to the default value `/default/path/to/file.yaml`

Long description goes here.

### ssl.private_key

Description of ssl.private_key here

| Attribute     | Value                    |
| ------------- | ------------------------ |
| **item_type** | `str`                    |
| **default**   | `/etc/certs/private.key` |
| **env_name**  | `MY_APP_SSL_PRIVATE_KEY` |
| **required**  | `True`                   |
| **cli_name**  | `--ssl-private-key`      |
| **fallback**  | `None`                   |
| **choices**   | `None`                   |

You can set ssl.private_key from the environment by setting the environment variable `MY_APP_SSL_PRIVATE_KEY`

You can set `ssl.private_key` from the command-line by specifying `--ssl-private-key` at My App Name's entrypoint.

If `ssl.private_key` is not set in any of the sources listed, it will fallback to the default value `/etc/certs/private.key`

Long description goes here.

### ssl.public_key

Description of ssl.public_key here

| Attribute     | Value                   |
| ------------- | ----------------------- |
| **item_type** | `str`                   |
| **default**   | `/etc/certs/public.crt` |
| **env_name**  | `MY_APP_SSL_PUBLIC_KEY` |
| **required**  | `True`                  |
| **cli_name**  | `--ssl-public-key`      |
| **fallback**  | `None`                  |
| **choices**   | `None`                  |

You can set ssl.public_key from the environment by setting the environment variable `MY_APP_SSL_PUBLIC_KEY`

You can set `ssl.public_key` from the command-line by specifying `--ssl-public-key` at My App Name's entrypoint.

If `ssl.public_key` is not set in any of the sources listed, it will fallback to the default value `/etc/certs/public.crt`

Long description goes here.

### web_port

Description of web_port here

| Attribute     | Value             |
| ------------- | ----------------- |
| **item_type** | `int`             |
| **default**   | `3000`            |
| **env_name**  | `MY_APP_WEB_PORT` |
| **required**  | `True`            |
| **cli_name**  | `--web-port/-p`   |
| **fallback**  | `None`            |
| **choices**   | `None`            |

You can set web_port from the environment by setting the environment variable `MY_APP_WEB_PORT`

You can set `web_port` from the command-line by specifying `--web-port/-p` at My App Name's entrypoint.

If `web_port` is not set in any of the sources listed, it will fallback to the default value `3000`

Long description goes here.
