# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UpdateWeekScheduleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UpdateWeekScheduleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'published': 'bool',
            'user_schedules': 'dict(str, UserSchedule)',
            'partial_upload_ids': 'list[str]',
            'metadata': 'WfmVersionedEntityMetadata',
            'agent_schedules_version': 'int',
            'short_term_forecast': 'ShortTermForecastReference',
            'headcount_forecast': 'HeadcountForecast',
            'agent_update_filter': 'str'
        }

        self.attribute_map = {
            'description': 'description',
            'published': 'published',
            'user_schedules': 'userSchedules',
            'partial_upload_ids': 'partialUploadIds',
            'metadata': 'metadata',
            'agent_schedules_version': 'agentSchedulesVersion',
            'short_term_forecast': 'shortTermForecast',
            'headcount_forecast': 'headcountForecast',
            'agent_update_filter': 'agentUpdateFilter'
        }

        self._description = None
        self._published = None
        self._user_schedules = None
        self._partial_upload_ids = None
        self._metadata = None
        self._agent_schedules_version = None
        self._short_term_forecast = None
        self._headcount_forecast = None
        self._agent_update_filter = None

    @property
    def description(self):
        """
        Gets the description of this UpdateWeekScheduleRequest.
        Description of the week schedule

        :return: The description of this UpdateWeekScheduleRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateWeekScheduleRequest.
        Description of the week schedule

        :param description: The description of this UpdateWeekScheduleRequest.
        :type: str
        """
        
        self._description = description

    @property
    def published(self):
        """
        Gets the published of this UpdateWeekScheduleRequest.
        Whether the week schedule is published

        :return: The published of this UpdateWeekScheduleRequest.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this UpdateWeekScheduleRequest.
        Whether the week schedule is published

        :param published: The published of this UpdateWeekScheduleRequest.
        :type: bool
        """
        
        self._published = published

    @property
    def user_schedules(self):
        """
        Gets the user_schedules of this UpdateWeekScheduleRequest.
        User schedules in the week

        :return: The user_schedules of this UpdateWeekScheduleRequest.
        :rtype: dict(str, UserSchedule)
        """
        return self._user_schedules

    @user_schedules.setter
    def user_schedules(self, user_schedules):
        """
        Sets the user_schedules of this UpdateWeekScheduleRequest.
        User schedules in the week

        :param user_schedules: The user_schedules of this UpdateWeekScheduleRequest.
        :type: dict(str, UserSchedule)
        """
        
        self._user_schedules = user_schedules

    @property
    def partial_upload_ids(self):
        """
        Gets the partial_upload_ids of this UpdateWeekScheduleRequest.
        IDs of partial uploads to include in this imported schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500

        :return: The partial_upload_ids of this UpdateWeekScheduleRequest.
        :rtype: list[str]
        """
        return self._partial_upload_ids

    @partial_upload_ids.setter
    def partial_upload_ids(self, partial_upload_ids):
        """
        Sets the partial_upload_ids of this UpdateWeekScheduleRequest.
        IDs of partial uploads to include in this imported schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500

        :param partial_upload_ids: The partial_upload_ids of this UpdateWeekScheduleRequest.
        :type: list[str]
        """
        
        self._partial_upload_ids = partial_upload_ids

    @property
    def metadata(self):
        """
        Gets the metadata of this UpdateWeekScheduleRequest.
        Version metadata for this work plan

        :return: The metadata of this UpdateWeekScheduleRequest.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UpdateWeekScheduleRequest.
        Version metadata for this work plan

        :param metadata: The metadata of this UpdateWeekScheduleRequest.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    @property
    def agent_schedules_version(self):
        """
        Gets the agent_schedules_version of this UpdateWeekScheduleRequest.
        Version of agent schedules in the week schedule

        :return: The agent_schedules_version of this UpdateWeekScheduleRequest.
        :rtype: int
        """
        return self._agent_schedules_version

    @agent_schedules_version.setter
    def agent_schedules_version(self, agent_schedules_version):
        """
        Sets the agent_schedules_version of this UpdateWeekScheduleRequest.
        Version of agent schedules in the week schedule

        :param agent_schedules_version: The agent_schedules_version of this UpdateWeekScheduleRequest.
        :type: int
        """
        
        self._agent_schedules_version = agent_schedules_version

    @property
    def short_term_forecast(self):
        """
        Gets the short_term_forecast of this UpdateWeekScheduleRequest.
        Reference to optionally point the schedule at a new short term forecast

        :return: The short_term_forecast of this UpdateWeekScheduleRequest.
        :rtype: ShortTermForecastReference
        """
        return self._short_term_forecast

    @short_term_forecast.setter
    def short_term_forecast(self, short_term_forecast):
        """
        Sets the short_term_forecast of this UpdateWeekScheduleRequest.
        Reference to optionally point the schedule at a new short term forecast

        :param short_term_forecast: The short_term_forecast of this UpdateWeekScheduleRequest.
        :type: ShortTermForecastReference
        """
        
        self._short_term_forecast = short_term_forecast

    @property
    def headcount_forecast(self):
        """
        Gets the headcount_forecast of this UpdateWeekScheduleRequest.
        The headcount forecast associated with the schedule.  If not null, existing values will be irrecoverably replaced

        :return: The headcount_forecast of this UpdateWeekScheduleRequest.
        :rtype: HeadcountForecast
        """
        return self._headcount_forecast

    @headcount_forecast.setter
    def headcount_forecast(self, headcount_forecast):
        """
        Sets the headcount_forecast of this UpdateWeekScheduleRequest.
        The headcount forecast associated with the schedule.  If not null, existing values will be irrecoverably replaced

        :param headcount_forecast: The headcount_forecast of this UpdateWeekScheduleRequest.
        :type: HeadcountForecast
        """
        
        self._headcount_forecast = headcount_forecast

    @property
    def agent_update_filter(self):
        """
        Gets the agent_update_filter of this UpdateWeekScheduleRequest.
        For a published schedule, this determines whether a notification will be shown to agents in the default PureCloud user interface.  The CPC notification will always be sent and the value specified here affects what data is returned in the 'updates' property.  In the default PureCloud UI, \"None\" means that agents will not be notified, \"ShiftTimesOnly\" means agents will only be notified for changes to shift start and end times,  and \"All\" means that agents will be notified for any change to a shift or activity (except for full day off activities).  When building a custom client, use this property to specify the level of detail you need. Defaults to \"ShiftTimesOnly\".

        :return: The agent_update_filter of this UpdateWeekScheduleRequest.
        :rtype: str
        """
        return self._agent_update_filter

    @agent_update_filter.setter
    def agent_update_filter(self, agent_update_filter):
        """
        Sets the agent_update_filter of this UpdateWeekScheduleRequest.
        For a published schedule, this determines whether a notification will be shown to agents in the default PureCloud user interface.  The CPC notification will always be sent and the value specified here affects what data is returned in the 'updates' property.  In the default PureCloud UI, \"None\" means that agents will not be notified, \"ShiftTimesOnly\" means agents will only be notified for changes to shift start and end times,  and \"All\" means that agents will be notified for any change to a shift or activity (except for full day off activities).  When building a custom client, use this property to specify the level of detail you need. Defaults to \"ShiftTimesOnly\".

        :param agent_update_filter: The agent_update_filter of this UpdateWeekScheduleRequest.
        :type: str
        """
        allowed_values = ["All", "ShiftTimeChange", "None"]
        if agent_update_filter.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for agent_update_filter -> " + agent_update_filter
            self._agent_update_filter = "outdated_sdk_version"
        else:
            self._agent_update_filter = agent_update_filter

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

