# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ImportShortTermForecastRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ImportShortTermForecastRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'file_name': 'str',
            'description': 'str',
            'route_group_list': 'RouteGroupList',
            'partial_upload_ids': 'list[str]'
        }

        self.attribute_map = {
            'file_name': 'fileName',
            'description': 'description',
            'route_group_list': 'routeGroupList',
            'partial_upload_ids': 'partialUploadIds'
        }

        self._file_name = None
        self._description = None
        self._route_group_list = None
        self._partial_upload_ids = None

    @property
    def file_name(self):
        """
        Gets the file_name of this ImportShortTermForecastRequest.
        The file name, if applicable, this data was extracted from (display purposes only)

        :return: The file_name of this ImportShortTermForecastRequest.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this ImportShortTermForecastRequest.
        The file name, if applicable, this data was extracted from (display purposes only)

        :param file_name: The file_name of this ImportShortTermForecastRequest.
        :type: str
        """
        
        self._file_name = file_name

    @property
    def description(self):
        """
        Gets the description of this ImportShortTermForecastRequest.
        Description for the imported forecast.  Pass an empty string for no description

        :return: The description of this ImportShortTermForecastRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ImportShortTermForecastRequest.
        Description for the imported forecast.  Pass an empty string for no description

        :param description: The description of this ImportShortTermForecastRequest.
        :type: str
        """
        
        self._description = description

    @property
    def route_group_list(self):
        """
        Gets the route_group_list of this ImportShortTermForecastRequest.
        The raw data to import

        :return: The route_group_list of this ImportShortTermForecastRequest.
        :rtype: RouteGroupList
        """
        return self._route_group_list

    @route_group_list.setter
    def route_group_list(self, route_group_list):
        """
        Sets the route_group_list of this ImportShortTermForecastRequest.
        The raw data to import

        :param route_group_list: The route_group_list of this ImportShortTermForecastRequest.
        :type: RouteGroupList
        """
        
        self._route_group_list = route_group_list

    @property
    def partial_upload_ids(self):
        """
        Gets the partial_upload_ids of this ImportShortTermForecastRequest.
        IDs of partial uploads to include in this imported forecast.  Only relevant for large forecasts

        :return: The partial_upload_ids of this ImportShortTermForecastRequest.
        :rtype: list[str]
        """
        return self._partial_upload_ids

    @partial_upload_ids.setter
    def partial_upload_ids(self, partial_upload_ids):
        """
        Sets the partial_upload_ids of this ImportShortTermForecastRequest.
        IDs of partial uploads to include in this imported forecast.  Only relevant for large forecasts

        :param partial_upload_ids: The partial_upload_ids of this ImportShortTermForecastRequest.
        :type: list[str]
        """
        
        self._partial_upload_ids = partial_upload_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

