# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['py_trees', 'py_trees.demos', 'py_trees.programs']

package_data = \
{'': ['*']}

install_requires = \
['pydot>=1.4']

entry_points = \
{'console_scripts': ['py-trees-demo-action-behaviour = '
                     'py_trees.demos.action:main',
                     'py-trees-demo-behaviour-lifecycle = '
                     'py_trees.demos.lifecycle:main',
                     'py-trees-demo-blackboard = '
                     'py_trees.demos.blackboard:main',
                     'py-trees-demo-blackboard-namespaces = '
                     'py_trees.demos.blackboard_namespaces:main',
                     'py-trees-demo-blackboard-remappings = '
                     'py_trees.demos.blackboard_remappings:main',
                     'py-trees-demo-context-switching = '
                     'py_trees.demos.context_switching:main',
                     'py-trees-demo-display-modes = '
                     'py_trees.demos.display_modes:main',
                     'py-trees-demo-dot-graphs = '
                     'py_trees.demos.dot_graphs:main',
                     'py-trees-demo-either-or = py_trees.demos.either_or:main',
                     'py-trees-demo-eternal-guard = '
                     'py_trees.demos.eternal_guard:main',
                     'py-trees-demo-logging = py_trees.demos.logging:main',
                     'py-trees-demo-pick-up-where-you-left-off = '
                     'py_trees.demos.pick_up_where_you_left_off:main',
                     'py-trees-demo-selector = py_trees.demos.selector:main',
                     'py-trees-demo-sequence = py_trees.demos.sequence:main',
                     'py-trees-demo-tree-stewardship = '
                     'py_trees.demos.stewardship:main',
                     'py-trees-render = py_trees.programs.render:main']}

setup_kwargs = {
    'name': 'py-trees',
    'version': '2.2.1',
    'description': 'pythonic implementation of behaviour trees',
    'long_description': "# Py Trees\n\n[[About](#about)][[Documentation](#documentation)][[Getting Started](#getting-started)][[Releases](#releases)][[Installation](#installation)][[PyTrees-Ros Ecosystem](#pytrees-ros-ecosystem)][[Developers](#developers)]\n\n----\n\n## About\n\nPyTrees is a python implementation of behaviour trees designed to facilitate the rapid development of medium sized decision making engines for use in fields like robotics. Brief feature list:\n\n* Sequence, Selector, Parallel composites\n* Blackboards for data sharing\n* Python generators for smarter ticking over the tree graph\n* Python decorators for enabling meta behaviours\n* Render trees to dot graphs or visualise with ascii graphs on stdout\n\n## Documentation\n\n[![devel][docs-devel-image]][docs-devel] [![2.1.x][docs-2.1.x-image]][docs-2.1.x] [![0.7.x][docs-0.7.x-image]][docs-0.7.x] [![0.6.x][docs-0.6.x-image]][docs-0.6.x]\n\n## Getting Started\n\nVSCode and a [py38 DevContainer](.devcontainer/devcontainer.json) on CodeSpaces will set you up with an environment\nfor running demos, tests and/or creating PRs in less than five minutes. If you're just looking for releases,\nfetch them from  [PyPi](https://pypi.org/project/py-trees/).\n\n1. Fork the project to your personal account\n2. Click on Code -> Codespaces -> + Create a Codespace\n3. Be froody\n\n```\n(docker) zen@py_trees:/workspaces/py_trees$ poetry install\n(docker) zen@py_trees:/workspaces/py_trees$ poetry shell\n\n(py-trees-py3.8) (docker) zen@py_trees:/workspaces/py_trees$ py-trees-demo-<tab>-<tab>\npy-trees-demo-action-behaviour            py-trees-demo-context-switching           py-trees-demo-logging\npy-trees-demo-behaviour-lifecycle         py-trees-demo-display-modes               py-trees-demo-pick-up-where-you-left-off\npy-trees-demo-blackboard                  py-trees-demo-dot-graphs                  py-trees-demo-selector\npy-trees-demo-blackboard-namespaces       py-trees-demo-either-or                   py-trees-demo-sequence\npy-trees-demo-blackboard-remappings       py-trees-demo-eternal-guard               py-trees-demo-tree-stewardship\n\n(py-trees-py3.8) (docker) zen@py_trees:/workspaces/py_trees$ py-trees-demo-blackboard\n*******************************************************************************\n                                   Blackboard\n*******************************************************************************\n\nDemonstrates usage of the blackboard and related behaviours.\n\nA sequence is populated with a few behaviours that exercise\nreading and writing on the Blackboard in interesting ways.\n\n*******************************************************************************\n\n[DEBUG] Writer               : BlackboardWriter.__init__()\n...\n...\n```\n\nIf you're really looking for something more edifying than hello world examples, walk through the [ros tutorials](https://py-trees-ros-tutorials.readthedocs.io/en/release-2.0.x/index.html) which incrementally step through the process of building a scenario handling layer for a robot.\n\nThere are also runtime visualisation tools - refer to the [py_trees_ros_viewer/README](https://github.com/splintered-reality/py_trees_ros_viewer/blob/devel/README.md) as an example implementation of the underlying [py_trees_js](https://github.com/splintered-reality/py_trees_js) library. \n\n## Releases\n\n* `0.y.x` - first open source releases\n* `1.0.x` - first stable release\n* `1.1.x` - improvements\n* `1.2.x` - improvements\n* `2.0.x` - blackboards v2 with namespaces, access permissions and key tracking\n* `2.1.x` - Chooser deprecated, api housekeeping\n\n| | Devel | 2.1.x | 2.0.x | 1.2.x | 0.7.x | 0.6.x |\n|:---:|:---:|:---:|:---:|:---:|:---:|:---:|\n| Sources | [![devel][sources-devel-image]][sources-devel] | [![2.1.x][sources-2.1.x-image]][sources-2.1.x] | [![2.0.x][sources-2.0.x-image]][sources-2.0.x] | [![1.2.x][sources-1.2.x-image]][sources-1.2.x] | [![0.7.x][sources-0.7.x-image]][sources-0.7.x] | [![0.6.x][sources-0.6.x-image]][sources-0.6.x]\n| Compatibility | [![Python 3.6][python36-image]][python36-docs] | [![Python 3.6][python36-image]][python36-docs] | [![Python 3.6][python36-image]][python36-docs] | [![Python 3.6][python36-image]][python36-docs] | [![Python 3.6][python36-image]][python36-docs] | [![Python 2.7][python27-image]][python27-docs]\n| CI | [![devel-Status][devel-build-status-image]][devel-build-status] | [![2.1.x-Status][2.1.x-build-status-image]][2.1.x-build-status] | [![2.0.x-Status][2.0.x-build-status-image]][2.0.x-build-status] | [![1.2.x-Status][1.2.x-build-status-image]][1.2.x-build-status] | [![0.7.x-Status][0.7.x-build-status-image]][0.7.x-build-status] | [![0.6.x-Status][0.6.x-build-status-image]][0.6.x-build-status] \n| Documentation | [![devel-Docs][rtd-devel-image]][docs-devel] | [![2.1.x-Docs][rtd-2.1.x-image]][docs-2.1.x] | [![2.0.x-Docs][rtd-2.0.x-image]][docs-2.0.x] | [![1.2.x-Docs][rtd-1.2.x-image]][docs-1.2.x] | [![0.7.x-Docs][rtd-0.7.x-image]][docs-0.7.x] | [![0.6.x-Docs][rtd-0.6.x-image]][docs-0.6.x]\n\n## Installation\n\nFrom [ppa](https://launchpad.net/~d-stonier/+archive/ubuntu/snorriheim) on Ubuntu/Bionic:\n\n```\n$ sudo apt install python3-py-trees\n```\n\nFrom [pypi](https://pypi.python.org/pypi/py_trees):\n\n```\n$ pip3 install py_trees\n```\n\nIn a Python Virtual Environment:\n\n```\n$ git clone https://github.com/splintered-reality/py_trees\n$ cd py_trees\n$ source ./venv.bash\n```\n\nBuild your own python3 deb:\n\n```\n$ git clone https://github.com/splintered-reality/py_trees\n$ cd py_trees\n$ source ./venv.bash\n$ make deb\n```\n\nFrom the ROS2 ecosystem:\n\n```\n$ sudo apt install ros-<rosdistro>-py-trees\n```\n\n## PyTrees-ROS Ecosystem\n\nSee the `py_trees_ros` [README](https://github.com/splintered-reality/py_trees_ros/blob/devel/README.md) for the latest information on pytrees packages in the ROS ecosystem and their status.\n\n## Developers\n\n### Documentation\n\n```\n# Build Locally\n$ make -C docs html\n\n# ReadTheDocs requirements\n$ poetry export -f requirements.txt --with docs -o docs/requirements.txt\n```\n\n[license-image]: https://img.shields.io/badge/License-BSD%203--Clause-orange.svg?style=plastic\n[license]: LICENSE\n\n[python36-image]: https://img.shields.io/badge/python-3.6-green.svg?style=plastic\n[python36-docs]: https://docs.python.org/3.6/\n[python27-image]: https://img.shields.io/badge/python-2.7-green.svg?style=plastic\n[python27-docs]: https://docs.python.org/2.7/\n\n[devel-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=devel&style=plastic\n[devel-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/devel\n[2.1.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F2.1.x&style=plastic\n[2.1.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/2.1.x\n[2.0.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F2.0.x&style=plastic\n[2.0.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/2.0.x\n[1.3.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F1.3.x&style=plastic\n[1.3.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/1.3.x\n[1.2.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F1.2.x&style=plastic\n[1.2.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/1.2.x\n[0.7.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F0.7.x&style=plastic\n[0.7.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/0.7.x\n[0.6.x-build-status-image]: https://img.shields.io/circleci/build/github/splintered-reality/py_trees?branch=release%2F0.6x&style=plastic\n[0.6.x-build-status]: https://circleci.com/gh/splintered-reality/py_trees/tree/release/0.6.x\n\n[docs-devel]: http://py-trees.readthedocs.io/\n[docs-2.1.x]: http://py-trees.readthedocs.io/en/release-2.1.x/\n[docs-2.0.x]: http://py-trees.readthedocs.io/en/release-2.0.x/\n[docs-1.3.x]: http://py-trees.readthedocs.io/en/release-1.3.x/\n[docs-1.2.x]: http://py-trees.readthedocs.io/en/release-1.2.x/\n[docs-0.7.x]: http://py-trees.readthedocs.io/en/release-0.7.x/\n[docs-0.6.x]: http://py-trees.readthedocs.io/en/release-0.6.x/\n[docs-0.5.x]: http://docs.ros.org/kinetic/api/py_trees/html/\n\n[docs-devel-image]: http://img.shields.io/badge/docs-devel-brightgreen.svg?style=plastic\n[docs-2.1.x-image]: http://img.shields.io/badge/docs-2.1.x-brightgreen.svg?style=plastic\n[docs-2.0.x-image]: http://img.shields.io/badge/docs-2.0.x-brightgreen.svg?style=plastic\n[docs-1.3.x-image]: http://img.shields.io/badge/docs-1.3.x-brightgreen.svg?style=plastic\n[docs-1.2.x-image]: http://img.shields.io/badge/docs-1.2.x-brightgreen.svg?style=plastic\n[docs-0.7.x-image]: http://img.shields.io/badge/docs-0.7.x-brightgreen.svg?style=plastic\n[docs-0.6.x-image]: http://img.shields.io/badge/docs-0.6.x-brightgreen.svg?style=plastic\n[docs-0.5.x-image]: http://img.shields.io/badge/docs-0.5.x-brightgreen.svg?style=plastic\n\n[rtd-devel-image]: https://readthedocs.org/projects/py-trees/badge/?version=devel&style=plastic\n[rtd-2.1.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-2.1.x&style=plastic\n[rtd-2.0.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-2.0.x&style=plastic\n[rtd-1.3.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-1.3.x&style=plastic\n[rtd-1.2.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-1.2.x&style=plastic\n[rtd-0.7.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-0.7.x&style=plastic\n[rtd-0.6.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-0.6.x&style=plastic\n[rtd-0.5.x-image]: https://readthedocs.org/projects/py-trees/badge/?version=release-0.5.x&style=plastic\n[not-available-docs-image]: http://img.shields.io/badge/docs-n/a-yellow.svg?style=plastic\n\n[sources-devel]: https://github.com/splintered-reality/py_trees/tree/devel\n[sources-2.1.x]: https://github.com/splintered-reality/py_trees/tree/release/2.1.x\n[sources-2.0.x]: https://github.com/splintered-reality/py_trees/tree/release/2.0.x\n[sources-1.3.x]: https://github.com/splintered-reality/py_trees/tree/release/1.3.x\n[sources-1.2.x]: https://github.com/splintered-reality/py_trees/tree/release/1.2.x\n[sources-0.7.x]: https://github.com/splintered-reality/py_trees/tree/release/0.7.x\n[sources-0.6.x]: https://github.com/splintered-reality/py_trees/tree/release/0.6.x\n[sources-0.5.x]: https://github.com/splintered-reality/py_trees/tree/release/0.5.x\n\n[sources-devel-image]: http://img.shields.io/badge/sources-devel-blue.svg?style=plastic\n[sources-2.1.x-image]: http://img.shields.io/badge/sources-2.1.x-blue.svg?style=plastic\n[sources-2.0.x-image]: http://img.shields.io/badge/sources-2.0.x-blue.svg?style=plastic\n[sources-1.3.x-image]: http://img.shields.io/badge/sources-1.3.x-blue.svg?style=plastic\n[sources-1.2.x-image]: http://img.shields.io/badge/sources-1.2.x-blue.svg?style=plastic\n[sources-0.7.x-image]: http://img.shields.io/badge/sources-0.7.x-blue.svg?style=plastic\n[sources-0.6.x-image]: http://img.shields.io/badge/sources-0.6.x-blue.svg?style=plastic\n[sources-0.5.x-image]: http://img.shields.io/badge/sources-0.5.x-blue.svg?style=plastic\n",
    'author': 'Daniel Stonier',
    'author_email': 'None',
    'maintainer': 'Daniel Stonier',
    'maintainer_email': 'd.stonier@gmail.com',
    'url': 'https://github.com/splintered-reality/py_trees',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
