# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class CollectionSummaryResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_href': 'str',
        'namespace': 'str',
        'name': 'str',
        'version': 'str',
        'requires_ansible': 'str',
        'pulp_created': 'datetime',
        'contents': 'object',
        'dependencies': 'object',
        'description': 'str',
        'tags': 'list[AnsibleTagResponse]'
    }

    attribute_map = {
        'pulp_href': 'pulp_href',
        'namespace': 'namespace',
        'name': 'name',
        'version': 'version',
        'requires_ansible': 'requires_ansible',
        'pulp_created': 'pulp_created',
        'contents': 'contents',
        'dependencies': 'dependencies',
        'description': 'description',
        'tags': 'tags'
    }

    def __init__(self, pulp_href=None, namespace=None, name=None, version=None, requires_ansible=None, pulp_created=None, contents=None, dependencies=None, description=None, tags=None, local_vars_configuration=None):  # noqa: E501
        """CollectionSummaryResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_href = None
        self._namespace = None
        self._name = None
        self._version = None
        self._requires_ansible = None
        self._pulp_created = None
        self._contents = None
        self._dependencies = None
        self._description = None
        self._tags = None
        self.discriminator = None

        if pulp_href is not None:
            self.pulp_href = pulp_href
        if namespace is not None:
            self.namespace = namespace
        if name is not None:
            self.name = name
        if version is not None:
            self.version = version
        self.requires_ansible = requires_ansible
        if pulp_created is not None:
            self.pulp_created = pulp_created
        if contents is not None:
            self.contents = contents
        if dependencies is not None:
            self.dependencies = dependencies
        if description is not None:
            self.description = description
        if tags is not None:
            self.tags = tags

    @property
    def pulp_href(self):
        """Gets the pulp_href of this CollectionSummaryResponse.  # noqa: E501


        :return: The pulp_href of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._pulp_href

    @pulp_href.setter
    def pulp_href(self, pulp_href):
        """Sets the pulp_href of this CollectionSummaryResponse.


        :param pulp_href: The pulp_href of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._pulp_href = pulp_href

    @property
    def namespace(self):
        """Gets the namespace of this CollectionSummaryResponse.  # noqa: E501

        The namespace of the collection.  # noqa: E501

        :return: The namespace of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this CollectionSummaryResponse.

        The namespace of the collection.  # noqa: E501

        :param namespace: The namespace of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                namespace is not None and len(namespace) > 64):
            raise ValueError("Invalid value for `namespace`, length must be less than or equal to `64`")  # noqa: E501

        self._namespace = namespace

    @property
    def name(self):
        """Gets the name of this CollectionSummaryResponse.  # noqa: E501

        The name of the collection.  # noqa: E501

        :return: The name of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CollectionSummaryResponse.

        The name of the collection.  # noqa: E501

        :param name: The name of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501

        self._name = name

    @property
    def version(self):
        """Gets the version of this CollectionSummaryResponse.  # noqa: E501

        The version of the collection.  # noqa: E501

        :return: The version of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CollectionSummaryResponse.

        The version of the collection.  # noqa: E501

        :param version: The version of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                version is not None and len(version) > 128):
            raise ValueError("Invalid value for `version`, length must be less than or equal to `128`")  # noqa: E501

        self._version = version

    @property
    def requires_ansible(self):
        """Gets the requires_ansible of this CollectionSummaryResponse.  # noqa: E501

        The version of Ansible required to use the collection. Multiple versions can be separated with a comma.  # noqa: E501

        :return: The requires_ansible of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._requires_ansible

    @requires_ansible.setter
    def requires_ansible(self, requires_ansible):
        """Sets the requires_ansible of this CollectionSummaryResponse.

        The version of Ansible required to use the collection. Multiple versions can be separated with a comma.  # noqa: E501

        :param requires_ansible: The requires_ansible of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                requires_ansible is not None and len(requires_ansible) > 255):
            raise ValueError("Invalid value for `requires_ansible`, length must be less than or equal to `255`")  # noqa: E501

        self._requires_ansible = requires_ansible

    @property
    def pulp_created(self):
        """Gets the pulp_created of this CollectionSummaryResponse.  # noqa: E501

        Timestamp of creation.  # noqa: E501

        :return: The pulp_created of this CollectionSummaryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_created

    @pulp_created.setter
    def pulp_created(self, pulp_created):
        """Sets the pulp_created of this CollectionSummaryResponse.

        Timestamp of creation.  # noqa: E501

        :param pulp_created: The pulp_created of this CollectionSummaryResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_created = pulp_created

    @property
    def contents(self):
        """Gets the contents of this CollectionSummaryResponse.  # noqa: E501

        A JSON field with data about the contents.  # noqa: E501

        :return: The contents of this CollectionSummaryResponse.  # noqa: E501
        :rtype: object
        """
        return self._contents

    @contents.setter
    def contents(self, contents):
        """Sets the contents of this CollectionSummaryResponse.

        A JSON field with data about the contents.  # noqa: E501

        :param contents: The contents of this CollectionSummaryResponse.  # noqa: E501
        :type: object
        """

        self._contents = contents

    @property
    def dependencies(self):
        """Gets the dependencies of this CollectionSummaryResponse.  # noqa: E501

        A dict declaring Collections that this collection requires to be installed for it to be usable.  # noqa: E501

        :return: The dependencies of this CollectionSummaryResponse.  # noqa: E501
        :rtype: object
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """Sets the dependencies of this CollectionSummaryResponse.

        A dict declaring Collections that this collection requires to be installed for it to be usable.  # noqa: E501

        :param dependencies: The dependencies of this CollectionSummaryResponse.  # noqa: E501
        :type: object
        """

        self._dependencies = dependencies

    @property
    def description(self):
        """Gets the description of this CollectionSummaryResponse.  # noqa: E501

        A short summary description of the collection.  # noqa: E501

        :return: The description of this CollectionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CollectionSummaryResponse.

        A short summary description of the collection.  # noqa: E501

        :param description: The description of this CollectionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def tags(self):
        """Gets the tags of this CollectionSummaryResponse.  # noqa: E501


        :return: The tags of this CollectionSummaryResponse.  # noqa: E501
        :rtype: list[AnsibleTagResponse]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this CollectionSummaryResponse.


        :param tags: The tags of this CollectionSummaryResponse.  # noqa: E501
        :type: list[AnsibleTagResponse]
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectionSummaryResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollectionSummaryResponse):
            return True

        return self.to_dict() != other.to_dict()
