# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class AnsibleCollectionVersionMarkResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_created': 'datetime',
        'pulp_href': 'str',
        'marked_collection': 'str',
        'value': 'str'
    }

    attribute_map = {
        'pulp_created': 'pulp_created',
        'pulp_href': 'pulp_href',
        'marked_collection': 'marked_collection',
        'value': 'value'
    }

    def __init__(self, pulp_created=None, pulp_href=None, marked_collection=None, value=None, local_vars_configuration=None):  # noqa: E501
        """AnsibleCollectionVersionMarkResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_created = None
        self._pulp_href = None
        self._marked_collection = None
        self._value = None
        self.discriminator = None

        if pulp_created is not None:
            self.pulp_created = pulp_created
        if pulp_href is not None:
            self.pulp_href = pulp_href
        self.marked_collection = marked_collection
        self.value = value

    @property
    def pulp_created(self):
        """Gets the pulp_created of this AnsibleCollectionVersionMarkResponse.  # noqa: E501

        Timestamp of creation.  # noqa: E501

        :return: The pulp_created of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._pulp_created

    @pulp_created.setter
    def pulp_created(self, pulp_created):
        """Sets the pulp_created of this AnsibleCollectionVersionMarkResponse.

        Timestamp of creation.  # noqa: E501

        :param pulp_created: The pulp_created of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :type: datetime
        """

        self._pulp_created = pulp_created

    @property
    def pulp_href(self):
        """Gets the pulp_href of this AnsibleCollectionVersionMarkResponse.  # noqa: E501


        :return: The pulp_href of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :rtype: str
        """
        return self._pulp_href

    @pulp_href.setter
    def pulp_href(self, pulp_href):
        """Sets the pulp_href of this AnsibleCollectionVersionMarkResponse.


        :param pulp_href: The pulp_href of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :type: str
        """

        self._pulp_href = pulp_href

    @property
    def marked_collection(self):
        """Gets the marked_collection of this AnsibleCollectionVersionMarkResponse.  # noqa: E501

        The content this mark is pointing to.  # noqa: E501

        :return: The marked_collection of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :rtype: str
        """
        return self._marked_collection

    @marked_collection.setter
    def marked_collection(self, marked_collection):
        """Sets the marked_collection of this AnsibleCollectionVersionMarkResponse.

        The content this mark is pointing to.  # noqa: E501

        :param marked_collection: The marked_collection of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and marked_collection is None:  # noqa: E501
            raise ValueError("Invalid value for `marked_collection`, must not be `None`")  # noqa: E501

        self._marked_collection = marked_collection

    @property
    def value(self):
        """Gets the value of this AnsibleCollectionVersionMarkResponse.  # noqa: E501

        The string value of this mark.  # noqa: E501

        :return: The value of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this AnsibleCollectionVersionMarkResponse.

        The string value of this mark.  # noqa: E501

        :param value: The value of this AnsibleCollectionVersionMarkResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                value is not None and not re.search(r'^[-a-zA-Z0-9_]+$', value)):  # noqa: E501
            raise ValueError(r"Invalid value for `value`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnsibleCollectionVersionMarkResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnsibleCollectionVersionMarkResponse):
            return True

        return self.to_dict() != other.to_dict()
